/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.geoobject;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import oracle.maps.core.Drawable;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.spatial.geometry.JGeometry;

public class JGeometryObject
implements GeoObject {
    private JGeometry geom = null;
    private String key = null;
    private Layer owner = null;

    public JGeometryObject(JGeometry geom, Object key, Layer layer) {
        this.geom = geom;
        this.key = (String)key;
        this.owner = layer;
    }

    public JGeometryObject clone() {
        try {
            return (JGeometryObject)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean isSubElementOf(GeoObject obj) {
        return false;
    }

    @Override
    public List<GeoObject> substract(List<? extends GeoObject> obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public Layer getLayer() {
        return this.owner;
    }

    public JGeometry getGeometry() {
        return this.geom;
    }

    public JGeometry setGeometry(JGeometry value) {
        JGeometry old = this.geom;
        this.geom = value;
        return old;
    }

    @Override
    public Object setKey(Object key) {
        String old = this.key;
        this.key = (String)key;
        return old;
    }

    @Override
    public void setLayer(Layer layer) {
        this.owner = layer;
    }

    @Override
    public Drawable getDrawable(AffineTransform viewportTransform) {
        return Drawable.createDrawable(this.geom, viewportTransform);
    }

    @Override
    public Rectangle2D getMBR() {
        if (this.geom == null) {
            return null;
        }
        int dim = this.geom.getDimensions();
        double[] mbr = this.geom.getMBR();
        if (mbr == null) {
            return null;
        }
        return new Rectangle2D.Double(mbr[0], mbr[1], mbr[dim] - mbr[0], mbr[dim + 1] - mbr[1]);
    }
}

