/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.core;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegionEvent;

public class EventManager
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ComponentListener,
ActionListener,
ChangeListener,
FocusListener {
    private MapRegionEvent lastEvent;
    private MapCanvas canvas;
    private LinkedList<Runnable> runLaterList = new LinkedList();
    private final int WAIT = 250;
    private Timer waitTimer;

    @Override
    public void keyPressed(KeyEvent e) {
        this.processInputEvent(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.processInputEvent(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.processInputEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.processInputEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.processInputEvent(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1 && e.getButton() == 3) {
            this.canvas.setPopupMenu(new JPopupMenu());
        }
        this.processInputEvent(e);
        if (e.getClickCount() == 1 && e.getButton() == 3) {
            this.canvas.getPopupMenu().show(this.canvas, e.getX(), e.getY());
            this.canvas.setPopupMenu(null);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.processInputEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.processInputEvent(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.processInputEvent(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.processInputEvent(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.processInputEvent(e);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.enqueMapRegionChange((MapRegionEvent)e);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    protected void enqueMapRegionChange(MapRegionEvent e) {
        this.lastEvent = e;
        if (this.waitTimer == null) {
            this.waitTimer = new Timer(250, this);
            this.waitTimer.start();
        } else {
            this.waitTimer.restart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.waitTimer) {
            this.waitTimer.stop();
            this.waitTimer = null;
            this.processMapRegionChange(this.lastEvent);
        }
    }

    private void processMapRegionChange(MapRegionEvent e) {
        if (this.canvas == null || this.canvas.getWidth() == 0 || this.canvas.getHeight() == 0 || this.canvas.getMapRegion().getDataWindow() == null) {
            return;
        }
        ArrayList<Layer> exceptedLayers = new ArrayList<Layer>();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        Iterator<Layer> itr = this.canvas.getLayerManager().descendingLayerIterator();
        while (itr.hasNext()) {
            Layer layer = itr.next();
            try {
                if (!layer.isVisible()) continue;
                layer.mapRegionChanged(e);
            }
            catch (Throwable ex) {
                exceptedLayers.add(layer);
                exceptions.add(ex);
            }
        }
        if (!exceptedLayers.isEmpty()) {
            this.canvas.onLayerException(exceptedLayers, exceptions);
        }
    }

    private void processInputEvent(EventObject e) {
        this.canvas.setCursor(Cursor.getDefaultCursor());
        ArrayList<Layer> exceptedLayers = new ArrayList<Layer>();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        Iterator<Layer> itr = this.canvas.getLayerManager().descendingLayerIterator();
        while (itr.hasNext()) {
            Layer layer = itr.next();
            try {
                if (layer.handleEvent(e)) continue;
                break;
            }
            catch (Throwable ex) {
                exceptedLayers.add(layer);
                exceptions.add(ex);
            }
        }
        while (this.runLaterList.size() > 0) {
            Runnable r = this.runLaterList.poll();
            try {
                r.run();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!exceptedLayers.isEmpty()) {
            this.canvas.onLayerException(exceptedLayers, exceptions);
        }
        this.canvas.actuallySetCursor();
        if (e instanceof InputEvent && !(e instanceof KeyEvent)) {
            ((InputEvent)e).consume();
        }
    }

    public void runLater(Runnable r) {
        this.runLaterList.offer(r);
    }

    public MapCanvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(MapCanvas canvas) {
        this.canvas = canvas;
    }
}

