/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.core;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.sdovis.util.ShapeUtil;
import oracle.spatial.geometry.JGeometry;

public class Drawable {
    protected static int defaultPointSize = 8;
    public static final int TYPE_AREA = 1;
    public static final int TYPE_LINESTRING = 2;
    public static final int TYPE_POINT = 3;
    public static final int TYPE_ORIENTED_POINT = 4;
    public static final int TYPE_IMAGE = 5;
    private Shape shape = null;
    private Point2D point = null;
    private Image image = null;
    private double vectorX = 0.0;
    private double vectorY = 0.0;
    private int type = 0;
    private Drawable next = null;

    public Drawable() {
    }

    public Drawable(Shape shape, int type) {
        this.setShape(shape, type);
    }

    public Drawable(Point2D point) {
        this.setPoint(point);
    }

    public Drawable(Point2D point, double vectorX, double vectorY) {
        this.point = point;
        this.vectorX = vectorX;
        this.vectorY = vectorY;
        this.type = 4;
    }

    public Drawable(Image img) {
        this.image = img;
        this.type = 5;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Point2D getPoint() {
        return this.point;
    }

    public void setShape(Shape shp, int type) {
        this.shape = shp;
        this.type = type;
        this.point = null;
    }

    public void setPoint(Point2D pt) {
        this.point = pt;
        this.type = 3;
        this.shape = null;
    }

    public boolean isShape() {
        return this.type == 1 || this.type == 2;
    }

    public boolean isPoint() {
        return this.type == 3 || this.type == 4;
    }

    public Rectangle2D getBounds2D() {
        Rectangle2D res = null;
        switch (this.type) {
            case 1: 
            case 2: {
                res = this.shape.getBounds2D();
                break;
            }
            case 3: 
            case 4: {
                res = new Rectangle2D.Double(this.point.getX(), this.point.getY(), 0.0, 0.0);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid drawable type.");
            }
        }
        if (this.next != null) {
            res.add(this.next.getBounds2D());
        }
        return res;
    }

    public Rectangle getBounds() {
        Rectangle res = null;
        switch (this.type) {
            case 1: 
            case 2: {
                res = this.shape.getBounds();
                break;
            }
            case 3: 
            case 4: {
                res = new Rectangle((int)this.point.getX(), (int)this.point.getY(), 0, 0);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid drawable type.");
            }
        }
        if (this.next != null) {
            res.add(this.next.getBounds());
        }
        return res;
    }

    public boolean contains(double x, double y) {
        boolean res = false;
        switch (this.type) {
            case 1: 
            case 2: {
                res = this.shape.contains(x, y);
                break;
            }
            case 3: 
            case 4: {
                res = this.point.getX() == x && this.point.getY() == y;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid drawable type.");
            }
        }
        if (res) {
            return true;
        }
        if (this.next != null) {
            res = this.next.contains(x, y);
        }
        return res;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean hitTest(Point2D p, double tolerance) {
        boolean res = false;
        switch (this.type) {
            case 1: {
                res = this.shape.contains(p.getX(), p.getY());
                break;
            }
            case 2: {
                res = this.shape.contains(p.getX(), p.getY());
                if (res) break;
                Rectangle2D.Double window = new Rectangle2D.Double(p.getX() - tolerance, p.getY() - tolerance, tolerance, tolerance);
                Rectangle2D r2d = this.shape.getBounds2D();
                double r2wdt = r2d.getWidth();
                double r2hgt = r2d.getHeight();
                if (r2wdt == 0.0 && r2hgt == 0.0 && window.contains(r2d.getCenterX(), r2d.getCenterY())) {
                    res = true;
                    break;
                }
                if (!window.contains(r2d) && !ShapeUtil.intersects((Shape)this.shape, (Shape)window)) break;
                res = true;
                break;
            }
            case 3: 
            case 4: {
                res = Math.abs(this.point.getX() - p.getX()) <= tolerance && Math.abs(this.point.getY() - p.getY()) <= tolerance;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid drawable type.");
            }
        }
        if (res) {
            return true;
        }
        if (this.next != null) {
            res = this.next.hitTest(p, tolerance);
        }
        return res;
    }

    public void draw(Graphics2D g) {
        switch (this.type) {
            case 1: 
            case 2: {
                g.draw(this.shape);
                break;
            }
            case 3: 
            case 4: {
                g.drawOval((int)this.point.getX() - defaultPointSize / 2, (int)this.point.getY() - defaultPointSize / 2, defaultPointSize, defaultPointSize);
            }
        }
        if (this.next != null) {
            this.next.draw(g);
        }
    }

    public void fill(Graphics2D g) {
        switch (this.type) {
            case 1: {
                g.fill(this.shape);
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                g.fillOval((int)this.point.getX() - defaultPointSize / 2, (int)this.point.getY() - defaultPointSize / 2, defaultPointSize, defaultPointSize);
            }
        }
        if (this.next != null) {
            this.next.fill(g);
        }
    }

    public void setNext(Drawable dr) {
        this.next = dr;
    }

    public Drawable getNext() {
        return this.next;
    }

    public Drawable getLast() {
        if (this.next != null) {
            return this.next.getLast();
        }
        return this;
    }

    public static int getDefaultPointSize() {
        return defaultPointSize;
    }

    public static void setDefaultPointSize(int defaultPointSize) {
        Drawable.defaultPointSize = defaultPointSize;
    }

    public int getType() {
        return this.type;
    }

    public double getVectorX() {
        return this.vectorX;
    }

    public double getVectorY() {
        return this.vectorY;
    }

    public static Drawable createDrawable(JGeometry geom, AffineTransform at) {
        if (geom == null) {
            return null;
        }
        Drawable head = null;
        Drawable prev = null;
        JGeometry newGeom = geom;
        if (at != null && !at.isIdentity()) {
            try {
                newGeom = JGeometryUtil.transformGeometry((JGeometry)geom, (AffineTransform)at);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        JGeometry[] elements = newGeom.getElements();
        for (int i = 0; i < elements.length; ++i) {
            Drawable dr = null;
            int gt = elements[i].getType();
            if (gt == 1) {
                Point2D p2 = elements[i].getJavaPoint();
                if (elements[i].isOrientedPoint()) {
                    double[] ords = elements[i].getOrdinatesArray();
                    int dim = elements[i].getDimensions();
                    dr = new Drawable(p2, ords[dim], ords[dim + 1]);
                } else {
                    dr = new Drawable(p2);
                }
            } else {
                Shape shp = elements[i].createShape();
                int type = 2;
                if (gt == 3) {
                    type = 1;
                }
                dr = new Drawable(shp, type);
            }
            if (prev != null) {
                prev.setNext(dr);
            } else {
                head = dr;
            }
            prev = dr;
        }
        return head;
    }

    public static Drawable createDrawable(JGeometry[] geoms, AffineTransform at) {
        if (geoms == null || geoms.length == 0) {
            return null;
        }
        Drawable drawable = null;
        Drawable last = null;
        for (int i = 0; i < geoms.length; ++i) {
            Drawable dr = Drawable.createDrawable(geoms[i], at);
            if (dr == null) continue;
            if (drawable == null) {
                drawable = dr;
            }
            if (last != null) {
                last.next = dr;
            }
            last = dr.getLastDrawable();
        }
        return drawable;
    }

    private Drawable getLastDrawable() {
        Drawable last = this;
        while (last.next != null) {
            last = last.next;
        }
        return last;
    }
}

