/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.favoritesNavigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeListener;
import oracle.help.java.util.MnemonicUtils;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.navigator.favoritesNavigator.FavoritesNavigator;
import oracle.help.topicDisplay.TopicDisplay;

public class FavoritesActionUtils {
    private static final String _RENAME = "addfavoriteitem.rename";
    private static final String _TOPIC_NAME = "addfavoriteitem.topicname";
    private static final String _NEW_FOLDER = "addfavoriteitem.newfolder";
    private static final String _FOLDER_NAME = "addfavoriteitem.foldername";

    private FavoritesActionUtils() {
    }

    public static void addFavoriteItem(FavoritesModel model, TopicDisplay display, Frame parentFrame) {
        String text = display.getCurrentPageTitle();
        String target = null;
        String hstitle = null;
        String url = display.getCurrentURL().toString();
        new AddFavoriteItemDialog(parentFrame, model, text, target, hstitle, url);
    }

    public static void renameFavoriteItem(Component owner, TopicTreeNode selectedNode, FavoritesModel model) {
        if (selectedNode != null) {
            ResourceBundle miscBundle = ResourceBundle.getBundle("oracle.help.resource.MiscBundle");
            String renameString = miscBundle.getString(_RENAME);
            JEWTDialog dialog = JEWTDialog.createDialog((Component)owner, (String)renameString, (int)3);
            JPanel folderNameBox = new JPanel();
            Topic selectedTopic = selectedNode.getTopic();
            String topicName = selectedTopic == null ? "" : selectedTopic.getLabel();
            JTextField nameField = new JTextField(topicName, 20);
            nameField.requestFocus();
            nameField.getDocument().addDocumentListener(FavoritesActionUtils._getDocumentListenerForRenameTextField(nameField, dialog, topicName));
            JLabel nameLabel = MnemonicUtils.createLabel(miscBundle.getString(_TOPIC_NAME), nameField);
            folderNameBox.add(nameLabel);
            folderNameBox.add(Box.createHorizontalStrut(5));
            folderNameBox.add(nameField);
            dialog.setContent((Component)folderNameBox);
            dialog.setResizable(true);
            dialog.setInitialFocus((Component)nameField);
            dialog.setOKButtonEnabled(false);
            if (dialog.runDialog()) {
                model.renameFavoriteItem(selectedNode, nameField.getText().trim());
            }
        }
    }

    public static void createNewFolder(Component owner, TopicTreeNode parent, FavoritesModel model) {
        ResourceBundle miscBundle = ResourceBundle.getBundle("oracle.help.resource.MiscBundle");
        String newFolderString = miscBundle.getString(_NEW_FOLDER);
        JEWTDialog dialog = JEWTDialog.createDialog((Component)owner, (String)newFolderString, (int)3);
        JPanel folderNameBox = new JPanel();
        JTextField nameField = new JTextField(StringUtils.stripMnemonic((String)newFolderString), 20);
        nameField.requestFocus();
        JLabel nameLabel = MnemonicUtils.createLabel(miscBundle.getString(_FOLDER_NAME), nameField);
        folderNameBox.add(nameLabel);
        folderNameBox.add(Box.createHorizontalStrut(5));
        folderNameBox.add(nameField);
        dialog.setContent((Component)folderNameBox);
        dialog.setResizable(true);
        dialog.setInitialFocus((Component)nameField);
        if (dialog.runDialog()) {
            model.addFavoriteItem(nameField.getText(), null, null, null, parent);
        }
    }

    private static DocumentListener _getDocumentListenerForRenameTextField(final JTextField nameField, final JEWTDialog dialog, final String topicName) {
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this._updateOKButtonStatus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this._updateOKButtonStatus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this._updateOKButtonStatus();
            }

            private void _updateOKButtonStatus() {
                String newTopicName = nameField.getText().trim();
                boolean enableOKButton = !newTopicName.isEmpty() && !topicName.equals(newTopicName);
                dialog.setOKButtonEnabled(enableOKButton);
            }
        };
        return documentListener;
    }

    private static class AddFavoriteItemDialog
    extends JDialog
    implements ActionListener {
        private static final String _MISC_RESOURCE_BUNDLE = "oracle.help.resource.MiscBundle";
        private static final String _CANCEL = "cancel";
        private static final String _KEY_CLOSE = "CLOSE";
        private static final String _ADD_TO_FAVORITES = "addfavoriteitem.addtofavorites";
        private static final String _TOPIC_NAME = "addfavoriteitem.topicname";
        private static final String _CREATE_IN = "addfavoriteitem.createin";
        private static final String _DELETE = "addfavoriteitem.delete";
        private static final String _NEW_FOLDER_DOT = "addfavoriteitem.newfolderdot";
        private static final String _RENAME_DOT = "addfavoriteitem.renamedot";
        private ResourceBundle _miscBundle = null;
        private FavoritesModel _model;
        private JTextField _text;
        private String _target;
        private String _hstitle;
        private String _url;
        private FavoritesNavigator _favoritesNav;
        private JButton _add;
        private JButton _close;
        private JButton _newFolder;
        private JButton _rename;
        private JButton _delete;

        public AddFavoriteItemDialog(Frame frame, FavoritesModel model, String text, String target, String hstitle, String url) {
            super(frame, true);
            this._model = model;
            this._target = target;
            this._hstitle = hstitle;
            this._url = url;
            this._text = new JTextField(text, 30);
            this._miscBundle = ResourceBundle.getBundle(_MISC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
            this._buildUI(frame);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this._close || _KEY_CLOSE.equals(e.getActionCommand())) {
                this.setVisible(false);
                this.dispose();
            } else if (src == this._add) {
                this._model.addFavoriteItem(this._text.getText(), this._target, this._hstitle, this._url, this._favoritesNav.getCurrentSelectionNode());
                this.setVisible(false);
                this.dispose();
            } else if (src == this._newFolder) {
                FavoritesActionUtils.createNewFolder(this, this._favoritesNav.getCurrentSelectionNode(), this._model);
            } else if (src == this._rename) {
                FavoritesActionUtils.renameFavoriteItem(this, this._favoritesNav.getCurrentSelectionNode(), this._model);
            } else if (src == this._delete) {
                this._model.removeFavoriteItem(this._favoritesNav.getCurrentSelectionNode());
            }
        }

        private void _buildUI(Frame frame) {
            JPanel mainPanel = new JPanel();
            mainPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            mainPanel.setLayout(new BorderLayout(10, 15));
            this.getContentPane().add(mainPanel);
            Box nameBox = Box.createHorizontalBox();
            JLabel instructionLabel = MnemonicUtils.createLabel(this._miscBundle.getString("addfavoriteitem.topicname"), this._text);
            nameBox.add(instructionLabel);
            nameBox.add(Box.createHorizontalStrut(5));
            nameBox.add(this._text);
            this._favoritesNav = new FavoritesNavigator();
            this._favoritesNav.setFavoritesModel(this._model);
            this._favoritesNav.initializeLazyNavigator();
            this._favoritesNav.addTopicTreeListener(new FavoritesListener());
            Box navBox = Box.createHorizontalBox();
            Box labelBox = Box.createVerticalBox();
            JLabel createInLabel = MnemonicUtils.createLabel(this._miscBundle.getString(_CREATE_IN), this._favoritesNav);
            labelBox.add(createInLabel);
            navBox.add(labelBox);
            navBox.add(Box.createHorizontalStrut(20));
            navBox.add(this._favoritesNav);
            Box mainBox = Box.createVerticalBox();
            mainBox.add(nameBox);
            mainBox.add(navBox);
            mainPanel.add((Component)mainBox, "Center");
            String addToFavString = this._miscBundle.getString(_ADD_TO_FAVORITES);
            this.setTitle(StringUtils.stripMnemonic((String)addToFavString));
            this._add = MnemonicUtils.createButton(addToFavString);
            this._add.addActionListener(this);
            this._add.setDefaultCapable(true);
            this.getRootPane().setDefaultButton(this._add);
            String newFolderString = this._miscBundle.getString(_NEW_FOLDER_DOT);
            this._newFolder = MnemonicUtils.createButton(newFolderString);
            this._newFolder.addActionListener(this);
            String renameString = this._miscBundle.getString(_RENAME_DOT);
            this._rename = MnemonicUtils.createButton(renameString);
            this._rename.addActionListener(this);
            String deleteString = this._miscBundle.getString(_DELETE);
            this._delete = MnemonicUtils.createButton(deleteString);
            this._delete.addActionListener(this);
            this._close = MnemonicUtils.createButton(this._miscBundle.getString(_CANCEL));
            this._close.addActionListener(this);
            Box buttonBox = Box.createVerticalBox();
            buttonBox.add(Box.createVerticalStrut(20));
            buttonBox.add(this._add);
            buttonBox.add(Box.createVerticalStrut(5));
            buttonBox.add(this._close);
            buttonBox.add(Box.createVerticalStrut(25));
            buttonBox.add(this._newFolder);
            buttonBox.add(Box.createVerticalStrut(5));
            buttonBox.add(this._newFolder);
            buttonBox.add(Box.createVerticalStrut(5));
            buttonBox.add(this._rename);
            buttonBox.add(Box.createVerticalStrut(5));
            buttonBox.add(this._delete);
            mainPanel.add((Component)buttonBox, "East");
            this.addWindowListener(WindowUtils.getWindowCloser());
            JRootPane rootPane = this.getRootPane();
            rootPane.registerKeyboardAction(this, _KEY_CLOSE, KeyStroke.getKeyStroke(27, 0), 1);
            this.pack();
            WindowUtils.centerWindow((Window)this, (Component)frame);
            this.setVisible(true);
            this._add.grabFocus();
        }

        private class FavoritesListener
        implements TopicTreeListener {
            private FavoritesListener() {
            }

            @Override
            public void topicActivated(TopicTreeItem item, boolean newWindow) {
            }

            @Override
            public void topicSelected(TopicTreeItem item) {
                if (item == null || item != null && item.getTopicTreeNode() == AddFavoriteItemDialog.this._model.getFavoritesRoot()) {
                    AddFavoriteItemDialog.this._rename.setEnabled(false);
                    AddFavoriteItemDialog.this._delete.setEnabled(false);
                } else {
                    AddFavoriteItemDialog.this._rename.setEnabled(true);
                    AddFavoriteItemDialog.this._delete.setEnabled(true);
                }
            }

            @Override
            public void popupDisplayed(TopicTreeItem item, JPopupMenu popup) {
            }
        }
    }
}

