/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.htmlBrowser.print;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.FontCache;
import ice.pilots.html4.ThePilot;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.StormBase;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.storm.print.StormPageFormat;
import ice.util.unit.PointUnit;
import ice.util.unit.Unit;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.net.URL;
import oracle.help.htmlBrowser.print.ICEPrintImpl;
import oracle.help.htmlBrowser.print.PrintStatusDialog;

public class ICEPrintImplJava2
implements ICEPrintImpl {
    private StormBase _stormBase = null;
    private String _viewportName = null;
    private Frame _parentFrame = null;
    private PrintStatusDialog _printStatusDialog = null;
    private static double PAGE_MARGIN = 54.0;

    public ICEPrintImplJava2(StormBase stormBase, String viewportName, Frame parentFrame) {
        this._stormBase = stormBase;
        this._viewportName = viewportName;
        this._parentFrame = parentFrame;
    }

    @Override
    public void printURL(URL url) {
        if (url != null) {
            URL[] urlArr = new URL[]{url};
            this.printURLs(urlArr);
        }
    }

    @Override
    public void printURLs(URL[] urls) {
        if (urls != null && urls.length > 0) {
            this._doJava2Printing(urls);
        }
    }

    @Override
    public Printable getPrintable(URL[] urls) {
        if (urls != null && urls.length > 0) {
            return new PrintableImpl(urls);
        }
        return null;
    }

    private void _doJava2Printing(URL[] urls) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pf = printJob.defaultPage();
        Paper paper = pf.getPaper();
        double paperWidth = paper.getWidth();
        double paperHeight = paper.getHeight();
        paper.setImageableArea(PAGE_MARGIN, PAGE_MARGIN, paperWidth - 2.0 * PAGE_MARGIN, paperHeight - 2.0 * PAGE_MARGIN);
        pf.setPaper(paper);
        pf = printJob.validatePage(pf);
        printJob.setPrintable(new PrintableImpl(urls), pf);
        if (printJob.printDialog()) {
            this._printStatusDialog = new PrintStatusDialog(this._parentFrame, new CancelListener(printJob));
            this._printStatusDialog.setVisible(true);
            try {
                printJob.print();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._printStatusDialog.setVisible(false);
        }
    }

    private class CancelListener
    implements ActionListener {
        private PrinterJob _printJob;

        public CancelListener(PrinterJob printJob) {
            this._printJob = printJob;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._printJob.cancel();
        }
    }

    private class PrintableImpl
    implements Printable {
        private URL[] _urls;
        private int _lastPageIndex = -1;
        private String _lastPageTitle = null;
        private int _lastURLIndex = -1;
        private float _printScale = 0.75f;
        private StormPrinter _stormPrinter = null;

        public PrintableImpl(URL[] urls) {
            this._urls = urls;
            this._lastPageIndex = -1;
            this._lastURLIndex = -1;
            this._lastPageTitle = null;
        }

        @Override
        public int print(Graphics g, PageFormat pf, int pageIndex) {
            FontCache.setPrintGraphics((Graphics)g);
            StormPrinter currentPrinter = this._getStormPrinter(pf, pageIndex);
            this._lastPageIndex = pageIndex;
            if (currentPrinter != null) {
                Graphics2D g2 = (Graphics2D)g;
                g2.translate(pf.getImageableX(), pf.getImageableY());
                g2.scale(this._printScale, this._printScale);
                currentPrinter.printPage(g);
                FontCache.setPrintGraphics(null);
                return 0;
            }
            FontCache.setPrintGraphics(null);
            return 1;
        }

        private StormPrinter _getStormPrinter(PageFormat pf, int pageIndex) {
            String statusLabel = null;
            if (pageIndex == this._lastPageIndex) {
                return this._stormPrinter;
            }
            while (true) {
                if (this._stormPrinter != null) {
                    int noOfPagesToSkip = pageIndex - this._lastPageIndex;
                    boolean needToBreak = false;
                    for (int i = 0; i < noOfPagesToSkip; ++i) {
                        needToBreak = this._stormPrinter.layoutNextPage();
                    }
                    if (needToBreak) break;
                }
                this._stormPrinter = null;
                ++this._lastURLIndex;
                if (this._lastURLIndex >= this._urls.length) break;
                URL currentURL = this._urls[this._lastURLIndex];
                if (currentURL == null) continue;
                ContentLoader loader = new ContentLoader(currentURL, "text/html");
                ICEPrintImplJava2.this._stormBase.renderContentFully(loader, ICEPrintImplJava2.this._viewportName);
                Viewport view = ICEPrintImplJava2.this._stormBase.findViewportByName(ICEPrintImplJava2.this._viewportName);
                Pilot pilot = view.getPilot();
                if (pilot == null) continue;
                this._stormPrinter = pilot.createPrinter();
                if (this._stormPrinter == null) continue;
                if (pilot instanceof ThePilot) {
                    ThePilot htmlPilot = (ThePilot)pilot;
                    DDocument document = (DDocument)htmlPilot.getDocument();
                    statusLabel = document.getTitle();
                }
                if (statusLabel != null && ICEPrintImplJava2.this._printStatusDialog != null) {
                    ICEPrintImplJava2.this._printStatusDialog.setStatusLabel(statusLabel);
                }
                StormPageFormat stormFormat = new StormPageFormat();
                stormFormat.setMargin((Unit)new PointUnit(0.0), 1);
                stormFormat.setMargin((Unit)new PointUnit(0.0), 3);
                stormFormat.setMargin((Unit)new PointUnit(0.0), 2);
                stormFormat.setMargin((Unit)new PointUnit(0.0), 4);
                if (pf.getOrientation() == 0) {
                    stormFormat.setOrientation(0);
                } else {
                    stormFormat.setOrientation(1);
                }
                stormFormat.setPageSize((Unit)new PointUnit(pf.getImageableWidth() / (double)this._printScale), (Unit)new PointUnit(pf.getImageableHeight() / (double)this._printScale));
                System.setProperty("ice.pilots.html4.printScaleAdjustment", "100");
                this._stormPrinter.setStormPageFormat(stormFormat);
            }
            return this._stormPrinter;
        }
    }
}

