/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.config.DbCartUserCopyConfig;
import oracle.dbtools.dbcart.tools.DbCartUtilityTool;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.databasecopy.DbCartCopy;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.SwingUtils;

public class DbCartCopyTool
extends DbCartUtilityTool {
    public static final String TYPE = "COPY";
    public static int ACTION = Ide.findOrCreateCmdID((String)"cart_copy");
    private JEWTDialog _actionDialog;
    private static final long serialVersionUID = 1L;
    public static int PREFERENCES = 0;
    public static int WIZARD = 1;
    private int m_usage;
    private OracleConnectionComboBox m_destConnSelector = new OracleConnectionComboBox();
    private JLabel m_labelDDL;
    private JCheckBox m_chkbxCopyDDL = new JCheckBox();
    private JRadioButton m_jRdoNotReplaceDest = new JRadioButton();
    private JRadioButton m_jRdoReplaceDest = new JRadioButton();
    private boolean m_showDDLCheckBox = true;
    private JCheckBox m_chkbxCopyData = new JCheckBox();
    private JCheckBox m_chkbxTruncData = new JCheckBox();
    private DbCartUserCopyConfig _config = new DbCartUserCopyConfig();
    private JCheckBox m_chkStopOnError = new JCheckBox();
    public static final int CONTINUE = 0;
    public static final int CANCEL_WITH_MSG = 1;
    public static final int CANCEL = 2;

    public DbCartCopyTool() {
        super(TYPE, 3);
    }

    @Override
    public IdeAction getAction() {
        if (this._action == null) {
            this._action = IdeAction.get((int)ACTION, null, (String)DbCartAddinArb.getString("COPY_LABEL"), null, null, (Icon)RaptorImagesArb.getIcon((String)TYPE), null, (boolean)true);
            this._action.addController((Controller)this);
        }
        return this._action;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == ACTION) {
            this.showDialog();
            return true;
        }
        return false;
    }

    public void showDialog() {
        ArrayList<ExtractObject> arrayList = DbCartUtil.getTableModel().getIncludedDBORows();
        List<ExtractObject> list = DbCartUtil.validateUniqueObjects(arrayList, false);
        this.getFilteredDestConnectionNames();
        if (!list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            if (!list.isEmpty()) {
                DbCartAddinArb.format("NOT_SUPPORTED", new Object[]{DbCartAddinArb.getString("EXPORT_LABEL")} + "\n");
                stringBuilder.append(DbCartAddinArb.getString("NON_UNIQUE_CART_COPY") + "\n\n");
                for (ExtractObject extractObject : list) {
                    stringBuilder.append(string + Connections.getDisplayName((String)extractObject.getDBObject().getConnectionName()) + ": " + extractObject.getDBObject().getObjectType() + " " + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                    string = ", ";
                }
                stringBuilder.append("\n\n");
                stringBuilder.append(DbCartAddinArb.format("NOT_SUPPORTED", DbCartAddinArb.getString("COPY_LABEL")) + "\n\n");
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)stringBuilder.toString(), (String)DbCartAddinArb.getString("CART_ERROR_TITLE"), (String)"DBCART_UNSUPPORTED_OBJECT_ERROR");
            }
        } else {
            String string = DbCartAddinArb.getString("COPY_DIALOG_TITLE");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_copyobjects_html");
            jPanel.add((Component)this.getConfigPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 0, new Insets(6, 0, 0, 0), 0, 0));
            jPanel.add((Component)this.getConnectionPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 2, new Insets(16, 0, 16, 0), 0, 0));
            jPanel.add((Component)this.getDdlPanel(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 1, new Insets(6, 0, 0, 0), 0, 0));
            jPanel.add((Component)this.getDataPanel(), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 23, 1, new Insets(6, 0, 16, 0), 0, 0));
            jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
            this._actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
            this._actionDialog.pack();
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = 0;
                    if (actionEvent.getActionCommand().equalsIgnoreCase("apply") && (n = DbCartCopyTool.this.validateUserInput()) == 0) {
                        DbCartCopy dbCartCopy = new DbCartCopy();
                        dbCartCopy.isCopyDDL(DbCartCopyTool.this.getChkbxCopyDDL());
                        dbCartCopy.isCopyData(DbCartCopyTool.this.getChkbxCopyData());
                        dbCartCopy.isNotReplaceDest(DbCartCopyTool.this.getDoNotReplaceDest());
                        dbCartCopy.isReplaceDest(DbCartCopyTool.this.getDoReplaceDest());
                        dbCartCopy.isTruncateData(DbCartCopyTool.this.getChkbxTruncData());
                        dbCartCopy.setTargetConnection(DbCartCopyTool.this.getTargetConnection());
                        dbCartCopy.setExtractObjectList(DbCartCopyTool.this.getClonedExtractObjects());
                        dbCartCopy.setDbCartCopy();
                    }
                    if (n == 0) {
                        DbCartCopyTool.this._actionDialog.setVisible(false);
                        DbCartCopyTool.this._actionDialog.dispose();
                    }
                }
            };
            this._actionDialog.addActionListener(actionListener);
            Dimension dimension = jPanel.getPreferredSize();
            int n = (int)dimension.getHeight() + 80;
            int n2 = (int)dimension.getWidth() + 80;
            this._actionDialog.setMinimumSize(n2, n);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._actionDialog);
            WizardLauncher.runDialog((JDialog)this._actionDialog);
        }
    }

    private JPanel getConnectionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("D_CON_LABEL")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("D_CON_LABEL")));
        jLabel.setLabelFor(this.m_destConnSelector.getJComboBox());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_destConnSelector.getJComboBox(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 22, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.addConnectionListener();
        return jPanel;
    }

    private void addConnectionListener() {
        this.m_destConnSelector.getJComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    Connections.getInstance().getConnection(DbCartCopyTool.this.m_destConnSelector.getCurrentConnectionName());
                }
                catch (Exception exception) {
                    Throwable throwable;
                    Exception exception2;
                    DbCartCopyTool.this.m_destConnSelector.getJComboBox().setSelectedIndex(-1);
                    while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                        exception2 = (Exception)throwable;
                    }
                    ExceptionHandler.handleException((Throwable)exception2);
                }
            }
        });
        this.m_destConnSelector.getJComboBox().setSelectedIndex(-1);
    }

    public void setTargetConnection(String string) {
        if (this.m_destConnSelector != null) {
            this.m_destConnSelector.setCurrentConnection(string);
        }
    }

    public String getTargetConnection() {
        if (this.m_destConnSelector != null) {
            return this.m_destConnSelector.getCurrentConnectionName();
        }
        return null;
    }

    private JPanel getDdlPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = this.m_usage == WIZARD ? this.getStringDDLOption() : this.getStringDDLOptionPref();
        ResourceUtils.resButton((AbstractButton)this.m_chkbxCopyDDL, (String)string);
        ResourceUtils.resButton((AbstractButton)this.m_jRdoNotReplaceDest, (String)this.getStringDoNotReplace());
        ResourceUtils.resButton((AbstractButton)this.m_jRdoReplaceDest, (String)this.getStringDoReplace());
        if (this.m_showDDLCheckBox) {
            this.m_chkbxCopyDDL.setText(StringUtils.stripMnemonic((String)(this.m_usage == WIZARD ? this.getStringDDLOption() : this.getStringDDLOptionPref())));
        } else {
            this.m_labelDDL = new JLabel(StringUtils.stripMnemonic((String)(this.m_usage == WIZARD ? this.getStringDDLOption() : this.getStringDDLOptionPref())));
        }
        this.setDDLComponents();
        this.setDoNotReplace(this.m_jRdoNotReplaceDest);
        this.m_jRdoNotReplaceDest.setSelected(true);
        this.setDoReplace(this.m_jRdoReplaceDest);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_jRdoNotReplaceDest);
        buttonGroup.add(this.m_jRdoReplaceDest);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this.m_jRdoNotReplaceDest, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 0, 0), 0, 0));
        jPanel2.add((Component)this.m_jRdoReplaceDest, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 0, 0), 0, 0));
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 20, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel2, "Center");
        TitledPane titledPane = new TitledPane((Component)(this.m_showDDLCheckBox ? this.m_chkbxCopyDDL : this.m_labelDDL), (Component)jPanel4);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)titledPane, "Center");
        this.setDDLComponents();
        return jPanel;
    }

    private JPanel getDataPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.m_chkbxCopyData, (String)StringUtils.stripMnemonic((String)DbCartAddinArb.getString("COPY_DATA_OPTION")));
        ResourceUtils.resButton((AbstractButton)this.m_chkbxTruncData, (String)DbCartAddinArb.getString("TRUNCATE_DATA_COPY"));
        this.m_chkbxTruncData.setSelected(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this.m_chkbxTruncData, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 8, 0, 0), 0, 0));
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 20, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel2, "Center");
        TitledPane titledPane = new TitledPane((Component)this.m_chkbxCopyData, (Component)jPanel4);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)titledPane, "Center");
        this.setDataComponents();
        return jPanel;
    }

    public boolean getChkbxCopyDDL() {
        return this.m_chkbxCopyDDL.isSelected();
    }

    public void setChkbxCopyDDL(boolean bl) {
        this.m_chkbxCopyDDL.setSelected(bl);
    }

    public boolean getChkbxCopyData() {
        return this.m_chkbxCopyData.isSelected();
    }

    public void setChkbxCopyData(boolean bl) {
        this.m_chkbxCopyData.setSelected(bl);
    }

    public boolean getDoNotReplaceDest() {
        return this.m_jRdoNotReplaceDest.isSelected();
    }

    public boolean getDoReplaceDest() {
        return this.m_jRdoReplaceDest.isSelected();
    }

    public void setDoNotReplaceDest(boolean bl) {
        this.m_jRdoNotReplaceDest.setSelected(bl);
    }

    public void setDoReplaceDest(boolean bl) {
        this.m_jRdoReplaceDest.setSelected(bl);
    }

    private String getStringDDLOption() {
        return DbCartAddinArb.getString("COPY_DDL_OPTION");
    }

    private String getStringDDLOptionPref() {
        return DbCartAddinArb.getString("COPY_DDL_OPTION_PREF");
    }

    private String getStringDoNotReplace() {
        return DbCartAddinArb.getString("DO_NOT_REPLACE_DEST");
    }

    private String getStringDoReplace() {
        return DbCartAddinArb.getString("DO_REPLACE_DEST");
    }

    private void setDoNotReplace(JRadioButton jRadioButton) {
        ResourceUtils.resButton((AbstractButton)jRadioButton, (String)DbCartAddinArb.getString("DO_NOT_REPLACE_DEST"));
        jRadioButton.setText(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("DO_NOT_REPLACE_DEST")));
        jRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("DO_NOT_REPLACE_DEST")));
    }

    private void setDoReplace(JRadioButton jRadioButton) {
        ResourceUtils.resButton((AbstractButton)jRadioButton, (String)DbCartAddinArb.getString("DO_REPLACE_DEST"));
        jRadioButton.setText(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("DO_REPLACE_DEST")));
        jRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("DO_REPLACE_DEST")));
    }

    public boolean getChkbxTruncData() {
        return this.m_chkbxTruncData.isSelected();
    }

    public void setChkbxTruncData(boolean bl) {
        this.m_chkbxTruncData.setSelected(bl);
    }

    public boolean getChkbxStopOnError() {
        return this.m_chkStopOnError.isSelected();
    }

    private int validateUserInput() {
        return this.checkForDestConnection() ? 0 : 1;
    }

    private boolean checkForDestConnection() {
        String string = this.getTargetConnection();
        Connection connection = null;
        boolean bl = false;
        if (string != null) {
            try {
                connection = Connections.getInstance().getConnection(string);
                bl = true;
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
        }
        if (connection == null) {
            MessageDialog.error((Component)SwingUtils.getMainWindow(), (Object)DbCartAddinArb.getString("NO_DEST_CONNECTION"), (String)DbCartAddinArb.getString("DBCART_COPY_ERROR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    private void setDDLComponents() {
        boolean bl = DbCartUtil.getTableModel().isAnyDDLRows();
        this.enableDdlOptions(bl);
        this.m_chkbxCopyDDL.setSelected(bl);
    }

    private void enableDdlOptions(boolean bl) {
        this.m_chkbxCopyDDL.setSelected(bl);
        this.m_chkbxCopyDDL.setEnabled(false);
        this.m_jRdoNotReplaceDest.setEnabled(bl);
        this.m_jRdoReplaceDest.setEnabled(bl);
        if (this.m_labelDDL != null) {
            this.m_labelDDL.setEnabled(bl);
        }
    }

    private void setDataComponents() {
        boolean bl = DbCartUtil.getTableModel().isAnyDataRows();
        this.enableDataOptions(bl);
        this.m_chkbxCopyData.setSelected(bl);
    }

    private void enableDataOptions(boolean bl) {
        this.m_chkbxCopyData.setEnabled(false);
        this.m_chkbxTruncData.setEnabled(bl);
    }

    @Override
    public void openConfigOptions() {
        URL uRL = this._chooser.getSelectedURL();
        try {
            this._config = new DbCartUserCopyConfig(DbCartUserCopyConfig.importFrom(uRL));
            String string = this._config.getString("DbCartConfig");
            if (string == null) {
                string = DbCartAddinArb.getString("XML_FILE_NO_KEY");
            }
            if (!string.equals("copy_tool")) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.format("XML_FILE_ERROR_MESSAGE", uRL.getFile(), "\"copy_tool\"", string), (String)DbCartAddinArb.getString("XML_FILE_ERROR_TITLE"), (String)"XML_FILE_ERROR_TITLE");
            } else {
                String string2 = this._config.getString("CONN_NAME");
                if (!this.setCombo(string2, this.m_destConnSelector.getJComboBox())) {
                    String string3 = string2 == null || string2.length() == 0 ? DbCartAddinArb.getString("XML_CONN_ERROR_MESSAGE4") : DbCartAddinArb.format("XML_CONN_ERROR_MESSAGE3", string2);
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)DbCartAddinArb.getString("XML_CONN_ERROR_TITLE"), (String)"XML_CONN_ERROR_TITLE");
                }
                this.setDDLComponents();
                this.m_jRdoReplaceDest.setSelected(this._config.getBoolean("DDL_DROP"));
                this.m_jRdoNotReplaceDest.setSelected(this._config.getBoolean("DDL_DROP") == false);
                this.setDataComponents();
                this.m_chkbxTruncData.setSelected(this._config.getBoolean("DATA_TRUNCATE"));
                this._actionDialog.repaint();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    public void saveConfigOptions() {
        URL uRL = this.getConfigURL();
        try {
            this._config.putString("DbCartConfig", "copy_tool");
            this._config.putString("CONN_NAME", (String)this.m_destConnSelector.getJComboBox().getSelectedItem());
            this._config.putBoolean("DDL_DROP", this.m_jRdoReplaceDest.isSelected());
            this._config.putBoolean("DATA_TRUNCATE", this.m_chkbxTruncData.isSelected());
            this._config.exportTo(uRL);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void getFilteredDestConnectionNames() {
        ArrayList<ExtractObject> arrayList = this.getClonedExtractObjects();
        OracleConnectionComboBox oracleConnectionComboBox = new OracleConnectionComboBox();
        String[] stringArray = oracleConnectionComboBox.getConnNames();
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(stringArray));
        for (ExtractObject extractObject : arrayList) {
            String string = extractObject.getSourceConnName();
            if (!arrayList2.contains(string)) continue;
            oracleConnectionComboBox.removeConnection(string);
        }
        this.m_destConnSelector = oracleConnectionComboBox;
    }
}

