/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.TPDBResultSetModel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.jdevimpl.db.resource.UISQLDevBundle;

public class ResultSetTesterComponent
extends TesterComponent {
    private final JPanel m_panel = new JPanel(new BorderLayout());
    private final ResultSetTable m_table = new ResultSetTable();

    public ResultSetTesterComponent() {
        this.m_panel.setName("ResultSetTesterComponent");
        this.m_table.setName("ResultSetTesterComponent.ResultSetTable");
    }

    public Component getComponent() {
        return this.m_panel;
    }

    public String getName() {
        return UISQLDevBundle.get("QUERY_RESULTS");
    }

    public void close() {
        this.m_panel.removeAll();
        try {
            this.m_table.closeModel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testSQL(Database db, String sqlQuery) {
        this.close();
        if (db != null) {
            try {
                if (db.getConnectionStore() == null) {
                    ModelImpl model = new ModelImpl(db);
                    model.init(sqlQuery, this.getBindVariables(db, sqlQuery));
                    this.m_table.setModel((TableModel)((Object)model));
                } else {
                    this.m_table.setQuery(db.getQualifiedName(), sqlQuery, null, this.getBindVariables(db, sqlQuery));
                }
                this.showOnPanel(new JScrollPane((Component)this.m_table), "Center");
                this.m_table.open(false);
            }
            catch (ExecutionException ee) {
                this.fail(ee.getCause());
            }
            catch (Throwable t) {
                this.fail(t);
            }
        }
    }

    private void fail(Throwable t) {
        String msg = UISQLDevBundle.format("QUERY_RESULTS_ERROR", t.getMessage());
        if (!(t instanceof SQLException)) {
            DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Execute failed in ResultSetTable", t);
        }
        this.close();
        JWrappedLabel label = new JWrappedLabel(msg);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.showOnPanel((Component)label, "North");
    }

    private void showOnPanel(Component c, Object constraints) {
        this.m_panel.removeAll();
        this.m_panel.add(c, constraints);
        this.m_panel.validate();
        this.m_panel.repaint();
    }

    private class ModelImpl
    extends TPDBResultSetModel {
        private final Database m_db;

        ModelImpl(Database db) {
            this.m_db = db;
        }

        protected Connection getConnection() throws DBException {
            return this.m_db.getConnection(false);
        }

        void init(String sql, Map<String, ?> bindMap) {
            String qname = DatabaseFactory.encodeIdentifier((String)ResultSetTesterComponent.this.getTester().getDefaultConnectionStore(), (String)this.m_db.getConnectionName());
            super.init(sql, qname, null, bindMap);
        }
    }
}

