/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.text.parser;

import oracle.ide.ceditor.text.parser.Parser;
import oracle.ide.ceditor.text.parser.Producer;

abstract class GenericParser
implements Parser {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_STRING = 1;
    private static final int STATE_WORD = 2;
    private static final int STATE_SLASH = 3;
    private static final int STATE_SINGLE_LINE_COMMENT = 4;
    private static final int STATE_COMMENT_1 = 5;
    private static final int STATE_COMMENT = 6;
    private static final int STATE_JAVADOC = 7;
    private static final int STATE_CHAR = 8;
    private int _state;

    GenericParser() {
    }

    protected abstract boolean isLitteral(String var1);

    protected abstract boolean isReservedWord(String var1);

    protected abstract boolean isOperator(char var1);

    protected abstract boolean isBrace(char var1);

    protected abstract boolean isStringDelimiter(char var1);

    protected abstract boolean isCharDelimiter(char var1);

    protected abstract boolean isStartComment(char var1);

    protected abstract boolean isEscapeChar(char var1);

    protected abstract boolean isIdentifierStart(char var1);

    protected abstract boolean isIdentifierPart(char var1);

    protected abstract boolean isComment2(char var1);

    protected abstract boolean isSpecialComment3(char var1);

    protected abstract boolean isSingleLineComment2(char var1);

    protected abstract boolean isEndComment1(char var1);

    protected abstract boolean isEndComment2(char var1);

    protected abstract boolean isCommentRecursive();

    @Override
    public void toAttributedString(String text, int length, Producer producer) {
        int anchor = 0;
        block19: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (this._state) {
                case 0: {
                    anchor = i;
                    if (this.isIdentifierStart(c)) {
                        this._state = 2;
                        continue block19;
                    }
                    if (this.isOperator(c)) {
                        this.addAttributes(producer, Producer.ATTRIBUTES_OPERATOR, i, i + 1);
                        continue block19;
                    }
                    if (this.isBrace(c)) {
                        this.addAttributes(producer, Producer.ATTRIBUTES_BRACE, i, i + 1);
                        continue block19;
                    }
                    if (this.isStringDelimiter(c)) {
                        this._state = 1;
                        continue block19;
                    }
                    if (this.isCharDelimiter(c)) {
                        this._state = 8;
                        continue block19;
                    }
                    if (!this.isStartComment(c)) continue block19;
                    this._state = 3;
                    continue block19;
                }
                case 1: {
                    if (this.isStringDelimiter(c)) {
                        this.addAttributes(producer, Producer.ATTRIBUTES_STRING, anchor, i + 1);
                        this._state = 0;
                        continue block19;
                    }
                    if (!this.isEscapeChar(c) || i + 1 >= length) continue block19;
                    ++i;
                    continue block19;
                }
                case 2: {
                    if (this.isIdentifierPart(c)) continue block19;
                    if (producer != null) {
                        String word = text.substring(anchor, i);
                        if (this.isReservedWord(word)) {
                            this.addAttributes(producer, Producer.ATTRIBUTES_RESERVED_WORD, anchor, i);
                        } else if (this.isLitteral(word)) {
                            this.addAttributes(producer, Producer.ATTRIBUTES_CONSTANT, anchor, i);
                        } else {
                            this.addAttributes(producer, Producer.ATTRIBUTES_IDENTIFIER, anchor, i);
                        }
                    }
                    --i;
                    this._state = 0;
                    continue block19;
                }
                case 3: {
                    if (this.isSingleLineComment2(c)) {
                        this._state = 4;
                        continue block19;
                    }
                    if (this.isComment2(c)) {
                        this._state = 5;
                        continue block19;
                    }
                    if (i > 0) {
                        this.addAttributes(producer, Producer.ATTRIBUTES_OPERATOR, anchor, i - 1);
                    }
                    this._state = 0;
                    continue block19;
                }
                case 4: {
                    if (c != '\r' && c != '\n') continue block19;
                    this.addAttributes(producer, Producer.ATTRIBUTES_SINGLE_LINE_COMMENT, anchor, i);
                    --i;
                    this._state = 0;
                    continue block19;
                }
                case 5: {
                    if (this.isSpecialComment3(c)) {
                        this._state = 7;
                        continue block19;
                    }
                    if (c == '\n') {
                        this.addAttributes(producer, Producer.ATTRIBUTES_COMMENT, anchor, i);
                        this.addAttributes(producer, Producer.ATTRIBUTES_NORMAL, i, i);
                        anchor = i + 1;
                    }
                    this._state = 6;
                    continue block19;
                }
                case 6: {
                    if (this.isEndComment1(c)) {
                        if (i + 1 >= length || !this.isEndComment2(text.charAt(i + 1))) continue block19;
                        this.addAttributes(producer, Producer.ATTRIBUTES_COMMENT, anchor, ++i + 1);
                        this._state = 0;
                        continue block19;
                    }
                    if (c != '\n') continue block19;
                    this.addAttributes(producer, Producer.ATTRIBUTES_COMMENT, anchor, i);
                    this.addAttributes(producer, Producer.ATTRIBUTES_NORMAL, i, i);
                    anchor = i + 1;
                    continue block19;
                }
                case 7: {
                    if (this.isEndComment1(c)) {
                        if (i + 1 >= length || !this.isEndComment2(text.charAt(i + 1))) continue block19;
                        this.addAttributes(producer, Producer.ATTRIBUTES_JAVADOC, anchor, ++i + 1);
                        this._state = 0;
                        continue block19;
                    }
                    if (c != '\n') continue block19;
                    this.addAttributes(producer, Producer.ATTRIBUTES_JAVADOC, anchor, i);
                    this.addAttributes(producer, Producer.ATTRIBUTES_NORMAL, i, i);
                    anchor = i + 1;
                    continue block19;
                }
                case 8: {
                    if (this.isCharDelimiter(c)) {
                        this.addAttributes(producer, Producer.ATTRIBUTES_CHAR, anchor, i + 1);
                        this._state = 0;
                        continue block19;
                    }
                    if (!this.isEscapeChar(c) || i + 1 >= length) continue block19;
                    ++i;
                }
            }
        }
        if (anchor < length) {
            switch (this._state) {
                case 1: {
                    this.addAttributes(producer, Producer.ATTRIBUTES_STRING, anchor, length);
                    break;
                }
                case 4: {
                    this.addAttributes(producer, Producer.ATTRIBUTES_SINGLE_LINE_COMMENT, anchor, length);
                    break;
                }
                case 5: 
                case 6: {
                    this.addAttributes(producer, Producer.ATTRIBUTES_COMMENT, anchor, length);
                    break;
                }
                case 7: {
                    this.addAttributes(producer, Producer.ATTRIBUTES_JAVADOC, anchor, length);
                    break;
                }
                case 8: {
                    this.addAttributes(producer, Producer.ATTRIBUTES_CHAR, anchor, length);
                    break;
                }
                case 2: {
                    String word = text.substring(anchor, length);
                    if (this.isReservedWord(word)) {
                        this.addAttributes(producer, Producer.ATTRIBUTES_RESERVED_WORD, anchor, length);
                        break;
                    }
                    if (this.isLitteral(word)) {
                        this.addAttributes(producer, Producer.ATTRIBUTES_CONSTANT, anchor, length);
                        break;
                    }
                    this.addAttributes(producer, Producer.ATTRIBUTES_IDENTIFIER, anchor, length);
                }
            }
        }
    }

    private void addAttributes(Producer producer, Object attributes, int from, int to) {
        if (producer != null) {
            producer.addAttributes(attributes, from, to);
        }
    }
}

