/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.newzebra.compare;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.algorithm.EditableContributor;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;

public class FileCompareContributor
extends TextCompareContributor
implements EditableContributor {
    private final File _file;
    private final TextBuffer _textBuffer;
    private final String _type;
    private final boolean _editable;

    public FileCompareContributor(File file, boolean bl) throws IOException {
        this.setIgnoreWhitespace(bl);
        this._file = file;
        this._textBuffer = TextBufferFactory.createTextBuffer();
        this._textBuffer.read((Reader)new FileReader(file));
        this._textBuffer.clearModified();
        this._editable = file.canWrite();
        int n = this._file.getName().lastIndexOf(46);
        this._type = n > 0 && n < this._file.getName().length() - 2 ? this._file.getName().substring(n + 1) : "";
        this.addTextBufferListeners();
    }

    public File getFile() {
        return this._file;
    }

    public TextBuffer getTextBuffer() {
        return this._textBuffer;
    }

    public String getShortLabel() {
        return this._file.getName();
    }

    public String getLongLabel() {
        return this._file.getPath();
    }

    public String getType() {
        return this._type;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean isModified() {
        return this.getTextBuffer().isModified();
    }

    public void save() throws IOException {
        FileWriter fileWriter = new FileWriter(this._file);
        this._textBuffer.write((Writer)fileWriter);
        fileWriter.close();
        this._textBuffer.clearModified();
    }
}

