/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.newzebra;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.gui.SEMessages;
import oracle.dbtools.migration.gui.newzebra.TranslationWedgeCompareView;
import oracle.dbtools.migration.gui.newzebra.compare.FileCompareContributor;
import oracle.dbtools.migration.gui.newzebra.compare.SqlCompareModelFactory;
import oracle.dbtools.migration.gui.newzebra.compare.StringCompareContributor;
import oracle.dbtools.migration.parser.log.TranslationMessages;
import oracle.ide.Ide;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.CustomHorizontalScrollView;
import oracle.javatools.compare.view.NavigableView;
import oracle.javatools.dialogs.MessageDialog;

public class ZebraMainPanel
extends JPanel {
    private File m_firstFile = null;
    private File m_secondFile = null;
    private File m_ancestorFile = null;
    private boolean m_ignoreWhitespace;
    private String m_firstFileString = null;
    private String m_secondFileString = null;
    private Object m_algorithmEngine = null;

    public ZebraMainPanel(String string, String string2, boolean bl, String string3, Object object) {
        this.m_firstFile = new File(string);
        this.m_secondFile = new File(string2);
        this.m_ancestorFile = string3 != null ? new File(string3) : null;
        this.m_ignoreWhitespace = bl;
        this.m_algorithmEngine = object;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"", (String)"", null);
        }
    }

    public ZebraMainPanel(String string, String string2, boolean bl, String string3, boolean bl2, Object object) {
        this.refresh(string, string2, bl, string3, bl2, object);
    }

    public void refresh(String string, String string2, boolean bl, String string3, boolean bl2, Object object) {
        this.m_firstFileString = string;
        this.m_secondFileString = string2;
        this.m_ancestorFile = string3 != null ? new File(string3) : null;
        this.m_ignoreWhitespace = bl;
        this.m_algorithmEngine = object;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"", (String)"", null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void jbInit() throws Exception {
        this.setToolTipText("Oracle Diff");
        try {
            CompareModel compareModel;
            Object object;
            Object object2;
            if (this.m_firstFile == null) {
                object2 = this.m_firstFileString;
                object = this.m_secondFileString;
                if (this.m_firstFileString != null) {
                    this.m_firstFileString = this.m_firstFileString.trim();
                }
                if (this.m_secondFileString != null) {
                    this.m_secondFileString = this.m_secondFileString.trim();
                }
                if (this.m_firstFileString.equals(this.m_secondFileString)) {
                    StringCompareContributor stringCompareContributor = new StringCompareContributor(this.m_firstFileString, this.m_ignoreWhitespace);
                    compareModel = SqlCompareModelFactory.createCompareModel((CompareContributor)stringCompareContributor, (CompareContributor)stringCompareContributor, this.m_algorithmEngine);
                } else {
                    compareModel = SqlCompareModelFactory.createCompareModel((CompareContributor)new StringCompareContributor((String)object2, this.m_ignoreWhitespace), (CompareContributor)new StringCompareContributor((String)object, this.m_ignoreWhitespace), this.m_algorithmEngine);
                }
            } else if (this.m_firstFile.equals(this.m_secondFile)) {
                object2 = new FileCompareContributor(this.m_firstFile, this.m_ignoreWhitespace);
                compareModel = SqlCompareModelFactory.createCompareModel((CompareContributor)object2, (CompareContributor)object2, this.m_algorithmEngine);
            } else {
                compareModel = SqlCompareModelFactory.createCompareModel((CompareContributor)new FileCompareContributor(this.m_firstFile, this.m_ignoreWhitespace), (CompareContributor)new FileCompareContributor(this.m_secondFile, this.m_ignoreWhitespace), this.m_algorithmEngine);
            }
            if (compareModel.getDifferenceCount() == 0) {
                TranslationMessages.debuginfo((String)"");
            }
            object2 = CompareViewFactory.createView((CompareModel)compareModel, (CompareMode)CompareMode.TWO_WAY_COMPARE, TranslationWedgeCompareView.class);
            object = object2.getGUI();
            this.setLayout(new BorderLayout());
            this.add((Component)object, "Center");
            if (object2 instanceof CustomHorizontalScrollView) {
                this.add(((CustomHorizontalScrollView)object2).getHorizontalScrollComponent(), "South");
            }
            if (object2 instanceof NavigableView) {
                this.installNavigableActions(this, (NavigableView)object2);
            }
            this.setVisible(true);
            if (!(object2 instanceof BaseCompareView)) return;
        }
        catch (IOException iOException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"", (String)"", null);
        }
    }

    private void installNavigableActions(JComponent jComponent, final NavigableView navigableView) {
        AbstractAction abstractAction = new AbstractAction(SEMessages.getString("ZebraMainPanel.8"), SEMessages.getIcon("FIRST_DIFF")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                navigableView.goToFirstDifference();
            }
        };
        abstractAction.putValue("ShortDescription", SEMessages.getString("ZebraMainPanel.9"));
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(SEMessages.getString("ZebraMainPanel.10")));
        AbstractAction abstractAction2 = new AbstractAction(SEMessages.getString("ZebraMainPanel.11"), SEMessages.getIcon("LAST_DIFF")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                navigableView.goToLastDifference();
            }
        };
        abstractAction2.putValue("ShortDescription", SEMessages.getString("ZebraMainPanel.12"));
        abstractAction2.putValue("AcceleratorKey", KeyStroke.getKeyStroke(SEMessages.getString("ZebraMainPanel.13")));
        AbstractAction abstractAction3 = new AbstractAction(SEMessages.getString("ZebraMainPanel.14"), SEMessages.getIcon("NEXT_DIFF")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!navigableView.goToNextDifference()) {
                    navigableView.goToFirstDifference();
                }
            }
        };
        abstractAction3.putValue("ShortDescription", SEMessages.getString("ZebraMainPanel.15"));
        abstractAction3.putValue("AcceleratorKey", KeyStroke.getKeyStroke(SEMessages.getString("ZebraMainPanel.16")));
        AbstractAction abstractAction4 = new AbstractAction(SEMessages.getString("ZebraMainPanel.17"), SEMessages.getIcon("PREV_DIFF")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!navigableView.goToPreviousDifference()) {
                    navigableView.goToLastDifference();
                }
            }
        };
        abstractAction4.putValue("ShortDescription", SEMessages.getString("ZebraMainPanel.18"));
        abstractAction4.putValue("AcceleratorKey", KeyStroke.getKeyStroke(SEMessages.getString("ZebraMainPanel.19")));
        JMenu jMenu = new JMenu(StringUtils.stripMnemonic((String)SEMessages.getString("ZebraMainPanel.20")));
        jMenu.setMnemonic(StringUtils.getMnemonicKeyCode((String)SEMessages.getString("ZebraMainPanel.20")));
        jMenu.add(abstractAction);
        jMenu.add(abstractAction4);
        jMenu.add(abstractAction3);
        jMenu.add(abstractAction2);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("controlShadow")));
        jToolBar.add(abstractAction);
        jToolBar.add(abstractAction4);
        jToolBar.add(abstractAction3);
        jToolBar.add(abstractAction2);
        jComponent.add((Component)jToolBar, "North");
    }
}

