/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui;

import antlr.collections.AST;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dbtools.logging.IStatusMessageConsumer;
import oracle.dbtools.migration.gui.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetState;
import org.antlr.runtime.tree.CommonTree;

public class ASTResultPanel
extends JPanel
implements WorksheetResultPanel {
    AST m_ast = null;
    private JTree m_jTreeRight = null;
    private JScrollPane m_scrollPane = null;
    protected JPanel _resultsPanel = null;
    private String m_id = null;
    private CommonTree m_commonTree = null;

    public ASTResultPanel(AST aST, String string) {
        this.m_ast = aST;
        this.m_id = string;
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setViewportView(this.setupTree(aST));
        this.setLayout(new BorderLayout());
        this.add(this.m_scrollPane);
    }

    public ASTResultPanel(JPanel jPanel, String string) {
        this.m_id = string;
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setViewportView(jPanel);
        this.setLayout(new BorderLayout());
        this.add(this.m_scrollPane);
    }

    public ASTResultPanel(CommonTree commonTree, String string) {
        this.m_commonTree = commonTree;
        this.m_id = string;
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setViewportView(this.setupCommonTree(commonTree));
        this.setLayout(new BorderLayout());
        this.add(this.m_scrollPane);
    }

    private Component setupCommonTree(CommonTree commonTree) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("The Source AST Tree");
        this.createNodes(commonTree, defaultMutableTreeNode);
        this.m_jTreeRight = new JTree(defaultMutableTreeNode);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        defaultTreeCellRenderer.setLeafIcon(null);
        this.m_jTreeRight.setCellRenderer(defaultTreeCellRenderer);
        for (int i = 0; i < this.m_jTreeRight.getRowCount(); ++i) {
            this.m_jTreeRight.expandRow(i);
        }
        return this.m_jTreeRight;
    }

    private void createNodes(CommonTree commonTree, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        List list = commonTree.getChildren();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                CommonTree commonTree2 = (CommonTree)list.get(i);
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(commonTree2.getText() + " [Line:" + commonTree2.getLine() + " Start:" + commonTree2.getTokenStartIndex() + " Stop:" + commonTree2.getTokenStopIndex() + " Type:" + commonTree2.getType());
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                this.createNodes(commonTree2, defaultMutableTreeNode2);
            }
        }
    }

    public JComponent getGUI() {
        return this;
    }

    public WorksheetState getState() {
        return null;
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabLabel() {
        return Messages.getString("ASTResultPaneTab");
    }

    public String getTabToolTip() {
        return Messages.getString("ASTResultPaneTip");
    }

    public boolean isCloseable() {
        return true;
    }

    public void setState(WorksheetState worksheetState) {
    }

    public void setTabLabel(String string) {
    }

    public void tabClosed() {
    }

    private JTree setupTree(AST aST) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("The Source AST Tree");
        this.createNodes(aST, defaultMutableTreeNode);
        this.m_jTreeRight = new JTree(defaultMutableTreeNode);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        defaultTreeCellRenderer.setLeafIcon(null);
        this.m_jTreeRight.setCellRenderer(defaultTreeCellRenderer);
        for (int i = 0; i < this.m_jTreeRight.getRowCount(); ++i) {
            this.m_jTreeRight.expandRow(i);
        }
        return this.m_jTreeRight;
    }

    private void createNodes(AST aST, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        AST aST2 = aST.getFirstChild();
        for (int i = 0; i < aST.getNumberOfChildren(); ++i) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(aST2.getText() + " " + (aST2.getSourceStartLine() == -1 ? "" : "<" + aST2.getSourceStartLine() + ":" + aST2.getSourceStartCol() + ">") + (aST2.getSourceStartLine() == -1 ? "" : " to ") + (aST2.getSourceEndLine() == -1 ? "" : "<" + aST2.getSourceEndLine() + ":" + aST2.getSourceEndCol() + ">"));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.createNodes(aST2, defaultMutableTreeNode2);
            aST2 = aST2.getNextSibling();
        }
    }

    public WorksheetContext getContext() {
        return null;
    }

    public boolean isPinned() {
        return false;
    }

    public void setContext(WorksheetContext worksheetContext) {
    }

    public void setPinned(boolean bl) {
    }

    public String getLastStatusMessage() {
        return null;
    }

    public void publishStatusMessage(String string, Exception exception) {
    }

    public void registerConsumer(IStatusMessageConsumer iStatusMessageConsumer) {
    }

    public String getID() {
        return this.m_id;
    }

    public JMenuItem[] getTabDynamicCtxMenu(WorksheetResultPanel[] worksheetResultPanelArray) {
        return new JMenuItem[0];
    }
}

