/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public final class PatchByteCode {
    private static final String DISABLE_PATCHING = PatchByteCode.class.getName() + ".disable";
    private static final Logger LOG = Logger.getLogger(PatchByteCode.class.getName());
    private static final byte[] RUNTIME_INVISIBLE_ANNOTATIONS;
    private static final byte[] PATCHED_PUBLIC;
    private static final String DESC_CTOR_ANNOTATION = "Lorg/openide/modules/ConstructorDelegate;";
    private static final String DESC_PATCHED_PUBLIC_ANNOTATION = "Lorg/openide/modules/PatchedPublic;";
    private static final String DESC_DEFAULT_CTOR = "()V";
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String PREFIX_EXTEND = "extend.";
    private static final PatchByteCode NOP;
    private static final PatchByteCode PUBLIC_ONLY;
    private final boolean patchPublic;
    private final Map<String, String> classToExtend;
    private final ClassLoader theClassLoader;
    private static Method patchAsmMethod;

    private PatchByteCode() {
        this(false, null, null);
    }

    private PatchByteCode(boolean pub, Map<String, String> classToExtend, ClassLoader ldr) {
        this.patchPublic = pub;
        this.classToExtend = classToExtend;
        this.theClassLoader = ldr;
    }

    private void load(URL stream) throws IOException {
        try (InputStream istm = stream.openStream();){
            Properties props = new Properties();
            props.load(new InputStreamReader(istm, "UTF-8"));
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String extendWith;
                String toExtend;
                String old;
                String pn = (String)en.nextElement();
                if (!pn.startsWith(PREFIX_EXTEND) || (old = this.classToExtend.put(toExtend = pn.substring(PREFIX_EXTEND.length()), extendWith = props.getProperty(pn))) == null) continue;
                throw new IOException("Multiple extend instructions for class" + toExtend + ": " + extendWith + " and " + old);
            }
        }
    }

    private PatchByteCode purify() {
        if (this.classToExtend == null || this.classToExtend.isEmpty()) {
            return PUBLIC_ONLY;
        }
        return this;
    }

    static PatchByteCode fromStream(Enumeration<URL> streams, ClassLoader ldr) {
        if (System.getProperty(DISABLE_PATCHING) != null) {
            return NOP;
        }
        PatchByteCode pb = new PatchByteCode(false, new HashMap<String, String>(3), ldr);
        boolean found = false;
        while (streams.hasMoreElements()) {
            URL stream = streams.nextElement();
            try {
                pb.load(stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            found = true;
        }
        return found ? pb.purify() : NOP;
    }

    byte[] apply(String className, byte[] data) throws IOException {
        if (this.patchPublic) {
            return PatchByteCode.patch(data);
        }
        if (this.classToExtend == null) {
            return data;
        }
        String extender = this.classToExtend.get(className);
        if (extender == null) {
            return PatchByteCode.patch(data);
        }
        ClassLoader l = Thread.currentThread().getContextClassLoader();
        if (l == null) {
            l = PatchByteCode.class.getClassLoader();
        }
        try {
            return (byte[])this.patchAsmMethod(l).invoke(null, data, extender, this.theClassLoader);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Method patchAsmMethod(ClassLoader l) throws NoSuchMethodException, SecurityException, ClassNotFoundException {
        if (patchAsmMethod == null) {
            Class<?> asm = Class.forName("org.netbeans.core.startup.Asm", true, l);
            patchAsmMethod = asm.getDeclaredMethod("patch", byte[].class, String.class, ClassLoader.class);
            patchAsmMethod.setAccessible(true);
        }
        return patchAsmMethod;
    }

    public static byte[] patch(byte[] data) {
        int constant_pool_count = PatchByteCode.u2(data, 8);
        int[] constantPoolOffsets = new int[constant_pool_count];
        int pos = 10;
        block7: for (int i = 1; i < constant_pool_count; ++i) {
            int tag = PatchByteCode.u1(data, pos++);
            constantPoolOffsets[i] = pos;
            switch (tag) {
                case 1: {
                    int len = PatchByteCode.u2(data, pos);
                    pos += len + 2;
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    pos += 4;
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    pos += 2;
                    continue block7;
                }
                case 5: 
                case 6: {
                    pos += 8;
                    ++i;
                    continue block7;
                }
                case 15: {
                    pos += 3;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("illegal constant pool tag " + tag + " at index " + i + " out of " + constant_pool_count);
                }
            }
        }
        int interfaces_count = PatchByteCode.u2(data, pos += 6);
        pos += 2;
        int fields_count = PatchByteCode.u2(data, pos += 2 * interfaces_count);
        pos += 2;
        for (int i = 0; i < fields_count; ++i) {
            int attributes_count = PatchByteCode.u2(data, pos += 6);
            pos += 2;
            for (int j = 0; j < attributes_count; ++j) {
                int attribute_length = PatchByteCode.u4(data, pos += 2);
                pos += 4;
                pos += attribute_length;
            }
        }
        int methods_count = PatchByteCode.u2(data, pos);
        pos += 2;
        for (int i = 0; i < methods_count; ++i) {
            int locationOfAccessFlags = pos;
            int attributes_count = PatchByteCode.u2(data, pos += 6);
            pos += 2;
            for (int j = 0; j < attributes_count; ++j) {
                int locationOfAttributeName = constantPoolOffsets[PatchByteCode.u2(data, pos)];
                int attribute_length = PatchByteCode.u4(data, pos += 2);
                pos += 4;
                if (PatchByteCode.utf8Matches(data, locationOfAttributeName, RUNTIME_INVISIBLE_ANNOTATIONS)) {
                    int num_annotations = PatchByteCode.u2(data, pos);
                    int pos2 = pos + 2;
                    for (int k = 0; k < num_annotations; ++k) {
                        if (!PatchByteCode.utf8Matches(data, constantPoolOffsets[PatchByteCode.u2(data, pos2)], PATCHED_PUBLIC)) continue;
                        int n = locationOfAccessFlags + 1;
                        data[n] = (byte)(data[n] & 0xF9);
                        int n2 = locationOfAccessFlags + 1;
                        data[n2] = (byte)(data[n2] | 1);
                    }
                }
                pos += attribute_length;
            }
        }
        return data;
    }

    private static int u1(byte[] data, int off) {
        int b = data[off];
        return b >= 0 ? b : b + 256;
    }

    private static int u2(byte[] data, int off) {
        return (PatchByteCode.u1(data, off) << 8) + PatchByteCode.u1(data, off + 1);
    }

    private static int u4(byte[] data, int off) {
        return (PatchByteCode.u2(data, off) << 16) + PatchByteCode.u2(data, off + 2);
    }

    private static boolean utf8Matches(byte[] data, int off, byte[] expected) {
        if (PatchByteCode.u2(data, off) != expected.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (data[off + 2 + i] == expected[i]) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            RUNTIME_INVISIBLE_ANNOTATIONS = "RuntimeInvisibleAnnotations".getBytes("UTF-8");
            PATCHED_PUBLIC = DESC_PATCHED_PUBLIC_ANNOTATION.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException x) {
            throw new ExceptionInInitializerError(x);
        }
        NOP = new PatchByteCode(false, null, null);
        PUBLIC_ONLY = new PatchByteCode(true, null, null);
    }
}

