/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.filter;

import java.util.List;
import oracle.ide.insight.InsightItem;

public final class FilterUtils {
    private FilterUtils() {
    }

    public static int getMatchingLength(String s1, String s2) {
        int len = Math.min(s1.length(), s2.length());
        for (int i = 0; i < len; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return i;
        }
        return len;
    }

    public static <T extends InsightItem> T findClosestDataItem(List<T> items, String name) {
        int numItems = items.size();
        if (name == null || name.length() == 0 || numItems == 0) {
            return (T)(numItems > 0 ? (InsightItem)items.get(0) : null);
        }
        String commonPrefix = FilterUtils.findCommonPrefix(items, name);
        int prefixLength = commonPrefix.length();
        if (prefixLength > 0) {
            prefixLength = Math.min(prefixLength, name.length());
            InsightItem bestItem = null;
            int bestLength = 0;
            for (int i = 0; i < numItems; ++i) {
                int matchingLength;
                InsightItem item = (InsightItem)items.get(i);
                String itemName = item.getName();
                if (!itemName.regionMatches(true, 0, name, 0, prefixLength) || (matchingLength = FilterUtils.getMatchingLength(itemName, name)) <= bestLength) continue;
                bestLength = matchingLength;
                bestItem = item;
            }
            if (bestItem != null) {
                return (T)bestItem;
            }
        }
        InsightItem lastItem = null;
        for (int i = 0; i < numItems; ++i) {
            InsightItem item = (InsightItem)items.get(i);
            String itemName = item.getName();
            int result = name.compareToIgnoreCase(itemName);
            if (result <= 0) {
                return (T)lastItem;
            }
            lastItem = item;
        }
        return (T)(numItems > 0 ? (InsightItem)items.get(numItems - 1) : null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T extends InsightItem> String findCommonPrefix(List<T> items, String name) {
        int numItems;
        if (name == null) return "";
        if (name.length() == 0) {
            return "";
        }
        int commonStart = numItems = items.size();
        int commonEnd = numItems;
        int shortestCommon = -1;
        boolean STATE_FIND_START = true;
        int STATE_FIND_END = 2;
        int state = 1;
        block4: for (int i = 0; i < numItems; ++i) {
            InsightItem item = (InsightItem)items.get(i);
            String itemName = item.getName();
            switch (state) {
                case 1: {
                    if (!FilterUtils.startsWithIgnoreCase(itemName, name)) break;
                    commonStart = i;
                    state = 2;
                    shortestCommon = itemName.length();
                    break;
                }
                case 2: {
                    if (!FilterUtils.startsWithIgnoreCase(itemName, name)) {
                        commonEnd = i;
                        break block4;
                    }
                    shortestCommon = Math.min(shortestCommon, itemName.length());
                }
            }
        }
        if (commonStart == commonEnd) {
            return "";
        }
        int nameLength = name.length();
        InsightItem controlItem = (InsightItem)items.get(commonStart);
        String controlName = controlItem.getName();
        int commonLen = shortestCommon;
        while (commonLen > nameLength) {
            boolean allMatches = true;
            for (int j = commonStart + 1; j < commonEnd; ++j) {
                InsightItem checkItem = (InsightItem)items.get(j);
                String checkName = checkItem.getName();
                if (checkName.regionMatches(true, 0, controlName, 0, commonLen)) continue;
                allMatches = false;
                break;
            }
            if (allMatches) {
                return controlName.substring(0, commonLen);
            }
            --commonLen;
        }
        return name;
    }

    public static boolean startsWithIgnoreCase(String name1, String name2) {
        return name1.regionMatches(true, 0, name2, 0, name2.length());
    }
}

