/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion.ui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.insight.InsightActionListener;
import oracle.ide.insight.InsightBundle;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.ui.InsightViewCustomizer;
import oracle.ide.insight.completion.ui.PopupController;
import oracle.javatools.ui.list.SimpleListModel;
import oracle.javatools.ui.list.SingleListSelectionModel;

public class InsightView<T extends InsightItem> {
    private SimpleListModel<T> model;
    private final JList list = new CustomList();
    private final JComponent gui;
    private final List<ChangeListener> changeListeners = new CopyOnWriteArrayList<ChangeListener>();
    private final PopupController popupController;
    private InsightViewCustomizer customizer;
    private static final int VISIBLE_DATA_ITEMS = 16;

    InsightView(final PopupController popupController) {
        this.popupController = popupController;
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(null);
        this.list.setSelectionModel((ListSelectionModel)new SingleListSelectionModel());
        this.list.setFocusable(false);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    popupController.complete();
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ChangeEvent event = new ChangeEvent(InsightView.this.getSelectedItem());
                for (ChangeListener l : InsightView.this.changeListeners) {
                    l.stateChanged(event);
                }
                InsightView.this.updateAccessibility();
            }
        });
        this.gui = scrollPane;
    }

    void updateAccessibility() {
        InsightItem insightItem = (InsightItem)this.model.getElementAt(this.list.getSelectedIndex());
        String name = InsightBundle.get("INSIGHT_ACCESSIBLE_POPUP_NAME_ITEM") + insightItem.getAccessibleText();
        this.list.getAccessibleContext().setAccessibleName(name);
    }

    public void setItems(List<T> dataItems) {
        assert (!dataItems.isEmpty());
        this.model = new SimpleListModel();
        this.model.asList().addAll(dataItems);
        this.list.setModel(this.model);
        this.list.setVisibleRowCount(Math.min(16, dataItems.size()));
        ChangeEvent event = new ChangeEvent(this.getSelectedItem());
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(event);
        }
    }

    public T getSelectedItem() {
        if (this.list.getModel().getSize() < 1) {
            return null;
        }
        return (T)((InsightItem)this.list.getSelectedValue());
    }

    public void setSelectedItem(T item) {
        for (int i = 0; i < this.model.getSize(); ++i) {
            if (this.model.getElementAt(i) != item) continue;
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(0);
            int j = Math.min(this.model.getSize() - 1, i + 8);
            this.list.ensureIndexIsVisible(j);
            this.list.ensureIndexIsVisible(i);
            break;
        }
    }

    public JComponent getGui(CompletionContext insightContext) {
        this.customizer = new InsightViewCustomizer(this.list, insightContext);
        insightContext.getProvider().customizeView(this.customizer);
        this.gui.setBackground(this.customizer.getRegularBackground());
        this.list.setCellRenderer(this.customizer.getRenderer());
        int height = 0;
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            height = Math.max(height, (int)this.list.getCellBounds(i, i).getHeight());
        }
        this.list.setFixedCellHeight(height);
        this.popupController.setOptions(this.customizer.getOptions());
        return this.gui;
    }

    public boolean handleInsightAction(InsightActionListener.Action action) {
        int sel = this.list.getSelectedIndex();
        int lastIndex = this.list.getModel().getSize() - 1;
        int newSel = Integer.MIN_VALUE;
        int ensureVisible = Integer.MIN_VALUE;
        if (action == InsightActionListener.Action.UP) {
            newSel = sel == 0 ? lastIndex : sel - 1;
        } else if (action == InsightActionListener.Action.DOWN) {
            newSel = sel == lastIndex ? 0 : sel + 1;
        } else if (action == InsightActionListener.Action.PAGE_UP) {
            if (sel != 0) {
                newSel = sel - this.list.getVisibleRowCount();
                ensureVisible = this.list.getFirstVisibleIndex() - this.list.getVisibleRowCount();
            } else {
                newSel = lastIndex;
            }
        } else if (action == InsightActionListener.Action.PAGE_DOWN) {
            if (sel != lastIndex) {
                newSel = sel + this.list.getVisibleRowCount();
                ensureVisible = this.list.getLastVisibleIndex() + this.list.getVisibleRowCount();
            } else {
                newSel = 0;
            }
        }
        if (newSel != Integer.MIN_VALUE) {
            if (ensureVisible != Integer.MIN_VALUE) {
                ensureVisible = Math.max(0, ensureVisible);
                ensureVisible = Math.min(this.list.getModel().getSize() - 1, ensureVisible);
                this.list.ensureIndexIsVisible(ensureVisible);
            }
            newSel = Math.max(0, newSel);
            newSel = Math.min(this.list.getModel().getSize() - 1, newSel);
            this.list.setSelectedIndex(newSel);
            this.list.ensureIndexIsVisible(newSel);
            return true;
        }
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public InsightViewCustomizer getCustomizer() {
        return this.customizer;
    }

    private static class CustomList
    extends JList {
        private static final int LARGE_LIST_LIMIT = 400;
        private static final int LARGE_LIST_FIXED_WIDTH = 500;

        private CustomList() {
        }

        @Override
        public int getFixedCellWidth() {
            ListModel model = this.getModel();
            if (model != null && model.getSize() > 400) {
                return 500;
            }
            return super.getFixedCellWidth();
        }

        @Override
        public int getFixedCellHeight() {
            ListModel model = this.getModel();
            if (model != null && model.getSize() > 400) {
                return this.getFontMetrics(this.getFont()).getHeight() + 2;
            }
            return super.getFixedCellHeight();
        }
    }
}

