/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion.ui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import oracle.ide.insight.InsightBundle;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.completion.CodeDetailItem;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.ui.DetailView;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.Utilities;

public final class CodeDetailView
implements DetailView {
    private BasicEditorPane editor = new BasicEditorPane();
    private JScrollPane sp = new JScrollPane((Component)this.editor);

    @Override
    public JComponent getDetailComponent() {
        this.editor.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        return this.sp;
    }

    public void itemSelected(CompletionContext insightContext, InsightItem item) {
        String fileName;
        String text = null;
        try {
            if (item instanceof CodeDetailItem) {
                text = ((CodeDetailItem)((Object)item)).getText(insightContext.getContext());
            }
        }
        catch (ExpiredTextBufferException e) {
            text = null;
        }
        if (text == null) {
            text = InsightBundle.get("POPUP_MSG_NO_DOC");
        }
        text = Utilities.trimCommonWhitespace(text);
        String string = fileName = item instanceof CodeDetailItem ? ((CodeDetailItem)((Object)item)).getFilename() : null;
        if (fileName != null) {
            this.editor.setLanguageSupport(fileName);
        }
        this.editor.setEditable(true);
        this.editor.setText(text);
        this.editor.setCaretPosition(0);
        this.editor.setEditable(false);
        this.sp.setPreferredSize(null);
        Dimension d = this.sp.getPreferredSize();
        if (d.width > 500) {
            d.width = 500;
            d.height += this.sp.getHorizontalScrollBar().getHeight();
        }
        if (d.height > 600) {
            d.height = 600;
            d.width += this.sp.getVerticalScrollBar().getWidth();
        }
        this.sp.setPreferredSize(d);
    }

    @Override
    public void shown(CompletionContext insightContext) {
    }

    @Override
    public void hidden(CompletionContext insightContext) {
        this.editor.setText("");
    }
}

