/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.insight.completion.CompletionController;
import oracle.ide.insight.completion.CompletionProvider;

public final class CompletionMultiProvider {
    private List<CompletionProvider> allProviders;
    private CompletionProvider currentProvider;
    private Set<Character> triggerCharacters = new HashSet<Character>();
    private final CompletionController controller;

    public CompletionMultiProvider(CompletionController controller, List<CompletionProvider> providers) {
        assert (!providers.isEmpty());
        this.controller = controller;
        this.allProviders = providers;
        this.currentProvider = providers.get(0);
        for (CompletionProvider provider : providers) {
            this.triggerCharacters.addAll(provider.getTriggerCharacters());
        }
    }

    public CompletionProvider getCurrentProvider() {
        return this.currentProvider;
    }

    public List<CompletionProvider> getAllProviders() {
        return Collections.unmodifiableList(this.allProviders);
    }

    public CompletionProvider getNextProvider() {
        int i = this.allProviders.indexOf(this.currentProvider) + 1;
        if (i >= this.allProviders.size()) {
            i = 0;
        }
        return this.allProviders.get(i);
    }

    public void setProvider(CompletionProvider provider) {
        if (this.currentProvider == provider) {
            return;
        }
        assert (this.allProviders.contains(provider));
        this.currentProvider = provider;
        this.controller.reShow();
    }

    public Collection<Character> getTriggerCharacters() {
        return this.triggerCharacters;
    }

    void setFirstProvider(Character triggerChar) {
        if (triggerChar != null) {
            for (CompletionProvider provider : this.allProviders) {
                if (!provider.getTriggerCharacters().contains(triggerChar)) continue;
                this.currentProvider = provider;
                return;
            }
        }
        this.currentProvider = this.allProviders.get(0);
    }
}

