/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.ide.config.Preferences;
import oracle.ide.controller.IdeAction;
import oracle.ide.insight.InsightActionListener;
import oracle.ide.insight.InsightAddin;
import oracle.ide.insight.InsightController;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.InsightModel;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.CompletionModel;
import oracle.ide.insight.completion.CompletionProvider;
import oracle.ide.insight.completion.CompletionResults;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.ide.insight.completion.CompletionWorker;
import oracle.ide.insight.completion.ui.BusyPopup;
import oracle.ide.insight.completion.ui.InsightPopup;
import oracle.ide.insight.options.InsightOptions;
import oracle.javatools.data.PropertyStorage;

public final class CompletionController
implements InsightController<CompletionContext<CompletionSupport>> {
    private CompletionWorker worker = null;
    private CompletionResults results;
    private CompletionContext<CompletionSupport> insightContext;
    private InsightPopup insightPopup = new InsightPopup();
    private BusyPopup busyPopup = new BusyPopup();
    private WorkerListener workerListener;
    private Class lastResultsModelClass;
    private Object lastState;
    private final List<PropertyChangeListener> propertyChangeListeners;

    public CompletionController() {
        this.insightPopup.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("state")) {
                    CompletionController.this.firePropertyChangeEvent(new PropertyChangeEvent(CompletionController.this, "state", evt.getOldValue(), evt.getNewValue()));
                    if (evt.getNewValue() == InsightController.State.HIDDEN) {
                        CompletionController.this.dispose();
                    }
                }
            }
        });
        this.workerListener = null;
        this.lastResultsModelClass = null;
        this.lastState = null;
        this.propertyChangeListeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    }

    private void dispose() {
        this.insightContext = null;
        this.results = null;
        this.lastResultsModelClass = null;
        this.lastState = null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (PropertyChangeListener l : this.propertyChangeListeners) {
            l.propertyChange(event);
        }
    }

    @Override
    public InsightController.State getState() {
        return this.insightPopup.getState();
    }

    @Override
    public void show(CompletionContext<CompletionSupport> insightContext) {
        assert (SwingUtilities.isEventDispatchThread());
        this.hide();
        if (this.worker != null) {
            this.worker.removePropertyChangeListener(this.workerListener);
            this.worker.cancel(true);
            this.workerListener = null;
        }
        this.insightContext = insightContext;
        this.worker = new CompletionWorker(insightContext);
        this.workerListener = new WorkerListener(this.worker);
        this.worker.addPropertyChangeListener(this.workerListener);
        this.worker.execute();
    }

    void reShow() {
        if (this.insightContext == null) {
            return;
        }
        CompletionSupport support = (CompletionSupport)this.insightContext.getSupport();
        CompletionContext<CompletionSupport> insightContext = new CompletionContext<CompletionSupport>(support, CompletionContext.Invoked.AUTO, this.insightContext.getMultiProvider());
        this.show(insightContext);
    }

    void triggerUpdate() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.getState() == InsightController.State.SHOWING) {
            assert (this.results != null);
            if (this.worker != null) {
                this.worker.removePropertyChangeListener(this.workerListener);
                this.worker.cancel(true);
                this.workerListener = null;
            }
            this.insightContext = new CompletionContext<CompletionSupport>((CompletionSupport)this.insightContext.getSupport(), this.insightContext.getInvoked(), this.insightContext.getMultiProvider());
            this.worker = new CompletionWorker(this.insightContext, this.results);
            this.workerListener = new WorkerListener(this.worker);
            this.worker.addPropertyChangeListener(this.workerListener);
            this.worker.execute();
        }
    }

    private void gotResults(CompletionResults results, CompletionContext insightContext) {
        assert (SwingUtilities.isEventDispatchThread());
        this.results = results;
        if (insightContext == null || insightContext.getAdapter() == null || insightContext.hasTextChanged()) {
            return;
        }
        assert (this.getState() == InsightController.State.HIDDEN);
        CompletionModel model = this.getCurrentModel();
        if (model == null || model.getItems().isEmpty()) {
            return;
        }
        this.lastResultsModelClass = model.getClass();
        this.lastState = insightContext.getAdapter().getState();
        try {
            if (insightContext.getInvoked() == CompletionContext.Invoked.MANUAL && insightContext.getAdapter().isEditable() && this.getOptions().isCompleteSingleInitial() && this.performCompleteSingleMatching(insightContext)) {
                return;
            }
            this.insightPopup.show(insightContext);
        }
        catch (Exception ex) {
            Logger.getLogger("global").log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            this.insightPopup.hide();
        }
    }

    @Override
    public void hide() {
        if (this.getState() == InsightController.State.SHOWING) {
            this.insightPopup.hide();
        }
        this.dispose();
    }

    private void gotUpdatedResults(CompletionResults results, CompletionContext insightContext) {
        assert (SwingUtilities.isEventDispatchThread());
        this.results = results;
        if (insightContext == null || insightContext.getAdapter() == null || insightContext.hasTextChanged()) {
            if (this.getState() == InsightController.State.SHOWING) {
                this.triggerUpdate();
            }
            return;
        }
        CompletionModel model = this.getCurrentModel();
        if (model == null || model.getItems().isEmpty()) {
            this.insightPopup.hide();
            return;
        }
        Class<?> newClass = model.getClass();
        if (this.lastResultsModelClass == null) {
            return;
        }
        if (!this.lastResultsModelClass.equals(newClass) && this.getOptions().isCompleteSingleNewData() && this.performCompleteSingleMatching(insightContext)) {
            return;
        }
        this.lastResultsModelClass = model.getClass();
        if (!insightContext.getAdapter().getState().equals(this.lastState) && this.getOptions().isCompleteSingleTyping() && this.performCompleteSingleMatching(insightContext)) {
            return;
        }
        this.lastState = insightContext.getAdapter().getState();
        this.insightPopup.update(insightContext, model);
    }

    private InsightOptions getOptions() {
        return InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private boolean performCompleteSingleMatching(CompletionContext insightContext) {
        CompletionModel model = this.getCurrentModel();
        if (model == null || !insightContext.getProvider().isExactMatch(model)) {
            return false;
        }
        InsightModel.Result result = model.complete((InsightItem)model.getMatchingItems().get(0));
        this.triggerToolTipInsight();
        if (result == InsightModel.Result.RETRIGGER) {
            this.reShow();
        } else {
            this.insightPopup.hide();
        }
        return true;
    }

    void triggerToolTipInsight() {
        if (!this.getOptions().isParamaterPopupEnabled()) {
            return;
        }
        IdeAction action = IdeAction.find((int)InsightAddin.TOOLTIP_INSIGHT_CMD_ID);
        try {
            action.performAction();
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    protected CompletionModel getCurrentModel() {
        if (this.insightContext == null) {
            return null;
        }
        CompletionProvider provider = this.insightContext.getProvider();
        return this.results.getModel(provider);
    }

    private class WorkerListener
    implements PropertyChangeListener,
    DocumentListener,
    InsightActionListener {
        final CompletionWorker worker;

        WorkerListener(CompletionWorker worker) {
            this.worker = worker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            block10: {
                if (evt.getPropertyName().equals("state") && evt.getNewValue() == SwingWorker.StateValue.STARTED && CompletionController.this.getState() == InsightController.State.HIDDEN) {
                    CompletionWorker worker = (CompletionWorker)evt.getSource();
                    CompletionContext workerInsightContext = worker.getInsightContext();
                    CompletionController.this.busyPopup.show(workerInsightContext);
                    workerInsightContext.getTextComponent().getDocument().addDocumentListener(this);
                    workerInsightContext.getAdapter().addInsightActionListener(this);
                }
                if (evt.getPropertyName().equals("state") && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                    try {
                        assert (this.worker == (CompletionWorker)evt.getSource());
                        this.worker.removePropertyChangeListener(this);
                        try {
                            if (this.worker.isCancelled()) break block10;
                            CompletionResults results = (CompletionResults)this.worker.get();
                            if (this.worker.isUpdate()) {
                                CompletionController.this.gotUpdatedResults(results, this.worker.getInsightContext());
                                break block10;
                            }
                            CompletionController.this.gotResults(results, this.worker.getInsightContext());
                        }
                        catch (InterruptedException results) {
                        }
                        catch (ExecutionException e) {
                            Logger.getLogger("global").log(Level.SEVERE, "Completion worker exception", e.getCause());
                            e.getCause().printStackTrace();
                        }
                    }
                    finally {
                        CompletionWorker localWorker = (CompletionWorker)evt.getSource();
                        CompletionContext localContext = localWorker.getInsightContext();
                        JTextComponent comp = localContext.getTextComponent();
                        this.cancel(comp.getDocument());
                    }
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.cancel(e.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.cancel(e.getDocument());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.cancel(e.getDocument());
        }

        public boolean insightActionPerformed(InsightActionListener.Action action, JTextComponent textComponent) {
            if (action == InsightActionListener.Action.CANCEL) {
                this.worker.cancel(true);
                this.cancel(textComponent.getDocument());
                return true;
            }
            return false;
        }

        private void cancel(Document doc) {
            doc.removeDocumentListener(this);
            CompletionController.this.busyPopup.hide();
            if (this.worker.getInsightContext() != null && this.worker.getInsightContext().getAdapter() != null) {
                this.worker.getInsightContext().getAdapter().removeInsightActionListener(this);
            }
            CompletionController.this.worker = null;
        }
    }
}

