/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.CurrentToolbarOptions;
import oracle.ide.ceditor.find.CurrentToolbarOptionsImpl;
import oracle.ide.ceditor.find.FindToolbar;
import oracle.ide.ceditor.find.FindToolbarController;
import oracle.ide.ceditor.find.FindToolbarOptions;
import oracle.ide.ceditor.find.ReplaceToolbar;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;

public abstract class AbstractFindToolbarController
implements FindToolbarController {
    private final BasicEditorPane editor;
    private final Toolbar findAndOptionsToolbar;
    private final ReplaceToolbar replaceToolbar;
    private final FindToolbar findToolbar;
    private final FindToolbarOptions optionsToolbar;

    public AbstractFindToolbarController(BasicEditorPane editor) {
        this.editor = editor;
        editor.putProperty("find-container", (Object)this);
        this.findToolbar = new FindToolbar(editor);
        this.replaceToolbar = new ReplaceToolbar(editor);
        this.optionsToolbar = new FindToolbarOptions(editor, this.findToolbar);
        this.findAndOptionsToolbar = new Toolbar();
        this.findAndOptionsToolbar.setBorder(null);
        this.findAndOptionsToolbar.add((Component)this.findToolbar.getToolbar());
        this.findAndOptionsToolbar.add(this.optionsToolbar.getOptionsComponent());
    }

    @Override
    public CurrentToolbarOptions getCurrentToolbarOptions() {
        CurrentToolbarOptionsImpl currentOptions = new CurrentToolbarOptionsImpl();
        this.getFindToolbar().populateCurrentOptions(currentOptions);
        this.getFindToolbarOptions().populateCurrentOptions(currentOptions);
        this.getReplaceToolbar().populateCurrentOptions(currentOptions);
        return currentOptions;
    }

    public static FindToolbarController getFindController(BasicEditorPane editor) {
        return (FindToolbarController)editor.getProperty("find-container");
    }

    protected final BasicEditorPane getEditor() {
        return this.editor;
    }

    protected final Toolbar getFindAndOptionsToolbar() {
        return this.findAndOptionsToolbar;
    }

    @Override
    public FindToolbar getFindToolbar() {
        return this.findToolbar;
    }

    public FindToolbarOptions getFindToolbarOptions() {
        return this.optionsToolbar;
    }

    @Override
    public ReplaceToolbar getReplaceToolbar() {
        return this.replaceToolbar;
    }

    @Override
    public void setFindShowing(boolean showing) {
    }

    @Override
    public void setReplaceShowing(boolean showing) {
        if (!showing) {
            this.replaceToolbar.reset();
        }
    }

    @Override
    public void updateVisibleActions() {
        View.updateToolbarActions((Toolbar)Ide.getToolbar());
    }

    @Override
    public boolean isFindShowing() {
        return false;
    }

    @Override
    public void navigate(int start, int length) {
        this.editor.select(start, start + length);
        this.editor.ensureCaretVisible();
    }

    @Override
    public boolean isReplaceShowing() {
        return false;
    }

    @Override
    public void dispose() {
    }
}

