/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.util;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.marshal.xml.PropertyInfo;
import oracle.javatools.marshal.xml.PropertyIterator;

public abstract class BeanHashStructureConverter {
    private static final String CLASS_NAME = ".className.";
    private final ClassLoader m_classLoader;

    protected BeanHashStructureConverter() {
        this(null);
    }

    protected BeanHashStructureConverter(ClassLoader classLoader) {
        this.m_classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    public final HashStructure getHashStructureForBean(Object bean) {
        HashStructure hash = HashStructure.newInstance();
        this.beanToHash(bean, hash);
        return hash;
    }

    protected final void beanToHash(Object bean, HashStructure hash) {
        hash.putString(CLASS_NAME, bean.getClass().getCanonicalName());
        PropertyIterator pi = new PropertyIterator(bean);
        while (pi.hasNext()) {
            PropertyInfo propertyInfo = pi.next();
            String name = propertyInfo.getXMLName();
            Object value = propertyInfo.getPropertyValue(bean);
            Class<?> clz = propertyInfo.getPropertyClass();
            if (clz == Object.class && value != null) {
                clz = value.getClass();
            }
            this.setHashValue(hash, clz, name, value, bean);
        }
    }

    protected void setHashValue(HashStructure hash, Class clz, String name, Object value, Object owner) {
        if (value != null) {
            if (this.isSupportedNatively(clz)) {
                this.setNativeHashValue(hash, clz, name, value);
            } else if (clz.isArray() || List.class == clz) {
                Object[] valAsArrary = clz.isArray() ? (Object[])value : ((List)value).toArray();
                ListStructure list = ListStructure.newInstance();
                for (Object child : valAsArrary) {
                    if (this.isSupportedNatively(child.getClass())) {
                        list.add(child);
                        continue;
                    }
                    HashStructure childHash = HashStructure.newInstance();
                    this.beanToHash(child, childHash);
                    list.add((Object)childHash);
                }
                hash.putListStructure(name, list);
            } else if (Map.class.isAssignableFrom(clz)) {
                HashStructure mapHash = HashStructure.newInstance();
                hash.putHashStructure(name, mapHash);
                Map map = (Map)value;
                for (Map.Entry e : map.entrySet()) {
                    if (!(e.getKey() instanceof String)) continue;
                    String key = (String)e.getKey();
                    Object val = e.getValue();
                    Class<?> clzz = val.getClass();
                    if (this.isSupportedNatively(clzz)) {
                        this.setNativeHashValue(mapHash, clzz, key, val);
                        continue;
                    }
                    HashStructure childHash = HashStructure.newInstance();
                    this.setHashValue(childHash, val.getClass(), key, val, map);
                }
            } else if (clz == Class.class) {
                hash.putString(name, ((Class)value).getCanonicalName());
            } else if (Enum.class.isAssignableFrom(clz)) {
                Enum en = (Enum)value;
                if (value != null) {
                    hash.putString(name, en.name());
                }
            } else {
                HashStructure childHash = HashStructure.newInstance();
                this.beanToHash(value, childHash);
                hash.putHashStructure(name, childHash);
            }
        }
    }

    private void setNativeHashValue(HashStructure hash, Class clz, String name, Object value) {
        if (String.class == clz) {
            hash.putString(name, (String)value);
        } else if (Integer.class == clz || Integer.TYPE == clz) {
            hash.putInt(name, ((Integer)value).intValue());
        } else if (Long.class == clz || Long.TYPE == clz) {
            hash.putLong(name, ((Long)value).longValue());
        } else if (Float.class == clz || Float.TYPE == clz) {
            hash.putFloat(name, ((Float)value).floatValue());
        } else if (Double.class == clz || Double.TYPE == clz) {
            hash.putDouble(name, ((Double)value).doubleValue());
        } else if (Boolean.class == clz || Boolean.TYPE == clz) {
            hash.putBoolean(name, ((Boolean)value).booleanValue());
        } else if (URL.class.isAssignableFrom(clz)) {
            hash.putURL(name, (URL)value);
        } else if (HashStructure.class.isAssignableFrom(clz)) {
            hash.putHashStructure(name, (HashStructure)value);
        } else if (ListStructure.class.isAssignableFrom(clz)) {
            hash.putListStructure(name, (ListStructure)value);
        }
    }

    public final boolean isGetBeanSupported(HashStructure hash) {
        return hash.containsKey(CLASS_NAME);
    }

    public final Object getBeanFromHashStructure(HashStructure hash) throws HashToBeanException {
        return this.createObjectForHash(null, null, hash);
    }

    protected final Object createObjectForHash(Object owner, String property, HashStructure hash) throws HashToBeanException {
        Object ret = null;
        try {
            Class<?> clz;
            String className = hash.getString(CLASS_NAME);
            if (className != null && (ret = this.createObject(owner, property, clz = Class.forName(className, true, this.m_classLoader))) != null) {
                this.hashToBean(hash, ret);
            }
        }
        catch (Exception e) {
            throw new HashToBeanException(e, ret);
        }
        return ret;
    }

    protected Object createObject(Object owner, String property, Class clz) throws InstantiationException, IllegalAccessException {
        return clz.newInstance();
    }

    protected final void hashToBean(HashStructure hash, Object bean) throws Exception {
        HashMap<String, PropertyInfo> propMap = new HashMap<String, PropertyInfo>();
        PropertyIterator pi = new PropertyIterator(bean);
        while (pi.hasNext()) {
            PropertyInfo info = pi.next();
            propMap.put(info.getXMLName(), info);
        }
        Exception ex = null;
        for (String key : hash.keySet()) {
            if (CLASS_NAME.equals(key)) continue;
            PropertyInfo info = (PropertyInfo)propMap.get(key);
            try {
                if (info != null) {
                    this.setBeanValue(info, bean, hash);
                    continue;
                }
                this.setUnrecognisedBeanValue(bean, key, hash.getObject(key));
            }
            catch (Exception e2) {
                if (ex == null) {
                    ex = e2;
                    continue;
                }
                ex.addSuppressed(e2);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    protected void setBeanValue(PropertyInfo propertyInfo, Object bean, HashStructure hash) throws Exception {
        Class clz = propertyInfo.getPropertyClass();
        String name = propertyInfo.getXMLName();
        if (hash.containsKey(name)) {
            if (String.class == clz) {
                propertyInfo.setPropertyValue(bean, (Object)hash.getString(name));
            } else if (Integer.TYPE == clz) {
                propertyInfo.setPropertyValue(bean, (Object)hash.getInt(name, 0));
            } else if (Integer.class == clz) {
                propertyInfo.setPropertyValue(bean, (Object)hash.getInt(name));
            } else if (Long.TYPE == clz) {
                propertyInfo.setPropertyValue(bean, (Object)hash.getLong(name, 0L));
            } else if (Long.class == clz) {
                propertyInfo.setPropertyValue(bean, (Object)hash.getLong(name));
            } else if (Float.TYPE == clz) {
                propertyInfo.setPropertyValue(bean, (Object)Float.valueOf(hash.getFloat(name, 0.0f)));
            } else if (Float.class == clz) {
                propertyInfo.setPropertyValue(bean, (Object)Float.valueOf(hash.getFloat(name)));
            } else if (Double.TYPE == clz) {
                propertyInfo.setPropertyValue(bean, (Object)hash.getDouble(name, 0.0));
            } else if (Double.class == clz) {
                propertyInfo.setPropertyValue(bean, (Object)hash.getDouble(name));
            } else if (Boolean.TYPE == clz) {
                propertyInfo.setPropertyValue(bean, (Object)hash.getBoolean(name, false));
            } else if (Boolean.class == clz) {
                propertyInfo.setPropertyValue(bean, (Object)hash.getBoolean(name));
            } else if (URL.class.isAssignableFrom(clz)) {
                propertyInfo.setPropertyValue(bean, (Object)hash.getURL(name));
            } else if (HashStructure.class.isAssignableFrom(clz)) {
                propertyInfo.setPropertyValue(bean, (Object)hash.getHashStructure(name));
            } else if (ListStructure.class.isAssignableFrom(clz)) {
                propertyInfo.setPropertyValue(bean, (Object)hash.getListStructure(name));
            } else if (clz.isArray() || List.class == clz) {
                ListStructure childList = hash.getListStructure(name);
                if (childList != null && !childList.isEmpty()) {
                    int numKids = childList.size();
                    Object[] array = clz.isArray() ? Arrays.copyOf(new Object[0], numKids, clz) : new Object[numKids];
                    for (int i = 0; i < numKids; ++i) {
                        Object kid = childList.get(i);
                        if (kid instanceof HashStructure) {
                            HashStructure kidHash = (HashStructure)kid;
                            if (this.isGetBeanSupported(kidHash)) {
                                array[i] = this.getBeanFromHashStructure(kidHash);
                                continue;
                            }
                            array[i] = this.getListValue(bean, name, i, kid);
                            continue;
                        }
                        array[i] = this.getListValue(bean, name, i, kid);
                    }
                    Object val = clz.isArray() ? array : Arrays.asList(array);
                    propertyInfo.setPropertyValue(bean, val);
                }
            } else if (Map.class.isAssignableFrom(clz)) {
                HashStructure mapHash = hash.getHashStructure(name);
                if (mapHash != null) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String key : mapHash.keySet()) {
                        Object kid = mapHash.getObject(key);
                        if (kid instanceof HashStructure) {
                            HashStructure kidHash = (HashStructure)kid;
                            if (this.isGetBeanSupported(kidHash)) {
                                map.put(key, this.getBeanFromHashStructure(kidHash));
                                continue;
                            }
                            map.put(key, this.getMapValue(bean, name, key, kid));
                            continue;
                        }
                        map.put(key, this.getMapValue(bean, name, key, kid));
                    }
                    propertyInfo.setPropertyValue(bean, map);
                }
            } else if (clz == Class.class) {
                String className = hash.getString(name);
                if (className != null) {
                    Class<?> childClz = Class.forName(className, true, this.m_classLoader);
                    propertyInfo.setPropertyValue(bean, childClz);
                }
            } else if (Enum.class.isAssignableFrom(clz)) {
                String enumStr = hash.getString(name);
                if (enumStr != null) {
                    Object en = Enum.valueOf(clz, enumStr);
                    propertyInfo.setPropertyValue(bean, en);
                }
            } else {
                HashStructure childHash = hash.getHashStructure(name);
                if (childHash != null) {
                    HashToBeanException childT = null;
                    Object child = null;
                    try {
                        child = this.createObjectForHash(bean, name, childHash);
                    }
                    catch (HashToBeanException htbe) {
                        childT = htbe;
                        child = htbe.getObject();
                    }
                    if (child != null) {
                        propertyInfo.setPropertyValue(bean, child);
                    }
                    if (childT != null) {
                        throw childT;
                    }
                }
            }
        }
    }

    protected void setUnrecognisedBeanValue(Object bean, String name, Object value) throws Exception {
        throw new IllegalStateException("No PropertyInfo for property " + name);
    }

    protected Object getMapValue(Object bean, String prop, String mapKey, Object mapValue) {
        return mapValue;
    }

    protected Object getListValue(Object bean, String prop, int index, Object listValue) {
        return listValue;
    }

    private final boolean isSupportedNatively(Class clz) {
        return String.class == clz || Integer.TYPE == clz || Integer.class == clz || Long.TYPE == clz || Long.class == clz || Float.TYPE == clz || Float.class == clz || Double.TYPE == clz || Double.class == clz || Boolean.TYPE == clz || Boolean.class == clz || URL.class.isAssignableFrom(clz) || HashStructure.class.isAssignableFrom(clz) || ListStructure.class.isAssignableFrom(clz);
    }

    public static class HashToBeanException
    extends Exception {
        private final Object m_obj;

        private HashToBeanException(Exception cause, Object obj) {
            super(cause);
            this.m_obj = obj;
        }

        public final Object getObject() {
            return this.m_obj;
        }

        @Override
        public synchronized Throwable getCause() {
            return super.getCause();
        }
    }
}

