/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.util.ModelUtil;

public class SQLFragmentExpressionBuilder {
    public static SQLFragment getExpression(DBObjectProvider provider, Relation relation, ExpressionType type, String expression) {
        SQLFragment retval = null;
        try {
            retval = SQLFragmentExpressionBuilder.getExpressionOrFail(provider, relation, type, expression);
        }
        catch (SQLQueryException sqe) {
            retval = new SimpleSQLFragment(expression);
        }
        return retval;
    }

    @Deprecated
    public static SQLFragment getExpression(DBObjectProvider provider, Relation relation, ExpressionType type, String expression, boolean ignorErrors) throws SQLQueryException {
        if (ignorErrors) {
            return SQLFragmentExpressionBuilder.getExpression(provider, relation, type, expression);
        }
        return SQLFragmentExpressionBuilder.getExpressionOrFail(provider, relation, type, expression);
    }

    public static SQLFragment getExpressionOrFail(DBObjectProvider provider, Relation relation, ExpressionType type, String expression) throws SQLQueryException {
        ChildDBObject retval = null;
        if (ModelUtil.hasLength((String)expression)) {
            Column c;
            if (relation != null && type == ExpressionType.ITEM && (c = (Column)DBUtil.findChildByName(relation, "columns", provider.getInternalName(expression), true, provider)) != null && c.getID() != null) {
                ColumnUsage cu = new ColumnUsage(c.getID());
                cu.setQualified(false);
                cu.setProvider(provider);
                retval = cu;
            }
            if (retval == null) {
                Schema schema = relation == null ? null : relation.getSchema();
                SQLQueryBuilder builder = SQLQueryBuilderFactory.createBuilder(provider, schema);
                if (builder instanceof AbstractSQLQueryBuilder) {
                    String queryBit = null;
                    String table = null;
                    if (relation != null) {
                        ((AbstractSQLQueryBuilder)builder).setSingleRelation(relation);
                        String relationName = relation.getName();
                        table = provider.getExternalName(relationName);
                        if (!relationName.equals(table) && !table.startsWith("\"")) {
                            table = "DUAL";
                        }
                    } else {
                        table = "DUAL";
                    }
                    if (type == ExpressionType.CONDITION) {
                        try {
                            queryBit = "SELECT 1 FROM " + table + " WHERE ";
                            builder.buildQuery(queryBit + expression);
                            SQLQuery query = builder.getSQLQuery();
                            if (query != null) {
                                retval = query.getWhereObject();
                                query.setWhereObject(null);
                            }
                        }
                        catch (SQLQueryException e) {
                            SQLFragmentExpressionBuilder.throwModifiedException(e, expression, queryBit);
                        }
                    } else if (type == ExpressionType.ITEM) {
                        String queryBit1 = "SELECT ";
                        String queryBit2 = " FROM " + table;
                        String queryString = queryBit1 + expression + queryBit2;
                        try {
                            SelectObject[] selects;
                            builder.buildQuery(queryString);
                            SQLQuery query = builder.getSQLQuery();
                            if (query != null && (selects = query.getSelectObjects()).length > 0 && selects[0] != null) {
                                retval = selects[0].getExpression();
                                selects[0].setExpression(null);
                            }
                        }
                        catch (SQLQueryException e) {
                            SQLFragmentExpressionBuilder.throwModifiedException(e, expression, queryBit1, queryBit2);
                        }
                    }
                }
                if (retval != null) {
                    SQLFragmentExpressionBuilder.resetFromObjectIDs(retval);
                    retval.setParent(null);
                } else if (!builder.matchesProvider()) {
                    retval = new SimpleSQLFragment(expression);
                } else {
                    throw new IllegalStateException("Build succeeded but we have no fragment");
                }
            }
        }
        return retval;
    }

    private static void throwModifiedException(SQLQueryException e, String expression, String ... queryBits) throws SQLQueryException {
        if (!(e instanceof SQLParseException) || queryBits.length == 0 || !ModelUtil.hasLength((String)queryBits[0])) {
            throw e;
        }
        SQLParseException spe = (SQLParseException)e;
        int offset = queryBits[0].length();
        String message = spe.getFragmentMessage(expression, offset);
        for (String cutstr : new String[]{"'FROM'", "from_clause"}) {
            int cut1 = message.indexOf(cutstr);
            if (cut1 <= 0) continue;
            int start = cut1;
            int end = cut1 + cutstr.length();
            if (message.charAt(start - 1) == ',') {
                --start;
            }
            message = message.substring(0, start) + message.substring(end);
        }
        throw new SQLQueryException((SQLFragment)e.getObject(), message, e);
    }

    private static void resetFromObjectIDs(SQLFragment frag) {
        if (frag instanceof ColumnUsage) {
            ((ColumnUsage)frag).setFromObjectID(null);
            ((ColumnUsage)frag).setQualified(false);
        }
        for (DBObject kid : frag.getOwnedObjects()) {
            if (!(kid instanceof SQLFragment)) continue;
            SQLFragmentExpressionBuilder.resetFromObjectIDs((SQLFragment)kid);
        }
    }

    public static enum ExpressionType {
        ITEM,
        CONDITION;

    }
}

