/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBLog;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.db.sql.SQLFragment;

public class JoinObject
extends AbstractSQLFragment {
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    public static final String FULL = "FULL";
    public static final String INNER = "INNER";
    public static final String CROSS = "CROSS";
    private static final String PARTITION_BY = "PARTITION BY";

    public JoinObject() {
        this(null, null, null);
    }

    public JoinObject(FromObject left, FromObject right, JoinCondition condition) {
        this(left, right, null, false, condition);
    }

    public JoinObject(FromObject left, FromObject right, String type, boolean natural, JoinCondition condition) {
        this.setIncludeJoinKeyword(true);
        this.setLeftExpression(left);
        this.setRightExpression(right);
        this.setJoinType(type);
        this.setNatural(natural);
        this.setCondition(condition);
    }

    public FromObject getLeftExpression() {
        return (FromObject)this.getProperty("leftExpression");
    }

    public void setLeftExpression(FromObject left) {
        this.setProperty("leftExpression", left);
    }

    public FromObject getRightExpression() {
        return (FromObject)this.getProperty("rightExpression");
    }

    public void setRightExpression(FromObject right) {
        this.setProperty("rightExpression", right);
    }

    public boolean getIncludeJoinKeyword() {
        return (Boolean)this.getProperty("includeJoinKeyword", true);
    }

    public void setIncludeJoinKeyword(boolean inc) {
        this.setProperty("includeJoinKeyword", inc);
    }

    public String getJoinType() {
        return (String)this.getProperty("joinType");
    }

    public void setJoinType(String type) {
        this.setProperty("joinType", type);
    }

    public boolean isNatural() {
        return (Boolean)this.getProperty("natural", false);
    }

    public void setNatural(boolean natural) {
        if (CROSS.equals(this.getJoinType()) && natural) {
            DBLog.getLogger(this).warning(APIBundle.get("SQL_CROSS_NOT_NATURAL"));
        }
        this.setProperty("natural", natural);
    }

    public JoinCondition getCondition() {
        return (JoinCondition)this.getProperty("condition");
    }

    public void setCondition(JoinCondition condition) {
        if ((this.isNatural() || CROSS.equals(this.getJoinType())) && condition != null) {
            DBLog.getLogger(this).warning(APIBundle.get("SQL_CROSS_NAT_NO_COND"));
        } else {
            this.setProperty("condition", condition);
        }
    }

    public ExpressionList getLeftPartitionBy() {
        return (ExpressionList)this.getProperty("leftPartitionBy");
    }

    public void setLeftPartitionBy(ExpressionList leftPartitionBy) {
        this.setProperty("leftPartitionBy", leftPartitionBy);
    }

    public ExpressionList getRightPartitionBy() {
        return (ExpressionList)this.getProperty("rightPartitionBy");
    }

    public void setRightPartitionBy(ExpressionList rightPartitionBy) {
        this.setProperty("rightPartitionBy", rightPartitionBy);
    }

    public boolean isOuterJoin() {
        String jt = this.getJoinType();
        return jt != null && !jt.equals(INNER) && !jt.equals(CROSS);
    }

    private boolean needsBrackets(FromObject from) {
        boolean retval = false;
        if (from != null) {
            SQLFragment subExpression = from.getExpression();
            retval = subExpression instanceof JoinObject;
        }
        return retval;
    }

    @Override
    public String getSQLText() {
        JoinCondition condition;
        StringBuilder buff = new StringBuilder();
        FromObject left = this.getLeftExpression();
        String leftText = this.getTextOrNull(left, this.needsBrackets(left));
        buff.append(leftText);
        ExpressionList leftPartitionBy = this.getLeftPartitionBy();
        if (leftPartitionBy != null) {
            buff.append(" ").append(this.createPartitionByText(leftPartitionBy));
        }
        if (this.isNatural()) {
            buff.append(" ").append("NATURAL");
        }
        String jt = this.getJoinType();
        boolean incKeyword = this.getIncludeJoinKeyword();
        if (INNER.equals(jt)) {
            if (incKeyword) {
                buff.append(" ").append(jt);
            }
        } else if (CROSS.equals(jt)) {
            buff.append(" ").append(CROSS);
        } else if (this.isOuterJoin()) {
            buff.append(" ").append(jt);
            if (incKeyword) {
                buff.append(" ").append("OUTER");
            }
        }
        buff.append(" ").append("JOIN").append(" ");
        FromObject right = this.getRightExpression();
        String rightText = this.getTextOrNull(right, this.needsBrackets(right));
        buff.append(rightText);
        ExpressionList rightPartitionBy = this.getRightPartitionBy();
        if (rightPartitionBy != null) {
            buff.append(" ").append(this.createPartitionByText(rightPartitionBy));
        }
        if ((condition = this.getCondition()) != null && !this.isNatural()) {
            buff.append(" ").append(condition.getSQLText());
        }
        return buff.toString();
    }

    private String createPartitionByText(ExpressionList partitionBy) {
        StringBuilder buff = new StringBuilder(PARTITION_BY);
        String queryPartitionClause = partitionBy.getSQLText();
        if (partitionBy.getArgumentCount() == 1) {
            queryPartitionClause = this.surroundWithBrackets(queryPartitionClause, true);
        }
        return PARTITION_BY + queryPartitionClause;
    }
}

