/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.sql.AbstractAliasFragment;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.WithClauseUsage;
import oracle.javatools.db.sql.XMLFunctionUsage;

public class FromObject
extends AbstractAliasFragment {
    public static final String TYPE = "FROM";

    public FromObject() {
    }

    public FromObject(SQLFragment expression, String alias) {
        super(expression, alias);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void setExpression(SQLFragment exp) {
        if (!(exp == null || exp instanceof SimpleSQLFragment || exp instanceof RelationUsage || exp instanceof SynonymUsage || exp instanceof SQLQuery || exp instanceof JoinObject || exp instanceof Function || exp instanceof XMLFunctionUsage || exp instanceof WithClauseUsage)) {
            throw new IllegalArgumentException("FromObject expression " + exp + " must be a RelationUsage, SQLQuery or JoinObject.");
        }
        super.setExpression(exp);
    }

    public void setPivotExpression(SQLFragment pivot) {
        this.setProperty("pivotExpression", pivot);
    }

    public SQLFragment getPivotExpression() {
        return (SQLFragment)this.getProperty("pivotExpression");
    }

    @Override
    public boolean canHaveAlias() {
        return !(this.getExpression() instanceof JoinObject);
    }

    public void setWith(boolean value) {
        this.setProperty("with", value);
    }

    public boolean isWith() {
        return (Boolean)this.getProperty("with", Boolean.FALSE);
    }

    public void setSubqueryFactoringClause(SQLFragment value) {
        this.setProperty("subqueryFactoringClause", value);
    }

    public SQLFragment getSubqueryFactoringClause() {
        SQLFragment retval = (SQLFragment)this.getProperty("subqueryFactoringClause");
        return retval;
    }

    @Override
    public String getSQLText() {
        String retval;
        String pivot = "";
        SQLFragment pivotExpr = this.getPivotExpression();
        SQLFragment queryExpr = this.getExpression();
        String alias = this.getAlias();
        if (this.isWith()) {
            StringBuilder sb = new StringBuilder();
            sb.append(alias).append(" ").append("AS").append(" ");
            sb.append(this.getTextOrNull(queryExpr));
            retval = sb.toString();
        } else if (queryExpr == null) {
            retval = alias;
        } else if (pivotExpr == null) {
            retval = super.getSQLText();
        } else {
            boolean needParen;
            StringBuilder buff = new StringBuilder();
            SQLFragment expr = this.getExpression();
            boolean bl = needParen = !(expr instanceof RelationUsage);
            if (needParen) {
                buff.append("(");
            }
            buff.append("\n");
            buff.append(this.getExpression().getSQLText());
            buff.append("\n");
            if (needParen) {
                buff.append(")");
            }
            pivot = pivotExpr.getSQLText();
            buff.append(" ").append(pivot);
            if (this.getAlias() != null) {
                buff.append(" ").append(this.getAlias());
            }
            retval = buff.toString();
        }
        return retval;
    }
}

