/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractProviderUsageSQLFragment;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.WhereObject;

public class FKUsage
extends AbstractProviderUsageSQLFragment
implements DBObjectUsage {
    public FKUsage() {
    }

    public FKUsage(DBObjectID fkID, DBObjectID leftID, DBObjectID rightID) {
        this.setObjectID(fkID);
        this.setLeftFromObjectID(leftID);
        this.setRightFromObjectID(rightID);
    }

    @Override
    public DBObjectID getObjectID() {
        return (DBObjectID)this.getProperty("objectID");
    }

    @Override
    public void setObjectID(DBObjectID fkid) {
        this.setProperty("objectID", fkid);
    }

    @Deprecated
    @Transient
    public FromObject getLeftFromObject() {
        return null;
    }

    @Deprecated
    @Transient
    public void setLeftFromObject(FromObject obj) {
        this.setLeftFromObjectID(obj != null ? obj.getID() : null);
    }

    public DBObjectID getLeftFromObjectID() {
        return (DBObjectID)this.getProperty("leftFromObjectID");
    }

    public void setLeftFromObjectID(DBObjectID leftID) {
        this.setProperty("leftFromObjectID", leftID);
    }

    public DBObjectID getRightFromObjectID() {
        return (DBObjectID)this.getProperty("rightFromObjectID");
    }

    public void setRightFromObjectID(DBObjectID rightID) {
        this.setProperty("rightFromObjectID", rightID);
    }

    @Deprecated
    @Transient
    public FromObject getRightFromObject() {
        return null;
    }

    @Deprecated
    @Transient
    public void setRightFromObject(FromObject obj) {
        this.setRightFromObjectID(obj != null ? obj.getID() : null);
    }

    public FromObject resolveLeftFromObject() {
        return this.resolveFromObject(this.getLeftFromObjectID());
    }

    public FromObject resolveRightFromObject() {
        return this.resolveFromObject(this.getRightFromObjectID());
    }

    private FromObject resolveFromObject(DBObjectID id) {
        FromObject ret = null;
        try {
            if (id != null) {
                ret = (FromObject)id.resolveID();
            }
        }
        catch (DBException e) {
            DBLog.getLogger(this).warning(e.getMessage());
        }
        return ret;
    }

    @Override
    public String getSQLText() {
        StringBuilder buff = new StringBuilder();
        DBObjectID fkID = this.getObjectID();
        if (fkID != null) {
            try {
                DBObjectID[] rightCols;
                DBObjectID[] leftCols;
                DBObjectID leftRelationId;
                FKConstraint fk = (FKConstraint)fkID.resolveID();
                FromObject left = this.resolveLeftFromObject();
                FromObject right = this.resolveRightFromObject();
                if (fk == null) {
                    DBLog.getLogger(this).fine("FKUsage: Cannot resolve id " + fkID);
                }
                if (left == null) {
                    DBLog.getLogger(this).fine("FKUsage: Cannot resolve left from id " + this.getLeftFromObjectID());
                }
                if (right == null) {
                    DBLog.getLogger(this).fine("FKUsage: Cannot resolve right from id " + this.getRightFromObjectID());
                }
                DBObjectID ref = fk.getReferenceID();
                UniqueConstraint refC = (UniqueConstraint)ref.resolveID();
                if (refC == null) {
                    DBLog.getLogger(this).fine("FKUsage: Cannot resolve referenced id " + fkID + " on fk " + fk.getName());
                }
                DBObjectID refRelationId = refC.getRelation().getID();
                SQLFragment leftExp = left.getExpression();
                DBObjectID dBObjectID = leftRelationId = leftExp instanceof RelationUsage ? ((RelationUsage)leftExp).getObjectID() : null;
                if (leftRelationId != null && refRelationId != null && leftRelationId.equals(refRelationId)) {
                    leftCols = refC.getColumnIDs();
                    rightCols = fk.getColumnIDs();
                } else {
                    leftCols = fk.getColumnIDs();
                    rightCols = refC.getColumnIDs();
                }
                for (int i = 0; i < leftCols.length; ++i) {
                    buff.append(left.getUsableAlias());
                    buff.append(".");
                    String leftName = DBUtil.getDBObjectName(leftCols[i]);
                    leftName = this.getExternalName(leftName, "COLUMN");
                    buff.append(leftName);
                    buff.append(" ");
                    buff.append(Comparison.Comparator.EQUAL.getSQLText());
                    buff.append(" ");
                    buff.append(right.getUsableAlias());
                    buff.append(".");
                    String rightName = DBUtil.getDBObjectName(rightCols[i]);
                    rightName = this.getExternalName(rightName, "COLUMN");
                    buff.append(rightName);
                    if (i >= leftCols.length - 1) continue;
                    buff.append(" ");
                    buff.append(WhereObject.WhereOperator.AND.getSQLText());
                    buff.append(" ");
                }
            }
            catch (DBException dbe) {
                dbe.printStackTrace();
            }
        } else {
            buff.append(fkID);
        }
        return buff.toString();
    }
}

