/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectID;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ProviderUsage;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.plsql.PlSqlAttribute;
import oracle.javatools.db.plsql.PlSqlDatatype;
import oracle.javatools.db.plsql.PlSqlMethod;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.AbstractFromObjectUsage;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.AbstractSchemaObjectUsage;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.AliasInUseException;
import oracle.javatools.db.sql.AmbiguousColumnException;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FKUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.HierarchicalQueryObject;
import oracle.javatools.db.sql.IDException;
import oracle.javatools.db.sql.InvalidAliasException;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.OnJoinCondition;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.PlSqlUsage;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentFactory;
import oracle.javatools.db.sql.SQLFragmentUtils;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryCancelledException;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.UsingJoinCondition;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.db.sql.WithClauseUsage;
import oracle.javatools.db.util.IdentitySet;
import oracle.javatools.db.util.SynchronizedBuildCache;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractSQLQueryBuilder
extends DerivedPropertyBuilder<SQLQuery>
implements SQLQueryBuilder {
    protected static final SQLFragment[] EMPTY_ARRAY = AbstractSQLFragment.EMPTY_ARRAY;
    private static final Iterator<String> s_tsKeyGen = DBUtil.getTimestampKeyGenerator(SQLQueryBuilder.class.getSimpleName());
    private static final SynchronizedBuildCache<SQLQuery> s_currentQueries = new SynchronizedBuildCache();
    private SQLQuery m_query;
    private QueryCache m_cache;
    private Schema m_defaultSchema;
    private Collection<SQLQueryClauseException> m_clauseErrors;
    private final List<SQLFragmentFactory> m_sqlFragFactories = new ArrayList<SQLFragmentFactory>();
    private Collection<? extends SystemObject> m_extraObjects;

    protected AbstractSQLQueryBuilder(DBObjectProvider pro, Schema defaultSchema) {
        super((AbstractDBObjectProvider)pro, "SQLQuery");
        this.m_defaultSchema = defaultSchema;
    }

    @Override
    protected final Logger getLogger() {
        return DBLog.getLogger(this);
    }

    protected final Schema getDefaultSchema() {
        return this.m_defaultSchema;
    }

    final void setDefaultSchema(Schema schema) {
        this.m_defaultSchema = schema;
    }

    protected final SQLQuery getQuery() {
        return this.m_query;
    }

    private synchronized QueryCache getCache() {
        if (this.m_cache == null && this.m_query != null && this.m_query.isDeclarative()) {
            this.m_cache = new QueryCache();
            this.loadQuery();
        }
        if (this.m_cache == null) {
            throw new IllegalStateException("You cannot query the cache if the query hasn't been succesfully built.");
        }
        return this.m_cache;
    }

    protected void checkCancelled() throws SQLQueryCancelledException {
        if (this.m_query != null && this.isCurrentBuildCancelled(this.m_query) || Thread.currentThread().isInterrupted()) {
            throw new SQLQueryCancelledException(this.m_query);
        }
    }

    @Override
    protected boolean canCacheBuildFailure(SQLQuery object, String sourceProp) {
        return false;
    }

    @Override
    public final void buildQuery(String sql) throws SQLQueryException {
        this.buildQuery(sql, null);
    }

    @Override
    public final void buildQuery(String sql, SQLQueryOwner parent) throws SQLQueryException {
        SQLQuery query = new SQLQuery(sql);
        query.setParent(parent);
        this.buildQuery(query);
    }

    protected final void setSQLQuery(SQLQuery query) {
        if (this.m_query != null && this.m_query != query) {
            throw new IllegalStateException("The query we are building cannot be changed");
        }
        this.m_query = query;
    }

    private void buildQuery(String sql, SQLQuery query, SQLQueryOwner parent) throws SQLQueryException {
        long millis = System.currentTimeMillis();
        AbstractDBObjectProvider pro = this.getProvider();
        String key = "buildQuery." + s_tsKeyGen.next();
        this.m_clauseErrors = new ArrayList<SQLQueryClauseException>();
        boolean built = false;
        try {
            DBUtil.suspendTimestampChecking(pro, key);
            this.setSQLQuery(query);
            this.m_cache = new QueryCache();
            this.notifyBuildStart();
            query.setQueryString(sql);
            Collection<String> derivedProps = this.getDerivedProperties("queryString");
            for (String prop : derivedProps) {
                query.setProperty(prop, null);
            }
            query.setDeclarative(true);
            this.buildQueryImpl(sql, query, parent);
            this.markAsBuilt(query, derivedProps.toArray(new String[derivedProps.size()]));
            built = true;
        }
        catch (SQLQueryCancelledException sqce) {
            throw sqce;
        }
        catch (SQLQueryException sqe) {
            this.checkCancelled();
            throw sqe;
        }
        finally {
            query.setQueryString(sql);
            query.setDeclarative(built);
            this.ensureNames(query);
            if (parent != null && parent.getID() instanceof BaseObjectID) {
                pro.getObjectFactory().ensureID(query, true, true);
            }
            this.notifyBuildEnd();
            DBUtil.resumeTimestampChecking(pro, key);
            long timeTaken = System.currentTimeMillis() - millis;
            if (this.getLogger().isLoggable(Level.FINER) && timeTaken > 10L) {
                StringBuilder msg = new StringBuilder();
                msg.append("buildQuery took: ");
                msg.append(Long.toString(timeTaken));
                msg.append(" ms.");
                this.getLogger().exiting("oracle.javatools.db.sql.AbstractSQLQueryBuilder", "buildQuery", msg.toString());
            }
        }
    }

    protected abstract void buildQueryImpl(String var1, SQLQuery var2, SQLQueryOwner var3) throws SQLQueryException;

    private void notifyBuildStart() throws SQLQueryException {
        try {
            if (this.m_query != null && !s_currentQueries.add(this.m_query)) {
                throw new SQLQueryException(this.m_query, APIBundle.get("SQL_BUILD_CIRCULAR"));
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            this.checkCancelled();
        }
    }

    private void notifyBuildEnd() {
        if (!s_currentQueries.remove(this.m_query)) {
            this.getLogger().warning("Unable to remove query from cache.");
        }
    }

    @Override
    public Collection<String> clearDerivedProperties(SQLQuery obj, String property, DBObjectChange change) {
        Collection<String> retval;
        if (!(!"queryString".equals(property) || s_currentQueries.contains(obj) || change.getPropertyChange("declarative") != null && Boolean.TRUE.equals(change.getPropertyChange("declarative").getNewValue()) || change.getPropertyChange(property).getNewValue() == null && obj.isDeclarative())) {
            retval = super.clearDerivedProperties(obj, property, change);
            obj.setDeclarative(false);
        } else {
            retval = Collections.emptyList();
        }
        return retval;
    }

    @Override
    public final void buildQuery(SQLQuery query) throws SQLQueryException {
        boolean builderOK = this.getProvider().getObjectFactory().setDerivedPropertyBuilder(query, this);
        if (!builderOK) {
            throw new IllegalStateException("SQLQueryBuilder cannot build a SQLQuery which has a different builder.");
        }
        if (query.isDeclarative()) {
            this.setSQLQuery(query);
        } else {
            try {
                Collection<SQLQueryClauseException> clauseErrors;
                DBUtil.ensureDerivedPropertiesBuilt(query, this.getProvider());
                if (this.m_query == null) {
                    this.setSQLQuery(query);
                }
                if ((clauseErrors = this.m_clauseErrors) != null && clauseErrors.size() > 0) {
                    SQLQueryClauseException ex = null;
                    for (SQLQueryClauseException next : clauseErrors) {
                        ex = DBException.append(ex, next);
                    }
                    if (ex != null) {
                        throw ex;
                    }
                }
            }
            catch (SQLQueryException sqe) {
                throw sqe;
            }
            catch (CancelledException ce) {
                throw new SQLQueryCancelledException(this.m_query);
            }
            catch (DBException dbe) {
                throw new SQLQueryException(query, dbe.getMessage(), dbe);
            }
        }
        this.validateQuery();
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"queryString"}, derived=true)
    public final void buildDeclarativeProperties(SQLQuery query) throws SQLQueryException, CancelledException {
        DBObject parent = query.getParent();
        Schema schema = DBUtil.getSchema(parent);
        if (schema != null) {
            this.m_defaultSchema = schema;
        }
        if (query.isDeclarative()) {
            this.setSQLQuery(query);
        } else {
            String queryText = query.getSQLText();
            if (queryText == null || queryText.equals("SELECT \n    \nFROM \n    \n")) {
                queryText = "";
            }
            try {
                this.buildQuery(queryText, query, parent instanceof SQLQueryOwner ? (SQLQueryOwner)parent : null);
            }
            catch (SQLParseException spe) {
                if (this.matchesProvider()) {
                    throw spe;
                }
                this.getLogger().info(spe.getMessage());
            }
            catch (SQLQueryCancelledException sqce) {
                throw new CancelledException(sqce.getMessage());
            }
            catch (SQLQueryException sqe) {
                throw sqe;
            }
            catch (Exception e) {
                this.getLogger().log(DBLog.getExceptionLogLevel(), "Query builder failed unexpectedly", e);
                String mess = APIBundle.format("SQL_CANT_BUILD_QUERY", e.getMessage());
                throw new SQLQueryException(null, mess, e);
            }
        }
    }

    @Override
    protected void derivePropertiesForTempCopy(SQLQuery object, SQLQuery orig, String sourceProp) throws DBException {
        super.derivePropertiesForTempCopy(object, orig, sourceProp);
        object.setDeclarative(orig.isDeclarative());
    }

    public <T extends SQLQueryException> void throwException(T sqe) throws T {
        if (this.m_clauseErrors == null || !(sqe instanceof SQLQueryClauseException)) {
            throw sqe;
        }
        this.addClauseException((SQLQueryClauseException)sqe);
    }

    public void addClauseException(SQLQueryClauseException sce) {
        if (sce != null) {
            if (this.m_clauseErrors == null) {
                throw new IllegalStateException("Cannot cache clause exceptions if we are not building");
            }
            this.m_clauseErrors.add(sce);
        }
    }

    @Override
    public void validateQuery() throws SQLQueryException {
        AliasFragment[] f = this.listAllFromObjects();
        this.checkAliases(f);
        AliasFragment[] s = this.m_query.getSelectObjects();
        this.checkAliases(s);
    }

    private void checkAliases(AliasFragment[] a) throws SQLQueryException {
        HashSet<String> aliases = new HashSet<String>();
        for (int i = 0; a != null && i < a.length; ++i) {
            String alias = a[i].getAlias();
            if (!ModelUtil.hasLength((String)alias)) continue;
            if (this.containsAliasIC(alias, aliases)) {
                this.throwException(new AliasInUseException(a[i]));
                continue;
            }
            this.validateAlias(a[i], "COLUMN", alias);
            aliases.add(alias);
        }
    }

    private void loadQuery() {
        String key = "loadQuery." + s_tsKeyGen.next();
        AbstractDBObjectProvider pro = this.getProvider();
        try {
            DBUtil.suspendTimestampChecking(pro, key);
            this.loadObject(this.m_query);
        }
        finally {
            DBUtil.resumeTimestampChecking(pro, key);
        }
    }

    protected void ensureIDs(SQLFragment ... frags) {
        for (SQLFragment s : frags) {
            this.ensureID(s);
        }
    }

    public DBObjectID ensureID(DBObject frag) {
        DBObjectID id;
        DBObjectID queryID;
        SQLQuery query = this.m_query;
        DBObjectID dBObjectID = queryID = query == null ? null : query.getID();
        if (query != null && queryID == null) {
            queryID = TemporaryObjectID.createID(this.m_query);
            this.m_query.setID(queryID);
        }
        if ((id = frag.getID()) == null) {
            frag.setID(TemporaryObjectID.createID(frag));
        }
        for (DBObject child : frag.getOwnedObjects()) {
            this.ensureID(child);
        }
        return frag.getID();
    }

    private void ensureNames(DBObject obj) {
        Map<String, Object> props = obj.getProperties();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String prop = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof DBObject) {
                if (this.needsName(val)) {
                    ((DBObject)val).setName(prop);
                }
                this.ensureNames((DBObject)val);
                continue;
            }
            if (!(val instanceof DBObject[])) continue;
            for (int i = 0; i < ((DBObject[])val).length; ++i) {
                DBObject child = ((DBObject[])val)[i];
                if (this.needsName(child)) {
                    child.setName(prop + i);
                }
                this.ensureNames(child);
            }
        }
    }

    private boolean needsName(Object obj) {
        boolean retval = false;
        if (obj instanceof AliasFragment) {
            if (((AliasFragment)obj).getAlias() == null) {
                SQLFragment exp = ((AliasFragment)obj).getExpression();
                retval = !(exp instanceof DBObjectUsage) && !(exp instanceof SimpleSQLFragment);
            }
        } else if (obj instanceof DBObject) {
            retval = ((DBObject)obj).getName() == null;
        }
        return retval;
    }

    private boolean containsAliasIC(String alias, Collection<String> aliases) {
        if (ModelUtil.hasLength((String)alias)) {
            for (String other : aliases) {
                if (!this.areExternalNamesEqual(alias, other)) continue;
                return true;
            }
        }
        return false;
    }

    private void addDependency(FromObject from, SQLFragment frag) {
        SQLQuery query = from.findParent(SQLQuery.class);
        if (query != this.m_query) {
            return;
        }
        QueryCache cache = this.getCache();
        IdentitySet deps = (IdentitySet)cache.m_fromDeps.get(from);
        if (deps == null) {
            deps = new IdentitySet();
            cache.m_fromDeps.put(from, deps);
        }
        deps.add(frag);
        cache.m_rFromDeps.put(frag, from);
    }

    private void removeDependency(DBObject frag) {
        Collection deps;
        FromObject from;
        QueryCache cache = this.m_cache;
        if (cache != null && (from = (FromObject)cache.m_rFromDeps.get(frag)) != null && (deps = (Collection)cache.m_fromDeps.get(from)) != null) {
            deps.remove(frag);
        }
    }

    protected void loadObjects(DBObject[] frags) {
        for (int i = 0; i < frags.length; ++i) {
            this.loadObject(frags[i]);
        }
    }

    protected void loadObject(DBObject frag) {
        if (frag != null) {
            QueryCache cache = this.getCache();
            if (frag instanceof ProviderUsage) {
                ((ProviderUsage)((Object)frag)).setProvider(this.getProvider());
            }
            if (frag instanceof UsingJoinCondition) {
                cache.m_usings.add((UsingJoinCondition)frag);
            }
            if (frag instanceof JoinObject && ((JoinObject)frag).isNatural()) {
                cache.m_naturalJoins.add((JoinObject)frag);
            }
            if (frag instanceof FromObjectUsage) {
                FromObject from = ((FromObjectUsage)frag).resolveFromObject();
                if (from != null) {
                    this.addDependency(from, (FromObjectUsage)frag);
                }
            } else if (frag instanceof FKUsage) {
                FromObject right;
                FromObject left = ((FKUsage)frag).resolveLeftFromObject();
                if (left != null) {
                    this.addDependency(left, (FKUsage)frag);
                }
                if ((right = ((FKUsage)frag).resolveRightFromObject()) != null) {
                    this.addDependency(right, (FKUsage)frag);
                }
            }
            DBObject[] kids = frag.getOwnedObjects();
            for (int i = 0; kids != null && i < kids.length; ++i) {
                this.loadObject(kids[i]);
            }
        }
    }

    protected void unloadObject(DBObject frag) {
        if (frag != null) {
            QueryCache cache = this.getCache();
            DBObject[] kids = frag.getOwnedObjects();
            for (int i = 0; kids != null && i < kids.length; ++i) {
                if (!(kids[i] instanceof SQLFragment)) continue;
                this.unloadObject(kids[i]);
            }
            if (frag instanceof UsingJoinCondition) {
                cache.m_usings.remove(frag);
            }
            if (frag instanceof JoinObject) {
                cache.m_naturalJoins.remove(frag);
            }
            this.removeDependency(frag);
        }
    }

    protected List<DBObjectID> getIDs(DBObject[] objs) throws SQLQueryException {
        ArrayList<DBObjectID> retval = new ArrayList<DBObjectID>(objs.length);
        for (int i = 0; i < objs.length; ++i) {
            DBObjectID id = objs[i].getID();
            if (id == null) {
                this.throwException(new IDException(objs[i]));
            }
            retval.add(id);
        }
        return retval;
    }

    protected Map<DBObjectID, FromObject> getRelIDs(FromObject[] usagesToUse) {
        HashMap<DBObjectID, FromObject> relsToUse = new HashMap<DBObjectID, FromObject>();
        for (int i = 0; usagesToUse != null && i < usagesToUse.length; ++i) {
            this.addRelIDs(relsToUse, usagesToUse[i]);
        }
        return relsToUse;
    }

    private void addRelIDs(Map<DBObjectID, FromObject> relsToUse, FromObject from) {
        SQLFragment exp;
        SQLFragment sQLFragment = exp = from == null ? null : from.getExpression();
        if (exp instanceof AbstractSchemaObjectUsage) {
            DBObjectID refobjid;
            SchemaObject refobj;
            DBObjectID id = ((AbstractSchemaObjectUsage)exp).getObjectID();
            if (id != null) {
                relsToUse.put(id, from);
            }
            if (exp instanceof SynonymUsage && (refobj = ((SynonymUsage)exp).getReferencedObject()) != null && (refobjid = refobj.getID()) != null) {
                relsToUse.put(refobjid, from);
            }
        } else if (exp instanceof JoinObject) {
            FromObject l = ((JoinObject)exp).getLeftExpression();
            FromObject r = ((JoinObject)exp).getRightExpression();
            this.addRelIDs(relsToUse, l);
            this.addRelIDs(relsToUse, r);
        }
    }

    protected void setNewFromObject(DBObject frag, FromObject oldFrom, FromObject newFrom) {
        if (frag instanceof FromObjectUsage) {
            if (oldFrom.equals(((FromObjectUsage)frag).resolveFromObject())) {
                ((FromObjectUsage)frag).setFromObjectID(newFrom.getID());
            }
        } else if (frag instanceof FKUsage) {
            if (oldFrom.equals(((FKUsage)frag).resolveLeftFromObject())) {
                ((FKUsage)frag).setLeftFromObjectID(newFrom.getID());
            }
            if (oldFrom.equals(((FKUsage)frag).resolveRightFromObject())) {
                ((FKUsage)frag).setRightFromObjectID(newFrom.getID());
            }
        }
        DBObject[] kids = frag.getOwnedObjects();
        for (int i = 0; kids != null && i < kids.length; ++i) {
            this.setNewFromObject(kids[i], oldFrom, newFrom);
        }
    }

    private List<String> getAliases(List<? extends AliasFragment> frags) {
        ArrayList<String> aliases = new ArrayList<String>();
        if (frags != null) {
            for (AliasFragment aliasFragment : frags) {
                aliases.add(aliasFragment.getUsableAlias());
            }
        }
        return aliases;
    }

    private List<String> getAliases(AliasFragment[] frags) {
        return frags == null ? new ArrayList() : this.getAliases(Arrays.asList(frags));
    }

    protected boolean areExternalNamesEqual(String alias1, String alias2) {
        boolean retval = false;
        AbstractDBObjectProvider pro = this.getProvider();
        retval = pro == null ? ModelUtil.areEqual((Object)this.getInternalName(alias1), (Object)this.getInternalName(alias2)) : pro.getDescriptor().areNamesEqual(alias1, alias2, "SQLFragment", true);
        return retval;
    }

    protected String getInternalName(String name) {
        AbstractDBObjectProvider pro = this.getProvider();
        if (pro != null) {
            return pro.getInternalName(name);
        }
        return name;
    }

    protected String getExternalName(String name) {
        AbstractDBObjectProvider pro = this.getProvider();
        if (pro != null) {
            return pro.getExternalName(name);
        }
        return name;
    }

    protected boolean isValidName(String type, String name) {
        AbstractDBObjectProvider pro = this.getProvider();
        if (pro != null) {
            return pro.isValidName(type, name);
        }
        return true;
    }

    protected void validateAlias(AliasFragment frag, String type, String alias) throws InvalidAliasException {
        AbstractDBObjectProvider pro = this.getProvider();
        try {
            if (ModelUtil.hasLength((String)alias)) {
                pro.validateName(type, alias);
            }
        }
        catch (InvalidNameException e) {
            throw new InvalidAliasException(frag, e.getMessage());
        }
    }

    @Override
    public SQLQuery getSQLQuery() {
        return this.m_query;
    }

    @Override
    public void addSelectObject(SelectObject select) throws SQLQueryException {
        this.addSelectObject(this.m_query.getSelectObjects().length, select);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelectObject(int index, SelectObject select) throws SQLQueryException {
        String alias;
        if (this.m_query.getParent() instanceof SQLQueryOwner && !this.isUniqueSelectAlias(alias = select.getUsableAlias())) {
            this.throwException(new AliasInUseException(select));
        }
        boolean failed = true;
        try {
            this.m_query.addSelectObject(index, select);
            this.loadObject(select);
            this.checkSelectObject(select);
            this.ensureID(select);
            failed = false;
        }
        finally {
            if (failed) {
                this.m_query.removeSelectObject(select);
            }
        }
    }

    @Override
    public boolean isUniqueSelectAlias(String alias) {
        return this.isUniqueSelectAlias(alias, null);
    }

    protected boolean isUniqueSelectAlias(String alias, List<String> extraNames) {
        List<String> aliases = this.getAliases(this.m_query.getSelectObjects());
        if (extraNames != null) {
            aliases.addAll(extraNames);
        }
        return !this.containsAliasIC(alias, aliases);
    }

    @Override
    public String createUniqueSelectAlias(String base) {
        return this.createUniqueSelectAlias(base, null);
    }

    protected String createUniqueSelectAlias(String base, List<String> extraNames) {
        String alias = null;
        List<String> aliases = this.getAliases(this.m_query.getSelectObjects());
        if (extraNames != null) {
            aliases.addAll(extraNames);
        }
        int length = this.getProvider().getDescriptor().getMaxNameLength("SELECT");
        int indexLength = -1;
        while ((alias = DBUtil.getUniqueName(aliases, base = base.substring(0, base.length() - ++indexLength), false)).length() > length) {
        }
        return alias;
    }

    @Override
    public SelectObject getSelectObject(String usableAlias) {
        SelectObject[] s = this.m_query.getSelectObjects();
        for (int i = 0; s != null && i < s.length; ++i) {
            if (!this.areExternalNamesEqual(s[i].getName(), usableAlias)) continue;
            return s[i];
        }
        return null;
    }

    @Override
    public SelectObject constructSelectObject(String expression, String alias) throws SQLQueryException {
        SelectObject obj = new SelectObject();
        obj.setAlias(alias);
        obj.setExpression(this.parseSelectExpression(expression, obj));
        this.validateAlias(obj, "COLUMN", alias);
        this.checkSelectObject(obj);
        this.addSelectObject(obj);
        return obj;
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructSelectObject(Column col, FromObject usageToUse) throws SQLQueryException {
        ArrayList<String> relNames = new ArrayList<String>();
        Map<DBObjectID, FromObject> relsToUse = this.getRelIDs(new FromObject[]{usageToUse});
        HashMap<DBObjectID, FromObject> newRels = new HashMap<DBObjectID, FromObject>();
        SelectObject s = this.doConstructSelectObject(col, relsToUse, newRels, relNames, null);
        FromObject[] newFroms = newRels.values().toArray(new FromObject[newRels.size()]);
        this.addFromObjects(newFroms);
        this.checkSelectObject(s);
        this.addSelectObject(s);
        return new SQLQueryObjectSetImpl(new SelectObject[]{s}, newFroms, s);
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructSelectObjects(Column[] baseCols, FromObject[] usagesToUse) throws SQLQueryException {
        ArrayList<String> relNames = new ArrayList<String>();
        ArrayList<String> colNames = new ArrayList<String>();
        Map<DBObjectID, FromObject> relsToUse = this.getRelIDs(usagesToUse);
        HashMap<DBObjectID, FromObject> newRels = new HashMap<DBObjectID, FromObject>();
        SelectObject[] newSelects = new SelectObject[baseCols.length];
        for (int i = 0; i < baseCols.length; ++i) {
            newSelects[i] = this.doConstructSelectObject(baseCols[i], relsToUse, newRels, relNames, colNames);
        }
        FromObject[] newFroms = newRels.values().toArray(new FromObject[newRels.size()]);
        this.addFromObjects(newFroms);
        this.addSelectObjects(newSelects);
        return new SQLQueryObjectSetImpl(newSelects, newFroms, null);
    }

    protected SelectObject doConstructSelectObject(Column col, Map<DBObjectID, FromObject> relsToUse, Map<DBObjectID, FromObject> newRels, List<String> relNames, List<String> colNames) throws SQLQueryException {
        FromObject from;
        DBObjectID relID;
        Relation rel;
        DBObjectID colId = col.getID();
        if (colId == null) {
            this.throwException(new IDException(col));
        }
        if ((rel = col.getRelation()) == null) {
            this.throwException(new SQLQueryException(APIBundle.format("SQL_COL_NO_REL", col.getName())));
        }
        if ((relID = rel.getID()) == null) {
            this.throwException(new IDException(rel));
        }
        if ((from = relsToUse.get(relID)) == null) {
            from = newRels.get(relID);
        }
        if (from == null) {
            from = this.createFromObject(rel, relNames);
            newRels.put(relID, from);
            relNames.add(rel.getName());
        }
        String alias = this.getExternalName(this.createUniqueSelectAlias(col.getName(), colNames));
        if (colNames != null) {
            colNames.add(alias);
        }
        return this.createSelectObject(colId, from, alias);
    }

    protected SelectObject createSelectObject(DBObjectID colId, FromObject from, String alias) {
        ColumnUsage cu = new ColumnUsage(colId, from);
        cu.setProvider(this.getProvider());
        SelectObject retval = new SelectObject();
        retval.setAlias(alias);
        retval.setExpression(cu);
        this.addDependency(from, cu);
        return retval;
    }

    protected void addSelectObjects(SelectObject[] selects) {
        SelectObject[] existing = this.m_query.getSelectObjects();
        int totalSize = (existing == null ? 0 : existing.length) + selects.length;
        SelectObject[] total = new SelectObject[totalSize];
        System.arraycopy(existing, 0, total, 0, existing.length);
        System.arraycopy(selects, 0, total, existing.length, selects.length);
        this.m_query.setSelectObjects(total);
        this.loadObjects(selects);
    }

    @Override
    public boolean removeSelectObject(SelectObject obj) {
        SQLFragment[] dependents = this.getDependentObjects(obj);
        for (int i = 0; i < dependents.length; ++i) {
            if (dependents[i] instanceof WhereObject) {
                this.removeWhereObject(dependents[i]);
                continue;
            }
            if (!(dependents[i] instanceof GroupByObject)) continue;
            this.m_query.setGroupByObject(null);
            this.unloadObject(dependents[i]);
        }
        if (this.m_query.removeSelectObject(obj)) {
            this.removeDependency(obj);
            return true;
        }
        return false;
    }

    @Override
    public void replaceSelectObject(SelectObject oldSelect, SelectObject newSelect) throws SQLQueryException {
        this.checkSelectObject(newSelect);
        String oldAlias = oldSelect.getAlias();
        String newAlias = newSelect.getAlias();
        if (ModelUtil.hasLength((String)newAlias)) {
            if (!this.areExternalNamesEqual(newAlias, oldAlias) && !this.isUniqueSelectAlias(newAlias)) {
                this.throwException(new AliasInUseException(newSelect));
            }
            this.validateAlias(newSelect, "COLUMN", this.getExternalName(newAlias));
        }
        oldSelect.setAlias(newAlias);
        SQLFragment oldExp = oldSelect.getExpression();
        SQLFragment newExp = newSelect.getExpression();
        if (ModelUtil.areDifferent((Object)oldExp, (Object)newExp)) {
            this.removeDependency(oldSelect);
            oldSelect.setExpression(newExp);
            this.loadObject(newExp);
            this.checkSelectObject(oldSelect);
        }
    }

    @Override
    public boolean isUniqueFromAlias(String alias) {
        return this.isUniqueFromAlias(alias, null);
    }

    protected boolean isUniqueFromAlias(String alias, List<String> extraNames) {
        List<String> aliases = this.getAliases(this.listAllFromObjects());
        if (extraNames != null) {
            aliases.addAll(extraNames);
        }
        return !this.containsAliasIC(alias, aliases);
    }

    @Override
    public String createUniqueFromAlias(String base) {
        return this.createUniqueFromAlias(base, null);
    }

    protected String createUniqueFromAlias(String base, List<String> extraNames) {
        String alias = null;
        List<String> aliases = this.getAliases(this.listAllFromObjects());
        if (extraNames != null) {
            aliases.addAll(extraNames);
        }
        int length = this.getProvider().getDescriptor().getMaxNameLength("FROM");
        int indexLength = -1;
        while ((alias = DBUtil.getUniqueName(aliases, base = base.substring(0, base.length() - ++indexLength), false)).length() > length) {
        }
        return alias;
    }

    @Override
    public FromObject[] listAllFromObjects() {
        return this.listAllFromObjects(false);
    }

    @Override
    public FromObject[] listAllFromObjects(boolean includeJoins) {
        return this.listAllFromObjects(includeJoins, false);
    }

    private FromObject[] listAllFromObjects(boolean includeJoins, boolean includeWiths) {
        ArrayList<FromObject> froms = new ArrayList<FromObject>();
        FromObject[] f = this.m_query.getFromObjects();
        for (int i = 0; i < f.length; ++i) {
            this.addFromObjects(f[i], froms, includeJoins, includeWiths);
        }
        return froms.toArray(new FromObject[froms.size()]);
    }

    private void addFromObjects(DBObject frag, List<FromObject> froms, boolean includeJoins, boolean includeWiths) {
        if (frag instanceof FromObject) {
            SQLFragment exp = ((FromObject)frag).getExpression();
            if (!(!includeJoins && exp instanceof JoinObject || !includeWiths && ((FromObject)frag).isWith())) {
                froms.add((FromObject)frag);
            }
        }
        if (!(frag instanceof SQLQuery)) {
            DBObject[] kids = frag.getOwnedObjects();
            for (int i = 0; kids != null && i < kids.length; ++i) {
                this.addFromObjects(kids[i], froms, includeJoins, includeWiths);
            }
        }
    }

    @Override
    public FromObject getFromObject(String usableAlias) {
        return this.getFromObject(usableAlias, null);
    }

    public FromObject getFromObject(String usableAlias, FromObject extrafrom) {
        FromObject[] f;
        ArrayList<FromObject> froms = new ArrayList<FromObject>();
        if (extrafrom != null) {
            this.addFromObjects(extrafrom, froms, false, true);
        }
        if ((f = this.listAllFromObjects(true, true)) != null) {
            froms.addAll(Arrays.asList(f));
        }
        ArrayList<FromObject> maybes = new ArrayList<FromObject>();
        for (FromObject fo : froms) {
            String stripped;
            String foAlias = fo.getUsableAlias();
            if (foAlias == null) continue;
            if (this.areExternalNamesEqual(foAlias, usableAlias)) {
                return fo;
            }
            if (!foAlias.contains(".") || !this.areExternalNamesEqual(stripped = foAlias.substring(foAlias.indexOf(".") + 1), usableAlias)) continue;
            maybes.add(fo);
        }
        return maybes.size() == 1 ? (FromObject)maybes.get(0) : null;
    }

    @Override
    public FromObject constructFromObject(String expression, String alias) throws SQLQueryException {
        SQLFragment exp = this.parseFromExpression(expression);
        FromObject fromObj = new FromObject(exp, alias);
        this.validateAlias(fromObj, "COLUMN", alias);
        this.addFromObject(fromObj);
        return fromObj;
    }

    protected FromObject createFromObject(SchemaObject rel, List<String> extraNames) throws SQLQueryException {
        AbstractSchemaObjectUsage ru;
        Schema s;
        DBObjectID relID = rel.getID();
        if (relID == null) {
            this.throwException(new IDException(rel));
        }
        String alias = rel.getName();
        boolean isViaLink = false;
        if (relID instanceof BaseObjectID) {
            isViaLink = ((BaseObjectID)relID).getDatabaseName() != null;
        }
        boolean sameSchema = true;
        if (isViaLink) {
            String shortName = ((BaseObjectID)relID).getDatabaseName().split("\\.")[0];
            alias = alias + "_" + shortName;
            sameSchema = false;
        } else if (this.m_defaultSchema != null && (s = rel.getSchema()) != null && !s.getName().equalsIgnoreCase(this.m_defaultSchema.getName())) {
            alias = s.getName() + "_" + alias;
            sameSchema = false;
        }
        if (sameSchema && this.isUniqueFromAlias(alias, extraNames)) {
            alias = null;
        } else {
            alias = this.createUniqueFromAlias(alias, extraNames);
            alias = this.getExternalName(alias);
        }
        if (rel instanceof Relation) {
            ru = new RelationUsage(relID);
        } else if (rel instanceof Synonym) {
            ru = new SynonymUsage(relID);
        } else {
            throw new SQLQueryException("Cannot reference " + rel.getType() + " " + rel.getName() + " in FROM clause.");
        }
        ru.setProvider(this.getProvider());
        FromObject from = new FromObject(ru, alias);
        from.setParent(this.m_query);
        this.ensureID(from);
        return from;
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructFromObject(SchemaObject relation, boolean createSelectObjects, boolean createJoins, FromObject[] includeInJoins) throws SQLQueryException {
        List<DBObjectID> baseRelIDs = this.getIDs(new SchemaObject[]{relation});
        ArrayList<String> relNames = new ArrayList<String>();
        HashMap<DBObjectID, FromObject> newRels = new HashMap<DBObjectID, FromObject>();
        ArrayList<Column> cols = createSelectObjects ? new ArrayList<Column>() : null;
        ArrayList<FKConstraint> fks = createJoins ? new ArrayList<FKConstraint>() : null;
        FromObject retval = this.doConstructFromObject(relation, baseRelIDs, relNames, newRels, cols, fks);
        FromObject[] newFroms = newRels.values().toArray(new FromObject[newRels.size()]);
        this.addFromObjects(newFroms);
        SelectObject[] newSelects = null;
        if (createSelectObjects) {
            newSelects = this.constructSelectObjects(cols.toArray(new Column[cols.size()]), new FromObject[]{retval}).getSelectObjects();
        }
        FromObject[] totalRels = new FromObject[]{retval};
        if (createJoins && includeInJoins != null) {
            totalRels = new FromObject[includeInJoins.length + 1];
            totalRels[0] = retval;
            System.arraycopy(includeInJoins, 0, totalRels, 1, includeInJoins.length);
        }
        return new SQLQueryObjectSetImpl(newSelects, newFroms, retval);
    }

    protected FromObject doConstructFromObject(SchemaObject relation, List<DBObjectID> baseRelIDs, List<String> relNames, Map<DBObjectID, FromObject> newRels, List<Column> cols, List<FKConstraint> fks) throws SQLQueryException {
        FromObject retval = this.createFromObject(relation, relNames);
        newRels.put(relation.getID(), retval);
        relNames.add(relation.getName());
        if (cols != null && relation instanceof Relation) {
            Column[] relCols = ((Relation)relation).getColumns();
            cols.addAll(Arrays.asList(relCols));
        }
        if (fks != null && relation instanceof Relation) {
            for (Constraint con : ((Relation)relation).getConstraints()) {
                DBObjectID end;
                DBObjectID refRelID;
                if (!(con instanceof FKConstraint) || (refRelID = this.getParentRelation(end = ((FKConstraint)con).getReferenceID()).getID()) == null || !baseRelIDs.contains(refRelID)) continue;
                fks.add((FKConstraint)con);
            }
        }
        return retval;
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructFromObjects(Relation[] baseRelations, boolean createSelectObjects, boolean createJoins, FromObject[] includeInJoins) throws SQLQueryException {
        List<DBObjectID> baseRelIDs = this.getIDs(baseRelations);
        ArrayList<String> relNames = new ArrayList<String>();
        HashMap<DBObjectID, FromObject> newRels = new HashMap<DBObjectID, FromObject>();
        FromObject[] retval = new FromObject[baseRelations.length];
        ArrayList<Column> cols = createSelectObjects ? new ArrayList<Column>() : null;
        ArrayList<FKConstraint> fks = createJoins ? new ArrayList<FKConstraint>() : null;
        for (int i = 0; i < baseRelations.length; ++i) {
            retval[i] = this.doConstructFromObject(baseRelations[i], baseRelIDs, relNames, newRels, cols, fks);
        }
        FromObject[] newFroms = newRels.values().toArray(new FromObject[newRels.size()]);
        this.addFromObjects(newFroms);
        SelectObject[] newSelects = null;
        if (createSelectObjects) {
            newSelects = this.constructSelectObjects(cols.toArray(new Column[cols.size()]), retval).getSelectObjects();
        }
        if (createJoins) {
            FromObject[] totalRels = null;
            if (includeInJoins == null) {
                totalRels = retval;
            } else {
                totalRels = new FromObject[retval.length + includeInJoins.length];
                System.arraycopy(retval, 0, totalRels, 0, retval.length);
                System.arraycopy(includeInJoins, 0, totalRels, retval.length, includeInJoins.length);
            }
        }
        return new SQLQueryObjectSetImpl(newSelects, retval);
    }

    @Override
    public void addFromObject(FromObject from) throws SQLQueryException {
        from.setParent(this.m_query);
        String alias = from.getUsableAlias();
        if (alias != null && !this.isUniqueFromAlias(alias)) {
            this.throwException(new AliasInUseException(from));
        } else {
            alias = from.getAlias();
            this.validateAlias(from, "TABLE", alias);
        }
        this.m_query.addFromObject(from);
        this.ensureID(from);
        this.loadObject(from);
        this.checkUsageQualifications();
    }

    protected void addFromObjects(FromObject[] froms) {
        if (froms != null && froms.length > 0) {
            FromObject[] existing = this.m_query.getFromObjects();
            int totalSize = (existing == null ? 0 : existing.length) + froms.length;
            FromObject[] total = new FromObject[totalSize];
            System.arraycopy(existing, 0, total, 0, existing.length);
            System.arraycopy(froms, 0, total, existing.length, froms.length);
            this.m_query.setFromObjects(total);
            this.ensureIDs(froms);
            this.loadObjects(froms);
            this.checkUsageQualifications();
        }
    }

    protected void addJoinObject(FromObject from) {
        FromObject right;
        JoinObject join;
        FromObject left;
        List<FromObject> existing = Arrays.asList(this.m_query.getFromObjects());
        if (existing.contains(left = (join = (JoinObject)from.getExpression()).getLeftExpression())) {
            this.m_query.removeFromObject(left);
        }
        if (existing.contains(right = join.getRightExpression())) {
            this.m_query.removeFromObject(right);
        }
        this.m_query.addFromObject(from);
        this.loadObject(from);
        this.checkUsageQualifications();
    }

    @Override
    public void replaceFromObject(FromObject oldFrom, FromObject newFrom) throws SQLQueryException {
        SQLFragment newExp;
        SQLFragment oldExp;
        boolean diffExp;
        String oldAlias = oldFrom.getAlias();
        String newAlias = newFrom.getAlias();
        if (ModelUtil.hasLength((String)newAlias)) {
            if (!this.areExternalNamesEqual(newAlias, oldAlias) && !this.isUniqueFromAlias(newAlias)) {
                this.throwException(new AliasInUseException(newFrom));
            }
            this.validateAlias(newFrom, "TABLE", newAlias);
        }
        if ((diffExp = ModelUtil.areDifferent((Object)(oldExp = oldFrom.getExpression()), (Object)(newExp = newFrom.getExpression()))) && oldExp instanceof RelationUsage) {
            this.removeFromObject(oldFrom);
            this.addFromObject(newFrom);
        } else {
            if (diffExp) {
                this.unloadObject(oldExp);
                this.loadObject(newExp);
                oldFrom.setExpression(newExp);
            }
            oldFrom.setAlias(newFrom.getAlias());
        }
        this.checkUsageQualifications();
    }

    @Override
    public boolean removeJoinObject(FromObject obj) {
        SQLFragment exp = obj.getExpression();
        if (exp instanceof JoinObject) {
            QueryCache cache = this.getCache();
            cache.m_naturalJoins.remove(exp);
            boolean retval = false;
            FromObject left = ((JoinObject)exp).getLeftExpression();
            FromObject right = ((JoinObject)exp).getRightExpression();
            DBObject parent = obj.getParent();
            JoinCondition condition = ((JoinObject)exp).getCondition();
            if (condition instanceof UsingJoinCondition) {
                cache.m_usings.remove(condition);
            }
            if (parent == this.m_query) {
                int index = this.m_query.indexOf(obj);
                if (index >= 0) {
                    this.m_query.addFromObject(index, right);
                    this.m_query.addFromObject(index, left);
                    this.m_query.removeFromObject(obj);
                    retval = true;
                }
            } else if (parent instanceof JoinObject) {
                FromObject putInParentJoin = left;
                FromObject putInQuery = right;
                JoinCondition parCond = ((JoinObject)parent).getCondition();
                if (parCond instanceof UsingJoinCondition) {
                    FromObject usedInCond;
                    FromObjectUsage[] fous = ((UsingJoinCondition)parCond).getColumns();
                    for (int i = 0; i < fous.length && (usedInCond = fous[i].resolveFromObject()) != left; ++i) {
                        if (usedInCond != right) continue;
                        putInParentJoin = right;
                        putInQuery = left;
                        break;
                    }
                } else if (this.usedInChildren(right, parCond)) {
                    putInParentJoin = right;
                    putInQuery = left;
                }
                if (((JoinObject)parent).getLeftExpression() == obj) {
                    ((JoinObject)parent).setLeftExpression(putInParentJoin);
                    this.m_query.addFromObject(putInQuery);
                } else {
                    ((JoinObject)parent).setRightExpression(putInParentJoin);
                    this.m_query.addFromObject(putInQuery);
                }
                retval = true;
            }
            if (retval) {
                this.checkUsageQualifications();
                return true;
            }
        }
        return false;
    }

    private boolean usedInChildren(FromObject from, DBObject frag) {
        if (frag instanceof FromObjectUsage) {
            return ((FromObjectUsage)frag).resolveFromObject() == from;
        }
        if (frag instanceof FKUsage) {
            return ((FKUsage)frag).resolveLeftFromObject() == from || ((FKUsage)frag).resolveRightFromObject() == from;
        }
        DBObject[] kids = frag.getOwnedObjects();
        for (int i = 0; i < kids.length; ++i) {
            if (!this.usedInChildren(from, kids[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFromObject(FromObject obj) {
        SQLFragment[] deps = this.getDependentObjects(obj);
        block0: for (int i = 0; i < deps.length; ++i) {
            if (!(deps[i] instanceof FromObjectUsage)) continue;
            boolean where = false;
            for (DBObject parent = deps[i].getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof SelectObject) {
                    this.removeSelectObject((SelectObject)parent);
                    continue block0;
                }
                if (parent instanceof OrderByObject) {
                    this.removeOrderByObject((OrderByObject)parent);
                    continue block0;
                }
                if (parent instanceof WhereObject) {
                    where = true;
                    if (!(parent.getParent() instanceof SQLQuery)) continue;
                    this.removeWhereObject((WhereObject)parent);
                    continue block0;
                }
                if (!(parent instanceof GroupByObject)) continue;
                if (where) {
                    this.setHavingObject(null);
                    continue block0;
                }
                this.removeGroupByColumn(deps[i]);
                continue block0;
            }
        }
        DBObject parent = obj.getParent();
        if (parent instanceof JoinObject) {
            FromObject replaceWith = null;
            replaceWith = obj == ((JoinObject)parent).getLeftExpression() ? ((JoinObject)parent).getRightExpression() : ((JoinObject)parent).getLeftExpression();
            FromObject joinFrom = (FromObject)parent.getParent();
            DBObject topDog = joinFrom.getParent();
            if (topDog instanceof JoinObject) {
                if (joinFrom == ((JoinObject)topDog).getLeftExpression()) {
                    ((JoinObject)topDog).setLeftExpression(replaceWith);
                } else {
                    ((JoinObject)topDog).setRightExpression(replaceWith);
                }
            } else {
                FromObject[] froms = this.m_query.getFromObjects();
                for (int i = 0; i < froms.length; ++i) {
                    if (froms[i] != joinFrom) continue;
                    froms[i] = replaceWith;
                }
                this.m_query.setFromObjects(froms);
            }
            this.unloadObject(obj);
            return true;
        }
        if (this.m_query.removeFromObject(obj)) {
            this.unloadObject(obj);
            return true;
        }
        return false;
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructFKJoin(FKConstraint fk, FromObject left, FromObject right) throws SQLQueryException {
        FromObject join = this.doConstructJoin(fk, null, null, left, right);
        if (join.getParent() == null) {
            this.addJoinObject(join);
        }
        return new SQLQueryObjectSetImpl(null, new FromObject[]{join}, join);
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructFKJoins(FKConstraint[] fks, FromObject[] usagesToUse) throws SQLQueryException {
        Map<DBObjectID, FromObject> relsIDsToUse = this.getRelIDs(usagesToUse);
        FromObject[] joins = new FromObject[fks.length];
        ArrayList<FromObject> newFroms = new ArrayList<FromObject>();
        for (int i = fks.length - 1; i >= 0; --i) {
            joins[i] = this.doConstructJoin(fks[i], relsIDsToUse, newFroms, null, i < fks.length - 1 ? joins[i + 1] : null);
        }
        this.addJoinObject(joins[0]);
        return new SQLQueryObjectSetImpl(null, joins, null);
    }

    protected FromObject doConstructJoin(FKConstraint fk, Map<DBObjectID, FromObject> relsIDsToUse, List<FromObject> newFroms, FromObject left, FromObject right) throws SQLQueryException {
        DBObjectID fkID = fk.getID();
        if (fkID == null) {
            this.throwException(new IDException(fk));
        }
        if (left == null) {
            Relation fkRel = fk.getRelation();
            DBObjectID fkRelID = fkRel.getID();
            if (relsIDsToUse.containsKey(fkRelID)) {
                left = relsIDsToUse.get(fkRelID);
            } else {
                left = this.createFromObject(fkRel, this.getAliases(newFroms));
                newFroms.add(left);
            }
        }
        if (right == null) {
            DBObjectID end = fk.getReferenceID();
            Relation refRel = this.getParentRelation(end);
            DBObjectID refRelID = refRel.getID();
            if (relsIDsToUse.containsKey(refRelID) && (right = relsIDsToUse.get(refRelID)) == left) {
                right = null;
            }
            if (right == null) {
                right = this.createFromObject(refRel, this.getAliases(newFroms));
                newFroms.add(right);
            }
        }
        return this.createJoinObject(fk, left, right);
    }

    @Override
    public FromObject createJoinObject(FKConstraint fk, FromObject left, FromObject right) throws SQLQueryException {
        if (left.getParent() instanceof JoinObject && left.getParent() == right.getParent()) {
            this.throwException(new SQLQueryException(APIBundle.get("SQL_JOIN_JOIN")));
        }
        JoinObject join = new JoinObject();
        FromObject newFrom = new FromObject(join, null);
        DBObject lPar = left.getParent();
        if (lPar == this.m_query) {
            this.m_query.removeFromObject(left);
        } else if (lPar instanceof JoinObject) {
            if (left == ((JoinObject)lPar).getLeftExpression()) {
                ((JoinObject)lPar).setLeftExpression(newFrom);
            } else {
                ((JoinObject)lPar).setRightExpression(newFrom);
            }
        }
        DBObject rPar = right.getParent();
        if (rPar == this.m_query) {
            this.m_query.removeFromObject(right);
        } else if (rPar instanceof JoinObject) {
            if (right == ((JoinObject)rPar).getLeftExpression()) {
                ((JoinObject)rPar).setLeftExpression(newFrom);
            } else {
                ((JoinObject)rPar).setRightExpression(newFrom);
            }
        }
        join.setLeftExpression(left);
        join.setRightExpression(right);
        this.createJoinCondition(fk, join);
        this.ensureID(newFrom);
        return newFrom;
    }

    private void logResolveIDException(DBException dbe) {
        this.getLogger().warning("ID failed to resolve: " + dbe.getMessage());
    }

    protected JoinCondition createJoinCondition(FKConstraint fk, JoinObject join) {
        AbstractSQLFragment cond = null;
        ArrayList<DBObjectID> using = new ArrayList<DBObjectID>();
        DBObjectID[] fkCols = fk.getColumnIDs();
        DBObjectID[] ukCols = null;
        DBObjectID refID = fk.getReferenceID();
        try {
            UniqueConstraint uk = (UniqueConstraint)refID.resolveID();
            if (uk != null) {
                ukCols = uk.getColumnIDs();
            }
        }
        catch (DBException dbe) {
            this.logResolveIDException(dbe);
        }
        if (fkCols == null || ukCols == null || fkCols.length < 1 || fkCols.length != ukCols.length) {
            using = null;
        } else {
            for (int i = 0; i < fkCols.length; ++i) {
                if (!ModelUtil.areEqual((Object)DBUtil.getDBObjectName(fkCols[i]), (Object)DBUtil.getDBObjectName(ukCols[i]))) {
                    using = null;
                    break;
                }
                using.add(fkCols[i]);
            }
        }
        if (using != null && using.size() > 0) {
            FromObjectUsage[] fous = new FromObjectUsage[using.size()];
            for (int i = 0; i < fous.length; ++i) {
                fous[i] = new ColumnUsage((DBObjectID)using.get(i), join.getLeftExpression());
            }
            cond = new UsingJoinCondition(fous);
            this.getCache().m_usings.add((UsingJoinCondition)cond);
        } else {
            FKUsage fku = this.createFKUsage(fk.getID(), join.getLeftExpression(), join.getRightExpression());
            cond = new OnJoinCondition(fku);
        }
        join.setCondition((JoinCondition)((Object)cond));
        return cond;
    }

    private Relation getParentRelation(DBObjectID constraintID) throws SQLQueryException {
        Relation retval;
        UniqueConstraint uc = null;
        try {
            uc = (UniqueConstraint)constraintID.resolveID();
        }
        catch (DBException dbe) {
            this.throwException(new IDException(constraintID, dbe));
        }
        Relation relation = retval = uc == null ? null : uc.getRelation();
        if (retval == null) {
            this.throwException(new IDException(uc));
        }
        return retval;
    }

    protected FKUsage doConstructFKUsage(FKConstraint fk, Map relsIDsToUse, List<FromObject> newFroms) throws SQLQueryException {
        DBObjectID fkID = fk.getID();
        if (fkID == null) {
            this.throwException(new IDException(fk));
        }
        FromObject left = null;
        DBObjectID end = fk.getReferenceID();
        Relation refRel = this.getParentRelation(end);
        DBObjectID refRelID = refRel.getID();
        if (relsIDsToUse.containsKey(refRelID)) {
            left = (FromObject)relsIDsToUse.get(refRelID);
        } else {
            left = this.createFromObject(refRel, this.getAliases(newFroms));
            newFroms.add(left);
        }
        FromObject right = null;
        Relation rel = fk.getRelation();
        DBObjectID relID = rel.getID();
        if (relsIDsToUse.containsKey(relID)) {
            right = (FromObject)relsIDsToUse.get(relID);
        } else {
            right = this.createFromObject(rel, this.getAliases(newFroms));
            newFroms.add(right);
        }
        return this.createFKUsage(fkID, left, right);
    }

    protected FKUsage createFKUsage(DBObjectID fkID, FromObject left, FromObject right) {
        DBObjectID leftID = left != null ? left.getID() : null;
        DBObjectID rightID = right != null ? right.getID() : null;
        FKUsage retval = new FKUsage(fkID, leftID, rightID);
        retval.setProvider(this.getProvider());
        return retval;
    }

    @Override
    public void setWhereObject(WhereObject obj) {
        WhereObject old = this.m_query.getWhereObject();
        if (old != null && !old.equals(obj)) {
            this.unloadObject(old);
        }
        this.m_query.setWhereObject(obj);
        if (obj != null) {
            this.loadObject(obj);
        }
    }

    protected boolean removeWhereObject(SQLFragment obj) {
        WhereObject top = this.m_query.getWhereObject();
        if (top != null) {
            if (top.equals(obj)) {
                this.unloadObject(obj);
                this.m_query.setWhereObject(null);
                return true;
            }
            SQLFragment[] args = top.getArguments();
            for (int i = 0; args != null && i < args.length; ++i) {
                SQLFragment exp;
                if (args[i] != obj) continue;
                SQLFragment[] newArgs = new SQLFragment[args.length - 1];
                System.arraycopy(args, 0, newArgs, 0, i);
                System.arraycopy(args, i + 1, newArgs, i, args.length - i - 1);
                top.setArguments(newArgs);
                this.unloadObject(obj);
                if (top.getArgumentCount() < 1) {
                    this.m_query.setWhereObject(null);
                } else if (top.getArgumentCount() == 1 && (exp = top.getArguments()[0]) instanceof WhereObject) {
                    this.m_query.setWhereObject((WhereObject)exp);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public RelationUsage[] getRelationUsages() {
        FromObject[] froms = this.listAllFromObjects();
        ArrayList<SQLFragment> retval = new ArrayList<SQLFragment>();
        for (int i = 0; i < froms.length; ++i) {
            SQLFragment exp = froms[i].getExpression();
            if (!(exp instanceof RelationUsage)) continue;
            retval.add(exp);
        }
        return retval.toArray(new RelationUsage[retval.size()]);
    }

    @Override
    public SQLFragment[] getDependentObjects(FromObject from) {
        QueryCache cache = this.getCache();
        Collection deps = (Collection)cache.m_fromDeps.get(from);
        if (deps != null) {
            ArrayList retval = new ArrayList();
            for (SQLFragment obj : deps) {
                this.findEquivalentObjects(obj, this.m_query, retval);
            }
            return retval.toArray(new SQLFragment[retval.size()]);
        }
        return EMPTY_ARRAY;
    }

    private void findEquivalentObjects(DBObject dep, DBObject search, Collection results) {
        DBObject[] kids = search.getOwnedObjects();
        for (int i = 0; i < kids.length; ++i) {
            if (kids[i] == null) continue;
            if (kids[i].equals(dep)) {
                results.add(kids[i]);
            }
            this.findEquivalentObjects(dep, kids[i], results);
        }
    }

    @Override
    public SQLFragment[] getDependentObjects(SelectObject select) {
        SQLFragment exp;
        ArrayList<GroupByObject> deps = new ArrayList<GroupByObject>();
        if (this.supportsGroupBy() && (exp = select.getExpression()) instanceof Function && ((Function)exp).isGrouping()) {
            boolean groupByDep = true;
            SelectObject[] sels = this.m_query.getSelectObjects();
            for (int i = 0; i < sels.length; ++i) {
                SQLFragment sexp;
                if (sels[i].equals(select) || !((sexp = sels[i].getExpression()) instanceof Function) || !((Function)sexp).isGrouping()) continue;
                groupByDep = false;
                break;
            }
            GroupByObject gbo = this.m_query.getGroupByObject();
            if (groupByDep && gbo != null) {
                deps.add(gbo);
            }
        }
        return deps.toArray(new SQLFragment[deps.size()]);
    }

    @Override
    public boolean canMergeRelationUsages(RelationUsage baseUsage, RelationUsage mergingUsage) {
        DBObjectID base = baseUsage.getObjectID();
        DBObjectID merging = mergingUsage.getObjectID();
        return base != null && ModelUtil.areEqual((Object)base, (Object)merging);
    }

    @Override
    public void mergeRelationUsages(RelationUsage baseUsage, RelationUsage mergingUsage) throws SQLQueryException {
        DBObjectID base = baseUsage.getObjectID();
        DBObjectID merging = baseUsage.getObjectID();
        if (base == null || ModelUtil.areDifferent((Object)base, (Object)merging)) {
            this.throwException(new SQLQueryException(APIBundle.get("SQL_RELU_MERGE_ERR")));
        }
        FromObject baseFrom = (FromObject)baseUsage.getParent();
        FromObject mergingFrom = (FromObject)mergingUsage.getParent();
        if (!(mergingFrom.getParent() instanceof SQLQuery)) {
            this.throwException(new SQLQueryException(APIBundle.get("SQL_MERGE_JOIN")));
        }
        SQLFragment[] deps = this.getDependentObjects(mergingFrom);
        for (int i = 0; i < deps.length; ++i) {
            this.setNewFromObject(deps[i], mergingFrom, baseFrom);
        }
    }

    @Override
    public FKUsage[] listAvailableFKs() {
        ArrayList<FKUsage> retval = new ArrayList<FKUsage>();
        RelationUsage[] usages = this.getRelationUsages();
        HashMap<DBObjectID, ArrayList<FromObject>> relIDs = new HashMap<DBObjectID, ArrayList<FromObject>>();
        for (int i = 0; i < usages.length; ++i) {
            DBObjectID id = usages[i].getObjectID();
            if (id == null) continue;
            ArrayList<FromObject> froms = (ArrayList<FromObject>)relIDs.get(id);
            if (froms == null) {
                froms = new ArrayList<FromObject>();
                relIDs.put(id, froms);
            }
            froms.add((FromObject)usages[i].getParent());
        }
        for (Map.Entry entry : relIDs.entrySet()) {
            DBObjectID relID = (DBObjectID)entry.getKey();
            if (relID == null) continue;
            for (FromObject left : (List)entry.getValue()) {
                Relation rel = (Relation)this.resolveID(relID);
                if (rel == null) continue;
                for (Constraint con : rel.getConstraints()) {
                    if (!(con instanceof FKConstraint)) continue;
                    try {
                        DBObjectID end = ((FKConstraint)con).getReferenceID();
                        DBObjectID refRelID = this.getParentRelation(end).getID();
                        List froms2 = (List)relIDs.get(refRelID);
                        for (int k = 0; froms2 != null && k < froms2.size(); ++k) {
                            FromObject right = (FromObject)froms2.get(k);
                            if (right == null) continue;
                            DBObjectID leftID = left != null ? left.getID() : null;
                            DBObjectID rightID = right != null ? right.getID() : null;
                            FKUsage fku = new FKUsage(con.getID(), leftID, rightID);
                            if (retval.contains(fku)) continue;
                            retval.add(fku);
                        }
                    }
                    catch (SQLQueryException sqe) {
                        this.getLogger().warning("Error listing FKs: " + sqe.getMessage());
                    }
                }
            }
        }
        return retval.toArray(new FKUsage[retval.size()]);
    }

    @Override
    @Deprecated
    public ColumnUsage[] getColumnUsages() {
        Collection<ColumnUsage> colus = DBUtil.findChildren(this.m_query, ColumnUsage.class);
        return colus.toArray(new ColumnUsage[colus.size()]);
    }

    public FromObjectUsage findColumnInFromObjects(String colName, boolean external, SQLFragment creating, FromObject ... extraFroms) throws SQLQueryException {
        FromObject[] froms = this.m_query.getFromObjects();
        if ((extraFroms = DBUtil.stripNulls(extraFroms)) != null && extraFroms.length > 0) {
            FromObject[] queryfroms = froms;
            froms = new FromObject[queryfroms.length + extraFroms.length];
            System.arraycopy(queryfroms, 0, froms, 0, queryfroms.length);
            System.arraycopy(extraFroms, 0, froms, queryfroms.length, extraFroms.length);
        }
        this.replaceWithAliases(froms);
        FromObjectUsage retval = this.findColumnInFromObjects(colName, external, froms, false, false, creating);
        if (retval != null) {
            retval.setQualified(false);
        }
        return retval;
    }

    protected void replaceWithAliases(FromObject[] froms) {
    }

    protected FromObjectUsage findColumnInFromObjects(String colName, boolean external, FromObject[] froms, boolean allowDuplicates, boolean enforceInAll, SQLFragment creating) throws SQLQueryException {
        if (!ModelUtil.hasLength((String)colName)) {
            return null;
        }
        FromObjectUsage retval = null;
        for (int i = 0; i < froms.length; ++i) {
            this.checkCancelled();
            FromObject from = froms[i];
            if (from == null) continue;
            this.ensureID(from);
            SQLFragment exp = from.getExpression();
            FromObjectUsage found = this.findColumnInFromExpression(colName, external, exp, allowDuplicates, from, creating);
            if (found != null) {
                if (retval != null && !allowDuplicates) {
                    this.throwException(new AmbiguousColumnException(creating, colName));
                }
                retval = found;
                continue;
            }
            if (!enforceInAll) continue;
            this.throwException(new SQLQueryException(APIBundle.format("SQL_MISSING_COL", colName, froms[i].getName())));
        }
        return retval;
    }

    public FromObjectUsage findColumnInFromExpression(String colName, boolean external, SQLFragment exp, boolean allowDuplicates, FromObject from, SQLFragment creating) throws SQLQueryException {
        FromObjectUsage found = null;
        if (exp instanceof RelationUsage) {
            found = this.findColumnInRelation(colName, external, (RelationUsage)exp);
        } else if (exp instanceof SynonymUsage) {
            SchemaObject so = ((SynonymUsage)exp).getReferencedObject();
            if (so instanceof Relation && (found = this.findColumnInRelation(colName, external, (Relation)so)) != null) {
                found.setFromObjectID(from.getID());
            }
        } else if (exp instanceof SQLQuery) {
            SQLQuery query = (SQLQuery)exp;
            found = this.isSelectStar(query) ? this.findColumnInFromObjects(colName, external, query.getFromObjects(), false, false, null) : this.findColumnInSubQuery(colName, external, query);
        } else if (exp instanceof JoinObject) {
            found = this.findColumnInJoin(colName, external, (JoinObject)exp, allowDuplicates, creating);
        } else if (exp instanceof ColumnUsage) {
            found = this.findColumnInColumnUsage(colName, external, (ColumnUsage)exp, from);
        } else if (exp instanceof Function && "TABLE".equals(((Function)exp).getFunction())) {
            found = this.findColumnInTableFunction(colName, external, (Function)exp, from);
        }
        return found;
    }

    protected FromObjectUsage findColumnInColumnUsage(String colName, boolean external, ColumnUsage colu, FromObject from) {
        DataTypeUsage dtu;
        DBObjectID id = colu.getObjectID();
        Column col = (Column)this.resolveID(id);
        if (col != null && (dtu = col.getDataTypeUsage()) != null) {
            DBObjectID foundID;
            DataType dt = null;
            try {
                dt = DataTypeHelper.getDataType(dtu, false);
            }
            catch (DBException dbe) {
                this.logResolveIDException(dbe);
            }
            if (dt != null && (foundID = this.getTypeMemberID(dt, colName, external)) != null) {
                return new PlSqlUsage(foundID, from.getID());
            }
        }
        return null;
    }

    protected FromObjectUsage findColumnInTableFunction(String colName, boolean external, Function func, FromObject from) {
        DBObjectID dtid;
        if (func != null && (dtid = func.getDataTypeID()) != null) {
            DBObjectID foundID;
            DBObject dt = null;
            try {
                dt = dtid.resolveID();
            }
            catch (DBException dbe) {
                this.logResolveIDException(dbe);
            }
            if (dt instanceof DataType && (foundID = this.getTypeMemberID((DataType)dt, colName, external)) != null) {
                return new PlSqlUsage(foundID, from.getID());
            }
        }
        return null;
    }

    private DBObjectID getTypeMemberID(DataType dt, String colName, boolean external) {
        PlSqlDatatype.Structure struct;
        String internalColName;
        DBObjectID foundID = null;
        AbstractDBObjectProvider pro = this.getProvider();
        String string = internalColName = external ? pro.getInternalName(colName) : colName;
        if (dt instanceof Type) {
            PlSqlAttribute attr;
            DBObjectID ofTypeID;
            DataTypeUsage otDTU;
            Type type = (Type)dt;
            if ("COLLECTION".equals(type.getTypeCode()) && (otDTU = type.getOfTypeUsage()) != null && (ofTypeID = otDTU.getDataTypeID()) != null) {
                try {
                    DataType newDt = (DataType)ofTypeID.resolveID();
                    if (newDt instanceof Type) {
                        type = (Type)newDt;
                    }
                }
                catch (DBException dbe) {
                    this.logResolveIDException(dbe);
                }
            }
            if ((attr = type.getAttribute(internalColName)) != null) {
                foundID = attr.getID();
                if (foundID == null) {
                    foundID = new ReferenceID((DBObject)attr, (DBObjectProvider)pro);
                }
            } else {
                PlSqlMethod method = type.getMethod(internalColName);
                if (method != null && (foundID = method.getID()) == null) {
                    foundID = new ReferenceID((DBObject)method, (DBObjectProvider)pro);
                }
            }
        } else if (dt instanceof PlSqlDatatype && (struct = ((PlSqlDatatype)dt).getStructure()) != PlSqlDatatype.Structure.SCALAR) {
            ReferenceID refId = new ReferenceID("TypeAttribute", (Schema)null, internalColName);
            refId.setProvider(pro);
            foundID = refId;
        }
        return foundID;
    }

    protected FromObjectUsage findColumnInJoin(String colName, boolean external, JoinObject join, boolean allowDuplicates, SQLFragment creating) throws SQLQueryException {
        if ((join.isNatural() || join.getCondition() instanceof UsingJoinCondition) && ModelUtil.hasLength((String)colName)) {
            try {
                FromObject right;
                FromObjectUsage foundRight;
                FromObject left = join.getLeftExpression();
                FromObjectUsage foundLeft = this.findColumnInFromObjects(colName, external, new FromObject[]{left}, true, false, null);
                if (foundLeft != null && (foundRight = this.findColumnInFromObjects(colName, external, new FromObject[]{right = join.getLeftExpression()}, true, false, null)) != null) {
                    allowDuplicates = true;
                }
            }
            catch (SQLQueryException e) {
                this.getLogger().warning("Error checking usages: " + e.getMessage());
            }
        }
        return this.findColumnInFromObjects(colName, external, new FromObject[]{join.getLeftExpression(), join.getRightExpression()}, allowDuplicates, false, creating);
    }

    public FromObjectUsage findColumnInRelation(String colName, boolean external, RelationUsage relU) throws SQLQueryException {
        this.checkCancelled();
        DBObjectID relID = relU.getObjectID();
        Relation rel = (Relation)this.resolveID(relID);
        FromObjectUsage retval = this.findColumnInRelation(colName, external, rel);
        if (retval != null) {
            retval.setFromObjectID(relU.getParent().getID());
        }
        return retval;
    }

    public FromObjectUsage findColumnInRelation(String colName, boolean external, Relation rel) throws SQLQueryException {
        this.checkCancelled();
        if (rel != null) {
            AbstractDBObjectProvider pro = this.getProvider();
            String colInternalName = external ? this.getInternalName(colName) : colName;
            Column col = (Column)DBUtil.findChildByName(rel, "columns", colInternalName, true, pro);
            this.checkCancelled();
            if (col != null) {
                DBObjectID colID = col.getID();
                if (colID == null) {
                    this.throwException(new IDException(col));
                }
                ColumnUsage cu = new ColumnUsage(colID);
                cu.setProvider(pro);
                return cu;
            }
        }
        return null;
    }

    private boolean isSelectStar(SQLQuery query) {
        boolean retval = false;
        SelectObject[] subSelects = query.getSelectObjects();
        if (subSelects.length == 1 && "*".equals(subSelects[0].getSQLText())) {
            retval = true;
        }
        return retval;
    }

    public SelectObjectUsage findColumnInSubQuery(String colName, boolean external, SQLQuery query) throws SQLQueryException {
        SelectObject[] subSelects = SQLFragmentUtils.getSelectObjects(query);
        for (int j = 0; j < subSelects.length; ++j) {
            String externalColName;
            String selectName = subSelects[j].getUsableAlias();
            if (selectName == null) continue;
            int index = selectName.lastIndexOf(".");
            if (index > -1) {
                selectName = selectName.substring(index + 1);
            }
            DatabaseDescriptor desc = this.getProvider().getDescriptor();
            String string = externalColName = external ? colName : desc.getExternalName(colName, "COLUMN");
            if (!desc.areNamesEqual(externalColName, selectName, "COLUMN", true)) continue;
            return new SelectObjectUsage(subSelects[j], (FromObject)query.getParent());
        }
        return null;
    }

    public ColumnUsage findColumnInStarSubQuery(String colName, boolean external, FromObject from) throws SQLQueryException {
        SQLFragment frag = from.getExpression();
        if (frag instanceof WithClauseUsage) {
            FromObject fo = ((WithClauseUsage)frag).resolveFromObject();
            frag = fo.getExpression();
        }
        SQLQuery query = (SQLQuery)frag;
        SelectObject[] subSelects = query.getSelectObjects();
        for (int j = 0; j < subSelects.length; ++j) {
            FromObjectUsage fromObjectUsage;
            String selectName = subSelects[j].getExpression().getSQLText();
            int index = selectName.lastIndexOf(".");
            if (index > -1) {
                selectName = selectName.substring(index + 1);
            }
            if (!selectName.equals("*") || !((fromObjectUsage = this.findColumnInFromObjects(colName, external, query.getFromObjects(), true, false, null)) instanceof ColumnUsage)) continue;
            ColumnUsage cu = (ColumnUsage)fromObjectUsage;
            cu.setFromObjectID(from.getID());
            return cu;
        }
        return null;
    }

    @Override
    public void setHierarchicalQueryObject(HierarchicalQueryObject obj) {
        HierarchicalQueryObject existing = this.m_query.getHierarchicalQueryObject();
        this.unloadObject(existing);
        this.m_query.setHierarchicalQueryObject(obj);
        if (obj != null) {
            SQLFragment connectby = obj.getConnectBy();
            SQLFragment startwith = obj.getStartWith();
            this.loadObject(connectby);
            this.loadObject(startwith);
        }
    }

    @Override
    public void setGroupByObject(GroupByObject obj) {
        GroupByObject existing = this.m_query.getGroupByObject();
        this.unloadObject(existing);
        this.m_query.setGroupByObject(obj);
        if (obj != null) {
            SQLFragment[] exps = obj.getExpressions();
            for (int i = 0; exps != null && i < exps.length; ++i) {
                this.loadObject(exps[i]);
            }
            WhereObject having = obj.getHaving();
            if (having != null) {
                this.loadObject(having);
            }
        }
    }

    private boolean isGroupingFunction(SQLFragment frag) {
        boolean retval = false;
        if (frag instanceof Function) {
            Function f = (Function)frag;
            retval = f.isGrouping();
        }
        if (!retval) {
            for (DBObject child : frag.getOwnedObjects("SQLFragment")) {
                if (!(child instanceof SQLFragment) || !this.isGroupingFunction((SQLFragment)child)) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    @Override
    public boolean canSetGroupBy() {
        if (this.supportsGroupBy()) {
            SelectObject[] s = this.m_query.getSelectObjects();
            for (int i = 0; s != null && i < s.length; ++i) {
                SQLFragment frag = s[i].getExpression();
                if (!this.isGroupingFunction(frag)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addGroupByColumn(SQLFragment colu) {
        this.addGroupByColumn(-1, colu);
    }

    @Override
    public void addGroupByColumn(int index, SQLFragment colu) {
        FromObjectUsage fou;
        GroupByObject gbo = this.m_query.getGroupByObject();
        if (gbo == null) {
            gbo = new GroupByObject();
            this.m_query.setGroupByObject(gbo);
        }
        if (colu instanceof FromObjectUsage && (this.isUsedInUsing(fou = (FromObjectUsage)colu) || this.isUsedInNatural(fou))) {
            fou.setQualified(false);
        }
        if (index == -1) {
            gbo.addExpression(colu);
        } else {
            gbo.addExpression(index, colu);
        }
        this.loadObject(colu);
    }

    @Override
    public boolean removeGroupByColumn(SQLFragment colu) {
        GroupByObject gbo = this.m_query.getGroupByObject();
        if (gbo != null && gbo.removeExpression(colu)) {
            this.unloadObject(colu);
            return true;
        }
        return false;
    }

    @Override
    public SQLFragment parseHavingExpression(String expression) throws SQLQueryException {
        return this.parseWhereExpression(expression);
    }

    @Override
    public final SQLFragment parseOrderByExpression(String expression) throws SQLQueryException {
        return this.parseOrderByExpression(expression, null);
    }

    protected SQLFragment parseOrderByExpression(String expression, OrderByObject obo) throws SQLQueryException {
        return this.parseSelectExpression(expression, null);
    }

    @Override
    public void setHavingObject(WhereObject having) {
        GroupByObject gbo = this.m_query.getGroupByObject();
        gbo.getHaving();
        this.unloadObject(gbo);
        gbo.setHaving(having);
        if (having != null) {
            this.loadObject(having);
        }
    }

    @Override
    public void addOrderByObject(OrderByObject ob) {
        this.m_query.addOrderByObject(ob);
        this.loadObject(ob);
        this.checkUsageQualifications();
    }

    @Override
    public void addOrderByObject(int index, OrderByObject ob) {
        this.m_query.addOrderByObject(index, ob);
        this.loadObject(ob);
        this.checkUsageQualifications();
    }

    @Override
    public boolean removeOrderByObject(OrderByObject ob) {
        if (this.m_query.removeOrderByObject(ob)) {
            this.unloadObject(ob);
            return true;
        }
        return false;
    }

    @Override
    public void replaceOrderByObject(OrderByObject oldOb, OrderByObject newOb) {
        SQLFragment newExp;
        SQLFragment oldExp = oldOb.getExpression();
        if (ModelUtil.areDifferent((Object)oldExp, (Object)(newExp = newOb.getExpression()))) {
            this.unloadObject(oldOb);
            newOb.copyTo(oldOb);
            this.loadObject(newExp);
        }
        this.checkUsageQualifications();
    }

    @Override
    public void setOrderByObjects(OrderByObject[] orderbys) {
        OrderByObject[] existing = this.m_query.getOrderByObjects();
        for (int i = 0; existing != null && i < existing.length; ++i) {
            this.unloadObject(existing[i]);
        }
        this.m_query.setOrderByObjects(orderbys);
        this.loadObjects(orderbys);
    }

    @Override
    @Deprecated
    public void syncViewColumns() throws AliasInUseException {
    }

    public String getColumnName(SelectObject sel) {
        String colName = null;
        if (ModelUtil.hasLength((String)sel.getAlias())) {
            colName = sel.getAlias();
        } else {
            SQLFragment exp = sel.getExpression();
            if (exp != null) {
                colName = sel.getUsableAlias();
            }
            if (exp instanceof AbstractFromObjectUsage && colName != null && colName.contains(".")) {
                colName = colName.substring(colName.indexOf(".") + 1);
            }
        }
        colName = this.getInternalName(colName);
        return colName;
    }

    public void checkUsageQualifications() {
        QueryCache cache = this.getCache();
        if (cache.m_fromDeps.size() > 0) {
            for (Map.Entry entry : cache.m_fromDeps.entrySet()) {
                for (SQLFragment dep : (Collection)entry.getValue()) {
                    if (!(dep instanceof FromObjectUsage)) continue;
                    FromObjectUsage fou = (FromObjectUsage)dep;
                    boolean usedInUsing = this.isUsedInUsing(fou) || this.isUsedInNatural(fou);
                    boolean isInUsing = fou.getParent() instanceof UsingJoinCondition;
                    if (fou.isQualified() && usedInUsing || isInUsing) {
                        fou.setQualified(false);
                        continue;
                    }
                    if (fou.isQualified() || usedInUsing) continue;
                    String name = fou.getColumnName();
                    try {
                        this.findColumnInFromObjects(name, false, null, new FromObject[0]);
                    }
                    catch (AmbiguousColumnException ace) {
                        fou.setQualified(true);
                    }
                    catch (SQLQueryException sqe) {
                        this.getLogger().warning("couldn't check usages: " + sqe.getMessage());
                    }
                }
            }
        }
    }

    private boolean isUsedInUsing(FromObjectUsage fou) {
        DBObjectID colId;
        boolean retval = false;
        QueryCache cache = this.getCache();
        if (cache.m_usings.size() > 0 && fou instanceof DBObjectUsage && (colId = ((DBObjectUsage)((Object)fou)).getObjectID()) != null) {
            for (UsingJoinCondition using : cache.m_usings) {
                FromObjectUsage[] cols = using.getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    if (!(cols[i] instanceof DBObjectUsage)) continue;
                    DBObjectID id = ((DBObjectUsage)((Object)cols[i])).getObjectID();
                    if (colId.equals(id, false)) {
                        retval = true;
                        continue;
                    }
                    JoinObject join = (JoinObject)using.getParent();
                    String colName = cols[i].getColumnName();
                    retval = this.isPresentInFrom(colId, colName, join.getLeftExpression()) || this.isPresentInFrom(colId, colName, join.getRightExpression());
                }
            }
        }
        return retval;
    }

    private boolean isPresentInFrom(DBObjectID colId, String internalColName, FromObject from) {
        boolean retval = false;
        try {
            DBObjectID otherID;
            FromObjectUsage otherCol = this.findColumnInFromObjects(internalColName, false, new FromObject[]{from}, true, false, null);
            if (otherCol != null && otherCol instanceof DBObjectUsage && colId.equals(otherID = ((DBObjectUsage)((Object)otherCol)).getObjectID(), false)) {
                retval = true;
            }
        }
        catch (SQLQueryException sQLQueryException) {
            // empty catch block
        }
        return retval;
    }

    private boolean isUsedInNatural(FromObjectUsage fou) {
        QueryCache cache = this.getCache();
        if (cache.m_naturalJoins.size() > 0 && fou instanceof DBObjectUsage) {
            DBObjectID id = ((DBObjectUsage)((Object)fou)).getObjectID();
            String colName = null;
            DBObject obj = this.resolveID(id);
            if (obj instanceof Column) {
                colName = obj.getName();
            }
            if (ModelUtil.hasLength(colName)) {
                for (JoinObject join : cache.m_naturalJoins) {
                    try {
                        FromObject right;
                        FromObjectUsage foundRight;
                        FromObject left = join.getLeftExpression();
                        FromObjectUsage foundLeft = this.findColumnInFromObjects(colName, false, new FromObject[]{left}, false, false, null);
                        if (foundLeft == null || (foundRight = this.findColumnInFromObjects(colName, false, new FromObject[]{right = join.getRightExpression()}, false, false, null)) == null) continue;
                        return true;
                    }
                    catch (SQLQueryException e) {
                        this.getLogger().warning("Error checking usages: " + e.getMessage());
                    }
                }
            }
        }
        return false;
    }

    private void checkSelectObject(SelectObject s) throws SQLQueryException {
        SQLFragment f = s.getExpression();
        if (f == null) {
            this.throwException(new SQLQueryException(s, APIBundle.get("SQL_EMPTY_EXP")));
        }
        if (f instanceof FromObjectUsage) {
            FromObjectUsage fou = (FromObjectUsage)f;
            boolean usedInUsing = this.isUsedInUsing(fou);
            boolean usedInNatural = this.isUsedInNatural(fou);
            if (fou.isQualified() && (usedInUsing || usedInNatural)) {
                fou.setQualified(false);
            }
        } else if (this.m_query.getParent() instanceof SQLQueryOwner) {
            if (!ModelUtil.hasLength((String)s.getAlias())) {
                this.setAliasFromColumn(s);
            }
            if (!ModelUtil.hasLength((String)s.getAlias())) {
                this.throwException(new SQLQueryClauseException(s, APIBundle.format("SQL_EXP_REQUIRE_ALIAS", f.getSQLText())));
            }
        }
    }

    @Override
    public final SQLFragment parseFromExpression(String expression) throws SQLQueryException {
        return this.parseFromExpression(expression, null);
    }

    protected SQLFragment parseFromExpression(String expression, FromObject creating) throws SQLQueryException {
        return null;
    }

    @Override
    public final SQLFragment parseSelectExpression(String expression) throws SQLQueryException {
        return this.parseSelectExpression(expression, null);
    }

    protected SQLFragment parseSelectExpression(String expression, SelectObject creating) throws SQLQueryException {
        throw new SQLQueryException(APIBundle.get("SQL_QUERY_PARSE_NONE"));
    }

    @Override
    public final SQLFragment parseWhereExpression(String expression) throws SQLQueryException {
        return this.parseWhereExpression(expression, null);
    }

    public SQLFragment parseWhereExpression(String expression, WhereObject creating) throws SQLQueryException {
        throw new SQLQueryException(APIBundle.get("SQL_QUERY_PARSE_NONE"));
    }

    @Override
    public Column[] getColumns() throws DBException {
        if (this.m_query == null) {
            throw new IllegalStateException("Must built a valid query first");
        }
        ArrayList<Column> collist = new ArrayList<Column>();
        if (this.m_query.getSQLText() != null) {
            try {
                boolean containsAsterisk = this.containsAsterisk();
                if (containsAsterisk) {
                    if (this.getProvider() instanceof Database && (this.m_extraObjects == null || this.m_extraObjects.isEmpty())) {
                        return this.getColumnsFromResultSet();
                    }
                    this.ensureComponent(this.m_query, "selectObjects");
                }
                int columnIndex = 0;
                if (this.m_query.isDeclarative() && !DBUtil.needsBuilding(this.m_query, "selectObjects")) {
                    List<SelectObject> sels = containsAsterisk ? SQLFragmentUtils.expandStarColumns(this.m_query) : Arrays.asList(this.m_query.getSelectObjects());
                    for (SelectObject so : sels) {
                        int index;
                        String selectName = so.getUsableAlias();
                        if (selectName != null && (index = selectName.lastIndexOf(".")) > -1) {
                            selectName = selectName.substring(index + 1);
                        }
                        selectName = this.getProvider().getInternalName(selectName);
                        collist.add(this.newViewColumn(selectName, columnIndex++));
                    }
                } else if (this.getProvider() instanceof Database) {
                    return this.getColumnsFromResultSet();
                }
                if (columnIndex == 0) {
                    for (QueryColumnInfo qci : this.getQueryColumnInfos()) {
                        collist.add(this.newViewColumn(qci.getName(), columnIndex++));
                    }
                }
            }
            catch (SQLQueryException sqlqe) {
                if (this.getProvider() instanceof Database && !this.matchesProvider()) {
                    return this.getColumnsFromResultSet();
                }
                throw sqlqe;
            }
        }
        return collist.toArray(new Column[collist.size()]);
    }

    protected Column[] getColumnsFromResultSet() throws DBException {
        return new Column[0];
    }

    private Column newViewColumn(String name, int columnIndex) {
        Column col = new Column();
        col.setName(name);
        col.setID(TemporaryObjectID.createID(col));
        this.getProvider().getObjectFactory().setDerivedPropertyBuilder(col, this.getDTUBuilder(columnIndex));
        return col;
    }

    protected abstract DerivedPropertyBuilder getDTUBuilder(int var1);

    protected abstract boolean containsAsterisk() throws SQLQueryException;

    public abstract List<QueryColumnInfo> getQueryColumnInfos() throws SQLQueryException;

    protected void setViewColDataType(Column col, SelectObject so) {
        DataTypeUsage olddtu;
        DBObject obj;
        SQLFragment exp;
        SQLFragment sQLFragment = exp = so == null ? null : so.getExpression();
        if (exp instanceof ColumnUsage && (obj = this.resolveID(((ColumnUsage)exp).getObjectID())) instanceof Column && (olddtu = ((Column)obj).getDataTypeUsage()) != null) {
            DataTypeUsage newdtu = (DataTypeUsage)olddtu.copyTo(null);
            newdtu.setID(null);
            col.setDataTypeUsage(newdtu);
        }
    }

    public void setSingleRelation(Relation singleRelation) {
        this.m_extraObjects = null;
        TemporaryObjectID.setID(singleRelation, true);
        this.addExtraObject(singleRelation);
    }

    public void setExtraObjects(Collection<? extends SystemObject> objs) {
        this.m_extraObjects = objs;
    }

    protected void addExtraObject(SystemObject obj) {
        if (obj != null) {
            ArrayList<SystemObject> objs = this.m_extraObjects == null ? new ArrayList<SystemObject>() : new ArrayList<SystemObject>(this.m_extraObjects);
            objs.add(obj);
            this.setExtraObjects(objs);
        }
    }

    private Relation findExtraRelation(DBObjectID id) {
        if (this.m_extraObjects != null && id != null) {
            for (SystemObject systemObject : this.m_extraObjects) {
                if (!(systemObject instanceof Relation) || !id.equals(systemObject.getID())) continue;
                return (Relation)systemObject;
            }
        }
        return null;
    }

    protected SchemaObject getObjectForFrom(String schema, String name, String databaseName) throws DBException {
        Collection<String> syntypes;
        String publicSchemaName;
        AbstractDBObjectProvider pro = this.getProvider();
        Collection<String> types = DBUtil.listSupportedTypes(pro, Relation.class, Synonym.class);
        DBObjectCriteria<SystemObject> crit = DBObjectCriteria.createTypeCriteria(types);
        crit.setName(name);
        crit.setDatabaseName(databaseName);
        if (schema == null && databaseName == null) {
            crit.setSchema(this.getDefaultSchema());
        } else {
            crit.setSchemaName(schema);
        }
        SchemaObject so = this.getObject(crit);
        if (so == null && (publicSchemaName = pro.getDescriptor().getPublicSchemaName()) != null && !(syntypes = DBUtil.listSupportedTypes(pro, Synonym.class)).isEmpty()) {
            DBObjectCriteria<SystemObject> pcrit = DBObjectCriteria.createTypeCriteria(syntypes);
            pcrit.setName(name);
            pcrit.setDatabaseName(databaseName);
            pcrit.setSchemaName(publicSchemaName);
            so = this.getObject(pcrit);
        }
        return so;
    }

    protected DBObject resolveID(DBObjectID id) {
        DBObject retval = null;
        if (id != null) {
            try {
                DBObjectID par = id.getParent();
                if (par == null) {
                    if (this.m_extraObjects != null) {
                        for (DBObject dBObject : this.m_extraObjects) {
                            if (!id.equals(dBObject.getID())) continue;
                            retval = dBObject;
                            break;
                        }
                    }
                    if (retval == null) {
                        retval = id.resolveID();
                    }
                } else if (id instanceof AbstractDBObjectID) {
                    DBObject parObj = this.resolveID(par);
                    if (parObj != null) {
                        retval = ((AbstractDBObjectID)id).resolveInParentObject(parObj);
                    }
                } else {
                    retval = id.resolveID();
                }
            }
            catch (DBException dbe) {
                this.logResolveIDException(dbe);
            }
        }
        return retval;
    }

    protected SchemaObject getObject(String type, Schema sch, String name) throws DBException {
        return this.getObject(DBObjectCriteria.createSingleObjectCriteria(type, sch, name));
    }

    protected SchemaObject getObject(DBObjectCriteria crit) throws DBException {
        this.checkCancelled();
        SchemaObject retval = null;
        AbstractDBObjectProvider pro = this.getProvider();
        if (pro != null) {
            crit.setDatabaseDescriptor(pro.getDescriptor());
        }
        if (this.m_extraObjects != null && crit.getDatabaseName() == null) {
            String type = crit.getTypeArray()[0];
            Schema sch = new Schema(crit.getSchemaName());
            for (SystemObject systemObject : this.m_extraObjects) {
                if (!crit.accept(systemObject)) continue;
                retval = (SchemaObject)systemObject;
                break;
            }
        }
        if (retval == null && pro != null) {
            retval = (SchemaObject)pro.getObject(crit);
        }
        return retval;
    }

    @Override
    public void registerSQLFragmentFactory(SQLFragmentFactory fac) {
        this.m_sqlFragFactories.add(0, fac);
    }

    protected void registerAllSQLFragmentFactories(AbstractSQLQueryBuilder builder) {
        this.m_sqlFragFactories.clear();
        this.m_sqlFragFactories.addAll(builder.m_sqlFragFactories);
    }

    public final SQLFragment createFromFactory(SQLFragment parent, String clause, Integer offset) {
        SQLFragment ret = null;
        for (SQLFragmentFactory fac : this.m_sqlFragFactories) {
            ret = fac.createFragment(this, parent, clause);
            if (ret == null) continue;
            if (!(ret instanceof AbstractSQLFragment) || offset == null || offset == -1) break;
            ((AbstractSQLFragment)ret).setStartOffset(offset);
            break;
        }
        return ret;
    }

    private void setAliasFromColumn(SelectObject selObj) {
        Relation originalRel;
        if (selObj.getAlias() == null && this.getProvider() instanceof Database && this.getQuery().getParent() instanceof Relation && this.getQuery().getParent().getID() instanceof TemporaryObjectID && (originalRel = (Relation)TemporaryObjectID.findOriginalObject(this.getQuery().getParent())) != null) {
            String selObjSQL = selObj.getSQLText();
            try {
                SQLQuery originalQuery = ((SQLQueryOwner)((Object)originalRel)).getSQLQuery();
                DBUtil.ensureDerivedPropertiesBuilt(originalQuery, this.getProvider());
                SelectObject[] origSels = originalQuery.getSelectObjects();
                for (int i = 0; i < origSels.length; ++i) {
                    String origSelSQL = origSels[i].getSQLText();
                    if (!selObjSQL.equals(origSelSQL)) continue;
                    selObj.setAlias(originalRel.getColumns()[i].getName());
                    break;
                }
            }
            catch (Exception e) {
                DBLog.getLogger(this).warning("failed looking for usable alias for " + selObj.getSQLText() + ":" + e.getMessage());
            }
        }
    }

    @Override
    @Deprecated
    public FunctionDefinition[] getBuiltInFunctions() {
        throw new UnsupportedOperationException("Get BuiltInFunction definitions from the descriptor");
    }

    static boolean isBuilding(SQLQuery query) {
        return s_currentQueries.contains(query);
    }

    public static class QueryColumnInfo {
        private final String m_name;
        private final String m_expression;

        public QueryColumnInfo(String name, String expression) {
            this.m_name = name;
            this.m_expression = expression;
        }

        public String getName() {
            return this.m_name;
        }

        public String getExpression() {
            return this.m_expression;
        }
    }

    private class QueryCache {
        private final Map<FromObject, Collection<SQLFragment>> m_fromDeps = new IdentityHashMap<FromObject, Collection<SQLFragment>>();
        private final Map<SQLFragment, FromObject> m_rFromDeps = new IdentityHashMap<SQLFragment, FromObject>();
        private Collection<UsingJoinCondition> m_usings = new IdentitySet<UsingJoinCondition>();
        private Collection<JoinObject> m_naturalJoins = new IdentitySet<JoinObject>();

        private QueryCache() {
        }
    }

    private class SQLQueryObjectSetImpl
    implements SQLQueryBuilder.SQLQueryObjectSet {
        private AbstractSQLFragment m_object;
        private SelectObject[] m_selectObjs;
        private FromObject[] m_fromObjs;

        public SQLQueryObjectSetImpl(SelectObject[] selectObjs, FromObject[] fromObjs) {
            this.m_selectObjs = selectObjs == null ? new SelectObject[]{} : selectObjs;
            this.m_fromObjs = fromObjs == null ? new FromObject[]{} : fromObjs;
        }

        public SQLQueryObjectSetImpl(SelectObject[] selectObjs, FromObject[] fromObjs, SQLFragment object) {
            this(selectObjs, fromObjs);
            this.m_object = (AbstractSQLFragment)object;
        }

        @Override
        public SQLFragment getObject() {
            return this.m_object;
        }

        @Override
        public SelectObject[] getSelectObjects() {
            return this.m_selectObjs;
        }

        @Override
        public FromObject[] getFromObjects() {
            return this.m_fromObjs;
        }
    }
}

