/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractProviderUsageSQLFragment;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractFromObjectUsage
extends AbstractProviderUsageSQLFragment
implements FromObjectUsage {
    protected AbstractFromObjectUsage() {
        this.setQualified(true);
    }

    @Deprecated
    protected AbstractFromObjectUsage(FromObject from) {
        this(from != null ? from.getID() : null);
    }

    protected AbstractFromObjectUsage(DBObjectID fromId) {
        this();
        this.setFromObjectID(fromId);
    }

    @Override
    @Transient
    @Deprecated
    public void setFromObject(FromObject from) {
        this.setFromObjectID(from != null ? from.getID() : null);
    }

    @Override
    @Transient
    @Deprecated
    public FromObject getFromObject() {
        return this.resolveFromObject();
    }

    @Override
    public FromObject resolveFromObject() {
        return this.resolveFromObject(this.getFromObjectID());
    }

    protected FromObject resolveFromObject(DBObjectID fromId) {
        return (FromObject)this.findFragmentInQuery(fromId);
    }

    protected DBObject findFragmentInQuery(DBObjectID id) {
        DBObject retval = null;
        if (id instanceof TemporaryObjectID) {
            retval = ((TemporaryObjectID)id).getDBObject();
        } else if (id != null) {
            SQLQuery query = this.findParent(SQLQuery.class);
            while (query != null && retval == null) {
                retval = DBUtil.findOwnedObjectInHierarchy(query, id);
                if (retval != null) continue;
                query = query.findParent(SQLQuery.class);
            }
        }
        return retval;
    }

    @Override
    public void setFromObjectID(DBObjectID id) {
        this.setProperty("fromObjectID", id);
    }

    @Override
    public DBObjectID getFromObjectID() {
        return (DBObjectID)this.getProperty("fromObjectID");
    }

    @Override
    public void setQualified(boolean qualified) {
        this.setProperty("qualified", qualified);
    }

    @Override
    public boolean isQualified() {
        return (Boolean)this.getProperty("qualified", true);
    }

    protected StringBuilder getSQLTextImpl() {
        StringBuilder buff = new StringBuilder();
        if (this.isQualified()) {
            String rel = null;
            FromObject from = this.resolveFromObject();
            if (from == null) {
                DBObjectID fromID = this.getFromObjectID();
                if (fromID instanceof BaseObjectID) {
                    rel = ((BaseObjectID)fromID).getName();
                }
            } else {
                rel = from.getUsableAlias();
            }
            if (ModelUtil.hasLength((String)rel) && rel.indexOf(" ") < 0) {
                buff.append(rel);
                buff.append('.');
            }
        }
        buff.append(this.getColumnName());
        return buff;
    }
}

