/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.refactoring;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.refactoring.CascadeWorker;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.refactoring.RefactoringProcessor;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.db.validators.DBObjectValidator;

public class CascadeProcessor
extends RefactoringProcessor {
    private Set<String> m_cascadeProps;

    @Override
    protected void processObjectDelete(DBObjectTransaction txn, SystemObject obj) throws DBException {
        CascadeManager mgr = txn.getProvider().getCascadeManager();
        Collection<DBObjectID> sorefs = mgr.listTopLevelReferers(obj, false);
        HashSet<DBObjectID> dependents = new HashSet<DBObjectID>(sorefs);
        dependents.removeAll(txn.getDeleteIDs());
        Object cre = null;
        if (dependents.size() > 0) {
            for (DBObjectID dep : dependents) {
                CancelledException.checkInterrupt();
                SystemObject depObj = (SystemObject)dep.resolveID();
                if ((depObj = txn.getCopyForUpdate(depObj)) == null) continue;
                try {
                    this.cascadeDelete(txn, obj, depObj);
                }
                catch (CascadeRequiredException e) {
                    CascadeRequiredException newCre = new CascadeRequiredException((DBObject)obj, dependents);
                    txn.addException(newCre);
                }
            }
        }
    }

    protected final void cascadeDelete(DBObjectTransaction txn, DBObject obj, SystemObject depObj) throws DBException {
        CascadeAction result;
        DBObjectProvider pro = txn.getProvider();
        DBObjectValidator worker = ((AbstractDBObjectProvider)pro).getValidatorForType(depObj.getType());
        if (worker != null && (result = worker.cascadeDelete(obj, depObj)) != null) {
            if (result == CascadeAction.NONE) {
                this.getLogger().fine("dependent object " + depObj + "required no cascade.");
            } else if (txn.isCascade()) {
                if (result == CascadeAction.DELETE) {
                    txn.includeUpdate(depObj, null);
                } else if (result == CascadeAction.UPDATE) {
                    txn.includeUpdate(depObj);
                }
            } else {
                throw new CascadeRequiredException(obj);
            }
        }
    }

    @Override
    protected void processObjectUpdate(DBObjectTransaction txn, Difference objDiff) throws DBException {
        this.processObjectUpdateImpl(txn, objDiff);
    }

    private void processObjectUpdateImpl(DBObjectTransaction txn, Difference objDiff) throws DBException {
        if (!objDiff.isSame()) {
            this.processSingleObjectUpdate(txn, objDiff);
            for (Difference difference : objDiff.getChildren()) {
                CancelledException.checkInterrupt();
                if (!difference.isLoaded() && difference.isDerived() || difference.isSame()) continue;
                if ("properties".equals(difference.getPropertyName()) && difference.isMap()) {
                    for (Difference difference2 : difference.getChildren()) {
                        this.processPropertyDifference(txn, difference2);
                    }
                    continue;
                }
                this.processPropertyDifference(txn, difference);
            }
        }
    }

    private void processPropertyDifference(DBObjectTransaction txn, Difference propDiff) throws DBException {
        Object orig;
        Class<?> clz = DBUtil.decodeArrayClass(propDiff.getDifferenceClass());
        if (clz != null && DBObject.class.isAssignableFrom(clz) && !"schema".equals(propDiff.getPropertyName()) && (orig = propDiff.getOriginalObject()) != null) {
            if (propDiff.isList()) {
                for (Difference difference : propDiff.getChildren()) {
                    DBObject child = (DBObject)difference.getOriginalObject();
                    if (child == null) continue;
                    if (difference.getUpdatedObject() == null) {
                        this.processChildObjectDelete(txn, child);
                        continue;
                    }
                    this.processObjectUpdateImpl(txn, difference);
                }
            } else if (propDiff.getUpdatedObject() == null) {
                this.processChildObjectDelete(txn, (DBObject)orig);
            } else {
                this.processObjectUpdateImpl(txn, propDiff);
            }
        }
    }

    private void processChildObjectDelete(DBObjectTransaction txn, DBObject obj) throws DBException {
        CascadeManager mgr = txn.getProvider().getCascadeManager();
        Set<DBObjectID> objrefs = this.getSystemObjectIDs(mgr.listReferers(obj));
        for (DBObjectID dep : objrefs) {
            CancelledException.checkInterrupt();
            SystemObject depSysObj = (SystemObject)dep.resolveID();
            if ((depSysObj = txn.getCopyForUpdate(depSysObj)) == null) continue;
            try {
                this.cascadeDelete(txn, obj, depSysObj);
            }
            catch (CascadeRequiredException e) {
                CascadeRequiredException newCre = new CascadeRequiredException(obj, objrefs);
                txn.addException(newCre);
            }
        }
    }

    private Set<DBObjectID> getSystemObjectIDs(Collection<DBObjectID> objIDs) {
        DBObjectIDSet retval = new DBObjectIDSet(true);
        for (DBObjectID id : objIDs) {
            DBObjectID sysobjID = null;
            if (id instanceof TemporaryObjectID) {
                DBObjectID parid;
                DBObject obj = ((TemporaryObjectID)id).getDBObject();
                SystemObject par = DBUtil.getSystemObject(obj);
                if (par != null && (parid = par.getID()) instanceof BaseObjectID) {
                    sysobjID = parid;
                }
            } else {
                DBObjectID par = DBUtil.getUppermostParent(id);
                if (Metadata.getInstance().isTypeOf(SystemObject.class, par.getType())) {
                    sysobjID = par;
                }
            }
            if (sysobjID == null) {
                this.getLogger().warning("Found reference with no valid SystemObject : " + id);
                continue;
            }
            retval.add(sysobjID);
        }
        return retval;
    }

    protected void processSingleObjectUpdate(DBObjectTransaction txn, Difference objDiff) throws DBException {
        if (this.requiresCascadeUpdate(txn, objDiff)) {
            DBObject orig = (DBObject)objDiff.getOriginalObject();
            CascadeManager mgr = txn.getProvider().getCascadeManager();
            Set<DBObjectID> objrefs = this.getSystemObjectIDs(mgr.listReferers(orig));
            for (DBObjectID dep : objrefs) {
                CancelledException.checkInterrupt();
                SystemObject depSysObj = (SystemObject)dep.resolveID();
                if ((depSysObj = txn.getCopyForUpdate(depSysObj)) == null) continue;
                try {
                    this.cascadeUpdate(txn, objDiff, depSysObj);
                }
                catch (CascadeRequiredException e) {
                    CascadeRequiredException newCre = new CascadeRequiredException((DBObject)objDiff.getUpdatedObject(), objrefs);
                    txn.addException(newCre);
                }
            }
        }
    }

    protected final void cascadeUpdate(DBObjectTransaction txn, Difference objDiff, SystemObject depObj) throws DBException {
        CascadeAction result;
        DBObjectProvider pro = txn.getProvider();
        DBObjectValidator worker = ((AbstractDBObjectProvider)pro).getValidatorForType(depObj.getType());
        if (worker != null && (result = worker.cascadeUpdate(objDiff, depObj)) != null) {
            if (result == CascadeAction.NONE) {
                this.getLogger().fine("dependent object " + depObj + "required no cascade.");
            } else if (txn.isCascade()) {
                if (result == CascadeAction.DELETE) {
                    txn.includeUpdate(depObj, null);
                } else if (result == CascadeAction.UPDATE) {
                    txn.includeUpdate(depObj);
                }
            } else if (result == CascadeAction.DELETE) {
                throw new CascadeRequiredException((DBObject)objDiff.getUpdatedObject());
            }
        }
    }

    private boolean requiresCascadeUpdate(DBObjectTransaction txn, Difference objDiff) {
        boolean retval = false;
        if (!objDiff.isSame()) {
            Set<String> props = this.getCascadeProperties(txn.getProvider());
            for (Difference difference : objDiff.getChildren()) {
                if (difference.isSame() || !props.contains(difference.getPropertyName())) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    private Set<String> getCascadeProperties(DBObjectProvider pro) {
        if (this.m_cascadeProps == null) {
            this.m_cascadeProps = new HashSet<String>();
            Map<String, DBObjectValidator> validators = pro.getDescriptor().getValidators(pro);
            for (CascadeWorker cascadeWorker : validators.values()) {
                this.m_cascadeProps.addAll(cascadeWorker.getCascadeProperties());
            }
        }
        return this.m_cascadeProps;
    }
}

