/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.function.Predicate;
import oracle.javatools.db.property.PropertyDefinition;
import oracle.javatools.db.property.PropertyInfo;

public final class PropertyCriteria
implements Predicate<PropertyInfo> {
    private Boolean m_derived;
    private Boolean m_deprecated = Boolean.FALSE;
    private Boolean m_internal = Boolean.FALSE;
    private boolean m_includeBean = true;
    private boolean m_includeExtra = true;
    private Predicate<PropertyInfo> m_predicate;

    public void setDerived(Boolean derived) {
        this.m_derived = derived;
    }

    public void setDeprecated(Boolean deprecated) {
        this.m_deprecated = deprecated;
    }

    public void setInternal(Boolean internal) {
        this.m_internal = internal;
    }

    public void setIncludeBean(boolean includeBean) {
        this.m_includeBean = includeBean;
    }

    boolean isIncludeBean() {
        return this.m_includeBean;
    }

    public void setIncludeExtra(boolean includeExtra) {
        this.m_includeExtra = includeExtra;
    }

    boolean isIncludeExtra() {
        return this.m_includeExtra;
    }

    public void addPredicate(Predicate<PropertyInfo> predicate) {
        this.m_predicate = this.m_predicate == null ? predicate : this.m_predicate.and(predicate);
    }

    @Override
    public boolean test(PropertyInfo info) {
        boolean extra = info instanceof PropertyDefinition;
        return (extra ? this.m_includeExtra : this.m_includeBean) && this.testImpl(info);
    }

    boolean testImpl(PropertyInfo info) {
        boolean retval = true;
        if (retval && this.m_derived != null) {
            boolean bl = retval = this.m_derived.booleanValue() == info.isDerived();
        }
        if (retval && this.m_deprecated != null) {
            boolean bl = retval = this.m_deprecated.booleanValue() == info.isDeprecated();
        }
        if (retval && this.m_internal != null) {
            boolean bl = retval = this.m_internal.booleanValue() == info.isInternal();
        }
        if (retval && this.m_predicate != null) {
            retval = this.m_predicate.test(info);
        }
        return retval;
    }

    public static PropertyCriteria createEmptyCriteria() {
        PropertyCriteria retval = new PropertyCriteria();
        retval.setDeprecated(null);
        retval.setInternal(null);
        return retval;
    }
}

