/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.logging.Level;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.property.MetadataImpl;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyDefinition;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Maps;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.deferred.Thunk;

public final class Metadata {
    private MetadataImpl m_impl;
    private final MultiMap<Class<? extends DBObject>, Class<? extends DBObject>> m_ownerMap = new MultiMap();
    private Map<String, Thunk<Class<? extends DBObject>>> m_extendedTypes;
    private final Map<Class<?>, Map<String, PropertyInfo>> m_descriptorInfos = new Maps.SoftHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Metadata getInstance() {
        DBCore core = DBCore.getInstance();
        Class<Metadata> clazz = Metadata.class;
        synchronized (Metadata.class) {
            Metadata m = core.get(Metadata.class);
            if (m == null) {
                m = new Metadata();
                core.put(m);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return m;
        }
    }

    private Metadata() {
    }

    private synchronized MetadataImpl getMetadata() {
        if (this.m_impl == null) {
            this.m_impl = new MetadataImpl();
        }
        return this.m_impl;
    }

    public Collection<Class<? extends DBObject>> getAllDBObjectClasses() {
        return Collections.unmodifiableCollection(this.getMetadata().getImplementations(DBObject.class));
    }

    public Map<String, Class<? extends DBObject>> getDBObjectClasses() {
        return Collections.unmodifiableMap(this.getMetadata().getTypeMap());
    }

    public boolean isSchemaObject(String type) {
        return this.isTypeOf(SchemaObject.class, type);
    }

    public boolean isTypeOf(Class<? extends DBObject> clz, String type) {
        Class<? extends DBObject> typeClz;
        this.checkLoaded(type);
        boolean retval = false;
        if (type != null && (typeClz = this.getMetadata().getTypeMap().get(type)) != null) {
            retval = clz.isAssignableFrom(typeClz);
        }
        return retval;
    }

    public DBObject newDBObject(String type, String name) {
        Class<? extends DBObject> clz = this.getObjectClass(type);
        if (clz != null) {
            try {
                DBObject obj = clz.newInstance();
                obj.setName(name);
                return obj;
            }
            catch (Exception e) {
                DBLog.getLogger(this).log(Level.FINE, "Couldn't create new " + type, e);
            }
        }
        return null;
    }

    public Class<? extends DBObject> getObjectClass(String type) {
        Class<? extends DBObject> retval = null;
        if (type != null) {
            this.checkLoaded(type);
            retval = this.getMetadata().getTypeMap().get(type);
        }
        return retval;
    }

    private synchronized void checkLoaded(String type) {
        Class clz;
        Thunk<Class<? extends DBObject>> thunk;
        if (this.m_extendedTypes != null && type != null && (thunk = this.m_extendedTypes.remove(type)) != null && (clz = (Class)thunk.get()) != null) {
            this.registerObjectClass(type, clz);
        }
    }

    private void checkLoaded(Class<?> clz) {
        if (DBObject.class.isAssignableFrom(clz)) {
            String type = Metadata.getType(clz);
            this.checkLoaded(type);
        }
    }

    public synchronized void registerObjectClass(String type, Thunk<Class<? extends DBObject>> clzThunk) {
        if (this.m_extendedTypes == null) {
            this.m_extendedTypes = new HashMap<String, Thunk<Class<? extends DBObject>>>();
        }
        this.m_extendedTypes.put(type, clzThunk);
    }

    public synchronized void registerObjectClass(String type, Class<? extends DBObject> clz) {
        Class<? extends DBObject> exists = this.getObjectClass(type);
        if (exists == null) {
            this.getMetadata().registerClass(clz);
        } else if (exists != clz) {
            throw new IllegalArgumentException(MessageFormat.format("Cannot register class {0}: type {1} is registered as class {2}", clz.getName(), type, exists.getName()));
        }
    }

    public Collection<String> getAllTypes(Class<? extends DBObject> clz) {
        Collection<Class<? extends DBObject>> impls;
        HashSet<String> types = new HashSet<String>();
        String clzType = Metadata.getType(clz);
        if (clzType != null) {
            types.add(clzType);
            this.checkLoaded(clzType);
        }
        if ((impls = this.getMetadata().getImplementations(clz)) != null) {
            for (Class<? extends DBObject> implclz : impls) {
                String type = Metadata.getType(implclz);
                if (type == null) continue;
                types.add(type);
            }
        }
        return types;
    }

    public DBObject newInstance(String type) {
        Class<? extends DBObject> clz = this.getObjectClass(type);
        if (clz != null) {
            if (Constraint.class.equals(clz)) {
                clz = UniqueConstraint.class;
            }
            try {
                return clz.newInstance();
            }
            catch (Exception e) {
                DBLog.logStackTrace("Error instantiating new DBObject", e);
            }
        }
        return null;
    }

    @Deprecated
    public Collection<String> getSupportedProperties(Class<?> objClz, Class<? extends DBObjectProvider> proClz) {
        return this.getSupportedProperties(objClz, proClz, true, true);
    }

    @Deprecated
    public Collection<String> getSupportedProperties(Class<?> objClz, Class<? extends DBObjectProvider> proClz, boolean incBean, boolean incExtra) {
        PropertyCriteria criteria = new PropertyCriteria();
        criteria.setIncludeBean(incBean);
        criteria.setIncludeExtra(incExtra);
        return this.getSupportedPropertiesMap(objClz, proClz, criteria).keySet();
    }

    Map<String, PropertyInfo> getSupportedPropertiesMap(Class<?> objClz, Class<? extends DBObjectProvider> proClz, PropertyCriteria criteria) {
        HashMap<String, PropertyInfo> retval = new HashMap<String, PropertyInfo>();
        this.populateSupportedPropertiesMap(objClz, proClz, criteria, retval, false);
        return retval;
    }

    public boolean hasSupportedProperty(Class<?> objClz, Class<? extends DBObjectProvider> proClz, Predicate<PropertyInfo> predicate) {
        boolean retval;
        if (predicate == null) {
            DBLog.logIllegalState("Must provide a predicate");
            retval = false;
        } else {
            HashMap<String, PropertyInfo> map = new HashMap<String, PropertyInfo>();
            this.populateSupportedPropertiesMap(objClz, proClz, predicate, map, true);
            retval = !map.isEmpty();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSupportedPropertiesMap(Class<?> objClz, Class<? extends DBObjectProvider> proClz, Predicate<PropertyInfo> predicate, Map<String, PropertyInfo> map, boolean justTheOne) {
        if (objClz == null) {
            DBLog.logIllegalState("Must provide an object class");
        } else {
            if (!(predicate instanceof PropertyCriteria) || ((PropertyCriteria)predicate).isIncludeBean()) {
                this.populateBeanProperties(objClz, proClz, predicate, map, justTheOne);
                if (justTheOne && !map.isEmpty()) {
                    return;
                }
                for (Class<? extends DBObject> implClz : this.getDefaultImplClasses(objClz)) {
                    this.populateBeanProperties(implClz, proClz, predicate, map, justTheOne);
                    if (!justTheOne || map.isEmpty()) continue;
                    return;
                }
            }
            if ((!(predicate instanceof PropertyCriteria) || ((PropertyCriteria)predicate).isIncludeExtra()) && DBObject.class.isAssignableFrom(objClz)) {
                Map<String, Collection<PropertyInfo>> allExtraProps;
                Map<String, Collection<PropertyInfo>> map2 = allExtraProps = this.getMetadata().getExtraProps();
                synchronized (map2) {
                    for (Map.Entry<String, Collection<PropertyInfo>> entry : allExtraProps.entrySet()) {
                        for (PropertyInfo propDef : entry.getValue()) {
                            if (!propDef.isSupported(proClz, objClz) || !this.testPredicateImpl(predicate, propDef)) continue;
                            map.put(entry.getKey(), propDef);
                            if (!justTheOne) continue;
                            return;
                        }
                    }
                }
            }
        }
    }

    private void populateBeanProperties(Class<?> objClz, Class<? extends DBObjectProvider> proClz, Predicate<PropertyInfo> predicate, Map<String, PropertyInfo> map, boolean justTheOne) {
        this.checkLoaded(objClz);
        BeanInfo bi = MetadataImpl.getBeanInfo(objClz);
        if (bi != null) {
            for (PropertyDescriptor desc : bi.getPropertyDescriptors()) {
                String propName;
                PropertyInfo info;
                if (this.weDoNotLike(desc, objClz) || !this.testPredicateImpl(predicate, info = this.findOrCreatePropertyInfo(objClz, propName = desc.getName(), desc))) continue;
                map.put(propName, info);
                if (!justTheOne) continue;
                return;
            }
        }
    }

    private boolean testPredicateImpl(Predicate<PropertyInfo> predicate, PropertyInfo info) {
        boolean retval = predicate instanceof PropertyCriteria ? ((PropertyCriteria)predicate).testImpl(info) : (predicate == null ? true : predicate.test(info));
        return retval;
    }

    private boolean weDoNotLike(PropertyDescriptor desc, Class objClz) {
        boolean retval = false;
        if ("parent".equals(desc.getName()) && DBObject.class.isAssignableFrom(objClz)) {
            retval = true;
        } else if (!MetadataImpl.isValidForPropertyInfo(desc)) {
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertyInfo getSupportedProperty(Class<?> objClz, String propName, Class<? extends DBObjectProvider> proClz) {
        PropertyInfo retval = this.findOrCreatePropertyInfo(objClz, propName, null);
        if (retval == null) {
            Class<? extends DBObject> implClz;
            Iterator<Class<? extends DBObject>> iterator = this.getDefaultImplClasses(objClz).iterator();
            while (iterator.hasNext() && (retval = this.findOrCreatePropertyInfo(implClz = iterator.next(), propName, null)) == null) {
            }
        }
        if (retval == null && DBObject.class.isAssignableFrom(objClz)) {
            Map<String, Collection<PropertyInfo>> allExtraProps;
            Map<String, Collection<PropertyInfo>> map = allExtraProps = this.getMetadata().getExtraProps();
            synchronized (map) {
                Collection<PropertyInfo> extraProps = allExtraProps.get(propName);
                if (extraProps != null) {
                    for (PropertyInfo extraProp : extraProps) {
                        if (extraProp == null || !extraProp.isSupported(proClz, objClz)) continue;
                        retval = extraProp;
                        break;
                    }
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyInfo findOrCreatePropertyInfo(Class<?> objClz, String propName, PropertyDescriptor desc) {
        PropertyInfo retval = null;
        Map<Class<?>, Map<String, PropertyInfo>> map = this.m_descriptorInfos;
        synchronized (map) {
            Map<String, PropertyInfo> infoMap = this.m_descriptorInfos.get(objClz);
            if (infoMap == null) {
                infoMap = new HashMap<String, PropertyInfo>();
                this.m_descriptorInfos.put(objClz, infoMap);
            } else {
                retval = infoMap.get(propName);
            }
            if (retval == null) {
                BeanInfo info;
                if (desc == null && (info = MetadataImpl.getBeanInfo(objClz)) != null) {
                    for (PropertyDescriptor testDesc : info.getPropertyDescriptors()) {
                        if (!testDesc.getName().equals(propName)) continue;
                        if (this.weDoNotLike(testDesc, objClz)) break;
                        desc = testDesc;
                        break;
                    }
                }
                if (desc != null) {
                    retval = PropertyInfo.createPropertyInfo(desc);
                    infoMap.put(propName, retval);
                }
            }
        }
        return retval;
    }

    Iterable<Class<? extends DBObject>> getDefaultImplClasses(Class<?> objClz) {
        List<Class<? extends DBObject>> retval;
        if (DBObject.class.isAssignableFrom(objClz)) {
            Collection<Class<? extends DBObject>> impls;
            retval = new ArrayList();
            String type = Metadata.getType(objClz);
            if (Modifier.isAbstract(objClz.getModifiers()) && (impls = this.getMetadata().getImplementations(objClz)) != null) {
                for (Class<? extends DBObject> implClz : impls) {
                    String implType = Metadata.getType(implClz);
                    if (implClz == objClz || implType == null || type != null && !ModelUtil.areEqual((Object)implType, (Object)type)) continue;
                    retval.add(implClz);
                }
            }
        } else {
            retval = Collections.emptyList();
        }
        return retval;
    }

    public void registerProperty(String name, Class returnType, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objectTypes) {
        PropertyDefinition prop = new PropertyDefinition(name, returnType, providerType, objectTypes);
        this.registerProperty(prop);
    }

    public void registerBooleanProperty(String name, Nullable.NullBehaviour nullBehaviour, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objectTypes) {
        PropertyDefinition prop = new PropertyDefinition(name, Boolean.class, providerType, objectTypes);
        prop.setNullBehaviour(nullBehaviour);
        this.registerProperty(prop);
    }

    public void registerStringProperty(String name, boolean isMultiLine, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objectTypes) {
        PropertyDefinition prop = new PropertyDefinition(name, String.class, providerType, objectTypes);
        prop.setTextPropertyInfo(isMultiLine, false, false);
        this.registerProperty(prop);
    }

    public void registerIDProperty(String name, boolean staticReference, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objectTypes) {
        this.registerIDProperty(name, staticReference, (Class<? extends DBObject>)null, (String[])null, providerType, objectTypes);
    }

    public void registerIDProperty(String name, boolean staticReference, Class<? extends DBObject> referencedClass, String[] referencedTypes, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objectTypes) {
        if (referencedClass == null) {
            referencedClass = DBObject.class;
        }
        PropertyDefinition prop = new PropertyDefinition(name, DBObjectID.class, providerType, objectTypes);
        prop.setReferencesInfo(staticReference, referencedClass, referencedTypes);
        this.registerProperty(prop);
    }

    public void registerProperty(PropertyInfo info) {
        if (info != null) {
            String name = info.getPropertyName();
            if (!ModelUtil.hasLength((String)name)) {
                throw new IllegalArgumentException("Property must have a valid name");
            }
            this.getMetadata().registerExtraProperty(info);
        }
    }

    public void registerProperties(Iterable<? extends PropertyInfo> infos) {
        if (infos != null) {
            this.getMetadata().registerExtraProperties(infos);
        }
    }

    public boolean isStaticReferenceProperty(String propName) {
        boolean retval = false;
        Map<String, Collection<PropertyInfo>> allExtraProps = this.getMetadata().getExtraProps();
        Collection<PropertyInfo> infos = allExtraProps.get(propName);
        if (infos != null) {
            for (PropertyInfo info : infos) {
                if (!info.isStaticReference()) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    public boolean isBeanProperty(Class<? extends DBObject> clz, String propName) {
        return this.findOrCreatePropertyInfo(clz, propName, null) != null;
    }

    public Collection<String> getOwnerTypes(String childType) {
        this.checkLoaded(childType);
        Class<? extends DBObject> childClz = this.getObjectClass(childType);
        Collection<Class<? extends DBObject>> clzs = this.getOwnerClasses(childClz);
        TreeSet<String> retval = new TreeSet<String>();
        for (Class<? extends DBObject> ownerClz : clzs) {
            retval.add(Metadata.getType(ownerClz));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Class<? extends DBObject>> getOwnerClasses(Class<? extends DBObject> childClz) {
        MultiMap<Class<? extends DBObject>, Class<? extends DBObject>> multiMap = this.m_ownerMap;
        synchronized (multiMap) {
            ArrayList<Class<? extends DBObject>> retval = new ArrayList<Class<? extends DBObject>>();
            Collection cached = this.m_ownerMap.get(childClz);
            if (cached == null) {
                if (childClz != null) {
                    for (Class<? extends Copyable> beanClz : this.getMetadata().getBeans()) {
                        if (!DBObject.class.isAssignableFrom(beanClz) || !Metadata.isRealBean(beanClz)) continue;
                        PropertyCriteria crit = new PropertyCriteria();
                        crit.addPredicate(info -> childClz.isAssignableFrom(DBUtil.decodeArrayClass(info.getPropertyClass())));
                        if (!this.hasSupportedProperty(beanClz, null, crit)) continue;
                        retval.add(beanClz);
                        this.m_ownerMap.add(childClz, beanClz);
                    }
                }
            } else {
                retval.addAll(cached);
            }
            return retval;
        }
    }

    public static boolean isRealBean(Class<?> clz) {
        int m;
        return clz != null && Modifier.isPublic(m = clz.getModifiers()) && !Modifier.isAbstract(m) && !clz.isInterface();
    }

    public static String getType(Class<? extends DBObject> objClass) {
        String retval = null;
        if (objClass != null) {
            try {
                Field f = objClass.getField("TYPE");
                if (f != null) {
                    retval = (String)f.get(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }
}

