/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.plsql.PlSqlComment;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtilCore;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class DBObjectPlSqlFragment
extends AbstractChildBuildableObject {
    private transient String m_sourceID;

    public DBObjectPlSqlFragment() {
        this((String)null, (DBObject)null);
    }

    public DBObjectPlSqlFragment(String name, DBObject parent) {
        this.setName(name);
        this.setParent(parent);
    }

    public Integer getStartOffset() {
        return (Integer)this.getProperty("startOffset");
    }

    public void setStartOffset(Integer start) {
        this.setProperty("startOffset", start);
    }

    public Integer getEndOffset() {
        return (Integer)this.getProperty("endOffset");
    }

    public void setEndOffset(Integer end) {
        this.setProperty("endOffset", end);
    }

    public DBObjectPlSqlFragment getChildAtOffset(int offset) throws CancelledException {
        return this.getChildAtOffsetUnderLock(offset, false, false);
    }

    public DBObjectPlSqlFragment getDeclarationAtOffset(int offset) throws CancelledException {
        return this.getChildAtOffsetUnderLock(offset, true, false);
    }

    public DBObjectPlSqlFragment getReferenceAtOffset(int offset) throws CancelledException {
        return this.getChildAtOffsetUnderLock(offset, false, true);
    }

    private DBObjectPlSqlFragment getChildAtOffsetUnderLock(final int offset, final boolean excludeRefs, final boolean excludeDecls) throws CancelledException {
        final Holder hFrag = new Holder();
        final Holder hEx = new Holder();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    hFrag.set((Object)DBObjectPlSqlFragment.this.getChildAtOffsetImpl(offset, excludeRefs, excludeDecls));
                }
                catch (CancelledException ce) {
                    hEx.set((Object)ce);
                }
            }
        };
        DBUtil.invokeCompoundChange(this, run, false);
        CancelledException ce = (CancelledException)hEx.get();
        if (ce != null) {
            throw ce;
        }
        return (DBObjectPlSqlFragment)hFrag.get();
    }

    private DBObjectPlSqlFragment getChildAtOffsetImpl(int offset, boolean excludeRefs, boolean excludeDecls) throws CancelledException {
        ArrayList<DBObjectPlSqlFragment> list = new ArrayList<DBObjectPlSqlFragment>();
        this.findChildrenAtOffset(offset, list);
        DBObjectPlSqlFragment retval = null;
        for (DBObjectPlSqlFragment frag : list) {
            if (frag instanceof PlSqlComment || excludeDecls && !(frag instanceof PlSqlReference) || excludeRefs && frag instanceof PlSqlReference) continue;
            if (retval == null) {
                retval = frag;
                continue;
            }
            if (frag.getEndOffset() - frag.getStartOffset() < retval.getEndOffset() - retval.getStartOffset()) {
                retval = frag;
                continue;
            }
            if (frag.getEndOffset() - frag.getStartOffset() != retval.getEndOffset() - retval.getStartOffset() || !(frag instanceof PlSqlReference)) continue;
            if (!(retval instanceof PlSqlReference)) {
                retval = frag;
                continue;
            }
            String retProp = DBUtil.getParentProperty(retval);
            String fragProp = DBUtil.getParentProperty(frag);
            if (!"propertyReferences".equals(retProp) || "propertyReferences".equals(fragProp) || fragProp == null) continue;
            retval = frag;
        }
        return retval;
    }

    private void findChildrenAtOffset(int offset, List<DBObjectPlSqlFragment> list) throws CancelledException {
        CancelledException.checkInterrupt();
        if (this.getStartOffset() != null && this.getStartOffset() <= offset && this.getEndOffset() != null && this.getEndOffset() >= offset) {
            list.add(this);
            Collection<String> types = Metadata.getInstance().getAllTypes(DBObjectPlSqlFragment.class);
            for (DBObject kid : this.getOwnedObjects(types.toArray(new String[types.size()]))) {
                if (!(kid instanceof DBObjectPlSqlFragment)) continue;
                DBObjectPlSqlFragment child = (DBObjectPlSqlFragment)kid;
                Integer start = child.getStartOffset();
                Integer end = child.getEndOffset();
                if (!(start != null && start > offset || end != null && end < offset)) {
                    child.findChildrenAtOffset(offset, list);
                    continue;
                }
                if (!(child instanceof PlSqlDatum)) continue;
                child.findChildrenAtOffset(offset, list);
            }
        }
    }

    @Internal
    public String getSourceID() {
        if (this instanceof PlSqlSourceObject) {
            if (this.m_sourceID == null) {
                this.m_sourceID = DBUtil.createUUID();
            }
            return this.m_sourceID;
        }
        if (this.getParent() instanceof DBObjectPlSqlFragment) {
            return ((DBObjectPlSqlFragment)this.getParent()).getSourceID();
        }
        return null;
    }

    PlSqlSourceObject getSourceObject() {
        if (this instanceof PlSqlSourceObject) {
            return (PlSqlSourceObject)((Object)this);
        }
        if (this.getParent() instanceof DBObjectPlSqlFragment) {
            return ((DBObjectPlSqlFragment)this.getParent()).getSourceObject();
        }
        return null;
    }

    @Override
    protected void copyToImpl(AbstractDBObject copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        if (copy instanceof DBObjectPlSqlFragment) {
            DBObjectPlSqlFragment frag = (DBObjectPlSqlFragment)copy;
            frag.m_sourceID = this.m_sourceID;
        }
    }

    @Override
    public String getName() {
        String source;
        String name = super.getName();
        if (name == null && this instanceof PlSqlSourceObject && !TemplateExpander.isPendingObject(this) && ModelUtil.hasLength((String)(source = ((PlSqlSourceObject)((Object)this)).getSource()))) {
            name = PlSqlUtilCore.getNameFromSource(source);
        }
        return name;
    }

    protected void setSourceImpl(String source) {
        if (!(this instanceof PlSqlSourceObject)) {
            throw new UnsupportedOperationException("setSourceImpl only for PlSqlSourceObjects");
        }
        this.setProperty("source", source);
        this.m_sourceID = null;
    }

    @Internal
    public String getSource() {
        String source;
        PlSqlSourceObject so;
        String retval = null;
        Integer start = this.getStartOffset();
        Integer end = this.getEndOffset();
        if (start != null && end != null && (so = this.getSourceObject()) != null && (source = so.getSource()) != null) {
            int len = source.length();
            if (start >= 0 && start <= len && end >= start && end <= len) {
                retval = source.substring(start, end + 1);
            }
        }
        return retval;
    }

    public void setSource(String source) {
        throw new UnsupportedOperationException();
    }
}

