/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.refactoring.CascadeAction;

public class OracleTablePartitions
extends AbstractChildBuildableObject {
    @PropertyKey(value=OracleTablePartitions.class, childOf={Table.class}, provider=OracleDatabase.class)
    @Nullable(value=Nullable.NullBehaviour.NULLABLE)
    public static final String KEY = "OracleTablePartitions";
    public static final String TYPE = "PARTITION MODEL";

    public OracleTablePartitions() {
    }

    public OracleTablePartitions(PartitionType partitionType, ObjectType objectType) {
        this.setPartitionType(partitionType);
        this.setObjectType(objectType);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setPartitionType(PartitionType partitionType) {
        this.setProperty("partitionType", (Object)partitionType);
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public PartitionType getPartitionType() {
        return (PartitionType)((Object)this.getProperty("partitionType"));
    }

    public void setObjectType(ObjectType objectType) {
        this.setProperty("objectType", (Object)objectType);
    }

    public ObjectType getObjectType() {
        return (ObjectType)((Object)this.getProperty("objectType"));
    }

    public void setSubpartitionModel(OracleTablePartitions subpartitionModel) {
        this.setProperty("subpartitionModel", subpartitionModel);
    }

    public OracleTablePartitions getSubpartitionModel() {
        return (OracleTablePartitions)this.getProperty("subpartitionModel");
    }

    public void setPartitionColumns(DBObjectID[] partitionColumns) {
        this.getChildSupport("partitionColumns").setChildArray(partitionColumns);
    }

    @References(value=Column.class, internal=true)
    public DBObjectID[] getPartitionColumns() {
        return this.getChildSupport("partitionColumns").getChildArray(DBObjectID.class);
    }

    public void addPartitionColumn(DBObjectID partitionColumn) {
        if (partitionColumn != null) {
            this.getChildSupport("partitionColumns").addChild(partitionColumn);
        }
    }

    public void addPartitionColumn(DBObjectID partitionColumn, int atIndex) {
        if (partitionColumn != null) {
            this.getChildSupport("partitionColumns").addChild(atIndex, partitionColumn);
        }
    }

    public void removePartitionColumn(DBObjectID partitionColumn) {
        this.getChildSupport("partitionColumns").removeChild(partitionColumn);
    }

    public void setReferencePartitionModelID(DBObjectID otpId) {
        this.setProperty("referencePartitionModelID", otpId);
    }

    @Derived(value="referenceConstraintID")
    @References(value=OracleTablePartitions.class)
    @Internal
    public DBObjectID getReferencePartitionModelID() {
        return (DBObjectID)this.getProperty("referencePartitionModelID");
    }

    public void setReferenceConstraintID(DBObjectID refConstraintID) {
        this.setProperty("referenceConstraintID", refConstraintID);
    }

    @References(value=FKConstraint.class, internal=true, cascade=CascadeAction.DELETE)
    public DBObjectID getReferenceConstraintID() {
        return (DBObjectID)this.getProperty("referenceConstraintID");
    }

    public void setHashQuantity(Integer hashQuantity) {
        this.setProperty("hashQuantity", hashQuantity);
    }

    public Integer getHashQuantity() {
        return (Integer)this.getProperty("hashQuantity");
    }

    @Transient
    @Deprecated
    public void setHashQuantityTablespaces(String[] tablespaceNames) {
        this.setHashQuantityTablespaceIds(null);
        if (tablespaceNames != null) {
            for (int i = 0; i < tablespaceNames.length; ++i) {
                this.addHashQuantityTablespace(tablespaceNames[i]);
            }
        }
    }

    public void setHashQuantityTablespaceIds(DBObjectID[] tablespaceIDs) {
        this.getChildSupport("hashQuantityTablespaceIds").setChildArray(tablespaceIDs);
    }

    @Deprecated
    public void addHashQuantityTablespace(String tablespaceName) {
        if (tablespaceName != null) {
            ReferenceID id = new ReferenceID("TABLESPACE", (Schema)null, tablespaceName);
            this.addHashQuantityTablespace(id);
        }
    }

    public void addHashQuantityTablespace(DBObjectID tablespaceID) {
        if (tablespaceID != null) {
            this.getChildSupport("hashQuantityTablespaceIds").addChild(tablespaceID);
        }
    }

    @Deprecated
    public void removeHashQuantityTablespace(String tablespaceName) {
        for (DBObjectID tbspId : this.getHashQuantityTablespaceIds()) {
            Tablespace tbsp = null;
            try {
                tbsp = (Tablespace)tbspId.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (!tbsp.getName().equals(tablespaceName)) continue;
            this.removeHashQuantityTablespace(tbspId);
        }
    }

    public void removeHashQuantityTablespace(DBObjectID tablespaceID) {
        this.getChildSupport("hashQuantityTablespaceIds").removeChild(tablespaceID);
    }

    @Deprecated
    public String[] getHashQuantityTablespaces() {
        ArrayList<String> tbspNames = new ArrayList<String>();
        for (DBObjectID tbspId : this.getHashQuantityTablespaceIds()) {
            Tablespace tbsp = null;
            try {
                tbsp = (Tablespace)tbspId.resolveID();
                if (tbsp == null) continue;
                tbspNames.add(tbsp.getName());
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return tbspNames.toArray(new String[tbspNames.size()]);
    }

    @References(value=Tablespace.class)
    public DBObjectID[] getHashQuantityTablespaceIds() {
        return this.getChildSupport("hashQuantityTablespaceIds").getChildArray(DBObjectID.class);
    }

    public void setPartitions(TablePartition[] partitions) {
        this.getChildSupport("partitions").setChildArray(partitions);
    }

    public TablePartition[] getPartitions() {
        return this.getChildSupport("partitions").getChildArray(TablePartition.class);
    }

    public void addPartition(TablePartition partition) {
        this.getChildSupport("partitions").addChild(partition);
    }

    public void removePartition(TablePartition partition) {
        this.getChildSupport("partitions").removeChild(partition);
    }

    public void addPartition(int index, TablePartition partition) {
        this.getChildSupport("partitions").addChild(index, partition);
    }

    public TablePartition createPartition(String name) {
        TablePartition partition = new TablePartition(name, this.getPartitionType(), this.getObjectType());
        this.addPartition(partition);
        return partition;
    }

    public static enum ObjectType {
        PARTITION,
        SUBPARTITION,
        SUBPARTITION_TEMPLATE,
        PARTITION_LEVEL_SUBPARTITION;

    }

    public static enum PartitionType {
        RANGE,
        HASH,
        LIST,
        REFERENCE;

    }
}

