/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.marshal.PartialParseUnsupportedException;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.util.ModelUtil;

public abstract class DBObjectHandler {
    protected String getEncoding() {
        return "UTF-8";
    }

    public final void write(DBObject obj, OutputStream out) throws IOException {
        this.write(Collections.singletonList(obj), out);
    }

    public final void write(DBObject obj, Writer out) throws IOException {
        this.write(Collections.singletonList(obj), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(List<? extends DBObject> objs, URL url) throws IOException {
        OutputStream out = URLFileSystem.openOutputStream((URL)url);
        try {
            this.write(objs, out);
        }
        finally {
            this.close(out);
        }
    }

    public final void write(List<? extends DBObject> objs, OutputStream out) throws IOException {
        this.write(objs, (Writer)new OutputStreamWriter(out, this.getEncoding()));
    }

    public abstract void write(List<? extends DBObject> var1, Writer var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean canRead(URL url, DBObjectProvider pro) throws IOException {
        boolean retval = false;
        InputStream in = URLFileSystem.openInputStream((URL)url);
        try {
            retval = this.canRead(in, pro);
        }
        finally {
            this.close(in);
        }
        return retval;
    }

    public final boolean canRead(InputStream in, DBObjectProvider pro) throws IOException {
        return this.canRead(new InputStreamReader(in, this.getEncoding()), pro);
    }

    public abstract boolean canRead(Reader var1, DBObjectProvider var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<DBObject> read(URL url, DBObjectProvider pro, Schema schema) throws IOException {
        List<DBObject> retval = null;
        schema = this.checkSchema(url, schema);
        InputStream in = URLFileSystem.openInputStream((URL)url);
        try {
            retval = this.read(in, pro, schema);
        }
        finally {
            this.close(in);
        }
        return retval;
    }

    private Schema checkSchema(URL url, Schema schema) {
        String schemaName;
        if (schema == null && ModelUtil.hasLength((String)(schemaName = this.getSchemaName(url)))) {
            schema = new Schema(schemaName);
        }
        return schema;
    }

    protected String getSchemaName(URL url) {
        return URLFileSystem.getName((URL)URLFileSystem.getParent((URL)url));
    }

    public final List<DBObject> read(InputStream in, DBObjectProvider pro, Schema schema) throws IOException {
        return this.read(new InputStreamReader(in, this.getEncoding()), pro, schema);
    }

    public final List<DBObject> read(Reader reader, DBObjectProvider pro, Schema schema) throws IOException {
        return this.read(reader, pro, schema, true);
    }

    public final List<DBObject> read(Reader reader, DBObjectProvider pro, Schema schema, boolean overrideSchema) throws IOException {
        List<DBObject> retval = this.readImpl(reader, pro, schema);
        if (retval != null) {
            for (DBObject obj : retval) {
                Schema objSchema;
                Schema schemaToUse = schema;
                if (!overrideSchema && obj instanceof SchemaObject && (objSchema = ((SchemaObject)obj).getSchema()) != null) {
                    schemaToUse = objSchema;
                }
                this.ensureDetails(obj, pro, schemaToUse, false);
            }
        }
        return retval;
    }

    protected void ensureDetails(DBObject obj, DBObjectProvider pro, Schema schema, boolean infoOnly) {
        if (obj instanceof SchemaObject) {
            ((SchemaObject)obj).setSchema(schema);
        }
        if (obj != null && pro != null) {
            pro.getObjectFactory().ensureID(obj, !infoOnly, infoOnly);
        }
    }

    protected abstract List<DBObject> readImpl(Reader var1, DBObjectProvider var2, Schema var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<DBObject> readInfo(URL url, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        List<DBObject> retval = null;
        schema = this.checkSchema(url, schema);
        InputStream in = URLFileSystem.openInputStream((URL)url);
        try {
            retval = this.readInfo(in, pro, schema);
        }
        finally {
            this.close(in);
        }
        return retval;
    }

    public final List<DBObject> readInfo(InputStream in, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        return this.readInfo(new InputStreamReader(in, this.getEncoding()), pro, schema);
    }

    public final List<DBObject> readInfo(Reader reader, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        List<DBObject> retval = this.readInfoImpl(reader, pro, schema);
        if (retval != null) {
            for (DBObject obj : retval) {
                this.ensureDetails(obj, pro, schema, true);
            }
        }
        return retval;
    }

    protected List<DBObject> readInfoImpl(Reader reader, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        throw new PartialParseUnsupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UnmarshalledIDs readIDs(URL url, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        UnmarshalledIDs retval = null;
        schema = this.checkSchema(url, schema);
        InputStream in = URLFileSystem.openInputStream((URL)url);
        try {
            retval = this.readIDs(in, pro, schema);
        }
        finally {
            this.close(in);
        }
        return retval;
    }

    public final UnmarshalledIDs readIDs(InputStream in, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        return this.readIDs(new InputStreamReader(in, this.getEncoding()), pro, schema);
    }

    public final UnmarshalledIDs readIDs(Reader reader, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        UnmarshalledIDs retval = new UnmarshalledIDs(pro);
        this.readIDsImpl(retval, reader, pro, schema);
        return retval;
    }

    protected void readIDsImpl(UnmarshalledIDs ids, Reader reader, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        HashSet<String> tokens = new HashSet<String>();
        List<DBObject> objs = this.readImpl(reader, pro, schema);
        if (objs != null) {
            DatabaseDescriptor desc = pro.getDescriptor();
            for (DBObject obj : objs) {
                this.getIDsAndTokens(obj, desc, ids, tokens);
            }
        }
        for (String token : tokens) {
            ids.addReferenceID(new ReferenceID("UNSPECIFIED_TYPE", (String)null, token));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void getIDsAndTokens(DBObject obj, DatabaseDescriptor desc, UnmarshalledIDs ids, Set<String> tokens) {
        ids.addObjectID(obj.getID());
        for (DBObjectID refID : obj.getReferenceIDs()) {
            ids.addReferenceID(refID);
        }
        PropertyCriteria crit = new PropertyCriteria();
        Map<String, PropertyInfo> infos = PropertyHelper.getPropertyInfos(obj.getClass(), null, crit);
        HashSet<String> sourceProps = new HashSet<String>();
        for (Map.Entry<String, PropertyInfo> info : infos.entrySet()) {
            PropertyInfo propertyInfo;
            String sourceProp = info.getValue().getDerivedSourceProperty();
            if (sourceProp == null || (propertyInfo = infos.get(sourceProp)) == null || propertyInfo.getPropertyClass() != String.class) continue;
            sourceProps.add(sourceProp);
        }
        for (String prop : sourceProps) {
            void var11_20;
            PlSqlSearch search;
            String val = (String)obj.getProperty(prop);
            if (!ModelUtil.hasLength((String)val)) continue;
            PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((String)val, (String[])new String[0]);
            Object lastTk = null;
            if ("source".equals(prop) && obj instanceof PlSqlSourceObject && !(obj instanceof PlSqlSchemaObjectBody) && (search = new PlSqlSearch("[create [or replace]] ? ?.")).matches(plSqlToken)) {
                PlSqlToken plSqlToken2 = search.getEndToken();
                String name = plSqlToken2.getSource();
                PlSqlToken plSqlToken3 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                lastTk = (PlSqlToken)plSqlToken3.getTokenAt(val.length() - 1);
                if (!lastTk.isCode()) {
                    lastTk = (PlSqlToken)lastTk.getPrevCodeToken();
                }
                if (lastTk.matches(";")) {
                    lastTk = (PlSqlToken)lastTk.getPrevCodeToken();
                }
                lastTk = lastTk.matches(name) ? (PlSqlToken)lastTk.getPrevCodeToken() : null;
            }
            while (var11_20 != lastTk && !var11_20.isEndMarker()) {
                if (var11_20.isCode(true)) {
                    tokens.add(desc.getInternalName(var11_20.getSource(), obj.getType()));
                }
                PlSqlToken plSqlToken4 = (PlSqlToken)var11_20.getNextCodeToken();
            }
        }
        for (Iterator<Map.Entry<String, PropertyInfo>> iterator : obj.getOwnedObjects()) {
            this.getIDsAndTokens((DBObject)((Object)iterator), desc, ids, tokens);
        }
    }

    private void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class UnmarshalledIDs {
        private final List<DBObjectID> m_ids = new ArrayList<DBObjectID>();
        private final Set<DBObjectID> m_refs = new DBObjectIDSet(true);
        private final DBObjectProvider m_pro;

        private UnmarshalledIDs(DBObjectProvider pro) {
            this.m_pro = pro;
        }

        private void ensureProvider(DBObjectID id) {
            if (this.m_pro != null) {
                this.m_pro.getObjectFactory().ensureProvider(id);
            }
        }

        public void addObjectID(DBObjectID id) {
            if (id != null) {
                this.ensureProvider(id);
                this.m_ids.add(id);
            }
        }

        public void addReferenceID(DBObjectID ref) {
            if (ref != null) {
                this.ensureProvider(ref);
                this.m_refs.add(ref);
            }
        }

        public Collection<DBObjectID> getReferences() {
            return this.m_refs;
        }

        public List<DBObjectID> getObjectIDs() {
            return this.m_ids;
        }
    }
}

