/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.hive.HiveDatabase;
import oracle.javatools.db.hive.HivePartition;
import oracle.javatools.db.hive.HivePropertyMetadata;
import oracle.javatools.db.hive.TblProperty;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.Transient;

public class HiveStorageProperties
extends AbstractChildDBObject {
    @PropertyKey(value=HiveStorageProperties.class, childOf={Table.class, HivePartition.class}, provider=HiveDatabase.class)
    public static final String TYPE = "HiveStorageProperties";

    @Override
    public String getType() {
        return TYPE;
    }

    public String getHdfsLocation() {
        return (String)this.getProperty("hdfsLocation");
    }

    public void setHdfsLocation(String location) {
        this.setProperty("hdfsLocation", location);
    }

    private void setPropertyValueImpl(String property, String name, String value) {
        AbstractDBObject.ChildSupport kids = this.getChildSupport(property);
        TblProperty tp = (TblProperty)kids.findChild(name);
        if (tp == null && value != null) {
            kids.addChild(new TblProperty(name, value));
        } else if (value == null) {
            kids.removeChild(tp);
        } else {
            tp.setTablePropertyValue(value);
        }
    }

    public TblProperty[] getSerDeProperties() {
        return this.getChildSupport("serDeProperties").getChildArray(TblProperty.class);
    }

    public void setSerDeProperties(TblProperty ... serDeProps) {
        this.getChildSupport("serDeProperties").setChildArray(serDeProps);
    }

    public String getSerDePropertyValue(String name) {
        TblProperty tp = (TblProperty)this.getChildSupport("serDeProperties").findChild(name);
        return tp == null ? null : tp.getTablePropertyValue();
    }

    public void setSerDeProperty(String name, String value) {
        this.setPropertyValueImpl("serDeProperties", name, value);
    }

    public String getSerDeClass() {
        return (String)this.getProperty("serDeClass");
    }

    public void setSerDeClass(String serDeClass) {
        this.setProperty("serDeClass", serDeClass);
    }

    @Transient
    public String getLineDelim() {
        return (String)this.getProperty("lineDelim");
    }

    @Transient
    public void setLineDelim(String delim) {
        this.setProperty("lineDelim", delim);
    }

    @Transient
    public String getMapKeyDelim() {
        return (String)this.getProperty("mapKeyDelim");
    }

    @Transient
    public void setMapKeyDelim(String delim) {
        this.setProperty("mapKeyDelim", delim);
    }

    @Transient
    public String getCollectionItemDelim() {
        return (String)this.getProperty("collectionItemDelim");
    }

    @Transient
    public void setCollectionItemDelim(String delim) {
        this.setProperty("collectionItemDelim", delim);
    }

    @Transient
    public String getFieldDelim() {
        return (String)this.getProperty("fieldDelim");
    }

    @Transient
    public void setFieldDelim(String delim) {
        this.setProperty("fieldDelim", delim);
    }

    @Transient
    public String getFieldEscape() {
        return (String)this.getProperty("fieldEscape");
    }

    @Transient
    public void setFieldEscape(String fieldEscape) {
        this.setProperty("fieldEscape", fieldEscape);
    }

    @Transient
    public String getNullFormat() {
        return (String)this.getProperty("nullFormat");
    }

    @Transient
    public void setNullFormat(String nullFormat) {
        this.setProperty("nullFormat", nullFormat);
    }

    public PredefinedFileFormat getPredefinedFileFormat() {
        return (PredefinedFileFormat)((Object)this.getProperty("predefinedFileFormat"));
    }

    public void setPredefinedFileFormat(PredefinedFileFormat fileFormat) {
        this.setProperty("predefinedFileFormat", (Object)fileFormat);
    }

    public String getInputFormatClass() {
        return (String)this.getProperty("inputFormatClass");
    }

    public void setInputFormatClass(String inputFormat) {
        this.setProperty("inputFormatClass", inputFormat);
    }

    public String getOutputFormatClass() {
        return (String)this.getProperty("outputFormatClass");
    }

    public void setOutputFormatClass(String outputFormat) {
        this.setProperty("outputFormatClass", outputFormat);
    }

    public String getStorageHandlerClass() {
        return (String)this.getProperty("storageHandlerClass");
    }

    public void setStorageHandlerClass(String storedBy) {
        this.setProperty("storageHandlerClass", storedBy);
    }

    @Override
    public void setProperty(String key, Object value) {
        String serDeProp = HivePropertyMetadata.getDelimitedSerDeProperty(key);
        if (serDeProp == null) {
            super.setProperty(key, value);
        } else {
            this.setSerDeProperty(serDeProp, (String)value);
        }
    }

    @Override
    public Object getProperty(String key) {
        String serDeProp = HivePropertyMetadata.getDelimitedSerDeProperty(key);
        Object retval = serDeProp == null ? super.getProperty(key) : this.getSerDePropertyValue(serDeProp);
        return retval;
    }

    public static enum PredefinedFileFormat {
        SEQUENCEFILE,
        TEXTFILE,
        RCFILE,
        ORC,
        AVRO;

    }
}

