/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Table;
import oracle.javatools.db.hive.HiveDatabase;
import oracle.javatools.db.hive.HivePartition;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.References;

public class HiveSkewProperties
extends AbstractChildDBObject {
    @PropertyKey(value=HiveSkewProperties.class, childOf={Table.class}, provider=HiveDatabase.class)
    public static final String TYPE = "HiveSkewProperties";

    @Override
    public String getType() {
        return TYPE;
    }

    @References(value=Column.class, internal=true)
    public DBObjectID[] getSkewedColumns() {
        return this.getChildSupport("skewedColumns").getChildArray(DBObjectID.class);
    }

    public void setSkewedColumns(DBObjectID ... skewCols) {
        this.getChildSupport("skewedColumns").setChildArray(skewCols);
    }

    public HivePartition[] getSkewedValues() {
        return this.getChildSupport("skewedValues").getChildArray(HivePartition.class);
    }

    public void setSkewedValues(HivePartition ... partitions) {
        this.getChildSupport("skewedValues").setChildArray(partitions);
    }

    public void addSkewedValue(HivePartition partition) {
        this.getChildSupport("skewedValues").addChild(partition);
    }

    public void removeSkewedValue(HivePartition partition) {
        this.getChildSupport("skewedValues").removeChild(partition);
    }

    @Nullable(value=Nullable.NullBehaviour.NULL_MEANS_FALSE)
    public Boolean getStoredAsDirectories() {
        return (Boolean)this.getProperty("storedAsDirectories");
    }

    public void setStoredAsDirectories(Boolean store) {
        this.setProperty("storedAsDirectories", store);
    }
}

