/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.hive.HivePartition;
import oracle.javatools.db.hive.HivePartitionProperties;
import oracle.javatools.db.hive.HiveSkewProperties;

public class HivePropertyMetadata {
    public static final String COLLECTION_DELIM = "colelction.delim";
    public static final String FIELD_DELIM = "field.delim";
    public static final String LINE_DELIM = "line.delim";
    public static final String MAPKEY_DELIM = "mapkey.delim";
    public static final String ESCAPE_CHAR = "escape.delim";
    public static final String NULL_FORMAT = "serialization.null.format";
    private static final List<String> s_delimProps;
    private static final List<String> s_delimSerDeProps;

    public static Collection<String> getDelimitedProperties() {
        return s_delimProps;
    }

    public static Collection<String> getDelimitedSerDeProperties() {
        return s_delimSerDeProps;
    }

    public static String getDelimitedProperty(String serDeProp) {
        int i = s_delimSerDeProps.indexOf(serDeProp);
        return i >= 0 ? s_delimProps.get(i) : null;
    }

    public static String getDelimitedSerDeProperty(String delimitedProp) {
        int i = s_delimProps.indexOf(delimitedProp);
        return i >= 0 ? s_delimSerDeProps.get(i) : null;
    }

    static String getSkewValue(HivePartition p, HiveSkewProperties props) {
        String[] vals = p.getValues();
        StringBuilder retval = new StringBuilder();
        if (vals != null) {
            boolean multi;
            DBObjectID[] cols = props.getSkewedColumns();
            int size = cols.length == 0 ? vals.length : cols.length;
            boolean bl = multi = size > 1;
            if (multi) {
                retval.append('(');
            }
            for (int i = 0; i < size; ++i) {
                if (retval.length() > 1) {
                    retval.append(", ");
                }
                retval.append('\'');
                if (i < vals.length && vals[i] != null) {
                    retval.append(vals[i]);
                }
                retval.append('\'');
            }
            if (multi) {
                retval.append(')');
            }
        }
        return retval.toString();
    }

    static String getPartitionSpec(HivePartition p, HivePartitionProperties props) {
        DBObjectID[] cols = props.getPartitionColumns();
        String[] vals = p.getValues();
        StringBuilder retval = new StringBuilder();
        int size = cols.length == 0 ? (vals == null ? 0 : vals.length) : cols.length;
        for (int i = 0; i < size; ++i) {
            if (retval.length() > 0) {
                retval.append(", ");
            }
            DBObjectID colID = i < cols.length ? cols[i] : null;
            retval.append(HivePropertyMetadata.getColumnName(colID, props)).append("='");
            if (vals != null && i < vals.length && vals[i] != null) {
                retval.append((Object)vals[i]);
            }
            retval.append('\'');
        }
        return retval.toString();
    }

    private static String getColumnName(DBObjectID colID, DBObject par) {
        String retval;
        if (colID == null) {
            retval = null;
        } else if (colID instanceof TemporaryObjectID) {
            retval = ((TemporaryObjectID)colID).getDBObject().getName();
        } else if (colID instanceof NameBasedID) {
            retval = ((NameBasedID)colID).getName();
        } else {
            Relation tab = DBUtil.findParentOfType(par, Relation.class);
            DBObject col = tab == null ? null : tab.findOwnedObject(colID);
            retval = col == null ? null : col.getName();
        }
        return retval;
    }

    public static void refactorValues(PropertyChangeEvent colsChange, HivePartition[] parts) {
        block9: {
            DBObjectID[] newCols;
            DBObjectID[] oldCols;
            if (parts.length <= 0 || (oldCols = (DBObjectID[])colsChange.getOldValue()) == (newCols = (DBObjectID[])colsChange.getNewValue())) break block9;
            if (oldCols == null) {
                for (HivePartition p : parts) {
                    p.setValues(new String[newCols.length]);
                }
            } else if (newCols == null) {
                for (HivePartition p : parts) {
                    p.setValues(new String[0]);
                }
            } else {
                TreeMap<Integer, Integer> indexMap = new TreeMap<Integer, Integer>();
                DiffEngine de = GenericDiffEngine.getDiffEngine(true);
                Difference diff = de.difference(oldCols, newCols);
                for (Difference difference : diff.getChildren()) {
                    int newI = difference.getIndexOfUpdatedObject();
                    if (newI < 0) continue;
                    indexMap.put(newI, difference.getIndexOfOriginalObject());
                }
                for (HivePartition p : parts) {
                    String[] oldVals = p.getValues();
                    String[] newVals = new String[newCols.length];
                    for (int i = 0; i < newCols.length; ++i) {
                        Integer oldI = (Integer)indexMap.get(i);
                        if (oldI == null || oldI < 0 || oldI >= oldVals.length) continue;
                        newVals[i] = oldVals[oldI];
                    }
                    p.setValues(newVals);
                }
            }
        }
    }

    static {
        ArrayList<String> d = new ArrayList<String>();
        ArrayList<String> s = new ArrayList<String>();
        d.add("collectionItemDelim");
        s.add(COLLECTION_DELIM);
        d.add("fieldEscape");
        s.add(ESCAPE_CHAR);
        d.add("fieldDelim");
        s.add(FIELD_DELIM);
        d.add("lineDelim");
        s.add(LINE_DELIM);
        d.add("mapKeyDelim");
        s.add(MAPKEY_DELIM);
        d.add("nullFormat");
        s.add(NULL_FORMAT);
        s_delimProps = Collections.unmodifiableList(d);
        s_delimSerDeProps = Collections.unmodifiableList(s);
    }
}

