/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.BuildableDBObjectDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.property.PropertyInfo;

class PlSqlFragmentSourceDiffer
extends BuildableDBObjectDiffer {
    PlSqlFragmentSourceDiffer() {
    }

    @Override
    protected boolean isSourcePropertySame(AbstractBuildableObject a, AbstractBuildableObject b, PropertyInfo derivedPropertyInfo, ResultSet objDiff) {
        if ("source".equals(derivedPropertyInfo.getDerivedSourceProperty()) && a != null && b != null && a.getClass() == b.getClass() && a instanceof DBObjectPlSqlFragment && !(a instanceof PlSqlSourceObject)) {
            DBObjectPlSqlFragment aFrag = (DBObjectPlSqlFragment)a;
            Integer aStart = aFrag.getStartOffset();
            Integer aEnd = aFrag.getEndOffset();
            DBObjectPlSqlFragment bFrag = (DBObjectPlSqlFragment)b;
            Integer bStart = bFrag.getStartOffset();
            Integer bEnd = bFrag.getEndOffset();
            if (aStart != null && aEnd != null && bStart != null && bEnd != null) {
                int bLen;
                int aLen = aEnd - aStart;
                if (aLen != (bLen = bEnd - bStart)) {
                    return false;
                }
                SchemaObject soA = DBUtil.getSchemaObject(aFrag);
                SchemaObject soB = DBUtil.getSchemaObject(bFrag);
                if (soA instanceof PlSqlSourceObject && soB instanceof PlSqlSourceObject) {
                    String srcA = ((PlSqlSourceObject)soA).getSource();
                    String srcB = ((PlSqlSourceObject)soB).getSource();
                    int aSrcLen = srcA.length();
                    int bSrcLen = srcB.length();
                    int fragLen = aEnd - aStart;
                    if (aStart >= 0 && aStart + fragLen <= aSrcLen && bStart >= 0 && bStart + fragLen <= bSrcLen) {
                        for (int i = 0; i < fragLen; ++i) {
                            if (srcA.charAt(aStart + i) == srcB.charAt(bStart + i)) continue;
                            return false;
                        }
                        return true;
                    }
                }
            }
        }
        return super.isSourcePropertySame(a, b, derivedPropertyInfo, objDiff);
    }
}

