/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public abstract class Difference
implements Copyable {
    private boolean m_same;
    private boolean m_filtered;
    private final Map<String, Object> m_props = new HashMap<String, Object>();
    private Difference m_parent;

    public boolean isLoaded() {
        return true;
    }

    public Difference getParent() {
        return this.m_parent;
    }

    protected void setParent(Difference parent) {
        this.m_parent = parent;
    }

    public abstract String getPropertyName();

    public boolean isDerived() {
        PropertyInfo info = this.getPropertyInfo();
        return info != null && info.isDerived();
    }

    protected Difference getSourceDifference() {
        String sourceProp;
        PropertyInfo info;
        Difference retval = null;
        Difference parent = this.getParent();
        if (parent != null && (info = this.getPropertyInfo()) != null && info.isDerived() && (sourceProp = info.getDerivedSourceProperty()) != null) {
            retval = parent.getChildDifference(sourceProp);
        }
        return retval;
    }

    protected PropertyInfo getPropertyInfo() {
        PropertyInfo retval = null;
        String propName = this.getPropertyName();
        if (propName != null) {
            Class<?> parClz;
            Difference par = this.getParent();
            if (par != null && "properties".equals(par.getPropertyName())) {
                par = par.getParent();
            }
            if (par != null && (parClz = par.getDifferenceClass()) != null && DBObject.class.isAssignableFrom(parClz)) {
                retval = PropertyHelper.findPropertyInfo(parClz, propName, (DBObjectProvider)null);
            }
        }
        return retval;
    }

    public String getPropertyPath() {
        String parentPath;
        String propName = this.getPropertyName();
        String string = parentPath = this.m_parent == null ? null : this.m_parent.getPropertyPath();
        String path = ModelUtil.hasLength((String)parentPath) ? (ModelUtil.hasLength((String)propName) ? parentPath + "/" + propName : parentPath) : propName;
        return path;
    }

    public abstract boolean isModified();

    public boolean isSame() {
        return this.m_same;
    }

    public final boolean isFiltered() {
        return this.m_filtered;
    }

    public void setSame(boolean same) {
        this.m_same = same;
    }

    public abstract boolean isLeaf();

    public abstract boolean isMap();

    public abstract boolean isList();

    public abstract Object getObject(String var1);

    public abstract void setObject(String var1, Object var2);

    public abstract int getIndexOf(String var1);

    public abstract void setUpdateContributor(String var1);

    public abstract String getOriginalContributor();

    public abstract String getUpdateContributor();

    public abstract Collection<? extends Difference> getChildren();

    public Difference getChildDifference(String propName) {
        return this.getChildDifference(propName, false);
    }

    public Difference getChildDifference(String propName, boolean ignoreSame) {
        Difference retval = null;
        if (ModelUtil.hasLength((String)propName)) {
            for (Difference difference : this.getChildren()) {
                if (difference == null || !propName.equals(difference.getPropertyName())) continue;
                if (ignoreSame && difference.isSame()) break;
                retval = difference;
                break;
            }
        }
        return retval;
    }

    public abstract Class<?> getDifferenceClass();

    public final Object getOriginalObject() {
        return this.getObject(this.getOriginalContributor());
    }

    public final Object getUpdatedObject() {
        return this.getObject(this.getUpdateContributor());
    }

    public final int getIndexOfOriginalObject() {
        return this.getIndexOf(this.getOriginalContributor());
    }

    public final int getIndexOfUpdatedObject() {
        return this.getIndexOf(this.getUpdateContributor());
    }

    public Difference getFilteredDifference(DifferenceFilter ... filters) {
        Difference retval = (Difference)this.copyTo(null);
        if (filters != null && filters.length > 0) {
            retval.applyFilters(false, filters);
        }
        return retval;
    }

    private void applyFilters(boolean forceFilter, DifferenceFilter ... filters) {
        if (!this.isLoaded() || !this.isSame()) {
            Collection<? extends Difference> children;
            String propPath;
            boolean propPathIsFiltered = forceFilter;
            if (!propPathIsFiltered && ModelUtil.hasLength((String)(propPath = this.getPropertyPath()))) {
                for (int i = 0; i < filters.length; ++i) {
                    if (!filters[i].isFilteredProperty(this, propPath)) continue;
                    propPathIsFiltered = true;
                    break;
                }
            }
            boolean filter = this.m_filtered;
            boolean same = false;
            if (!(!this.isLoaded() && propPathIsFiltered || (children = this.getChildrenInFilterOrder()).isEmpty())) {
                same = true;
                for (Difference difference : children) {
                    Difference sourceDiff = difference.getSourceDifference();
                    if (sourceDiff != null && sourceDiff.isFiltered()) {
                        difference.applyFilters(true, filters);
                        continue;
                    }
                    difference.applyFilters(propPathIsFiltered, filters);
                    if (propPathIsFiltered) continue;
                    same &= difference.isSame();
                    filter |= difference.isFiltered();
                }
            }
            if (propPathIsFiltered) {
                filter = true;
                same = true;
            }
            this.m_filtered = filter;
            if (same) {
                this.setSame(true);
            }
        }
    }

    private Collection<? extends Difference> getChildrenInFilterOrder() {
        Collection<? extends Difference> retval;
        if (this.isList()) {
            retval = this.getChildren();
        } else if (this.isMap()) {
            ArrayList<? extends Difference> list = new ArrayList<Difference>();
            ArrayList<Difference> derived = new ArrayList<Difference>();
            for (Difference difference : this.getChildren()) {
                if (difference.isDerived()) {
                    derived.add(difference);
                    continue;
                }
                list.add(difference);
            }
            list.addAll(derived);
            retval = list;
        } else {
            retval = Collections.emptyList();
        }
        return retval;
    }

    public final Object getProperty(String key) {
        return this.m_props.get(key);
    }

    public final void setProperty(String key, Object value) {
        this.m_props.put(key, value);
    }

    protected void copyToImpl(Difference other) {
        other.m_same = this.m_same;
        other.m_props.clear();
        ModelUtil.deepCopy(this.m_props, other.m_props);
    }

    public final void print() {
        this.print(DBLog.getLogger(this), Level.FINEST);
    }

    public final void print(Logger logger, Level level) {
        if (logger.isLoggable(level)) {
            StringBuilder buff = new StringBuilder("\n");
            this.print(buff, "");
            logger.log(level, buff.toString());
        }
    }

    public final void print(PrintStream stream) {
        StringBuilder buff = new StringBuilder();
        this.print(buff, "");
        stream.println(buff);
        stream.flush();
    }

    private void print(StringBuilder buff, String indent) {
        buff.append(indent);
        this.toString(buff);
        buff.append("\n");
        indent = indent + "  ";
        for (Difference difference : this.getChildrenForLog()) {
            difference.print(buff, indent);
        }
    }

    protected String getOriginalObjectForLog() {
        return String.valueOf(this.getOriginalObject());
    }

    protected String getUpdatedObjectForLog() {
        return String.valueOf(this.getUpdatedObject());
    }

    protected String getSameTextForLog() {
        return this.isSame() ? "SAME" : "XXXX";
    }

    protected Collection<? extends Difference> getChildrenForLog() {
        return this.getChildren();
    }

    public final String toString() {
        StringBuilder buff = new StringBuilder();
        this.toString(buff);
        return buff.toString();
    }

    protected void toString(StringBuilder buff) {
        String spacer = "  ";
        buff.append(this.getSameTextForLog()).append("  ");
        buff.append(this.getPropertyName());
        if (this.isLeaf()) {
            buff.append("  ").append("(").append(this.getOriginalObjectForLog()).append(" : ").append(this.getUpdatedObjectForLog()).append(")");
        }
        int origI = this.getIndexOfOriginalObject();
        int updI = this.getIndexOfUpdatedObject();
        if (origI >= 0 || updI >= 0) {
            buff.append("  ").append(origI + " " + updI);
        }
    }
}

