/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenProcessor;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtilCore;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.util.ModelUtil;

public abstract class TokenGenerator {
    private TokenProcessor m_processor;
    private String m_tokenName;

    public abstract void generateToken(TokenContext var1);

    public abstract Object evaluateToken(TokenContext var1);

    public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
        return Collections.emptyList();
    }

    @Deprecated
    public Collection<String> getPropertiesAltered(String type, DBObjectProvider pro) {
        return Collections.emptyList();
    }

    public Map<PropertyAction.ChildAction, Collection<String>> getAlterPropertiesProcessed(String type, DBObjectProvider pro) {
        return this.createPropertyMap(this.getPropertiesAltered(type, pro), null, null);
    }

    protected final Map<PropertyAction.ChildAction, Collection<String>> createPropertyMap(Collection<String> alterModifyProps, Collection<String> alterAddProps, Collection<String> alterRemoveProps) {
        EnumMap<PropertyAction.ChildAction, Collection<String>> retval = new EnumMap<PropertyAction.ChildAction, Collection<String>>(PropertyAction.ChildAction.class);
        retval.put(PropertyAction.ChildAction.ADD, alterAddProps);
        retval.put(PropertyAction.ChildAction.REMOVE, alterRemoveProps);
        retval.put(PropertyAction.ChildAction.MODIFY, alterModifyProps);
        return retval;
    }

    protected final TokenProcessor getProcessor() {
        return this.m_processor;
    }

    final void setProcessor(TokenProcessor processor, String tokenName) {
        this.m_processor = processor;
        this.m_tokenName = tokenName;
    }

    final String getTokenName() {
        return this.m_tokenName;
    }

    public static class DefaultSchemaGenerator
    extends TokenGenerator {
        public static final String TOKEN = "defaultSchema";

        @Override
        public void generateToken(TokenContext context) {
            Schema def = context.getDefaultSchema();
            context.append(def);
        }

        @Override
        public Object evaluateToken(TokenContext context) {
            Schema s;
            boolean retval = true;
            Object obj = context.getObject();
            if (obj instanceof DBObject && (s = DBUtil.getSchema((DBObject)obj)) != null) {
                Schema def = context.getDefaultSchema();
                retval = DBUtil.areNamesAndTypesEqual(s, def);
            }
            return retval;
        }
    }

    public static class CommentGenerator
    extends TokenGenerator {
        public static final String TOKEN = "quotedComment";

        @Override
        public void generateToken(TokenContext context) {
            String c = this.getComment(context);
            if (ModelUtil.hasLength((String)c) && !c.equals(" ")) {
                context.appendString("'", false);
                context.appendString(c.replace("'", "''"), false);
                context.appendString("'", false);
            } else {
                context.appendString("''", false);
            }
        }

        private String getComment(TokenContext context) {
            String retval = null;
            Object c = context.getObject();
            if (c instanceof DBObject) {
                retval = (String)((DBObject)c).getProperty("Comment");
            }
            return retval;
        }

        @Override
        public Object evaluateToken(TokenContext context) {
            String comment = this.getComment(context);
            comment = comment == null ? null : comment.trim();
            return ModelUtil.hasLength((String)comment);
        }

        @Override
        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("Comment");
        }
    }

    public static final class NameGenerator
    extends TokenGenerator {
        public static final String TOKEN = "schema.name";

        @Override
        public void generateToken(TokenContext context) {
            Object value = context.getObject();
            DBObjectProvider pro = context.getProvider();
            if (pro != null && value instanceof PlSqlSourceObject && value instanceof DBObjectPlSqlFragment) {
                Schema plsSchema;
                PlSqlSourceObject pls = (PlSqlSourceObject)value;
                PlSqlToken nameTk = null;
                PlSqlToken typeTk = null;
                PlSqlToken schemaTk = null;
                try {
                    PlSqlParser parser = PlSqlUtilCore.findOrCreateParser(pls, pro);
                    nameTk = parser.getNameToken();
                    typeTk = parser.getTypeToken();
                    schemaTk = parser.getSchemaToken();
                }
                catch (CancelledException ce) {
                    DBLog.getLogger(this).warning("Parsing cancelled while building ddl. " + ce.getMessage());
                }
                String plsName = null;
                if (nameTk != null && pro != null) {
                    plsName = pro.getInternalName(nameTk.getSource());
                }
                if (!ModelUtil.hasLength(plsName)) {
                    plsName = pls.getName();
                } else {
                    PlSqlToken tk = typeTk;
                    tk = (PlSqlToken)tk.getNextToken();
                    StringBuilder sb = new StringBuilder();
                    while (!tk.isCode()) {
                        sb.append(tk.getSource());
                        tk = (PlSqlToken)tk.getNextToken();
                    }
                    if (" ".equals(sb.substring(0, 1))) {
                        context.append(sb.substring(1));
                    } else {
                        context.append(sb.toString());
                    }
                }
                if (ModelUtil.hasLength((String)pls.getSource()) && (pro instanceof Database || context.getOptions().isSqlBlankLines()) && (plsSchema = pls.getSchema()) != null) {
                    String schemaInSource = null;
                    if (schemaTk != null) {
                        schemaInSource = schemaTk.getSource();
                    }
                    String destSchemaName = plsSchema.getName();
                    if (schemaInSource != null) {
                        if (destSchemaName.equals(pro.getInternalName(schemaInSource))) {
                            context.append(schemaInSource);
                            context.append(Character.valueOf('.'));
                        } else {
                            context.appendSchemaName(destSchemaName);
                        }
                    } else {
                        context.appendSchemaName(destSchemaName);
                    }
                }
                context.appendName(plsName);
            } else if (value instanceof DBObject) {
                Schema valueSchema;
                if (value instanceof SchemaObject && (valueSchema = (Schema)context.getPropertyValue("schema")) != null) {
                    context.appendSchemaName(valueSchema.getName());
                }
                context.appendName((String)context.getPropertyValue("name"));
            } else {
                context.append(value);
            }
        }

        @Override
        public Object evaluateToken(TokenContext context) {
            return null;
        }

        @Override
        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("name", "schema");
        }
    }

    public static final class CascadeGenerator
    extends TokenGenerator {
        public static final String TOKEN = "cascade";

        @Override
        public void generateToken(TokenContext context) {
        }

        @Override
        public Object evaluateToken(TokenContext context) {
            return context.getOptions().isCascade();
        }
    }

    public static final class ReplaceGenerator
    extends TokenGenerator {
        public static final String TOKEN = "replace";

        @Override
        public void generateToken(TokenContext context) {
            if (context.getOptions().isReplace()) {
                context.append("OR REPLACE");
            }
        }

        @Override
        public Object evaluateToken(TokenContext context) {
            return context.getOptions().isReplace();
        }
    }
}

