/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.util.ModelUtil;

public final class DDL<T extends DDLType> {
    private Map<T, Collection<String>> m_ddls = new TreeMap<T, Collection<String>>();
    private Collection<DDL<T>> m_following;
    private DBObject m_obj;
    private boolean m_hasPrompts;

    public DDL() {
    }

    public DDL(DBObject obj) {
        this.m_obj = obj;
    }

    public void append(T type, String ddl) {
        Collection<String> ddls = this.m_ddls.get(type);
        if (ddls == null) {
            ddls = new ArrayList<String>();
            this.m_ddls.put(type, ddls);
        }
        ddls.add(ddl);
    }

    public void appendAll(T type, Collection<String> ddl) {
        if (ddl != null && ddl.size() > 0) {
            Collection<String> ddls = this.m_ddls.get(type);
            if (ddls == null) {
                ddls = new ArrayList<String>();
                this.m_ddls.put(type, ddls);
            }
            ddls.addAll(ddl);
        }
    }

    public void append(DDL<T> other) {
        if (other != null) {
            if (this.m_following == null) {
                this.m_following = new ArrayList<DDL<T>>();
            }
            this.m_following.add(other);
        }
    }

    public Collection<String> get(T type) {
        Collection<String> cached = this.m_ddls.get(type);
        if (this.m_following != null) {
            for (DDL<T> follower : this.m_following) {
                Collection<String> fc = follower.get(type);
                if (fc == null || fc.size() <= 0) continue;
                if (cached == null || cached.size() == 0) {
                    cached = fc;
                    continue;
                }
                cached.addAll(fc);
            }
        }
        return cached == null ? Collections.emptyList() : new ArrayList<String>(cached);
    }

    public void remove(T type) {
        this.m_ddls.remove(type);
        if (this.m_following != null) {
            for (DDL<T> follower : this.m_following) {
                follower.remove(type);
            }
        }
    }

    public int size() {
        int retval = 0;
        for (Collection<String> collection : this.m_ddls.values()) {
            retval += collection.size();
        }
        if (this.m_following != null) {
            for (DDL dDL : this.m_following) {
                retval += dDL.size();
            }
        }
        return retval;
    }

    public Collection<String> getStatements() {
        return this.getStatements(false);
    }

    private Collection<String> getStatements(boolean appendTerminators) {
        ArrayList<String> retval = new ArrayList<String>();
        Map<T, Collection<StatementWithObject>> map = this.getStatementsForExecution();
        for (Map.Entry<T, Collection<StatementWithObject>> entry : map.entrySet()) {
            DDLType type = (DDLType)entry.getKey();
            for (StatementWithObject swo : entry.getValue()) {
                String ddl = swo.getStatement();
                if (!ModelUtil.hasLength((String)ddl)) continue;
                if (appendTerminators) {
                    retval.add(this.appendTerminator(ddl, type));
                    continue;
                }
                retval.add(this.stripTerminator(ddl, type));
            }
        }
        return retval;
    }

    private String appendTerminator(String ddl, T type) {
        boolean append = false;
        String terminator = ((DDLType)type).getTerminator();
        if (ModelUtil.hasLength((String)terminator)) {
            String trimTerm = terminator.trim();
            if (ModelUtil.hasLength((String)trimTerm) && !ddl.trim().endsWith(trimTerm)) {
                append = true;
            } else if (!ddl.endsWith(terminator)) {
                append = true;
            }
        }
        return append ? ddl + terminator : ddl;
    }

    private String stripTerminator(String ddl, T type) {
        String terminator = ((DDLType)type).getTerminator();
        String string = terminator = terminator == null ? "" : terminator.trim();
        if (ModelUtil.hasLength((String)terminator) && ddl.trim().endsWith(terminator)) {
            ddl = ddl.substring(0, ddl.lastIndexOf(terminator));
        }
        return ddl;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeTerminators) {
        StringBuilder buff = new StringBuilder();
        Iterator<String> stmts = this.getStatements(includeTerminators).iterator();
        while (stmts.hasNext()) {
            buff.append(stmts.next());
            if (!stmts.hasNext()) continue;
            buff.append("\n");
        }
        return buff.toString();
    }

    public DDL<T> copyWithPrompts() {
        if (this.m_hasPrompts) {
            return this;
        }
        DDL<T> retval = new DDL<T>();
        retval.m_hasPrompts = true;
        Map<T, Collection<StatementWithObject>> all = this.getStatementsForExecution();
        for (DDLType type : all.keySet()) {
            Collection<StatementWithObject> list = all.get(type);
            for (StatementWithObject next : list) {
                String stmt;
                DBObject obj = next.getObject();
                String prompt = type.createPrompt(obj, stmt = next.getStatement());
                if (ModelUtil.hasLength((String)prompt) && !prompt.endsWith("\n")) {
                    prompt = prompt + "\n";
                }
                DDL<DDLType> bit = new DDL<DDLType>(obj);
                if (ModelUtil.hasLength((String)prompt)) {
                    bit.append(type, prompt + stmt);
                } else {
                    bit.append(type, stmt);
                }
                retval.append(bit);
            }
        }
        return retval;
    }

    Ddl convertToLegacy() {
        Ddl ddl = new Ddl();
        this.convertAllInto(ddl);
        return ddl;
    }

    private void convertAllInto(Ddl ddl) {
        for (Map.Entry<T, Collection<String>> entry : this.m_ddls.entrySet()) {
            Ddl whyAmIForcedToDoThis = new Ddl();
            whyAmIForcedToDoThis.put(((DDLType)entry.getKey()).toString(), entry.getValue());
            ddl.append(whyAmIForcedToDoThis);
        }
        if (this.m_following != null) {
            for (DDL dDL : this.m_following) {
                dDL.convertAllInto(ddl);
            }
        }
    }

    Ddl[] convertToLegacyArray() {
        Ddl[] retval = new Ddl[]{new Ddl()};
        this.convertAllInto(retval[0]);
        return retval;
    }

    Map<T, Collection<StatementWithObject>> getStatementsForExecution() {
        TreeMap retval = new TreeMap();
        this.putAll(retval, this.getStatementsForExecutionImpl());
        for (Map.Entry entry : retval.entrySet()) {
            Boolean sort = ((DDLType)entry.getKey()).getDependencySortPreference();
            if (sort == null) continue;
            this.topSort((Collection)entry.getValue(), sort);
        }
        return retval;
    }

    private void putAll(Map<T, Collection<StatementWithObject>> bigMap, Map<T, Collection<StatementWithObject>> addAllThese) {
        for (DDLType type : addAllThese.keySet()) {
            Collection<StatementWithObject> stmts = addAllThese.get(type);
            if (stmts == null) continue;
            Collection<StatementWithObject> stmtsInMap = bigMap.get(type);
            if (stmtsInMap == null) {
                bigMap.put(type, stmts);
                stmtsInMap = stmts;
            } else {
                stmtsInMap.addAll(stmts);
            }
            if (!type.ensureUnique() || stmtsInMap.size() <= 1) continue;
            StatementWithObject chesney = stmtsInMap.iterator().next();
            stmtsInMap.clear();
            stmtsInMap.add(chesney);
        }
    }

    private Map<T, Collection<StatementWithObject>> getStatementsForExecutionImpl() {
        TreeMap retval = new TreeMap();
        for (DDLType dDLType : this.m_ddls.keySet()) {
            Collection<String> stmts = this.m_ddls.get(dDLType);
            if (stmts == null || stmts.size() <= 0) continue;
            ArrayList<StatementWithObject> forMapping = new ArrayList<StatementWithObject>();
            retval.put(dDLType, forMapping);
            for (String s : stmts) {
                forMapping.add(new StatementWithObject(this.stripTerminator(s, dDLType), this.m_obj));
            }
        }
        if (this.m_following != null) {
            for (DDL dDL : this.m_following) {
                this.putAll(retval, dDL.getStatementsForExecutionImpl());
            }
        }
        return retval;
    }

    private void topSort(Collection<StatementWithObject> stmts, boolean parentThenChild) {
        boolean found = false;
        DBUtil.IDQueryCriteria crit = new DBUtil.IDQueryCriteria(DBUtil.IDQuery.EXTERNAL);
        crit.setRecurse(true);
        crit.setExistingOnly(true);
        crit.setTopLevelOnly(true);
        for (StatementWithObject stmt : stmts) {
            if (stmt.m_obj == null) continue;
            for (DBObjectID dBObjectID : DBUtil.getReferenceIDs(stmt.m_obj, crit)) {
                for (StatementWithObject otherStmt : stmts) {
                    if (otherStmt == stmt || otherStmt.m_obj == null || !dBObjectID.equals(otherStmt.m_obj.getID(), true)) continue;
                    if (stmt.m_to == null) {
                        stmt.m_to = new ArrayList();
                    }
                    stmt.m_to.add(otherStmt);
                    if (otherStmt.m_from == null) {
                        otherStmt.m_from = new ArrayList();
                    }
                    otherStmt.m_from.add(stmt);
                    found = true;
                }
            }
        }
        if (found) {
            ArrayList<StatementWithObject> newOrder = new ArrayList<StatementWithObject>();
            boolean sortOK = true;
            ArrayList<StatementWithObject> roots = new ArrayList<StatementWithObject>();
            for (StatementWithObject statementWithObject : stmts) {
                if (statementWithObject.m_to != null) continue;
                roots.add(statementWithObject);
            }
            while (!roots.isEmpty()) {
                StatementWithObject statementWithObject = (StatementWithObject)roots.remove(0);
                if (parentThenChild) {
                    newOrder.add(statementWithObject);
                } else {
                    newOrder.add(0, statementWithObject);
                }
                if (statementWithObject.m_from == null) continue;
                for (StatementWithObject other : statementWithObject.m_from) {
                    if (other.m_to != null) {
                        Iterator iter = other.m_to.iterator();
                        while (iter.hasNext()) {
                            if (statementWithObject != iter.next()) continue;
                            iter.remove();
                            break;
                        }
                    }
                    if (!other.m_to.isEmpty()) continue;
                    roots.add(other);
                }
            }
            if (sortOK) {
                for (StatementWithObject statementWithObject : stmts) {
                    if (statementWithObject.m_to == null || statementWithObject.m_to.isEmpty()) continue;
                    sortOK = false;
                    break;
                }
            }
            if (sortOK) {
                stmts.clear();
                stmts.addAll(newOrder);
            }
        }
    }

    class StatementWithObject {
        private String m_stmt;
        private DBObject m_obj;
        private Collection<StatementWithObject> m_to;
        private Collection<StatementWithObject> m_from;

        private StatementWithObject(String stmt, DBObject obj) {
            this.m_stmt = stmt;
            this.m_obj = obj;
        }

        public DBObject getObject() {
            return this.m_obj;
        }

        public String getStatement() {
            return this.m_stmt;
        }
    }
}

