/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.token.TokenPattern;

public class PredefinedDataType
extends AbstractBuildableObject
implements DataType {
    private String[] m_tokenizedDefinition;
    private TokenPattern m_search;

    public PredefinedDataType() {
    }

    public PredefinedDataType(String name) {
        super(name, null);
    }

    public PredefinedDataType(int domain, String name) {
        this(domain, name, null, new DataTypeAttribute[0]);
    }

    public PredefinedDataType(int domain, String name, String definition, DataTypeAttribute ... attributes) {
        super(name, null);
        this.setDefinition(definition);
        this.setDataTypeAttributes(attributes);
    }

    public PredefinedDataType(int domain, String name, String definition, long minSize, long maxSize, long defaultSize, boolean isSizeMandatory, DataTypeAttribute ... attributes) {
        this(domain, name, definition, attributes);
        this.addAttribute(new DataTypeAttribute("size", "DATATYPE_ATTRIBUTE_LABEL_SIZE", minSize, new Long(maxSize), new Long(defaultSize), isSizeMandatory), 0);
    }

    @Override
    public final String getType() {
        return "DATATYPE";
    }

    public final void addAttribute(DataTypeAttribute attribute) {
        this.getChildSupport("dataTypeAttributes").addChild(attribute);
    }

    public final void addAttribute(DataTypeAttribute attribute, int atIndex) {
        this.getChildSupport("dataTypeAttributes").addChild(atIndex, attribute);
    }

    public final void removeAttribute(DataTypeAttribute attribute) {
        this.getChildSupport("dataTypeAttributes").removeChild(attribute);
    }

    @Override
    public DataTypeUsage createDefaultUsage() {
        DataTypeUsage usage = new DataTypeUsage(this);
        HashMap<String, Object> attributeValues = new HashMap<String, Object>();
        for (DataTypeAttribute attribute : this.getDataTypeAttributes()) {
            if (!attribute.isMandatory()) continue;
            attributeValues.put(attribute.getName(), attribute.getDefaultValue());
        }
        if (attributeValues.size() > 0) {
            usage.setAttributeValues(attributeValues);
        }
        return usage;
    }

    @Override
    public DataTypeUsage createUsage(Map<String, Object> attributeValues) {
        assert (attributeValues != null);
        DataTypeUsage usage = new DataTypeUsage(this);
        HashMap<String, Object> declarableAttributeValues = new HashMap<String, Object>();
        for (String name : attributeValues.keySet()) {
            DataTypeAttribute attribute = this.getDataTypeAttribute(name);
            if (attribute == null || !attribute.isDeclarable() || attributeValues.get(name) == null) continue;
            declarableAttributeValues.put(name, attributeValues.get(name));
        }
        String nameAttr = (String)attributeValues.get("name");
        if (nameAttr != null) {
            this.addAttributeValues(declarableAttributeValues, nameAttr, new DTAContext());
        }
        usage.setAttributeValues(declarableAttributeValues);
        return usage;
    }

    @Override
    @Deprecated
    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
    }

    @Override
    @Deprecated
    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
    }

    @Override
    public String getDDL(DataTypeUsage dataTypeUsage) {
        DDLGenImpl c = new DDLGenImpl(this.getDefinitionForSearch());
        return c.getDDL(dataTypeUsage.getAttributeValues());
    }

    @Override
    public final boolean hasDataTypeAttribute(String name) {
        return this.getDataTypeAttribute(name) != null;
    }

    @Override
    public final DataTypeAttribute getDataTypeAttribute(String name) {
        return (DataTypeAttribute)this.getChildSupport("dataTypeAttributes").findChild(name);
    }

    @Override
    public final DataTypeAttribute[] getDataTypeAttributes() {
        return this.getChildSupport("dataTypeAttributes").getChildArray(DataTypeAttribute.class);
    }

    public final void setDataTypeAttributes(DataTypeAttribute[] attrs) {
        this.getChildSupport("dataTypeAttributes").setChildArray(attrs);
    }

    @Override
    public Integer getSQLType() {
        return (Integer)this.getProperty("SQLType");
    }

    public void setSQLType(Integer sqlType) {
        this.setProperty("SQLType", sqlType);
    }

    public ValueType getValueType() {
        return (ValueType)((Object)this.getProperty("valueType"));
    }

    public void setValueType(ValueType valueType) {
        this.setProperty("valueType", (Object)valueType);
    }

    public BigDecimal getMinValue() {
        return (BigDecimal)this.getProperty("minValue");
    }

    public void setMinValue(BigDecimal minValue) {
        this.setProperty("minValue", minValue);
    }

    public BigDecimal getMaxValue() {
        return (BigDecimal)this.getProperty("maxValue");
    }

    public void setMaxValue(BigDecimal maxValue) {
        this.setProperty("maxValue", maxValue);
    }

    public String getDefinition() {
        return (String)this.getProperty("definition");
    }

    public void setDefinition(String definition) {
        this.setProperty("definition", definition);
        this.clearSearchCache();
    }

    public String getSearchDefinition() {
        return (String)this.getProperty("searchDefinition");
    }

    public void setSearchDefinition(String searchDefinition) {
        this.setProperty("searchDefinition", searchDefinition);
        this.clearSearchCache();
    }

    protected String getDefinitionForSearch() {
        String retval = this.getSearchDefinition();
        if (retval == null) {
            retval = this.getDefinition();
        }
        if (retval == null) {
            retval = this.getName();
        }
        return retval;
    }

    private void clearSearchCache() {
        this.m_search = null;
        this.m_tokenizedDefinition = null;
    }

    private void addAttributeValues(Map attributeValues, String dataType, DTAContext c) {
        if (this.m_tokenizedDefinition == null) {
            this.m_tokenizedDefinition = PredefinedDataType.tokenize(this.getDefinitionForSearch(), "[]( ),");
        }
        c.m_dataType = dataType;
        String[] tokenizedDataType = PredefinedDataType.tokenize(dataType, "( ),");
        c.m_index = 0;
        c.m_valueIndex = 0;
        while (c.m_index < this.m_tokenizedDefinition.length && c.m_valueIndex < tokenizedDataType.length) {
            this.addAttributeValues(attributeValues, tokenizedDataType, false, c);
            c.m_index++;
        }
    }

    private void addOptionalAttributeValue(Map attributeValues, String[] dataType, DTAContext c) {
        c.m_index++;
        if (!this.addAttributeValues(attributeValues, dataType, true, c)) {
            int optionalClauses = 1;
            do {
                if (this.m_tokenizedDefinition[c.m_index].equals("[")) {
                    ++optionalClauses;
                    continue;
                }
                if (!this.m_tokenizedDefinition[c.m_index].equals("]")) continue;
                --optionalClauses;
            } while (optionalClauses > 0 && ++c.m_index < this.m_tokenizedDefinition.length);
        }
    }

    private boolean addAttributeValues(Map attributeValues, String[] dataType, boolean optional, DTAContext c) {
        while (c.m_valueIndex < dataType.length && c.m_index < this.m_tokenizedDefinition.length && !this.m_tokenizedDefinition[c.m_index].equals("]")) {
            if (this.m_tokenizedDefinition[c.m_index].equals("[")) {
                this.addOptionalAttributeValue(attributeValues, dataType, c);
            } else if (this.m_tokenizedDefinition[c.m_index].charAt(0) == '<') {
                String attributeName = this.m_tokenizedDefinition[c.m_index].substring(1, this.m_tokenizedDefinition[c.m_index].length() - 1);
                DataTypeAttribute dta = this.getDataTypeAttribute(attributeName);
                int valueType = dta.getValueType();
                if (valueType == 1 || valueType == 2) {
                    attributeValues.put(attributeName, DataTypeHelper.getAttributeValue(dataType[c.m_valueIndex], (DataType)dta.getParent(), attributeName));
                } else if (valueType == 0) {
                    String value = dataType[c.m_valueIndex];
                    if (this.getDataTypeAttribute(attributeName).getValues() != null) {
                        int validValueIdx;
                        String[] validValues = this.getDataTypeAttribute(attributeName).getValues();
                        while ((validValueIdx = this.isValidValue(value, validValues)) == -1 && ++c.m_valueIndex < dataType.length) {
                            value = value + dataType[c.m_valueIndex];
                        }
                        if (c.m_valueIndex < dataType.length) {
                            attributeValues.put(attributeName, validValues[validValueIdx]);
                        } else if (!optional) {
                            DBLog.getLogger(this).warning("Data type \"" + c.m_dataType + "\" doesn't match its definition : " + this.getDefinitionForSearch());
                        }
                    }
                }
                c.m_valueIndex++;
            } else {
                if (optional) {
                    if (this.m_tokenizedDefinition[c.m_index].compareToIgnoreCase(dataType[c.m_valueIndex]) != 0) {
                        return false;
                    }
                } else assert (this.m_tokenizedDefinition[c.m_index].compareToIgnoreCase(dataType[c.m_valueIndex]) == 0) : "Data type \"" + DTAContext.access$100(c) + "\" doesn't match its definition : " + this.getDefinitionForSearch();
                c.m_valueIndex++;
            }
            c.m_index++;
        }
        return true;
    }

    private int isValidValue(String targetValue, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i].replaceAll("\\s", "").compareToIgnoreCase(targetValue) != 0) continue;
            return i;
        }
        return -1;
    }

    protected static String[] tokenize(String string, String delimiters) {
        StringTokenizer tok = new StringTokenizer(string.replaceAll("\\s", " "), delimiters, true);
        ArrayList<String> tokens = new ArrayList<String>();
        int tokenCount = 0;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.charAt(0) == ' ') continue;
            tokens.add(token);
            ++tokenCount;
        }
        return tokens.toArray(new String[tokenCount]);
    }

    @Override
    public boolean matches(String usageString) {
        return DataTypeHelper.matches(this.getSearch(), usageString) != null;
    }

    @Override
    public DataTypeUsage createUsage(String usageString) {
        return DataTypeHelper.getUsageFromString(this, this.getSearch(), usageString);
    }

    private TokenPattern getSearch() {
        if (this.m_search == null) {
            this.m_search = DataTypeHelper.buildSearch(this.getDefinitionForSearch(), this.getDataTypeAttributes());
        }
        return this.m_search;
    }

    public static enum ValueType {
        SIGNED_INT,
        UNSIGNED_INT,
        FLOAT,
        CHAR,
        BINARY,
        DATE,
        TIMESTAMP;


        public static boolean isNumericType(ValueType type) {
            return type != null && type.ordinal() < 3;
        }
    }

    private static class DTAContext {
        private int m_index;
        private int m_valueIndex;
        private String m_dataType;

        private DTAContext() {
        }
    }

    static class DDLGenImpl {
        private int m_index;
        private final String m_definition;

        DDLGenImpl(String definition) {
            this.m_definition = definition;
        }

        String getDDL(Map<String, Object> attributeValues) {
            String ddl = "";
            if (this.m_definition != null) {
                this.m_index = 0;
                while (this.m_index < this.m_definition.length()) {
                    ddl = ddl + this.getDDL(attributeValues, false);
                    ++this.m_index;
                }
            }
            return ddl;
        }

        private String getDDL(Map<String, Object> attributeValues, boolean optional) {
            char ch;
            String ddl = "";
            int length = this.m_definition.length();
            while (this.m_index < length && (ch = this.m_definition.charAt(this.m_index)) != ']') {
                if (ch == '[') {
                    ddl = ddl + this.getOptionalDDL(attributeValues);
                } else if (ch == '<') {
                    String attributeName = "";
                    while (++this.m_index < this.m_definition.length() && this.m_definition.charAt(this.m_index) != '>') {
                        attributeName = attributeName + this.m_definition.charAt(this.m_index);
                    }
                    Object attributeValue = attributeValues.get(attributeName);
                    if (optional && attributeValue == null) {
                        return "";
                    }
                    if (attributeValue != null) {
                        ddl = ddl + attributeValue.toString();
                    }
                } else if (ch == '\\' && this.m_index < length - 1) {
                    char next = this.m_definition.charAt(this.m_index + 1);
                    if (next == '<' || next == '>' || next == '[' || next == ']') {
                        ddl = ddl + next;
                        ++this.m_index;
                    } else {
                        ddl = ddl + ch;
                    }
                } else {
                    ddl = ddl + ch;
                }
                ++this.m_index;
            }
            return ddl;
        }

        private String getOptionalDDL(Map attributeValues) {
            ++this.m_index;
            String ddl = this.getDDL(attributeValues, true);
            if (ddl.length() == 0) {
                while (this.m_index < this.m_definition.length() && this.m_definition.charAt(this.m_index) != ']') {
                    if (this.m_definition.charAt(this.m_index) == '[') {
                        this.getOptionalDDL(attributeValues);
                    }
                    ++this.m_index;
                }
            }
            return ddl;
        }
    }
}

