/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.Collection;
import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.Internal;
import oracle.javatools.util.ModelUtil;

public final class DataTypeID
implements DBObjectID {
    private static final String s_stringPrefix = "DataTypeID:";
    private String m_typeName;
    private String m_schemaName;
    private DatabaseDescriptor m_desc;

    public DataTypeID() {
    }

    public DataTypeID(String typeName, DatabaseDescriptor desc) {
        this(typeName, null, desc);
    }

    public DataTypeID(String typeName, String schemaName, DatabaseDescriptor desc) {
        this.m_schemaName = schemaName;
        this.m_typeName = typeName;
        this.m_desc = desc;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String name) {
        this.m_typeName = name;
    }

    public DatabaseDescriptor getDatabaseDescriptor() {
        return this.m_desc;
    }

    @Deprecated
    @Internal
    public Class getProviderClass() {
        return null;
    }

    @Deprecated
    public void setProviderClass(Class clz) {
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.m_schemaName = schemaName;
    }

    public boolean equals(DBObjectID id) {
        return this.equals(id, true);
    }

    @Override
    public boolean equals(DBObjectID id, boolean strict) {
        return id instanceof DataTypeID && this.equalsImpl((DataTypeID)id);
    }

    protected boolean equalsImpl(DataTypeID id) {
        return ModelUtil.areEqual((Object)this.m_typeName, (Object)id.m_typeName) && ModelUtil.areEqual((Object)this.m_schemaName, (Object)id.m_schemaName) && this.isSameDescriptor(id.m_desc);
    }

    private boolean isSameDescriptor(DatabaseDescriptor other) {
        boolean retval = this.m_desc == other ? true : (this.m_desc == null || other == null ? false : ModelUtil.areEqual((Object)this.m_desc.getDatabaseType(), (Object)other.getDatabaseType()) && this.m_desc.getDatabaseVersion() == other.getDatabaseVersion());
        return retval;
    }

    public Object copyTo(Object target) {
        DataTypeID copy = target == null ? new DataTypeID() : (DataTypeID)target;
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(DataTypeID target) {
        target.m_desc = this.m_desc;
        target.m_schemaName = this.m_schemaName;
        target.m_typeName = this.m_typeName;
    }

    @Override
    public String getType() {
        return this.m_schemaName == null ? "DATATYPE" : "TYPE";
    }

    @Override
    public DBObject resolveID() throws DBException {
        return this.resolveIDImpl(false);
    }

    private DataType resolveIDImpl(boolean silent) {
        DataType retval = null;
        if (this.m_desc != null && ModelUtil.hasLength((String)this.m_typeName)) {
            if (this.m_schemaName != null) {
                DBObjectCriteria<Type> crit = new DBObjectCriteria<Type>(Type.class, new String[0]);
                crit.setName(this.m_typeName);
                crit.setSchemaName(this.m_schemaName);
                Collection<Type> objs = this.m_desc.listBuiltInObjects(crit);
                if (objs.size() == 1) {
                    retval = objs.iterator().next();
                }
            } else {
                retval = this.m_desc.getDataType(this.m_typeName);
            }
            if (retval == null) {
                DBLog.getLogger(this).log(silent ? Level.FINE : Level.WARNING, "DataTypeID: DataType {0} not found for {1}", new String[]{this.m_typeName, this.m_desc.getDatabaseType()});
            }
        }
        return retval;
    }

    public void ensureProvider(DBObjectProvider pro) {
        if (pro != null && this.m_typeName != null) {
            DBObjectID id;
            this.m_desc = pro.getDescriptor();
            DataType dt = this.resolveIDImpl(true);
            if (dt != null && (id = dt.getID()) instanceof DataTypeID) {
                this.m_desc = ((DataTypeID)id).getDatabaseDescriptor();
            }
        }
    }

    @Override
    public DBObjectID getParent() {
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof DBObjectID && this.equals((DBObjectID)obj);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        String SEP = ":";
        StringBuilder retval = new StringBuilder(s_stringPrefix);
        if (this.m_schemaName != null) {
            retval.append(this.m_schemaName).append(":");
        }
        retval.append(this.m_typeName);
        if (this.m_desc != null) {
            retval.append(":").append(this.m_desc.getDatabaseType()).append(":").append(this.m_desc.getDatabaseVersion());
        }
        return retval.toString();
    }

    public static final boolean isIDType(String idString) {
        return idString.startsWith(s_stringPrefix);
    }

    public static DataTypeID createFromString(String idString) {
        DataTypeID retval = null;
        if (DataTypeID.isIDType(idString)) {
            String name = null;
            String schema = null;
            String[] bits = idString.split(":");
            if (bits.length == 4) {
                schema = bits[2];
                name = bits[3];
            } else if (bits.length == 3) {
                schema = bits[1];
                name = bits[2];
            } else if (bits.length == 2) {
                name = bits[1];
            }
            if (name != null) {
                retval = new DataTypeID(name, schema, null);
            }
        }
        return retval;
    }
}

