/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.MissingProviderException;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.datatypes.UserDataType;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenPattern;
import oracle.javatools.util.ModelUtil;

public class DataTypeHelper {
    private static Logger getLogger() {
        return DBLog.getLogger(DataTypeHelper.class);
    }

    public static DataType getDataType(DataTypeUsage usage) throws DBException {
        return DataTypeHelper.getDataType(usage, true);
    }

    public static DataType getDataType(DataTypeUsage usage, boolean createUnknownTypeIfMissing) throws DBException {
        DataType retval = null;
        if (usage != null) {
            DBObject obj;
            DBObjectID dataTypeID = usage.getDataTypeID();
            if (dataTypeID == null) {
                throw new DBException((DBObject)usage, "Column's DataTypeUsage has no DataTypeID to resolve.");
            }
            if (dataTypeID instanceof ReferenceID && "DATATYPE".equals(dataTypeID.getType())) {
                if (((ReferenceID)dataTypeID).getSchemaName() == null) {
                    dataTypeID = (DBObjectID)dataTypeID.copyTo(null);
                    ((ReferenceID)dataTypeID).setSchema(DBUtil.getSchema(usage));
                }
                obj = DataTypeHelper.resolveDataTypeReferenceID((ReferenceID)dataTypeID);
            } else {
                obj = dataTypeID.resolveID();
            }
            if (obj instanceof Synonym) {
                obj = DBUtil.getSynonymReference((Synonym)obj);
            }
            DataType dataType = retval = obj instanceof DataType ? (DataType)obj : null;
            if (retval == null && createUnknownTypeIfMissing && dataTypeID instanceof BaseObjectID) {
                BaseObjectID id = (BaseObjectID)dataTypeID;
                String name = id.getName();
                String type = id.getType();
                if (name != null && ("DATATYPE".equals(type) || "TYPE".equals(type))) {
                    DBObjectProvider pro = id.getProvider();
                    String schemaName = id.getSchemaName();
                    if ((pro == null || pro.supportsObjectType("TYPE")) && ("TYPE".equals(type) || schemaName != null)) {
                        if (schemaName != null) {
                            Schema schema;
                            try {
                                schema = pro == null ? null : pro.getSchema(schemaName);
                            }
                            catch (DBException e) {
                                schema = null;
                            }
                            if (schema == null) {
                                schema = new Schema(schemaName);
                            }
                            if (pro == null) {
                                retval = new Type();
                                retval.setName(name);
                                ((Type)retval).setSchema(schema);
                            } else {
                                retval = pro.getObjectFactory().newObject(Type.class, schema, name, false, false);
                            }
                        }
                    } else {
                        retval = DataTypeRegistry.getInstance().createUserDataType(name, pro);
                    }
                }
            }
        }
        return retval;
    }

    public static DBObject resolveDataTypeReferenceID(ReferenceID id) throws DBException {
        Schema defaultSchema;
        AbstractBuildableObject retval = null;
        DBObjectProvider pro = id.getProvider();
        if (pro == null) {
            throw new MissingProviderException();
        }
        String objName = id.getName();
        String schemaName = id.getSchemaName();
        if (schemaName == null && (defaultSchema = pro.getDefaultSchema()) != null) {
            schemaName = defaultSchema.getName();
        }
        if (objName != null && schemaName != null) {
            DBObjectCriteria<Type> typeCrit = new DBObjectCriteria<Type>(Type.class, new String[0]);
            typeCrit.setName(objName);
            typeCrit.setSchemaName(schemaName);
            retval = pro.getDescriptor().getBuiltInObject(typeCrit);
            if (retval == null && (retval = pro.getObject(typeCrit)) == null && pro.supportsObjectType("SYNONYM")) {
                String publicSchemaName;
                DBObjectCriteria<Synonym> synCrit = new DBObjectCriteria<Synonym>(Synonym.class, new String[0]);
                synCrit.setName(objName);
                synCrit.setSchemaName(schemaName);
                retval = pro.getObject(synCrit);
                if (retval == null && (publicSchemaName = pro.getDescriptor().getPublicSchemaName()) != null) {
                    synCrit.setSchemaName(publicSchemaName);
                    retval = pro.getObject(synCrit);
                }
            }
        }
        return retval;
    }

    public static Long getLongAttributeValue(DataTypeUsage usage, String name) {
        return DataTypeHelper.toLong(usage.getAttributeValue(name));
    }

    public static String getStringAttributeValue(DataTypeUsage usage, String name) {
        return DataTypeHelper.toString(usage.getAttributeValue(name));
    }

    public static String getStringAttributeDefaultValue(DataTypeUsage usage, String attributeName) {
        String result = null;
        try {
            Object defaultValue;
            DataTypeAttribute attribute;
            DataType dataType = DataTypeHelper.getDataType(usage, false);
            if (dataType != null && (attribute = dataType.getDataTypeAttribute(attributeName)) != null && (defaultValue = attribute.getDefaultValue()) != null) {
                result = defaultValue.toString();
            }
        }
        catch (DBException dbe) {
            DataTypeHelper.getLogger().warning(dbe.getMessage());
        }
        return result;
    }

    public static Long toLong(Object usageValue) {
        try {
            String convert = usageValue == null ? null : ModelUtil.nullifyIfEmpty((String)usageValue.toString());
            return convert == null ? null : Long.valueOf(convert);
        }
        catch (NumberFormatException x) {
            return null;
        }
    }

    public static Long toLongOrError(Object usageValue) throws NumberFormatException {
        String convert = usageValue == null ? null : ModelUtil.nullifyIfEmpty((String)usageValue.toString());
        return convert == null ? null : Long.valueOf(convert);
    }

    public static String toString(Object usageValue) {
        return usageValue == null ? null : usageValue.toString();
    }

    @Deprecated
    public static String getNameFromLabel(int resourceLabelID) {
        return null;
    }

    @Deprecated
    public static String getNameFromLabel(String resourceLabel) {
        return resourceLabel;
    }

    public static Object getAttributeValue(Object value, DataType dataType, String attributeName) {
        DataTypeAttribute attribute;
        if (value instanceof String && !ModelUtil.hasLength((String)((String)value))) {
            value = null;
        }
        Object ret = null;
        if (dataType == null || dataType instanceof UserDataType) {
            ret = value;
        } else if (value != null && (attribute = dataType.getDataTypeAttribute(attributeName)) != null) {
            int valueType = attribute.getValueType();
            if (valueType == 1) {
                ret = DataTypeHelper.toLong(value);
            } else if (valueType == 2) {
                List<String> avList;
                String candidate = DataTypeHelper.toString(value);
                String[] allowableValues = attribute.getValues();
                if (allowableValues != null && (avList = Arrays.asList(allowableValues)).contains(candidate)) {
                    ret = candidate;
                }
                if (ret == null) {
                    ret = DataTypeHelper.toLong(value);
                }
            } else {
                ret = DataTypeHelper.toString(value);
            }
        }
        return ret;
    }

    @Deprecated
    public static String getDDL(DataTypeUsage dtu) {
        return DataTypeHelper.getDDL(dtu, null);
    }

    public static String getDDL(DataTypeUsage dtu, DBObjectProvider pro) {
        DBObjectID dataTypeID;
        String retval = null;
        if (dtu != null && (dataTypeID = dtu.getDataTypeID()) != null) {
            if (dataTypeID instanceof BaseObjectID) {
                String typeString = DataTypeHelper.getTypeStringFromID(dataTypeID, null, pro);
                retval = DataTypeHelper.getTypeDDL(dtu, typeString);
            } else {
                try {
                    DataType dt = DataTypeHelper.getDataType(dtu, false);
                    retval = dt != null ? dt.getDDL(dtu) : DataTypeHelper.getTypeStringFromID(dataTypeID, null, pro);
                }
                catch (DBException dbe) {
                    DataTypeHelper.getLogger().warning("Couldn't resolve datatype ID for DDL: " + dbe.getMessage());
                }
            }
        }
        return retval;
    }

    public static boolean canGetTypeStringFromID(DBObjectID id) {
        DBObject type = null;
        try {
            type = id.resolveID();
        }
        catch (DBException e) {
            type = null;
        }
        if (type instanceof DataType) {
            return true;
        }
        if (id instanceof ReferenceID) {
            return "DATATYPE".equals(id.getType());
        }
        return false;
    }

    @Deprecated
    public static String getTypeStringFromID(DBObjectID typeID, Schema defaultSchema) {
        return DataTypeHelper.getTypeStringFromID(typeID, defaultSchema, null);
    }

    public static String getTypeStringFromUsage(DataTypeUsage typeUsage, Schema defaultSchema, DBObjectProvider pro) {
        String retval = typeUsage == null ? null : DataTypeHelper.getTypeStringFromID(typeUsage.getDataTypeID(), defaultSchema, pro);
        return retval;
    }

    public static String getTypeStringFromID(DBObjectID typeID, Schema defaultSchema, DBObjectProvider pro) {
        StringBuilder retval = new StringBuilder();
        String pubName = pro == null ? null : pro.getDescriptor().getPublicSchemaName();
        String defaultSchemaName = defaultSchema == null ? null : defaultSchema.getName();
        DBObject type = null;
        if (pro != null && typeID instanceof BaseObjectID && "UNSPECIFIED_TYPE".equals(typeID.getType())) {
            type = pro.getDataType(((BaseObjectID)typeID).getName());
        }
        if (typeID != null && type == null) {
            try {
                type = typeID.resolveID();
            }
            catch (DBException e) {
                DataTypeHelper.getLogger().warning(e.getMessage());
            }
        }
        if (type != null) {
            retval.append(DataTypeHelper.getExternalName(type, pro));
            DBObject parent = type;
            while (parent.getParent() != null) {
                parent = parent.getParent();
                retval.insert(0, ".");
                retval.insert(0, DataTypeHelper.getExternalName(parent, pro));
            }
            if (parent instanceof SchemaObject) {
                String schemaName;
                Schema schema = ((SchemaObject)parent).getSchema();
                String string = schemaName = schema == null ? null : schema.getName();
                if (ModelUtil.hasLength((String)schemaName) && ModelUtil.areDifferent((Object)schemaName, (Object)defaultSchemaName) && ModelUtil.areDifferent((Object)schemaName, (Object)pubName)) {
                    retval.insert(0, ".");
                    retval.insert(0, DataTypeHelper.getExternalName(schemaName, "SCHEMA", pro));
                }
            }
        } else if (typeID instanceof BaseObjectID) {
            String schemaName;
            DBObjectID nextID = typeID;
            boolean addDot = false;
            while (nextID instanceof BaseObjectID) {
                if (addDot) {
                    retval.insert(0, ".");
                }
                retval.insert(0, DataTypeHelper.getExternalName((BaseObjectID)nextID, pro));
                addDot = true;
                if (nextID.getParent() == null) break;
                nextID = nextID.getParent();
            }
            if (nextID instanceof BaseObjectID && ModelUtil.hasLength((String)(schemaName = ((BaseObjectID)nextID).getSchemaName())) && ModelUtil.areDifferent((Object)schemaName, (Object)defaultSchemaName) && ModelUtil.areDifferent((Object)schemaName, (Object)pubName)) {
                retval.insert(0, ".");
                retval.insert(0, DataTypeHelper.getExternalName(schemaName, "SCHEMA", pro));
            }
        }
        return retval.toString();
    }

    private static String getExternalName(DBObject obj, DBObjectProvider pro) {
        String retval = obj instanceof PredefinedDataType ? obj.getName() : DataTypeHelper.getExternalName(obj.getName(), obj.getType(), pro);
        return retval;
    }

    private static String getExternalName(BaseObjectID id, DBObjectProvider pro) {
        return DataTypeHelper.getExternalName(id.getName(), id.getType(), pro);
    }

    private static String getExternalName(String name, String type, DBObjectProvider pro) {
        String retval = name;
        if (pro != null) {
            retval = pro.getExternalName(retval, type);
        }
        return retval;
    }

    public static String getTypeDDL(DataTypeUsage dataTypeUsage, String typeString) {
        StringBuilder fsb = new StringBuilder();
        if (dataTypeUsage.hasAttributeValue("ref")) {
            fsb.append("REF ");
        }
        fsb.append(typeString);
        Object id = dataTypeUsage.getAttributeValue("ref_scope");
        if (id instanceof BaseObjectID) {
            String tabName;
            DBObjectProvider pro = ((BaseObjectID)id).getProvider();
            fsb.append(" SCOPE IS ");
            String schemaName = ((BaseObjectID)id).getSchemaName();
            if (ModelUtil.hasLength((String)schemaName)) {
                if (pro != null) {
                    schemaName = pro.getExternalName(schemaName);
                }
                fsb.append(schemaName).append(".");
            }
            if ((tabName = ((BaseObjectID)id).getName()) != null && pro != null) {
                tabName = pro.getExternalName(tabName);
            }
            fsb.append(tabName);
        }
        return fsb.toString();
    }

    @Deprecated
    public static String getTypeStringFromRef(PlSqlReference ref, Schema defaultSchema) {
        return DataTypeHelper.getTypeStringFromRef(ref, defaultSchema, null);
    }

    public static String getTypeStringFromRef(PlSqlReference ref, Schema defaultSchema, DBObjectProvider pro) {
        StringBuilder sb = new StringBuilder(DataTypeHelper.getTypeStringFromID(ref.getReferenceID(), defaultSchema, pro));
        if (ref.getReferenceType() == PlSqlReference.ReferenceType.PCT_ROWTYPE) {
            sb.append("%ROWTYPE");
        }
        if (ref.getReferenceType() == PlSqlReference.ReferenceType.PCT_TYPE) {
            sb.append("%TYPE");
        }
        if (ref.getReferenceType() == PlSqlReference.ReferenceType.REF) {
            sb.insert(0, "REF ");
        }
        return sb.toString();
    }

    public static PlSqlReference getDataTypeRefForString(DBObjectProvider provider, Schema defaultSchema, String usageString) {
        PlSqlReference ref = provider != null ? provider.getObjectFactory().newObject(PlSqlReference.class) : new PlSqlReference();
        PlSqlReference.ReferenceType refType = PlSqlReference.ReferenceType.DIRECT;
        PlSqlToken tk = PlSqlTokenizer.tokenize((String)usageString, (String[])new String[0]);
        if (tk.matches("ref")) {
            refType = PlSqlReference.ReferenceType.REF;
            tk = (PlSqlToken)tk.getNextCodeToken();
        }
        PlSqlToken end = tk;
        while (end.getType() != Token.Type.END_MARKER) {
            end = (PlSqlToken)end.getNextToken();
        }
        if ((end = (PlSqlToken)end.getPrevCodeToken()).matches("TYPE") && ((PlSqlToken)end.getPrevCodeToken()).matches("%")) {
            refType = PlSqlReference.ReferenceType.PCT_TYPE;
            end = (PlSqlToken)end.getPrevCodeToken();
            end = (PlSqlToken)end.getPrevCodeToken();
        } else if (end.matches("ROWTYPE") && ((PlSqlToken)end.getPrevCodeToken()).matches("%")) {
            refType = PlSqlReference.ReferenceType.PCT_ROWTYPE;
            end = (PlSqlToken)end.getPrevCodeToken();
            end = (PlSqlToken)end.getPrevCodeToken();
        }
        String dtuSource = tk.getSource(true, (Token)end);
        ref.setName("datatype");
        ref.setDataTypeUsageSource(dtuSource);
        if (provider == null) {
            DataTypeUsage dtu = DataTypeHelper.getDataTypeUsageForString(provider, defaultSchema, dtuSource);
            if (refType == PlSqlReference.ReferenceType.REF) {
                dtu.putAttributeValue("ref", Boolean.TRUE);
            }
            ref.setDataTypeUsage(dtu);
        }
        ref.setReferenceType(refType);
        return ref;
    }

    public static DBObjectID findOrCreateIDForTypeString(DBObjectProvider provider, Schema defaultSchema, String typeString) {
        if (!ModelUtil.hasLength((String)typeString)) {
            return null;
        }
        DBObjectID retval = DataTypeHelper.findIDForTypeString(provider, defaultSchema, typeString);
        if (retval == null) {
            retval = DataTypeHelper.createReferenceIDForTypeString(provider, defaultSchema, typeString);
        }
        return retval;
    }

    public static DBObjectID createReferenceIDForTypeString(DBObjectProvider provider, Schema defaultSchema, String typeString) {
        PlSqlToken startTk;
        DBObjectID retval = null;
        PlSqlToken tk = startTk = PlSqlTokenizer.tokenize((String)typeString, (String[])new String[0]);
        PlSqlToken endTk = null;
        while (tk.getType() != Token.Type.END_MARKER) {
            tk = (PlSqlToken)tk.getNextToken();
        }
        endTk = (PlSqlToken)tk.getPrevCodeToken();
        try {
            String tokenStr = provider.getInternalName(startTk.getSource(true));
            Schema schema = provider.getSchema(tokenStr);
            boolean qualified = ((PlSqlToken)startTk.getNextCodeToken()).matches(".");
            if (schema != null && qualified) {
                startTk = (PlSqlToken)startTk.getNextCodeToken(2);
            } else {
                if (schema == null) {
                    schema = defaultSchema;
                }
                if (schema == null) {
                    schema = provider.getDefaultSchema();
                }
            }
            String typeName = ((PlSqlToken)startTk.getNextCodeToken()).getType() == Token.Type.END_MARKER ? provider.getInternalName(startTk.getSource(true)) : startTk.getSource(true, (Token)endTk);
            if (provider != null && schema != null) {
                String schemaName = schema.getName();
                DBObjectCriteria<Type> typeCrit = new DBObjectCriteria<Type>(Type.class, new String[0]);
                typeCrit.setName(typeName);
                typeCrit.setSchemaName(schemaName);
                Type builtIn = provider.getDescriptor().getBuiltInObject(typeCrit);
                if (builtIn != null) {
                    retval = builtIn.getID();
                }
            }
            if (retval == null) {
                ReferenceID refID = new ReferenceID("DATATYPE", qualified ? schema : null, typeName);
                refID.setProvider(provider);
                retval = refID;
            }
        }
        catch (DBException e) {
            DataTypeHelper.getLogger().warning(e.getMessage());
        }
        return retval;
    }

    public static DBObjectID findIDForTypeString(DBObjectProvider provider, Schema defaultSchema, String typeString) {
        PlSqlToken startTk;
        DataType userDataType = null;
        if (!ModelUtil.hasLength((String)typeString)) {
            return null;
        }
        DBObjectID retval = null;
        PlSqlToken tk = startTk = PlSqlTokenizer.tokenize((String)typeString, (String[])new String[0]);
        PlSqlToken endTk = null;
        while (tk.getType() != Token.Type.END_MARKER) {
            tk = (PlSqlToken)tk.getNextToken();
        }
        endTk = (PlSqlToken)tk.getPrevCodeToken();
        DataType dt = provider.getDataType(startTk.getSource(true, (Token)endTk));
        if (dt != null) {
            if (dt instanceof UserDataType) {
                userDataType = dt;
            } else {
                return dt.getID();
            }
        }
        if (startTk.matches("REF")) {
            throw new IllegalArgumentException("refs not done like this any more");
        }
        if (userDataType != null) {
            return userDataType.getID();
        }
        if (provider.supportsObjectType("PROCEDURE") || provider.supportsObjectType("TYPE")) {
            Schema schema = defaultSchema;
            try {
                if (schema == null) {
                    schema = provider.getDefaultSchema();
                }
            }
            catch (DBException e) {
                DataTypeHelper.getLogger().warning(e.getMessage());
            }
            if (schema != null) {
                retval = DataTypeHelper.findObjectID(provider, schema, startTk);
            }
            if (retval == null) {
                try {
                    schema = provider.getSchema(provider.getInternalName(startTk.getSource(true)));
                    if (schema != null && ((PlSqlToken)startTk.getNextCodeToken()).matches(".")) {
                        retval = DataTypeHelper.findObjectID(provider, schema, (PlSqlToken)startTk.getNextCodeToken(2));
                    }
                }
                catch (DBException e) {
                    DataTypeHelper.getLogger().warning(e.getMessage());
                }
            }
        }
        return retval;
    }

    public static DataTypeUsage getDataTypeUsage(DBObjectProvider provider, Schema defaultSchema, String typeName, int size, int precision, int scale) {
        DataTypeUsage retval = null;
        DataType dataType = provider.getDataType(typeName);
        if (dataType == null) {
            DBObjectID id = DataTypeHelper.findIDForTypeString(provider, defaultSchema, typeName);
            if (id != null) {
                retval = new DataTypeUsage();
                retval.setDataTypeID(id);
            }
        } else {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("name", typeName);
            attributes.put("size", DataTypeHelper.getAttributeValue(size, dataType, "size"));
            attributes.put("precision", DataTypeHelper.getAttributeValue(precision, dataType, "precision"));
            attributes.put("scale", DataTypeHelper.getAttributeValue(scale, dataType, "scale"));
            retval = dataType.createUsage(attributes);
        }
        return retval;
    }

    public static DataTypeUsage getDataTypeUsageForString(DBObjectProvider provider, Schema defaultSchema, String usageString) {
        return DataTypeHelper.getDataTypeUsageForString(provider, defaultSchema, usageString, false);
    }

    public static DataTypeUsage getDataTypeUsageForString(DBObjectProvider provider, Schema defaultSchema, String usageString, boolean strict) {
        DBObjectID id;
        DataTypeUsage dtu = null;
        if (ModelUtil.hasLength((String)usageString)) {
            for (DataType dt : provider.listSupportedDataTypes()) {
                if (!dt.matches(usageString)) continue;
                dtu = dt.createUsage(usageString);
                break;
            }
        }
        if (!(dtu != null || (id = strict ? DataTypeHelper.findIDForTypeString(provider, defaultSchema, usageString) : DataTypeHelper.findOrCreateIDForTypeString(provider, defaultSchema, usageString)) == null || id instanceof DataTypeID && !ModelUtil.hasLength((String)((DataTypeID)id).getSchemaName()) && strict)) {
            dtu = new DataTypeUsage();
            dtu.setDataTypeID(id);
        }
        return dtu;
    }

    private static DBObjectID findObjectID(DBObjectProvider provider, DBObject parent, PlSqlToken tk) {
        String tokVal = provider.getInternalName(tk.getSource(true));
        if (parent instanceof Schema) {
            for (String objType : DataTypeHelper.getOrderedTypes(provider, "TYPE", "TABLE")) {
                SchemaObject so = null;
                try {
                    so = provider.getObject(objType, (Schema)parent, tokVal);
                }
                catch (DBException e) {
                    so = null;
                }
                if (so == null) continue;
                if (((PlSqlToken)tk.getNextCodeToken()).getType() == Token.Type.END_MARKER) {
                    return so.getID();
                }
                if (((PlSqlToken)tk.getNextCodeToken()).matches(".")) {
                    return DataTypeHelper.findObjectID(provider, so, (PlSqlToken)tk.getNextCodeToken(2));
                }
                return null;
            }
        } else {
            for (DBObject kid : parent.getOwnedObjects()) {
                if (kid.getName() == null || !kid.getName().equals(tokVal)) continue;
                if (((PlSqlToken)tk.getNextCodeToken()).getType() == Token.Type.END_MARKER) {
                    return kid.getID();
                }
                if (((PlSqlToken)tk.getNextCodeToken()).matches(".")) {
                    return DataTypeHelper.findObjectID(provider, kid, (PlSqlToken)tk.getNextCodeToken(2));
                }
                return null;
            }
        }
        return null;
    }

    private static String[] getOrderedTypes(DBObjectProvider provider, String ... topTypes) {
        ArrayList<String> types = new ArrayList<String>();
        for (String type : provider.listObjectTypes()) {
            types.add(type);
        }
        for (int i = topTypes.length - 1; i >= 0; --i) {
            if (!types.contains(topTypes[i])) continue;
            types.remove(topTypes[i]);
            types.add(0, topTypes[i]);
        }
        return types.toArray(new String[types.size()]);
    }

    static TokenPattern buildSearch(String definition, DataTypeAttribute[] attributes) {
        TokenPattern retval = null;
        HashMap<String, DataTypeAttribute> attrMap = new HashMap<String, DataTypeAttribute>();
        for (DataTypeAttribute dta : attributes) {
            attrMap.put(dta.getName(), dta);
        }
        try {
            String[] names;
            String defWithSpaces = definition.replace("\\<", " \\< ");
            String pass1 = defWithSpaces.replaceAll("([^\\\\])\\>", "$1?>");
            String pass2 = defWithSpaces;
            TokenPattern s = new TokenPattern(pass1);
            for (String name : names = s.getNames()) {
                StringBuffer sb1 = new StringBuffer();
                sb1.append("<").append(name).append(">");
                StringBuffer sb2 = new StringBuffer();
                DataTypeAttribute dta = (DataTypeAttribute)attrMap.get(name);
                String[] values = dta.getValues();
                if (dta != null && values != null && values.length > 0) {
                    sb2.append("<").append(name).append(" {");
                    for (int i = 0; i < values.length; ++i) {
                        sb2.append(values[i]);
                        if (i >= values.length - 1) continue;
                        sb2.append("|");
                    }
                    sb2.append("}>");
                } else {
                    int valueType = dta.getValueType();
                    String end = valueType == 1 || valueType == 2 ? " [{-|+}]?>" : (valueType == 3 ? " {?}...>" : " ?>");
                    sb2.append("<").append(name).append(end);
                }
                pass2 = pass2.replace(sb1.toString(), sb2.toString());
            }
            retval = new TokenPattern(DataTypeHelper.addTail(pass2));
        }
        catch (IllegalArgumentException e) {
            DataTypeHelper.getLogger().severe("Cannot create PlSqlSearch based on PredefinedDataType definition " + definition + " - " + e.getMessage());
        }
        return retval;
    }

    static DataTypeUsage getUsageFromString(DataType dt, TokenPattern search, String usageString) {
        DataTypeUsage retval = null;
        HashMap<String, Object> attributeValues = new HashMap<String, Object>();
        TokenPattern.PatternResult res = DataTypeHelper.matches(search, usageString);
        if (res != null) {
            for (String name : search.getNames()) {
                DataTypeAttribute dta = dt.getDataTypeAttribute(name);
                if (dta == null) continue;
                String valueStr = res.getNamedMatch(name, false);
                Object value = valueStr;
                if (valueStr != null) {
                    value = DataTypeHelper.getAttributeValue(valueStr, dt, name);
                }
                attributeValues.put(name, value);
            }
            retval = dt.createUsage(attributeValues);
        }
        return retval;
    }

    static TokenPattern.PatternResult matches(TokenPattern search, String usageString) {
        return search == null ? null : search.getResult(DataTypeHelper.addTail(usageString));
    }

    private static String addTail(String str) {
        return str + " \\";
    }

    @Deprecated
    public static boolean isXMLType(DataType type) {
        return XMLTypeColumnProperties.isXMLType(type);
    }

    public static boolean isTableType(DataType type) {
        PlSqlSearch tableTypeSearch;
        boolean retval = false;
        if (type instanceof Type && (tableTypeSearch = new PlSqlSearch("[create [ or replace] ] type ?. [oid ?] {is|as} table of")).matches(((Type)type).getSource())) {
            retval = true;
        }
        return retval;
    }

    public static boolean isTypeOf(DataType dataType, Class<? extends DataType> dataTypeClz) {
        return DataTypeHelper.unwrapDataType(dataType, dataTypeClz) != null;
    }

    public static <D extends DataType> D unwrapDataType(DataType dataType, Class<D> dataTypeClz) {
        while (dataType instanceof DataTypeSynonym) {
            dataType = ((DataTypeSynonym)dataType).getBaseType();
        }
        DataType retval = null;
        if (dataType != null && dataTypeClz.isAssignableFrom(dataType.getClass())) {
            retval = (DataType)dataTypeClz.cast(dataType);
        }
        return (D)retval;
    }

    public static PredefinedDataType.ValueType getValueType(DataType dataType) {
        PredefinedDataType base = DataTypeHelper.unwrapDataType(dataType, PredefinedDataType.class);
        return base == null ? null : base.getValueType();
    }

    public static boolean isNumericType(DataType dataType) {
        return PredefinedDataType.ValueType.isNumericType(DataTypeHelper.getValueType(dataType));
    }
}

