/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.Column;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.util.ModelUtil;

public class View
extends Relation
implements SQLQueryOwner {
    public static final String TYPE = "VIEW";
    @Deprecated
    public static final String READ_ONLY = "WITH READ ONLY";
    @Deprecated
    public static final String CHECK_OPTION = "WITH CHECK OPTION";

    public View() {
        this((String)null, (Schema)null);
    }

    public View(String name, Schema schema) {
        super(name, schema);
        this.setForceOnCreate(false);
    }

    @TextProperty(multiLine=true)
    @Internal
    public String getViewText() {
        SQLQuery query = this.getSQLQuery();
        if (query == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(query.getSQLText().trim());
        Restriction restriction = this.getRestriction();
        if (restriction != null) {
            builder.append("\n");
            builder.append("WITH ");
            builder.append(restriction.toString());
        }
        return builder.toString();
    }

    public void setViewText(String text) {
        Restriction restriction;
        SQLQuery query;
        if (text == null) {
            query = null;
            restriction = null;
        } else if (text.trim().endsWith(READ_ONLY)) {
            query = new SQLQuery(text.substring(0, text.lastIndexOf(READ_ONLY)).trim());
            restriction = Restriction.READ_ONLY;
        } else if (text.trim().endsWith(CHECK_OPTION)) {
            query = new SQLQuery(text.substring(0, text.lastIndexOf(CHECK_OPTION)).trim());
            restriction = Restriction.CHECK_OPTION;
        } else {
            query = new SQLQuery(text);
            restriction = null;
        }
        this.setSQLQuery(query);
        this.setRestriction(restriction);
    }

    @Override
    public SQLQuery getSQLQuery() {
        return (SQLQuery)this.getProperty("SQLQuery");
    }

    @Override
    public void setSQLQuery(SQLQuery query) {
        this.setProperty("SQLQuery", query);
    }

    @Override
    @Derived(value="SQLQuery")
    public Column[] getColumns() {
        return super.getColumns();
    }

    @Override
    public boolean isDeclarative() {
        SQLQuery query = this.getSQLQuery();
        return query != null && query.isDeclarative();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Nullable(value=Nullable.NullBehaviour.NULLABLE)
    public Restriction getRestriction() {
        return (Restriction)((Object)this.getProperty("restriction"));
    }

    public void setRestriction(Restriction restriction) {
        this.setProperty("restriction", (Object)restriction);
    }

    @Deprecated
    public String getQueryRestriction() {
        Restriction restriction = this.getRestriction();
        return restriction != null ? restriction.toString() : null;
    }

    @Deprecated
    @Transient
    public void setQueryRestriction(String restriction) {
        if (!ModelUtil.hasLength((String)restriction)) {
            this.setRestriction(null);
        } else {
            String converted = restriction.replaceAll(" ", "_").replaceFirst("WITH_", "");
            this.setRestriction(Restriction.valueOf(converted));
        }
    }

    public boolean isForceOnCreate() {
        return (Boolean)this.getProperty("forceOnCreate", false);
    }

    public void setForceOnCreate(boolean force) {
        this.setProperty("forceOnCreate", force);
    }

    public static enum Restriction {
        READ_ONLY,
        CHECK_OPTION;


        public String toString() {
            return super.toString().replaceAll("_", " ");
        }
    }
}

