/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.ModelUtil;

public class TemporaryObjectID
implements DBObjectID {
    private DBObject m_obj;
    private DBObject m_original;

    private TemporaryObjectID(DBObject obj) {
        this.m_obj = obj;
        this.m_original = null;
    }

    public Object copyTo(Object target) {
        TemporaryObjectID copy = target == null ? new TemporaryObjectID(null) : (TemporaryObjectID)target;
        copy.m_obj = this.m_obj;
        copy.m_original = this.m_original;
        return copy;
    }

    public final boolean equals(Object obj) {
        return obj instanceof DBObjectID && this.equals((DBObjectID)obj, true);
    }

    @Override
    public boolean equals(DBObjectID other, boolean strict) {
        boolean retval;
        if (other == null) {
            retval = false;
        } else if (other instanceof TemporaryObjectID) {
            retval = this.equalsImpl((TemporaryObjectID)other, strict);
        } else if (this.m_original != null && other.equals(this.m_original.getID(), strict)) {
            if (strict && other instanceof NameBasedID) {
                String thisName;
                String string = thisName = this.m_obj == null ? null : this.m_obj.getName();
                retval = thisName == null ? true : ModelUtil.areEqual((Object)thisName, (Object)((NameBasedID)other).getName());
            } else {
                retval = true;
            }
        } else {
            retval = !strict && this.isSameTypeAndName(other);
        }
        return retval;
    }

    private boolean equalsImpl(TemporaryObjectID other, boolean strict) {
        boolean retval = this == other || this.m_obj == other.m_obj ? true : (this.m_original == other.m_original ? (this.m_original == null ? this.isSameTypeAndName(other) : true) : (this.isInOriginalHeirachy(other.m_obj) ? true : (other.isInOriginalHeirachy(this.m_obj) ? true : (!strict ? this.isSameTypeAndName(other) : false))));
        return retval;
    }

    private NameBasedID getNameBasedID() {
        PropertyInfo nameInfo;
        NameBasedID thisName = null;
        DBObject obj = null;
        obj = this.m_obj != null && !this.isObjectRemovedFromParent() ? this.m_obj : this.m_original;
        if (obj != null && (nameInfo = PropertyHelper.findPropertyInfo(obj.getClass(), "name", (Class<? extends DBObjectProvider>)null)) != null && (!nameInfo.isInternal() || DBUtil.getFrozenProperties(obj).containsKey("name"))) {
            DBObjectID parID;
            thisName = new NameBasedID(obj, (AbstractDBObjectProvider)null);
            DBObject par = obj.getParent();
            if (par != null && (parID = par.getID()) instanceof TemporaryObjectID) {
                thisName.setParent(((TemporaryObjectID)parID).getNameBasedID());
            }
        }
        return thisName;
    }

    private boolean isObjectRemovedFromParent() {
        boolean retval = false;
        if (this.m_original != null && this.m_obj instanceof ChildDBObject && this.m_obj.getParent() == null && this.m_original.getParent() != null) {
            retval = true;
        }
        return retval;
    }

    private boolean isSameTypeAndName(DBObjectID other) {
        NameBasedID thisName;
        boolean retval = false;
        if (ModelUtil.areEqual((Object)this.getType(), (Object)other.getType()) && (thisName = this.getNameBasedID()) != null) {
            retval = this.isSameName(thisName, other);
        }
        return retval;
    }

    private boolean isSameName(NameBasedID thisName, DBObjectID other) {
        boolean retval = false;
        if (other instanceof TemporaryObjectID) {
            NameBasedID otherName = ((TemporaryObjectID)other).getNameBasedID();
            retval = otherName != null && thisName.equals(otherName, false);
        } else if (other instanceof BaseObjectID) {
            retval = other.equals(thisName, false);
        } else {
            try {
                DBObject otherObj = other.resolveID();
                if (otherObj != null) {
                    NameBasedID otherName = new NameBasedID(otherObj, (AbstractDBObjectProvider)null);
                    retval = otherName.equals(thisName, false);
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger(this).warning("Could not resolve " + other.toString() + " for comparison: " + dbe.getMessage());
            }
        }
        return retval;
    }

    private boolean isInOriginalHeirachy(DBObject other) {
        if (other != null) {
            DBObjectID origID;
            if (other == this.m_original) {
                return true;
            }
            DBObjectID dBObjectID = origID = this.m_original == null ? null : this.m_original.getID();
            if (origID instanceof TemporaryObjectID) {
                return ((TemporaryObjectID)origID).isInOriginalHeirachy(other);
            }
        }
        return false;
    }

    @Override
    public String getType() {
        return this.m_obj.getType();
    }

    @Override
    public DBObjectID getParent() {
        return null;
    }

    @Override
    public DBObject resolveID() throws DBException {
        return this.m_obj;
    }

    public DBObject getOriginalObject() {
        return this.m_original;
    }

    public DBObject getDBObject() {
        return this.m_obj;
    }

    @Deprecated
    public DBObject resolveOriginalID() throws DBException {
        return this.m_original;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("TempObjID:");
        buff.append(this.getType()).append(':');
        if (this.m_original != null) {
            if (this.m_original.getParent() == null && this.m_obj != null && this.m_obj.getParent() != null) {
                buff.append(DBUtil.getFullyQualifiedName(this.m_obj.getParent(), true)).append('.').append(this.m_original.getName());
            } else {
                buff.append(DBUtil.getFullyQualifiedName(this.m_original, true));
            }
            buff.append(" copy ");
        } else if (this.m_obj != null) {
            buff.append(DBUtil.getFullyQualifiedName(this.m_obj, true));
            buff.append(" new ");
        }
        return buff.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static DBObjectID createID(DBObject obj) {
        assert (obj != null);
        return new TemporaryObjectID(obj);
    }

    public static void setID(DBObject obj, boolean recurse) {
        if (obj != null) {
            if (obj.getID() == null) {
                obj.setID(TemporaryObjectID.createID(obj));
            }
            if (recurse && obj instanceof AbstractDBObject) {
                for (DBObject child : ((AbstractDBObject)obj).getPropertySupport().getOwnedObjects(null)) {
                    TemporaryObjectID.setID(child, true);
                }
            }
        }
    }

    public static DBObjectID createID(DBObject obj, DBObject original) {
        assert (obj != null);
        TemporaryObjectID tid = new TemporaryObjectID(obj);
        tid.m_original = original;
        return tid;
    }

    public static DBObjectID findOriginalID(TemporaryObjectID id) {
        if (id.m_original != null) {
            DBObjectID nextID = id.m_original.getID();
            if (nextID == id) {
                throw new IllegalStateException("Infinite TemporaryObjectID loop.");
            }
            if (nextID instanceof TemporaryObjectID) {
                return TemporaryObjectID.findOriginalID((TemporaryObjectID)nextID);
            }
            return nextID;
        }
        return null;
    }

    public static DBObject findOriginalObject(TemporaryObjectID id) {
        DBObjectID origID;
        DBObject retval = id.m_original;
        if (retval != null && (origID = retval.getID()) instanceof TemporaryObjectID) {
            retval = TemporaryObjectID.findOriginalObject((TemporaryObjectID)origID);
        }
        return retval;
    }

    public static <T extends DBObject> T findOriginalObject(T obj) {
        DBObjectID id;
        DBObject retval = null;
        if (obj != null && (id = obj.getID()) instanceof TemporaryObjectID) {
            retval = TemporaryObjectID.findOriginalObject((TemporaryObjectID)id);
        }
        return (T)retval;
    }

    public static <T extends DBObject> T getOriginalObject(T obj) {
        DBObjectID id;
        DBObject retval = null;
        if (obj != null && (id = obj.getID()) instanceof TemporaryObjectID) {
            retval = ((TemporaryObjectID)id).m_original;
        }
        return (T)retval;
    }

    public static class CopyBackPolicy
    extends IDPolicy.DefaultIDPolicy {
        @Override
        protected DBObjectID getNewID(DBObject original, DBObject copy) {
            DBObjectID origID;
            DBObjectID retval = super.getNewID(original, copy);
            if (retval != null && (origID = original.getID()) instanceof TemporaryObjectID && (((TemporaryObjectID)origID).m_original == null || ((TemporaryObjectID)origID).m_original.getID() instanceof TemporaryObjectID)) {
                ((TemporaryObjectID)origID).m_original = copy;
            }
            return retval;
        }
    }

    public static class TemporaryIDPolicy
    extends IDPolicy {
        @Override
        protected DBObjectID getNewID(DBObject original, DBObject copy) {
            return TemporaryObjectID.createID(copy, original);
        }
    }
}

