/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyInfo;

public class SchemaObjectManager
extends CascadeManager {
    private static final DBObjectID[] EMPTY_ID = new DBObjectID[0];
    private boolean m_registeredAll;
    private final Map<DBObjectID, Collection<DBObjectID>> m_deps = this.createIDMap();
    private final Map<DBObjectID, Collection<DBObjectID>> m_soDeps = this.createIDMap();

    public SchemaObjectManager(DBObjectProvider provider) {
        super(provider);
    }

    protected final boolean haveRegisteredAll() {
        return this.m_registeredAll;
    }

    protected void clearAllCaches() {
        this.m_registeredAll = false;
        this.m_deps.clear();
        this.m_soDeps.clear();
    }

    public void registerObject(SystemObject obj) {
        this.registerObject(obj, false);
    }

    public void registerObject(SystemObject obj, boolean loadOnly) {
        if (this.shouldRegister(obj, loadOnly)) {
            this.registerObject(obj, obj);
        }
    }

    protected boolean shouldRegister(SystemObject obj, boolean loadOnly) {
        boolean register = this.m_registeredAll;
        if (!register) {
            register = obj instanceof View || obj instanceof Synonym || obj instanceof Table || obj instanceof Trigger || obj instanceof MaterializedViewLog;
        }
        return register;
    }

    protected final boolean needsInitialization(SystemObject obj) {
        return DBUtil.needsBuilding(obj);
    }

    public void unregisterObject(SystemObject obj) {
        if (this.m_registeredAll) {
            DBObjectID id = obj.getID();
            if (id != null) {
                // empty if block
            }
            this.unregisterImpl(obj);
        }
    }

    @Deprecated
    public DBObjectID[] getSchemaObjectReferers(SystemObject obj, boolean deep) {
        return EMPTY_ID;
    }

    @Override
    public Collection<DBObjectID> listTopLevelReferers(SystemObject obj, CascadeManager.LookupCriteria criteria) throws CancelledException {
        boolean deep = criteria.isRecurse();
        this.checkInit();
        DBObjectID id = obj.getID();
        Collection<DBObjectID> refs = this.getSchemaObjectReferersImpl(id, deep ? this.createIDSet() : null);
        if (obj instanceof Schema) {
            refs = this.includeSchemaObjects((Schema)obj, refs);
        }
        if (criteria.getTypes() != null) {
            Iterator<DBObjectID> iter = refs.iterator();
            while (iter.hasNext()) {
                if (criteria.isRequiredType(iter.next().getType())) continue;
                iter.remove();
            }
        }
        return refs == null ? Collections.emptyList() : refs;
    }

    @Deprecated
    public DBObjectID[] getReferers(DBObject obj) {
        return EMPTY_ID;
    }

    @Override
    public Collection<DBObjectID> listReferers(DBObject obj) throws CancelledException {
        Collection<DBObjectID> retval;
        Collection<DBObjectID> refs;
        DBObjectID topID;
        this.checkInit();
        SystemObject top = DBUtil.findParentOfType(obj, SystemObject.class);
        if (top != null && (topID = top.getID()) != null && (refs = this.getSchemaObjectReferersImpl(top.getID(), null)) != null) {
            for (DBObjectID ref : refs) {
                try {
                    DBObject refObj = ref.resolveID();
                    this.ensureDerivedReferencePropertiesBuilt(refObj);
                }
                catch (CancelledException ce) {
                    throw ce;
                }
                catch (DBException dbe) {
                    this.getLogger().warning(dbe.getMessage());
                }
            }
        }
        return (retval = this.listReferers(obj, null)) == null ? Collections.emptyList() : retval;
    }

    private void ensureDerivedReferencePropertiesBuilt(DBObject obj) throws DBException {
        if (obj != null) {
            PropertyCriteria crit = new PropertyCriteria();
            crit.addPredicate(info -> info.getReferencedClass() != null);
            crit.setInternal(null);
            crit.setDerived(true);
            for (PropertyInfo info2 : this.getProvider().getPropertyManager().getPropertyInfos(obj.getClass(), crit).values()) {
                DBUtil.ensureObjectBuilt(obj, info2.getPropertyName());
            }
            for (DBObject kid : DBUtil.getExistingOwnedObjects(obj)) {
                this.ensureDerivedReferencePropertiesBuilt(kid);
            }
        }
    }

    private Collection<DBObjectID> listReferers(DBObject obj, Collection<DBObjectID> referers) {
        Collection<DBObjectID> refs;
        DBObjectID id = obj.getID();
        if (id != null && (refs = this.m_deps.get(id)) != null) {
            if (referers == null) {
                referers = this.createIDSet();
            }
            referers.addAll(refs);
        }
        for (DBObject kid : DBUtil.getExistingOwnedObjects(obj)) {
            referers = this.listReferers(kid, referers);
        }
        return referers;
    }

    private void unregisterImpl(DBObject obj) {
        DBObjectID id = obj.getID();
        if (id != null) {
            Collection<DBObjectID> referers;
            Collection<DBObjectID> refs = this.getProvider().getObjectFactory().getReferenceIDs(obj);
            for (DBObjectID ref : refs) {
                if (!this.m_deps.containsKey(ref) || (referers = this.m_deps.get(ref)) == null) continue;
                referers.remove(id);
                if (referers.size() >= 1) continue;
                this.m_deps.remove(ref);
            }
            for (DBObject kid : DBUtil.getExistingOwnedObjects(obj)) {
                this.unregisterImpl(kid);
            }
            if (obj instanceof SystemObject) {
                Iterator<Map.Entry<DBObjectID, Collection<DBObjectID>>> iter = this.m_soDeps.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<DBObjectID, Collection<DBObjectID>> e = iter.next();
                    referers = e.getValue();
                    if (referers == null) continue;
                    referers.remove(id);
                    if (referers.size() >= 1) continue;
                    iter.remove();
                }
            }
        }
    }

    private Collection<DBObjectID> getSchemaObjectReferersImpl(DBObjectID id, Collection<DBObjectID> refs) {
        Collection<DBObjectID> newRefs;
        if (id != null && (newRefs = this.m_soDeps.get(id)) != null && newRefs.size() > 0) {
            if (refs == null) {
                refs = this.createIDSet();
                refs.addAll(newRefs);
            } else {
                for (DBObjectID deepID : newRefs) {
                    if (deepID == null || refs.contains(deepID)) continue;
                    refs.add(deepID);
                    this.getSchemaObjectReferersImpl(deepID, refs);
                }
            }
        }
        return refs;
    }

    private void registerObject(SystemObject key, DBObject obj) {
        Collection<DBObjectID> refs = this.getProvider().getObjectFactory().getReferenceIDs(obj);
        for (DBObjectID ref : refs) {
            if (ref instanceof TemporaryObjectID) {
                this.getLogger().warning("WARNING: attempt to cache temporary ID with the dependency manager");
                continue;
            }
            this.registerDependency(key, obj, ref);
        }
        for (DBObject kid : DBUtil.getExistingOwnedObjects(obj)) {
            this.registerObject(key, kid);
        }
    }

    private void registerSchemaObjectDependency(SystemObject referer, DBObjectID referedTo) {
        DBObjectID id = referer.getID();
        this.addMapping(id, referedTo, this.m_soDeps);
    }

    protected void registerDependency(SystemObject key, DBObject referer, DBObjectID referedTo) {
        DBObjectID id = referer.getID();
        if (!(referedTo instanceof DataTypeID)) {
            this.addMapping(id, referedTo, this.m_deps);
            DBObjectID referedToParent = DBUtil.getUppermostParent(referedTo);
            if (referedToParent != null && key != null) {
                this.registerSchemaObjectDependency(key, referedToParent);
            }
        }
    }

    private void addMapping(DBObjectID id, DBObjectID refID, Map<DBObjectID, Collection<DBObjectID>> deps) {
        if (refID != null && id != null && !refID.equals(id)) {
            this.mapKeyToCollection(refID, id, deps);
        }
    }

    private <K, T> void mapKeyToCollection(K key, T itemForCollection, Map<K, Collection<T>> map) {
        Collection<T> c = map.get(key);
        if (c == null) {
            c = itemForCollection instanceof DBObjectID ? this.createIDSet() : new HashSet<T>();
            map.put(key, c);
        }
        c.add(itemForCollection);
    }

    protected void checkInit() throws CancelledException {
    }

    protected final synchronized void registerAllObjects() throws CancelledException {
        try {
            this.clearAllCaches();
            this.m_registeredAll = true;
            String[] types = this.listObjectTypes();
            Schema[] schemas = this.listSchemas();
            for (int i = 0; i < schemas.length; ++i) {
                this.setRegisterProgress(0, 1, i, schemas.length, schemas[i].getName());
                SchemaObject[] objects = this.getProvider().listObjects(types, schemas[i]);
                for (int j = 0; j < objects.length; ++j) {
                    this.setRegisterProgress(j, objects.length, i, schemas.length, schemas[i].getName());
                    this.registerObject(objects[j]);
                }
            }
        }
        catch (CancelledException ce) {
            throw ce;
        }
        catch (DBException dbe) {
            DBLog.getLogger(this).severe(dbe.getMessage());
            this.m_registeredAll = false;
        }
    }

    protected String[] listObjectTypes() {
        ArrayList<String> retval = new ArrayList<String>();
        String[] t = this.getProvider().listObjectTypes();
        for (int i = 0; i < t.length; ++i) {
            retval.add(t[i]);
        }
        retval.remove("SEQUENCE");
        retval.remove("PACKAGE");
        retval.remove("FUNCTION");
        retval.remove("PROCEDURE");
        return retval.toArray(new String[retval.size()]);
    }

    protected Schema[] listSchemas() throws DBException {
        return this.getProvider().listSchemas();
    }

    protected void setRegisterProgress(int objN, int objT, int schemaN, int schemaT, String schemaName) throws CancelledException {
        CancelledException.checkInterrupt();
    }

    @Deprecated
    public static final SystemObject[] getDependencies(SystemObject obj, DBObjectProvider pro, boolean recurse) {
        return new SystemObject[0];
    }
}

