/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.util.ModelUtil;

public class Index
extends AbstractSchemaObject
implements ChildDBObject {
    public static final String TYPE = "INDEX";
    private transient Table m_table;

    public Index() {
    }

    public Index(String name, Table table) {
        this(name, table == null ? null : table.getSchema(), table);
    }

    public Index(String name, Schema schema) {
        this(name, schema, (Table)null);
    }

    public Index(String name, Schema schema, Table table) {
        super(name, schema);
        this.m_table = table;
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public IndexType getIndexType() {
        return (IndexType)((Object)this.getProperty("indexType"));
    }

    @References(value=Indextype.class, cascade=CascadeAction.NONE)
    public DBObjectID getDomainIndextype() {
        return (DBObjectID)this.getProperty("domainIndextype");
    }

    @TextProperty(multiLine=true)
    public String getDomainIndextypeParameters() {
        return (String)this.getProperty("domainIndextypeParameters");
    }

    public String getDomainIndextypeOpStatus() {
        return (String)this.getProperty("domainIndextypeOpStatus");
    }

    public void setParallelDegree(Integer value) {
        this.setProperty("parallelDegree", value);
    }

    public Integer getParallelDegree() {
        return (Integer)this.getProperty("parallelDegree");
    }

    public void setIndexType(IndexType indexType) {
        this.setProperty("indexType", (Object)indexType);
    }

    public void setDomainIndextype(DBObjectID id) {
        this.setProperty("domainIndextype", id);
    }

    public void setDomainIndextypeParameters(String parameters) {
        this.setProperty("domainIndextypeParameters", parameters);
    }

    public void setDomainIndextypeOpStatus(String status) {
        this.setProperty("domainIndextypeOpStatus", status);
    }

    public void setKeyCompression(Integer keyCompression) {
        this.setProperty("keyCompression", keyCompression);
    }

    public Integer getKeyCompression() {
        return (Integer)this.getProperty("keyCompression");
    }

    public Boolean getReverse() {
        return (Boolean)this.getProperty("reverse");
    }

    public void setReverse(Boolean reverse) {
        this.setProperty("reverse", reverse);
    }

    public void setSystemGenerated(Boolean generated) {
        this.setProperty("systemGenerated", generated);
    }

    public Boolean getSystemGenerated() {
        return (Boolean)this.getProperty("systemGenerated");
    }

    public void setTable(Table table) {
        Table oldTable = this.m_table;
        if (this.m_table != table) {
            this.m_table = table;
            Schema s = this.getSchema();
            if (s != null && this.m_table != null) {
                Schema tabSchema = this.m_table.getSchema();
                if (tabSchema != null && ModelUtil.areEqual((Object)s.getName(), (Object)tabSchema.getName())) {
                    this.setSchema(null);
                }
            } else if (s == null && table == null && oldTable != null) {
                super.setSchema(oldTable.getSchema());
            }
            this.getPropertySupport().setBuilt("table");
        }
    }

    @Internal
    public Table getTable() {
        Index origIdx;
        DBObjectID id;
        this.checkInit("table");
        if (this.m_table == null && (id = this.getID()) instanceof TemporaryObjectID && (origIdx = (Index)TemporaryObjectID.findOriginalObject((TemporaryObjectID)id)) != null) {
            this.m_table = origIdx.m_table;
        }
        return this.m_table;
    }

    @Override
    public void setParent(DBObject par) {
        if (par instanceof Table || par == null) {
            this.setTable((Table)par);
        }
    }

    @Override
    public Object getProperty(String key) {
        Object retval = "parent".equals(key) ? this.m_table : ("table".equals(key) ? this.getTable() : super.getProperty(key));
        return retval;
    }

    @Override
    public void setProperty(String key, Object value) {
        if ("parent".equals(key) || "table".equals(key)) {
            Table oldValue = this.getTable();
            this.setTable((Table)value);
            this.firePropertyChanged(key, oldValue, value);
        } else {
            super.setProperty(key, value);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setColumnExpressions(IndexObject[] colExprs) {
        this.getChildSupport("columnExpressions").setChildArray(colExprs);
    }

    public IndexObject[] getColumnExpressions() {
        return this.getChildSupport("columnExpressions").getChildArray(IndexObject.class);
    }

    public void addColumnExpression(IndexObject colExpr) {
        this.getChildSupport("columnExpressions").addChild(colExpr);
    }

    public void addColumnExpression(int posn, IndexObject colExpr) {
        this.getChildSupport("columnExpressions").addChild(posn, colExpr);
    }

    public void removeColumnExpression(IndexObject colExpr) {
        this.getChildSupport("columnExpressions").removeChild(colExpr);
    }

    @Override
    public DBObject findOwnedObject(DBObjectID id, boolean strict) {
        return this.findOwnedObject(id, strict, true);
    }

    @Override
    public Schema getSchema() {
        Schema s = super.getSchema();
        if (s == null && this.m_table != null) {
            s = this.m_table.getSchema();
        }
        return s;
    }

    @Override
    public void setSchema(Schema s) {
        if (this.m_table == null || !DBUtil.areNamesAndTypesEqual(s, this.m_table.getSchema())) {
            super.setSchema(s);
        } else {
            super.setSchema(null);
        }
    }

    @Override
    protected void copyToImpl(AbstractDBObject copy, DBObject copyParent, IDPolicy idPolicy) {
        this.ensureParentTable((Index)copy, (Table)copyParent);
        super.copyToImpl(copy, copyParent, idPolicy);
        this.ensureParentTable((Index)copy, (Table)copyParent);
    }

    private void ensureParentTable(Index copy, Table copyParent) {
        if (copyParent == null) {
            copyParent = this.m_table;
        }
        if (copyParent != null) {
            copy.setTable(copyParent);
        }
    }

    public static enum IndexType {
        NORMAL,
        UNIQUE,
        BITMAP,
        DOMAIN;


        public static IndexType migrate(String old) {
            try {
                int i = Integer.valueOf(old.toString());
                switch (i) {
                    case 2: {
                        return UNIQUE;
                    }
                    case 3: {
                        return BITMAP;
                    }
                    case 4: {
                        return DOMAIN;
                    }
                }
                return NORMAL;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

