/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.refactoring.CascadeAction;

public class FKConstraint
extends ColumnConstraint {
    public static final String CONSTRAINT_TYPE = "FKConstraint";
    @Deprecated
    public static final int ON_DELETE_RESTRICT = 0;
    @Deprecated
    public static final int ON_DELETE_CASCADE = 1;
    @Deprecated
    public static final int ON_DELETE_SET_NULL = 2;

    public FKConstraint() {
        this((String)null, (Relation)null);
    }

    public FKConstraint(String name, Relation relation) {
        super(name, relation);
    }

    public void setReferenceID(DBObjectID id) {
        this.setProperty("referenceID", id);
    }

    @References(value=UniqueConstraint.class, cascade=CascadeAction.DELETE)
    public DBObjectID getReferenceID() {
        return (DBObjectID)this.getProperty("referenceID");
    }

    @Override
    public String getConstraintType() {
        return CONSTRAINT_TYPE;
    }

    public ReferentialAction getOnDeleteAction() {
        return (ReferentialAction)((Object)this.getProperty("onDeleteAction"));
    }

    public void setOnDeleteAction(ReferentialAction action) {
        this.setProperty("onDeleteAction", (Object)action);
    }

    @Deprecated
    public int getDeleteMode() {
        int retval = 0;
        ReferentialAction action = this.getOnDeleteAction();
        if (action != null) {
            switch (action) {
                case CASCADE: {
                    retval = 1;
                    break;
                }
                case SET_NULL: {
                    retval = 2;
                }
            }
        }
        return retval;
    }

    @Deprecated
    @Transient
    public void setDeleteMode(int onDelete) {
        ReferentialAction action;
        switch (onDelete) {
            case 1: {
                action = ReferentialAction.CASCADE;
                break;
            }
            case 2: {
                action = ReferentialAction.SET_NULL;
                break;
            }
            default: {
                action = ReferentialAction.RESTRICT;
            }
        }
        this.setOnDeleteAction(action);
    }

    public static enum ReferentialAction {
        CASCADE,
        RESTRICT,
        SET_NULL,
        NO_ACTION,
        SET_DEFAULT;


        public String toString() {
            return super.toString().replaceAll("_", " ");
        }
    }
}

