/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ora.ddl.OracleDDLType;
import oracle.javatools.util.ModelUtil;

@Deprecated
public class Ddl {
    public static final String ACO = "ACO";
    public static final String CMT = "CMT";
    public static final String CMC = "CMC";
    public static final String CONUK = "CONUK";
    public static final String CONFK = "CONFK";
    public static final String CONCC = "CONCC";
    public static final String OET = "OET";
    public static final String IOT = "IOT";
    public static final String TP = "TP";
    public static final String LOBP = "LOBP";
    public static final String IND = "IND";
    public static final String MVW = "MVW";
    public static final String MVL = "MVL";
    public static final String SEQ = "SEQ";
    public static final String SYN = "SYN";
    public static final String TAB = "TAB";
    public static final String TRG = "TRG";
    public static final String TRG_DIS = "TRG_DIS";
    public static final String VW = "VW";
    public static final String DROP = "DROP";
    public static final String DROP_XMLSCHEMA = "DROP_XMLSCHEMA";
    public static final String DROPMVL = "DROPMVL";
    public static final String FLASHBACK = "FLASHBACK";
    public static final String DROPCON = "DROPCON";
    public static final String RENTAB = "RENTAB";
    public static final String INCOMPLETE_TYPE = "INCOMPLETE_TYPE";
    public static final String SPEC = "SPEC";
    public static final String EVOLVED_TYPE_ALTER = "EVOLVED_TYPE_ALTER";
    public static final String BODY = "BODY";
    public static final String SPOOLON = "SPOOLON";
    public static final String SPOOLOFF = "SPOOLOFF";
    public static final String SCHEMA = "SCHEMA";
    public static final String GRANT = "GRANT";
    public static final String DATABASELINK = "DATABASELINK";
    public static final String XMLSCHEMA = "XMLSCHEMA";
    public static final String[] s_ddlOrder = new String[]{"DROPCON", "DROPMVL", "DROP", "INCOMPLETE_TYPE", "DATABASELINK", "XMLSCHEMA", "TAB", "ACO", "LOBP", "CONUK", "CONFK", "CONCC", "OET", "IOT", "TP", "VW", "RENTAB", "MVW", "CMT", "CMC", "MVL", "IND", "SEQ", "SYN", "SPEC", "EVOLVED_TYPE_ALTER", "BODY", "TRG", "TRG_DIS", "SCHEMA", "GRANT"};
    public static final HashSet s_ddlTerminatorRequired = new HashSet<String>(Arrays.asList("DROPCON", "DROPMVL", "DROP", "DROP_XMLSCHEMA", "DATABASELINK", "XMLSCHEMA", "TAB", "VW", "MVW", "MVL", "ACO", "LOBP", "CONUK", "CONFK", "CONCC", "OET", "IOT", "TP", "CMT", "CMC", "RENTAB", "IND", "SEQ", "SYN", "TRG_DIS", "SCHEMA", "GRANT", "EVOLVED_TYPE_ALTER"));
    private static final String NEWLINE = "\n";
    private Map<String, Object> m_map = new HashMap<String, Object>();
    private String m_sqlTerminator = ";\n";

    @Deprecated
    public Ddl() {
    }

    public void setSqlTerminator(String terminator) {
        this.m_sqlTerminator = terminator;
    }

    public String getSqlTerminator() {
        return this.m_sqlTerminator;
    }

    public boolean isArray(String ddlType) {
        boolean result = false;
        Object o = this.m_map.get(ddlType);
        if (null != o) {
            result = this.m_map.get(ddlType).getClass().isArray();
        }
        return result;
    }

    public boolean containsKey(String key) {
        return this.m_map.containsKey(key);
    }

    public void put(String key, String sql) {
        this.m_map.put(key, sql);
    }

    public void putOne(String key, String sql) {
        if (!this.m_map.containsKey(key)) {
            this.m_map.put(key, sql);
        }
    }

    public void put(String key, String[] sqla) {
        this.m_map.put(key, sqla);
    }

    public void put(String key, Collection sqla) {
        if (sqla.size() > 0) {
            String[] stringArray = new String[]{};
            stringArray = sqla.toArray(stringArray);
            this.put(key, stringArray);
        }
    }

    public String get(String key) {
        String result = null;
        Object o = this.m_map.get(key);
        if (this.isArray(key)) {
            StringBuffer fsb = new StringBuffer();
            String[] sa = (String[])o;
            boolean separatorRequired = false;
            for (String stmt : sa) {
                if (!ModelUtil.hasLength((String)stmt)) continue;
                if (separatorRequired) {
                    if (s_ddlTerminatorRequired.contains(key) && fsb.lastIndexOf(this.m_sqlTerminator) != fsb.length() - this.m_sqlTerminator.length()) {
                        fsb.append(this.m_sqlTerminator);
                    }
                    fsb.append(NEWLINE);
                }
                fsb.append(stmt);
                separatorRequired = true;
            }
            result = fsb.toString();
        } else {
            result = (String)o;
        }
        return result;
    }

    public String getOne(String key) {
        String result = null;
        if (this.isArray(key)) {
            String[] array = (String[])this.m_map.get(key);
            result = array[0];
        } else {
            result = (String)this.m_map.get(key);
        }
        return result;
    }

    public String[] getArray(String key) {
        String[] result = null;
        Object o = this.m_map.get(key);
        if (null != o) {
            if (this.isArray(key)) {
                result = (String[])o;
            } else {
                String[] sa = new String[]{(String)o};
                result = sa;
            }
        }
        return result;
    }

    public String[] getArrayTrimSlash(String key) {
        String[] result = this.getArray(key);
        if (null != result && (INCOMPLETE_TYPE.equals(key) || SPEC.equals(key) || BODY.equals(key) || TRG.equals(key))) {
            for (int j = 0; j < result.length; ++j) {
                String s = result[j];
                if (!s.trim().endsWith("/")) continue;
                result[j] = s.substring(0, s.lastIndexOf(47));
            }
        }
        return result;
    }

    public List getArrayList(String key) {
        String[] list = this.getArray(key);
        return list == null ? Collections.emptyList() : Arrays.asList(list);
    }

    public String getCreateTable() {
        return this.get(TAB);
    }

    public String[] getAddConstraints() {
        ArrayList oa = new ArrayList();
        if (this.containsKey(CONUK)) {
            oa.addAll(this.getArrayList(CONUK));
        }
        if (this.containsKey(CONFK)) {
            oa.addAll(this.getArrayList(CONFK));
        }
        if (this.containsKey(CONCC)) {
            oa.addAll(this.getArrayList(CONCC));
        }
        return oa.toArray(new String[0]);
    }

    public Set keySet() {
        return this.m_map.keySet();
    }

    public String getDdl() {
        return this.getDdl(true);
    }

    public String getDdl(boolean addTerminators) {
        StringBuffer ddl = new StringBuffer();
        if (this.m_map.containsKey(SPOOLON)) {
            ddl.append(this.getOne(SPOOLON));
            ddl.append(NEWLINE);
            ddl.append(NEWLINE);
        }
        for (int i = 0; i < s_ddlOrder.length; ++i) {
            String stmt;
            if (!this.m_map.containsKey(s_ddlOrder[i]) || !ModelUtil.hasLength((String)(stmt = this.get(s_ddlOrder[i])))) continue;
            ddl.append(stmt);
            if (!addTerminators) continue;
            if (s_ddlTerminatorRequired.contains(s_ddlOrder[i]) && ddl.lastIndexOf(this.m_sqlTerminator) != ddl.length() - this.m_sqlTerminator.length()) {
                ddl.append(this.m_sqlTerminator);
            }
            ddl.append(NEWLINE);
        }
        if (this.m_map.containsKey(SPOOLOFF)) {
            ddl.append(this.getOne(SPOOLOFF));
            ddl.append(NEWLINE);
        }
        return ddl.toString();
    }

    public Ddl append(Ddl appendThis) {
        for (String ddlType : appendThis.keySet()) {
            if (this.m_map.containsKey(ddlType)) {
                String[] stringArray = new String[2];
                ArrayList<String> a = new ArrayList<String>(Arrays.asList(this.getArray(ddlType)));
                a.addAll(Arrays.asList(appendThis.getArray(ddlType)));
                this.put(ddlType, a.toArray(stringArray));
                continue;
            }
            if (appendThis.isArray(ddlType)) {
                this.put(ddlType, appendThis.getArray(ddlType));
                continue;
            }
            this.put(ddlType, appendThis.get(ddlType));
        }
        return this;
    }

    public Ddl stripPrompts() {
        Ddl result = new Ddl();
        for (String key : this.m_map.keySet()) {
            String[] sql = this.getArray(key);
            ArrayList<String> newSql = new ArrayList<String>();
            for (int j = 0; j < sql.length; ++j) {
                if (sql[j].startsWith("PROMPT")) {
                    int np = sql[j].indexOf(NEWLINE);
                    String noPrompt = null;
                    if (np > 0) {
                        noPrompt = sql[j].substring(np + 1);
                    }
                    if (!ModelUtil.hasLength(noPrompt)) continue;
                    newSql.add(noPrompt);
                    continue;
                }
                newSql.add(sql[j]);
            }
            if (newSql.size() <= 0) continue;
            result.put(key, newSql.toArray(new String[0]));
        }
        return result;
    }

    public DDL<OracleDDLType> convertToNew(DBObject obj) {
        DDL<OracleDDLType> ddl = new DDL<OracleDDLType>(obj);
        for (String type : this.m_map.keySet()) {
            OracleDDLType ddlType = OracleDDLType.getDDLType(type);
            Object val = this.m_map.get(type);
            if (val instanceof String) {
                ddl.append(ddlType, (String)val);
                continue;
            }
            if (!(val instanceof String[])) continue;
            ddl.appendAll(ddlType, Arrays.asList((String[])val));
        }
        return ddl;
    }
}

