/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.diff.DBObjectIDComparator;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceApplier;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class DBUtil
implements Comparator<DBObject> {
    private static Comparator<DBObject> s_typeComparator;
    private static Comparator<DBObject> s_nameComparator;
    private boolean m_compareByType;

    protected DBUtil() {
    }

    private static Logger getLogger() {
        return DBLog.getLogger(DBUtil.class);
    }

    @Override
    public int compare(DBObject o1, DBObject o2) {
        int retval;
        if (o1 == o2) {
            retval = 0;
        } else if (o1 == null) {
            retval = -10;
        } else if (o2 == null) {
            retval = 10;
        } else {
            if (this.m_compareByType) {
                retval = this.compareType(o1, o2);
                if (retval == 0) {
                    retval = this.compareName(o1, o2);
                }
            } else {
                retval = this.compareName(o1, o2);
                if (retval == 0) {
                    retval = this.compareType(o1, o2);
                }
            }
            if (retval == 0) {
                retval = this.compareSchema(o1, o2);
            }
        }
        return retval;
    }

    private int compareName(DBObject o1, DBObject o2) {
        String n2;
        String n1 = o1.getName();
        int retval = n1 == (n2 = o2.getName()) ? 0 : (n1 == null ? -10 : (n2 == null ? 10 : n1.compareTo(n2)));
        return retval;
    }

    private int compareSchema(DBObject o1, DBObject o2) {
        int retval = 0;
        if (o1 instanceof SchemaObject && o2 instanceof SchemaObject) {
            Schema s1 = ((SchemaObject)o1).getSchema();
            Schema s2 = ((SchemaObject)o2).getSchema();
            retval = this.compare(s1, s2);
        }
        return retval;
    }

    private int compareType(DBObject o1, DBObject o2) {
        String t2;
        String t1 = o1.getType();
        int result = t1.compareTo(t2 = o2.getType());
        if (result == 0 && o1 instanceof Constraint) {
            String c1 = ((Constraint)o1).getConstraintType();
            String c2 = ((Constraint)o2).getConstraintType();
            result = c1.compareTo(c2);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DBUtil && ((DBUtil)obj).m_compareByType == this.m_compareByType;
    }

    public int hashCode() {
        return this.m_compareByType ? 0 : 1;
    }

    public static Comparator<DBObject> getTypeComparator() {
        if (s_typeComparator == null) {
            s_typeComparator = new DBUtil();
            ((DBUtil)DBUtil.s_typeComparator).m_compareByType = true;
        }
        return s_typeComparator;
    }

    public static Comparator<DBObject> getNameComparator() {
        if (s_nameComparator == null) {
            s_nameComparator = new DBUtil();
            ((DBUtil)DBUtil.s_nameComparator).m_compareByType = false;
        }
        return s_nameComparator;
    }

    public static Map<DBObjectID, DBObjectID> getTemporaryIDMap(DBObject ... objs) {
        HashMap<DBObjectID, DBObjectID> idMap = new HashMap<DBObjectID, DBObjectID>();
        if (objs != null) {
            for (DBObject obj : objs) {
                DBUtil.poplateTempIDMap(obj, idMap);
            }
        }
        return idMap;
    }

    private static void poplateTempIDMap(DBObject obj, Map<DBObjectID, DBObjectID> idMap) {
        DBObjectID origID;
        DBObject orig;
        DBObjectID newID = obj.getID();
        if (newID instanceof TemporaryObjectID && (orig = ((TemporaryObjectID)newID).getOriginalObject()) != null && (origID = orig.getID()) != null) {
            idMap.put(origID, newID);
        }
        for (DBObject kid : DBUtil.getExistingOwnedObjects(obj)) {
            DBUtil.poplateTempIDMap(kid, idMap);
        }
    }

    public static void resetTemporaryCopy(DBObject copy, DBObject newOrig, DBObject newOrigPar, DBObjectProvider pro) {
        String prop;
        DBObject orig = TemporaryObjectID.getOriginalObject(copy);
        if (newOrig == null && newOrigPar != null && (prop = DBUtil.getParentProperty(copy)) != null) {
            Object val = newOrigPar.getProperty(prop);
            if (val instanceof DBObject) {
                newOrig = (DBObject)val;
            } else if (val instanceof DBObject[]) {
                DatabaseDescriptor desc = pro.getDescriptor();
                newOrig = DBUtil.findChildByNameImpl((DBObject[])val, copy.getName(), desc);
                if (newOrig == null && orig != null) {
                    newOrig = DBUtil.findChildByNameImpl((DBObject[])val, orig.getName(), desc);
                }
            }
        }
        if (orig == null && newOrigPar != null && newOrig != null) {
            newOrig.copyTo(copy, true);
        } else if (orig != null && orig != newOrig) {
            copy.setID(TemporaryObjectID.createID(copy, newOrig));
        }
        for (DBObject child : DBUtil.getExistingOwnedObjects(copy)) {
            DBUtil.resetTemporaryCopy(child, null, newOrig, pro);
        }
    }

    public static <D extends DBObject> D makeTemporaryCopy(D object) {
        DBObject retval = null;
        if (object != null) {
            retval = object.copyTo(null, true);
        }
        return (D)retval;
    }

    public static <D extends DBObject> D makeClonedCopy(D object) {
        DBObject retval = null;
        if (object != null) {
            retval = object.copyTo(null, new IDPolicy.SameIDPolicy());
        }
        return (D)retval;
    }

    public static <T> T copyPropertyValue(T value, DBObject orig, DBObject copy, IDPolicy idPolicy) {
        Object[] retval = null;
        if (value instanceof AbstractDBObject) {
            retval = ((AbstractDBObject)value).copyTo(null, copy, idPolicy);
        } else if (value instanceof Copyable) {
            retval = ((Copyable)value).copyTo(null);
        } else if (value instanceof Object[]) {
            Object[] newArray = (Object[])Array.newInstance(value.getClass().getComponentType(), ((Object[])value).length);
            for (int i = 0; i < newArray.length; ++i) {
                newArray[i] = DBUtil.copyPropertyValue(((Object[])value)[i], orig, copy, idPolicy);
            }
            retval = newArray;
        } else if (value instanceof Map) {
            Object[] newMap = new HashMap();
            for (Map.Entry e : ((Map)value).entrySet()) {
                newMap.put(e.getKey(), DBUtil.copyPropertyValue(e.getValue(), orig, copy, idPolicy));
            }
            retval = newMap;
        } else {
            retval = value;
        }
        return (T)retval;
    }

    public static Map<String, Object> getFrozenProperties(DBObject obj) {
        AbstractBuildableObject.BuildablePropertySupport props = obj instanceof AbstractBuildableObject ? ((AbstractBuildableObject)obj).getPropertySupport() : obj.getProperties();
        return Collections.unmodifiableMap(props);
    }

    public static Collection<DBObject> getExistingOwnedObjects(DBObject obj) {
        return ((AbstractDBObject)obj).getPropertySupport().getOwnedObjects(new String[0]);
    }

    public static Collection<DBObjectID> getExistingReferenceIDs(DBObject obj) {
        ArrayList<DBObjectID> retval = new ArrayList<DBObjectID>();
        ((AbstractDBObject)obj).getPropertySupport().addAllReferenceIDs(retval);
        return retval;
    }

    public static boolean needsBuilding(DBObject obj) {
        if (obj instanceof AbstractBuildableObject) {
            return ((AbstractBuildableObject)obj).needsInitialization();
        }
        return false;
    }

    public static boolean needsBuilding(DBObject obj, String property) {
        if (obj instanceof AbstractBuildableObject) {
            return !((AbstractBuildableObject)obj).isBuilt(property);
        }
        return false;
    }

    public static DBObjectBuilder getDBObjectBuilder(DBObject obj, String prop) {
        DBObjectBuilder retval = null;
        if (obj instanceof AbstractBuildableObject) {
            retval = ((AbstractBuildableObject)obj).getPropertySupport().getBuilder(prop);
        }
        return retval;
    }

    public static void ensureObjectBuilt(DBObject object, String ... props) throws DBException {
        if (object instanceof AbstractBuildableObject) {
            AbstractBuildableObject obj = (AbstractBuildableObject)object;
            if (props == null || props.length == 0) {
                if (obj.needsInitialization()) {
                    obj.getPropertySupport().checkBuiltEx(null);
                }
            } else {
                for (String prop : props) {
                    obj.getPropertySupport().checkBuiltEx(prop);
                }
            }
        }
    }

    public static boolean needsDerivedPropertiesBuilding(DBObjectProvider pro, DBObject obj) {
        DerivedPropertyBuilder builder;
        if (obj instanceof SQLQueryOwner || obj instanceof SQLQuery) {
            SQLQuery query = null;
            query = obj instanceof SQLQueryOwner ? ((SQLQueryOwner)obj).getSQLQuery() : (SQLQuery)obj;
            if (query != null) {
                return !query.isDeclarative();
            }
        } else if (pro != null && (builder = pro.getObjectFactory().ensureDerivedPropertyBuilder(obj)) != null) {
            PropertyManager propMgr = pro.getPropertyManager();
            Class<?> clz = obj.getClass();
            for (String prop : builder.listBuildableProperties()) {
                PropertyInfo info = propMgr.findPropertyInfo(clz, prop);
                if (info == null || !info.isDerived() || !DBUtil.needsBuilding(obj, info.getPropertyName())) continue;
                return true;
            }
        }
        return false;
    }

    public static void ensureDerivedPropertiesBuilt(DBObject object, DBObjectProvider pro) throws DBException {
        DBUtil.ensureDerivedPropertiesBuilt(object, pro, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureDerivedPropertiesBuilt(DBObject object, DBObjectProvider pro, Collection<? extends SystemObject> extras) throws DBException {
        if (object instanceof SystemObject) {
            DBUtil.ensureObjectBuilt((SystemObject)object, new String[0]);
        }
        if (object != null) {
            DerivedPropertyBuilder dpb = pro.getObjectFactory().ensureDerivedPropertyBuilder(object);
            for (AbstractBuildableObject buildable : DBUtil.findChildren(object, AbstractBuildableObject.class)) {
                boolean setExtras = false;
                try {
                    if (dpb instanceof AbstractSQLQueryBuilder && extras != null && !extras.isEmpty()) {
                        setExtras = true;
                        ((AbstractSQLQueryBuilder)dpb).setExtraObjects(extras);
                    }
                    buildable.getPropertySupport().ensureDerivedPropertiesBuilt();
                }
                finally {
                    if (setExtras) {
                        ((AbstractSQLQueryBuilder)dpb).setExtraObjects(null);
                    }
                }
            }
        }
    }

    public static Collection<DBObjectID> getReferenceIDs(DBObject obj, boolean recurse, IDQuery query, String ... types) {
        IDQueryCriteria crit = new IDQueryCriteria(query);
        crit.setTypes(types);
        crit.setRecurse(recurse);
        return DBUtil.getReferenceIDs(obj, crit);
    }

    public static Collection<DBObjectID> getReferenceIDs(DBObject obj, IDQueryCriteria crit) {
        ArrayList<DBObjectID> refs = new ArrayList<DBObjectID>();
        DBUtil.getReferenceIDsImpl(obj, refs, null, crit);
        return refs;
    }

    public static Collection<Tuple<DBObjectID, DBObject>> getReferenceIDsAndReferers(DBObject obj, boolean recurse, IDQuery query, String ... types) {
        ArrayList<Tuple<DBObjectID, DBObject>> retval = new ArrayList<Tuple<DBObjectID, DBObject>>();
        ArrayList<DBObjectID> refs = new ArrayList<DBObjectID>();
        ArrayList<DBObject> referers = new ArrayList<DBObject>();
        IDQueryCriteria crit = new IDQueryCriteria(query);
        crit.setTypes(types);
        crit.setRecurse(recurse);
        DBUtil.getReferenceIDsImpl(obj, refs, referers, crit);
        for (int i = 0; i < refs.size(); ++i) {
            retval.add((Tuple<DBObjectID, DBObject>)new Tuple(refs.get(i), referers.get(i)));
        }
        return retval;
    }

    private static void getReferenceIDsImpl(DBObject obj, List<DBObjectID> refs, List<DBObject> referers, IDQueryCriteria crit) {
        Collection<DBObjectID> ids = crit.m_existingOnly ? DBUtil.getExistingReferenceIDs(obj) : Arrays.asList(obj.getReferenceIDs());
        for (DBObjectID ref : ids) {
            Object[] types = crit.m_types;
            if (types != null && types.length > 0 && Arrays.binarySearch(types, ref.getType()) < 0 || (crit.m_idQuery != IDQuery.INTERNAL ? crit.m_idQuery == IDQuery.EXTERNAL && DBUtil.isInternalRef(ref, obj) : !DBUtil.isInternalRef(ref, obj))) continue;
            refs.add(crit.m_topLevelOnly ? DBUtil.getUppermostParent(ref) : ref);
            if (referers == null) continue;
            referers.add(obj);
        }
        if (crit.m_recurse) {
            Collection<DBObject> kids = crit.m_existingOnly ? DBUtil.getExistingOwnedObjects(obj) : Arrays.asList(obj.getOwnedObjects());
            for (DBObject owned : kids) {
                DBUtil.getReferenceIDsImpl(owned, refs, referers, crit);
            }
        }
    }

    public static boolean isInternalRef(DBObjectID ref, DBObject obj) {
        DBObject top = DBUtil.getUppermostParent(obj);
        DBObjectID topID = DBUtil.getUppermostParent(ref);
        return topID != null && ModelUtil.areEqual((Object)topID, (Object)top.getID());
    }

    public static boolean replaceReferenceIDs(DBObject obj, Map<? extends DBObjectID, ? extends DBObjectID> idMap) {
        return DBUtil.replaceIDsImpl(obj, idMap, false);
    }

    public static boolean replaceAllIDs(DBObject obj, Map<? extends DBObjectID, ? extends DBObjectID> idMap) {
        return DBUtil.replaceIDsImpl(obj, idMap, true);
    }

    private static boolean replaceIDsImpl(DBObject obj, Map<? extends DBObjectID, ? extends DBObjectID> idMap, boolean incObjectID) {
        boolean retval = false;
        if (idMap != null && !idMap.isEmpty()) {
            DBObjectID id;
            DBObjectID newID;
            if (incObjectID && (newID = idMap.get(id = ((AbstractDBObject)obj).obtainActualID())) != null) {
                obj.setID(newID);
                retval = true;
            }
            retval = obj.replaceReferenceIDs(idMap) || retval;
            for (DBObject kid : DBUtil.getExistingOwnedObjects(obj)) {
                retval = DBUtil.replaceIDsImpl(kid, idMap, incObjectID) || retval;
            }
        }
        return retval;
    }

    public static void updateObjectAndIDs(DBObject oldVersion, DBObject newVersion) {
        newVersion.copyTo(oldVersion, new IDPolicy.SameIDPolicy());
    }

    public static DBObject findOwnedObjectInHierarchy(DBObject top, DBObjectID find) {
        DBObject retval = null;
        if (top != null && top.getID() != null) {
            ArrayList<DBObjectID> stack = new ArrayList<DBObjectID>();
            boolean found = false;
            for (DBObjectID current = find; current != null; current = current.getParent()) {
                if (current.equals(top.getID(), true)) {
                    found = true;
                    break;
                }
                stack.add(0, current);
            }
            if (found) {
                DBObjectID childID;
                DBObject next = top;
                Iterator iterator = stack.iterator();
                while (iterator.hasNext() && (next = next.findOwnedObject(childID = (DBObjectID)iterator.next())) != null) {
                }
                retval = next;
            }
        }
        return retval;
    }

    public static <T extends DBObject> Collection<T> findChildren(DBObject obj, Class<T> clz) {
        ArrayList retval = new ArrayList();
        if (clz != null) {
            DBUtil.findChildrenImpl(retval, obj, clz);
        }
        return retval;
    }

    private static <T extends DBObject> void findChildrenImpl(Collection<T> found, DBObject obj, Class<T> clz) {
        if (clz.isAssignableFrom(obj.getClass())) {
            found.add(clz.cast(obj));
        }
        for (DBObject kid : obj.getOwnedObjects()) {
            DBUtil.findChildrenImpl(found, kid, clz);
        }
    }

    public static <T extends DBObject> T findChildInCopy(DBObject orig, DBObject copy, T origChild) {
        DBObject retval = null;
        if (orig == null || copy == null || origChild == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if (orig == origChild) {
            retval = copy;
        } else {
            ArrayList<Tuple> stack = new ArrayList<Tuple>();
            for (Object origLoop = origChild; origLoop != null; origLoop = origLoop.getParent()) {
                String prop = DBUtil.getParentProperty(origLoop);
                stack.add(new Tuple((Object)prop, origLoop));
                if (origLoop == orig) break;
                if (origLoop != null) continue;
                throw new IllegalArgumentException("origChild isn't in the hierarchy of orig");
            }
            DBObject copyLoop = copy;
            DBObject currentOrig = null;
            for (int i = stack.size() - 1; i >= 0; --i) {
                Tuple p = (Tuple)stack.get(i);
                currentOrig = (DBObject)p.getSecond();
                Object value = copyLoop.getProperty((String)p.getFirst());
                DBObject found = null;
                if (value instanceof DBObject && DBUtil.isTempCopy((DBObject)value, currentOrig)) {
                    found = (DBObject)value;
                } else if (value instanceof Object[]) {
                    for (Object valueChild : (Object[])value) {
                        if (!(valueChild instanceof DBObject) || !DBUtil.isTempCopy((DBObject)valueChild, currentOrig)) continue;
                        found = (DBObject)valueChild;
                    }
                }
                if (found == null) {
                    currentOrig = null;
                    break;
                }
                copyLoop = found;
            }
            if (currentOrig == origChild) {
                retval = copyLoop;
            }
        }
        return (T)retval;
    }

    private static boolean isTempCopy(DBObject copy, DBObject orig) {
        return orig == TemporaryObjectID.getOriginalObject(copy);
    }

    public static String getParentProperty(DBObject object) {
        String retval = null;
        DBObject par = object.getParent();
        if (par != null) {
            Map<String, Object> props = DBUtil.getFrozenProperties(par);
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                boolean found = false;
                Object value = entry.getValue();
                if (value == object) {
                    found = true;
                } else if (value instanceof Object[]) {
                    for (Object child : (Object[])value) {
                        if (child != object) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
                retval = entry.getKey();
                break;
            }
        }
        return retval;
    }

    public static String getPropertyPath(DBObject parent, DBObject child) {
        String retval = null;
        boolean found = false;
        for (DBObject current = child; current != null; current = current.getParent()) {
            if (current == parent) {
                found = true;
                break;
            }
            String nextProp = DBUtil.getParentProperty(current);
            retval = Property.createPath(nextProp, retval);
        }
        return found ? retval : null;
    }

    public static String getUniqueName(Collection<String> existing, String base) {
        return DBUtil.getUniqueName(existing, base, true);
    }

    public static String getUniqueName(Collection<String> existing, String base, boolean increment) {
        String retval = null;
        if (existing == null || !existing.contains(base)) {
            retval = base;
        } else {
            int start = 1;
            int n = base.length() - 1;
            if (increment) {
                Tuple<String, Integer> split = DBUtil.splitBaseName(base);
                base = (String)split.getFirst();
                Integer numFromSplit = (Integer)split.getSecond();
                if (numFromSplit != null) {
                    start = numFromSplit;
                }
            } else if (Character.isDigit(base.charAt(n))) {
                base = base + "_";
            }
            int i = start;
            while (retval == null) {
                String tryThis = base + i;
                if (!existing.contains(tryThis)) {
                    retval = tryThis;
                }
                ++i;
            }
        }
        return retval;
    }

    public static Tuple<String, Integer> splitBaseName(String name) {
        Integer number = null;
        String base = name;
        if (ModelUtil.hasLength((String)name)) {
            int n;
            for (n = base.length() - 1; Character.isDigit(base.charAt(n)) && n > 0; --n) {
            }
            try {
                number = Integer.parseInt(n == 0 ? base : base.substring(n + 1));
                base = n == 0 ? "" : base.substring(0, n + 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Tuple((Object)base, number);
    }

    public static String getUniqueName(Collection<String> existing, String base, boolean increment, int maxLen) {
        if (maxLen > 0 && base.length() > maxLen) {
            base = base.substring(0, maxLen - 1);
            increment = false;
        }
        String uniqueName = null;
        while (uniqueName == null) {
            uniqueName = DBUtil.getUniqueName(existing, base, increment);
            if (maxLen <= 0 || uniqueName.length() <= maxLen) continue;
            uniqueName = null;
            increment = false;
            if ((base = base.substring(0, base.length() - 1)).length() != 0) continue;
            break;
        }
        return uniqueName;
    }

    public static String getFullyQualifiedName(DBObjectID id) {
        return DBUtil.getFullyQualifiedName(id, false);
    }

    public static String getFullyQualifiedName(DBObjectID id, boolean incSchema) {
        String objName;
        String name = null;
        if (id instanceof BaseObjectID && ModelUtil.hasLength((String)(objName = ((BaseObjectID)id).getName()))) {
            name = objName;
            DBObjectID par = id.getParent();
            if (par == null) {
                String dbName;
                String schemaName;
                if (incSchema && ModelUtil.hasLength((String)(schemaName = ((BaseObjectID)id).getSchemaName()))) {
                    name = schemaName + "." + name;
                }
                if (ModelUtil.hasLength((String)(dbName = ((BaseObjectID)id).getDatabaseName()))) {
                    name = name + '@' + dbName;
                }
            } else {
                name = DBUtil.getFullyQualifiedName(par, incSchema) + "." + name;
            }
        }
        if (name == null) {
            try {
                DBObject obj = id.resolveID();
                if (obj != null) {
                    name = DBUtil.getFullyQualifiedName(obj, incSchema);
                }
            }
            catch (DBException dbe) {
                name = null;
            }
        }
        return name;
    }

    public static String getFullyQualifiedName(DBObject obj) {
        return DBUtil.getFullyQualifiedName(obj, false);
    }

    public static String getFullyQualifiedName(DBObject obj, boolean incSchema) {
        Schema schema;
        DBObject par = obj.getParent();
        String name = null;
        name = par == null ? (obj instanceof SchemaObject && incSchema ? ((schema = ((SchemaObject)obj).getSchema()) == null ? "" : schema.getName() + ".") : "") : DBUtil.getFullyQualifiedName(par, incSchema) + ".";
        String objName = obj.getName();
        if (objName != null) {
            name = name + objName;
        }
        return name;
    }

    public static Schema getSchema(DBObject obj) {
        Schema retval = null;
        if (obj instanceof SchemaObject) {
            retval = ((SchemaObject)obj).getSchema();
        } else if (obj != null) {
            DBObject parent = obj.getParent();
            if (parent instanceof Schema) {
                retval = (Schema)parent;
            } else if (parent != null) {
                retval = DBUtil.getSchema(parent);
            }
        }
        return retval;
    }

    public static String getSchemaName(DBObject obj) {
        Schema schema = DBUtil.getSchema(obj);
        return schema == null ? null : schema.getName();
    }

    public static <T extends DBObject> T findParentOfType(DBObject child, Class<T> clz) {
        DBObject retval = null;
        if (child != null) {
            retval = clz.isAssignableFrom(child.getClass()) ? child : DBUtil.findParentOfType(child.getParent(), clz);
        }
        return (T)retval;
    }

    public static SchemaObject getSchemaObject(DBObject obj) {
        return DBUtil.getTopParent(obj, SchemaObject.class);
    }

    public static SystemObject getSystemObject(DBObject obj) {
        return DBUtil.getTopParent(obj, SystemObject.class);
    }

    private static <T extends DBObject> T getTopParent(DBObject obj, Class<T> parClz) {
        if (obj == null) {
            return null;
        }
        DBObject parent = obj.getParent();
        if (parent != null) {
            return DBUtil.getTopParent(parent, parClz);
        }
        if (parClz.isAssignableFrom(obj.getClass())) {
            return (T)((DBObject)parClz.cast(obj));
        }
        return null;
    }

    public static DBObject getUppermostParent(DBObject obj) {
        DBObject parent = obj.getParent();
        if (parent != null) {
            return DBUtil.getUppermostParent(parent);
        }
        return obj;
    }

    public static DBObjectID getUppermostParent(DBObjectID id) {
        DBObjectID parent;
        DBObject parent2;
        DBObjectID topID;
        DBObject obj;
        if (id instanceof TemporaryObjectID && (obj = ((TemporaryObjectID)id).getDBObject()) != null && (topID = (parent2 = DBUtil.getUppermostParent(obj)).getID()) != null) {
            return topID;
        }
        if (id != null && (parent = id.getParent()) != null) {
            return DBUtil.getUppermostParent(parent);
        }
        return id;
    }

    public static boolean isSameOrChildOf(DBObjectID id1, DBObjectID id2, boolean strict) {
        DBObjectID parent;
        boolean retval = id1.equals(id2, strict);
        if (!retval && (parent = id1.getParent()) != null) {
            retval = DBUtil.isSameOrChildOf(parent, id2, strict);
        }
        return retval;
    }

    public static Map<Schema, Collection<SystemObject>> sortIntoSchemas(SystemObject ... objs) {
        if (objs != null && objs.length > 0) {
            return DBUtil.sortIntoSchemas(Arrays.asList(objs));
        }
        return Collections.emptyMap();
    }

    public static Map<Schema, Collection<SystemObject>> sortIntoSchemas(Collection<? extends SystemObject> objs) {
        TreeMap<DBObject, ArrayList<SystemObject>> mapped = new TreeMap<DBObject, ArrayList<SystemObject>>(DBUtil.getNameComparator());
        for (SystemObject systemObject : objs) {
            Schema s = DBUtil.getSchema(systemObject);
            ArrayList<SystemObject> col = (ArrayList<SystemObject>)mapped.get(s);
            if (col == null) {
                col = new ArrayList<SystemObject>();
                mapped.put(s, col);
            }
            col.add(systemObject);
        }
        return mapped;
    }

    public static <T extends DBObject> T getProviderDefinition(T obj, DBObjectProvider pro) throws DBException {
        return DBUtil.getProviderDefinition(obj, pro, null);
    }

    public static <T extends DBObject> T getProviderDefinition(T obj, DBObjectProvider pro, String schemaName) throws DBException {
        DBObject proDefParent;
        DBObject parent;
        DBObject retval = null;
        if (obj instanceof SystemObject && pro.supportsObjectType(obj.getType())) {
            DBObjectCriteria<SystemObject> criteria = new DBObjectCriteria<SystemObject>((SystemObject)obj);
            if (obj instanceof SchemaObject && ModelUtil.hasLength((String)schemaName)) {
                criteria.setSchemaName(schemaName);
            }
            retval = pro.getObject(criteria);
        } else if (obj != null && (parent = obj.getParent()) != null && (proDefParent = DBUtil.getProviderDefinition(parent, pro, schemaName)) != null) {
            retval = proDefParent.findOwnedObject(obj.getType(), obj.getName());
        }
        return (T)retval;
    }

    public static <T extends SystemObject> T[] getProviderDefinitions(T[] objs, DBObjectProvider pro) throws DBException {
        SystemObject[] retval = (SystemObject[])Array.newInstance(objs.getClass().getComponentType(), objs.length);
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            retval[i] = (SystemObject)DBUtil.getProviderDefinition(objs[i], pro);
        }
        return retval;
    }

    @Deprecated
    public static DBObject getProviderDefinition(ReferenceID refID, DBObjectProvider pro) throws DBException {
        return DBUtil.resolveInOtherProvider(refID, pro);
    }

    public static <T> T[] stripNulls(T[] objs) {
        ArrayList<T> retval = new ArrayList<T>();
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            retval.add(objs[i]);
        }
        return retval.toArray((Object[])Array.newInstance(objs.getClass().getComponentType(), retval.size()));
    }

    public static boolean isCompoundName(String name, String quote) {
        boolean result = false;
        if (ModelUtil.hasLength((String)name) && ModelUtil.hasLength((String)quote)) {
            int idx = name.indexOf(quote);
            if (idx == 0) {
                String substr = name.substring(1);
                idx = substr.indexOf(quote);
                while (idx > -1 && idx < substr.length() - 1) {
                    if (substr.startsWith(quote, idx + 1)) {
                        substr = substr.substring(idx + 2);
                        idx = substr.indexOf(quote);
                        continue;
                    }
                    substr = substr.substring(idx + 1);
                    break;
                }
                result = substr.startsWith(".");
            } else {
                idx = name.indexOf(".");
                result = idx > -1;
            }
        }
        return result;
    }

    public static boolean isDangling(DBObjectID refID) {
        boolean isDangling = false;
        if (refID instanceof ReferenceID) {
            try {
                DBObject dbo = refID.resolveID();
                isDangling = null == dbo;
            }
            catch (DBException dbe) {
                isDangling = true;
            }
        }
        return isDangling;
    }

    public static boolean isDatabaseLink(DBObjectID id) {
        return id instanceof BaseObjectID && ModelUtil.hasLength((String)((BaseObjectID)id).getDatabaseName());
    }

    public static DBObjectID getOriginalID(DBObject dbo) {
        DBObjectID retval = null;
        DBObjectID id = dbo.getID();
        if (id instanceof TemporaryObjectID) {
            retval = TemporaryObjectID.findOriginalID((TemporaryObjectID)id);
        }
        return retval;
    }

    public static Collection<DBObject> findUsagesIn(DBObject used, DBObject searchRoot) {
        DBObjectID id;
        ArrayList<DBObject> retval = new ArrayList<DBObject>();
        if (used != null && (id = used.getID()) != null) {
            DBUtil.findUsagesImpl(id, searchRoot, retval);
        }
        return retval;
    }

    private static void findUsagesImpl(DBObjectID id, DBObject searchRoot, Collection<DBObject> retval) {
        DBObjectIDComparator comparator = new DBObjectIDComparator(true);
        if (searchRoot != null) {
            for (DBObjectID refid : searchRoot.getReferenceIDs()) {
                if (comparator.compare(refid, id) != 0) continue;
                retval.add(searchRoot);
            }
            for (DBObject kid : searchRoot.getOwnedObjects()) {
                DBUtil.findUsagesImpl(id, kid, retval);
            }
        }
    }

    public static FKConstraint[] getReferences(Constraint ucon, DBObjectProvider prov) throws CancelledException {
        ArrayList<FKConstraint> result = new ArrayList<FKConstraint>();
        if (ucon instanceof UniqueConstraint) {
            CascadeManager man = prov.getCascadeManager();
            for (DBObjectID ref : man.listReferers(ucon)) {
                try {
                    DBObject obj = ref.resolveID();
                    if (!(obj instanceof FKConstraint)) continue;
                    result.add((FKConstraint)obj);
                }
                catch (CancelledException ce) {
                    throw ce;
                }
                catch (DBException dbe) {
                    DBUtil.getLogger().log(Level.WARNING, "Couldn't resolve reference to constraint: " + dbe.getMessage());
                }
            }
        }
        return result.toArray(new FKConstraint[result.size()]);
    }

    public static String getDBObjectName(DBObjectID id) {
        String name = "";
        if (id != null) {
            if (id instanceof BaseObjectID) {
                name = ((BaseObjectID)id).getName();
            } else if (id instanceof DataTypeID) {
                name = ((DataTypeID)id).getTypeName();
            }
            if (!ModelUtil.hasLength((String)name)) {
                try {
                    DBObject dbObject = id.resolveID();
                    if (dbObject != null) {
                        name = dbObject.getName();
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
        }
        return name;
    }

    public static String getSchemaName(DBObjectID dbObjectID) {
        String retval = "";
        if (dbObjectID != null) {
            if (dbObjectID instanceof BaseObjectID && Metadata.getInstance().isSchemaObject(dbObjectID.getType())) {
                retval = ((BaseObjectID)dbObjectID).getSchemaName();
            }
            if (!ModelUtil.hasLength((String)retval)) {
                try {
                    Schema s;
                    DBObject dbObject = dbObjectID.resolveID();
                    if (dbObject instanceof SchemaObject && (s = ((SchemaObject)dbObject).getSchema()) != null) {
                        retval = s.getName();
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
        }
        return retval;
    }

    public static DBObject resolveInOtherProvider(BaseObjectID id, DBObjectProvider pro) throws DBException {
        BaseObjectID copy;
        DBObject res;
        DBObjectProvider idPro = id.getProvider();
        if (idPro == pro) {
            return id.resolveID();
        }
        if (pro instanceof AbstractDBObjectProvider && (res = (copy = BaseObjectID.copyWithNewProvider(id, (AbstractDBObjectProvider)pro)).resolveID()) != null) {
            return res;
        }
        if (id instanceof NameBasedID) {
            return pro.getObject(DBObjectCriteria.createSingleObjectCriteria(id.getType(), id.getSchemaName(), id.getName()));
        }
        return null;
    }

    public static boolean areNamesAndTypesEqual(DBObject obj1, DBObject obj2) {
        return DBUtil.getNameComparator().compare(obj1, obj2) == 0;
    }

    public static boolean areEqualIgnoreNullValues(Map map1, Map map2) {
        boolean mapsAreEqual = true;
        if (map1 != map2) {
            HashSet allKeys = new HashSet();
            if (map1 != null) {
                allKeys.addAll(map1.keySet());
            }
            if (map2 != null) {
                allKeys.addAll(map2.keySet());
            }
            for (Object key : allKeys) {
                Object val2;
                Object val1 = DBUtil.getValue(map1, key);
                if (DBUtil.areEqual(val1, val2 = DBUtil.getValue(map2, key))) continue;
                mapsAreEqual = false;
                break;
            }
        }
        return mapsAreEqual;
    }

    public static boolean areEqual(Object obj1, Object obj2) {
        boolean retval = obj1 instanceof Object[] && obj2 instanceof Object[] ? Arrays.equals((Object[])obj1, (Object[])obj2) : ModelUtil.areEqual((Object)obj1, (Object)obj2);
        return retval;
    }

    private static Object getValue(Map map, Object key) {
        Object retval = null;
        if (map != null && (retval = map.get(key)) instanceof Collection && ((Collection)retval).isEmpty()) {
            retval = null;
        }
        return retval;
    }

    public static void suspendTimestampChecking(DBObjectProvider pro, String timestampKey) {
        if (pro instanceof AbstractDBObjectProvider) {
            ((AbstractDBObjectProvider)pro).suspendTimestampQueries(timestampKey);
        }
    }

    public static void resumeTimestampChecking(DBObjectProvider pro, String timestampKey) {
        if (pro instanceof AbstractDBObjectProvider) {
            ((AbstractDBObjectProvider)pro).resumeTimestampQueries(timestampKey);
        }
    }

    public static void clearCachedTimestamp(DBObjectProvider pro, SystemObject obj) {
        DBObjectID id;
        if (pro instanceof AbstractDBObjectProvider && (id = obj.getID()) != null) {
            ((AbstractDBObjectProvider)pro).putCachedTimestampKey(id, null);
        }
    }

    public static Iterator<String> getTimestampKeyGenerator(final String base) {
        final AtomicInteger counter = new AtomicInteger();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public String next() {
                return base + counter.getAndUpdate(i -> i == Integer.MAX_VALUE ? 0 : i + 1);
            }
        };
    }

    public static String createUUID() {
        return UUID.randomUUID().toString();
    }

    public static SQLFragment getColumnExpressionFragment(String expression, Relation rel, DBObjectProvider pro, boolean quoteColumns) {
        SQLFragment frag = null;
        if (ModelUtil.hasLength((String)expression)) {
            try {
                frag = SQLFragmentExpressionBuilder.getExpressionOrFail(pro, rel, SQLFragmentExpressionBuilder.ExpressionType.ITEM, expression.trim());
                if (frag != null && quoteColumns) {
                    DBUtil.markColumnUsages(frag);
                }
            }
            catch (SQLQueryException e) {
                frag = new SimpleSQLFragment(expression);
            }
        }
        return frag;
    }

    private static void markColumnUsages(SQLFragment expr) {
        if (expr instanceof ColumnUsage) {
            ((ColumnUsage)expr).setAlwaysQuote(true);
        }
        for (DBObject kid : expr.getOwnedObjects()) {
            if (!(kid instanceof SQLFragment)) continue;
            DBUtil.markColumnUsages((SQLFragment)kid);
        }
    }

    public static String[] filterSchemaObjectTypes(String[] objectTypes) {
        return DBUtil.filterObjectTypes(objectTypes, SchemaObject.class);
    }

    public static String[] filterObjectTypes(String[] objectTypes, Class<? extends DBObject> clz) {
        ArrayList<String> types = new ArrayList<String>();
        if (objectTypes != null) {
            for (String t : objectTypes) {
                if (t == null || !Metadata.getInstance().isTypeOf(clz, t)) continue;
                types.add(t);
            }
        }
        return types.toArray(new String[types.size()]);
    }

    public static void forceObjectReset(String type, String schemaName, String name, DBObjectProvider pro) {
        SystemObject obj;
        if (pro instanceof AbstractDatabase && ModelUtil.hasLength((String)type) && pro.supportsObjectType(type) && ModelUtil.hasLength((String)name) && (obj = ((AbstractDBObjectProvider)pro).findObject(type, schemaName == null ? null : new Schema(schemaName), name)) != null) {
            ((AbstractDBObjectProvider)pro).resetObject(obj, null, null);
        }
    }

    public static void forceObjectReset(SystemObject obj, DBObjectProvider pro) throws DBException {
        if ((obj = DBUtil.getProviderDefinition(obj, pro)) != null && pro instanceof AbstractDatabase) {
            ((AbstractDBObjectProvider)pro).resetObject(obj, null, null);
        }
    }

    public static void forceObjectUpdate(DBObjectProvider pro, SystemObject orig, Runnable runnable) {
        if (!(pro instanceof AbstractDBObjectProvider)) {
            throw new IllegalArgumentException("pro expected to be instance of AbstractDBObjectProvider");
        }
        if (orig == null) {
            throw new NullPointerException("orig cannot be null");
        }
        DBObjectChange change = DBUtil.invokeCompoundChange(orig, runnable, true);
        if (change != null) {
            AbstractDBObjectProvider prov = (AbstractDBObjectProvider)pro;
            prov.fireObjectUpdated(change);
        }
    }

    public static void forceObjectUpdate(DBObjectProvider pro, SystemObject orig, SystemObject upd) {
        if (!(pro instanceof AbstractDBObjectProvider)) {
            throw new IllegalArgumentException("pro expected to be instance of AbstractDBObjectProvider");
        }
        if (orig == null) {
            throw new NullPointerException("orig cannot be null");
        }
        if (upd == null) {
            throw new NullPointerException("upd cannot be null");
        }
        if (orig.getClass() != upd.getClass()) {
            throw new IllegalArgumentException("orig must be same class as upd");
        }
        AbstractDBObjectProvider prov = (AbstractDBObjectProvider)pro;
        DifferenceApplier diffApp = new DifferenceApplier(prov);
        diffApp.apply(orig, upd);
        for (DBObjectChange doc : diffApp.getEvents()) {
            prov.fireObjectUpdated(doc);
        }
    }

    public static Class findCommonSuperclass(Class<?> clz1, Class<?> clz2) {
        Class retval;
        if (clz1 == null) {
            retval = clz2;
        } else if (clz2 == null || ModelUtil.areEqual(clz1, clz2)) {
            retval = clz1;
        } else if (clz1.isAssignableFrom(clz2)) {
            retval = clz1;
        } else if (clz2.isAssignableFrom(clz1)) {
            retval = clz2;
        } else {
            TreeSet common = new TreeSet(new Comparator<Class<?>>(){

                @Override
                public int compare(Class<?> o1, Class<?> o2) {
                    if (o1.equals(o2)) {
                        return 0;
                    }
                    if (o1.equals(Object.class)) {
                        return 1000;
                    }
                    if (o2.equals(Object.class)) {
                        return -1000;
                    }
                    boolean isI1 = o1.isInterface();
                    boolean isI2 = o2.isInterface();
                    if (isI1 && !isI2) {
                        return 100;
                    }
                    if (isI2 && !isI1) {
                        return -100;
                    }
                    if (o1.isAssignableFrom(o2)) {
                        return 10;
                    }
                    if (o2.isAssignableFrom(o1)) {
                        return -10;
                    }
                    return (int)Math.signum(o1.getName().compareTo(o2.getName()));
                }
            });
            for (Class<?> clz1h = clz1; clz1h != null; clz1h = clz1h.getSuperclass()) {
                for (Class<?> i : clz1h.getInterfaces()) {
                    common.add(i);
                }
                if (!clz1h.isAssignableFrom(clz2)) continue;
                common.add(clz1h);
            }
            retval = (Class)common.iterator().next();
        }
        return retval;
    }

    public static DBObject findChildByName(DBObject parent, String property, String childName, DBObjectProvider pro) {
        return DBUtil.findChildByName(parent, property, childName, false, pro);
    }

    public static DBObject findChildByName(DBObject parent, String property, String childName, boolean searchOriginal, DBObjectProvider pro) {
        DBObject retval;
        Object propVal = parent.getProperty(property);
        if (propVal instanceof Object[]) {
            DBObject origChild;
            DBObject origPar;
            retval = DBUtil.findChildByNameImpl((Object[])propVal, childName, pro.getDescriptor());
            if (retval == null && searchOriginal && (origPar = TemporaryObjectID.getOriginalObject(parent)) != null && (origChild = DBUtil.findChildByName(origPar, property, childName, true, pro)) != null) {
                retval = DBUtil.findChildInCopy(origPar, parent, origChild);
            }
        } else {
            retval = null;
        }
        return retval;
    }

    private static DBObject findChildByNameImpl(Object[] arr, String childName, DatabaseDescriptor desc) {
        for (Object o : arr) {
            DBObject child;
            String name;
            if (!(o instanceof DBObject) || !desc.areNamesEqual(name = (child = (DBObject)o).getName(), childName, child.getType(), false)) continue;
            return child;
        }
        return null;
    }

    public static SystemObject getSystemObjectFromParent(Difference cmr, String contributor) {
        DBObject dbo = DBUtil.getDBObjectFromParent(cmr, contributor);
        return DBUtil.getSystemObject(dbo);
    }

    public static String getFullPropertyPath(Difference diff) {
        String fullPropertyPath = null;
        if (diff != null && !DBObject.class.isAssignableFrom(diff.getDifferenceClass())) {
            fullPropertyPath = diff.getPropertyName();
        }
        if (fullPropertyPath != null) {
            String parentPropPath;
            Difference parent = diff.getParent();
            String string = parentPropPath = parent == null ? null : DBUtil.getFullPropertyPath(parent);
            if (ModelUtil.hasLength((String)parentPropPath)) {
                fullPropertyPath = parentPropPath + "/" + fullPropertyPath;
            }
        }
        return fullPropertyPath;
    }

    public static DBObject getDBObjectFromParent(Difference cmr, String contributor) {
        DBObject result = null;
        while (cmr != null) {
            Object rso = null;
            if (ModelUtil.hasLength((String)contributor)) {
                rso = cmr.getObject(contributor);
            } else {
                rso = cmr.getOriginalObject();
                if (rso == null) {
                    rso = cmr.getUpdatedObject();
                }
            }
            if (rso instanceof DBObject) {
                result = (DBObject)rso;
                break;
            }
            cmr = cmr.getParent();
        }
        return result;
    }

    public static Class<?> decodeArrayClass(Class<?> clz) {
        if (clz != null && clz.isArray()) {
            clz = clz.getComponentType();
        }
        return clz;
    }

    public static boolean isDeprecated(Enum val) {
        boolean retval = false;
        if (val != null) {
            try {
                Field fld = val.getClass().getField(val.name());
                retval = fld.isAnnotationPresent(Deprecated.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public static String isViaDatabaseLink(SystemObject dso) {
        DBObjectID schemaID;
        Schema schema;
        String retval = null;
        DBObjectID id = dso.getID();
        if (id instanceof BaseObjectID) {
            retval = ((BaseObjectID)id).getDatabaseName();
        }
        if (retval == null && dso instanceof SchemaObject && (schema = ((SchemaObject)dso).getSchema()) != null && (schemaID = schema.getID()) instanceof BaseObjectID) {
            retval = ((BaseObjectID)schemaID).getDatabaseName();
        }
        return retval;
    }

    public static List<SchemaObject> getSynonymReferenceChain(Synonym synonym) {
        ArrayList<SchemaObject> ret = new ArrayList<SchemaObject>();
        DBObject refobj = synonym;
        try {
            while (refobj instanceof SchemaObject) {
                ret.add((SchemaObject)refobj);
                if (refobj instanceof Synonym) {
                    DBObjectID synref = refobj.getReference();
                    if (synref != null) {
                        refobj = synref.resolveID();
                        continue;
                    }
                    refobj = null;
                    continue;
                }
                refobj = null;
            }
        }
        catch (DBException dbe) {
            DBUtil.getLogger().log(Level.WARNING, "Couldn't resolve synonym {0} : {1}", new String[]{synonym.getName(), dbe.getMessage()});
        }
        return ret;
    }

    public static SchemaObject getSynonymReference(Synonym synonym) {
        SchemaObject ret = null;
        if (synonym != null) {
            List<SchemaObject> chain = DBUtil.getSynonymReferenceChain(synonym);
            ret = chain.get(chain.size() - 1);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBObjectChange invokeCompoundChange(DBObject obj, Runnable runnable, boolean fireEvents) {
        final Holder noddy = new Holder();
        DBObjectListener list = new DBObjectListener(){

            @Override
            public void objectUpdated(DBObjectChange change) {
                noddy.set((Object)change);
            }
        };
        try {
            if (obj != null) {
                obj.addObjectListener(list);
            }
            if (obj instanceof AbstractDBObject) {
                ((AbstractDBObject)obj).invokeCompoundChange(runnable, fireEvents);
            } else {
                runnable.run();
            }
        }
        finally {
            if (obj != null) {
                obj.removeObjectListener(list);
            }
        }
        return (DBObjectChange)noddy.get();
    }

    public static Collection<String> listSupportedTypes(DBObjectProvider pro, Class<? extends SystemObject> ... objClasses) {
        HashSet<String> retval = new HashSet<String>();
        if (objClasses != null) {
            for (Class<? extends SystemObject> clz : objClasses) {
                for (String type : Metadata.getInstance().getAllTypes(clz)) {
                    if (!pro.supportsObjectType(type)) continue;
                    retval.add(type);
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cascadeInternalRename(SystemObject sysObj, DBObject child, String oldName, String newName, DBObjectProvider pro) throws DBException {
        if (pro instanceof AbstractDBObjectProvider && sysObj != null && child instanceof Column && ModelUtil.areDifferent((Object)oldName, (Object)newName)) {
            DBObjectID id = child.getID();
            if (id instanceof TemporaryObjectID) {
                if (TemporaryObjectID.getOriginalObject(child) == null) {
                    SystemObject sysObjCopy = DBUtil.makeTemporaryCopy(sysObj);
                    DBObject childCopy = DBUtil.findChildInCopy(sysObj, sysObjCopy, child);
                    child.setName(oldName);
                    try {
                        DBUtil.cascadeInternalRenameImpl(sysObjCopy, childCopy, oldName, newName, pro);
                        sysObjCopy.copyTo(sysObj);
                    }
                    finally {
                        child.setName(newName);
                    }
                } else {
                    DBUtil.cascadeInternalRenameImpl(sysObj, child, oldName, newName, pro);
                }
            } else {
                throw new IllegalStateException("DBUtil.cascadeInternalRename can only be used on a new object, or a temp copy");
            }
        }
    }

    private static <T extends SystemObject> void cascadeInternalRenameImpl(T sysObj, DBObject child, String oldName, String newName, DBObjectProvider pro) throws DBException {
        try {
            DBObjectValidator<T> validator = ((AbstractDBObjectProvider)pro).getValidator(sysObj);
            ResultSet objDiff = new ResultSet(null, child, (Object)child, null, "MAP");
            objDiff.setSame(false);
            ResultSet nameDiff = new ResultSet(objDiff, false, (Object)oldName, (Object)newName, "name");
            validator.cascadeUpdate(objDiff, sysObj);
        }
        catch (MissingValidatorException mve) {
            DBUtil.getLogger().warning(mve.getMessage());
        }
    }

    public static <T extends Enum> T findEnumFromString(String s, Class<? extends Enum> clz) {
        Enum retval = null;
        if (s != null) {
            for (Enum e : clz.getEnumConstants()) {
                if (!s.equals(e.toString())) continue;
                retval = e;
                break;
            }
        }
        return (T)retval;
    }

    public static Class<?>[] getAllInterfaces(Class<?> clz) {
        LinkedHashSet retval = new LinkedHashSet();
        while (clz != null) {
            retval.addAll(Arrays.asList(clz.getInterfaces()));
            clz = clz.getSuperclass();
        }
        return retval.toArray(new Class[retval.size()]);
    }

    public static class IDQueryCriteria {
        private final IDQuery m_idQuery;
        private boolean m_recurse;
        private boolean m_existingOnly;
        private boolean m_topLevelOnly;
        private String[] m_types;

        public IDQueryCriteria(IDQuery idQuery) {
            this.m_idQuery = idQuery;
        }

        public void setTypes(String ... types) {
            if (types != null) {
                types = DBUtil.stripNulls(types);
                Arrays.sort(types);
            }
            this.m_types = types;
        }

        public void setRecurse(boolean recurse) {
            this.m_recurse = recurse;
        }

        public void setExistingOnly(boolean existingOnly) {
            this.m_existingOnly = existingOnly;
        }

        public void setTopLevelOnly(boolean topLevelOnly) {
            this.m_topLevelOnly = topLevelOnly;
        }
    }

    public static enum IDQuery {
        INTERNAL,
        EXTERNAL,
        BOTH;

    }
}

