/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IdentityColumnProperties;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.SQLFragment;

public class Column
extends AbstractChildBuildableObject {
    public static final String TYPE = "COLUMN";
    @Deprecated
    public static final String AUTO_GENERATED_SEQUENCE = "AUTO_GENERATED_SEQUENCE";
    @Deprecated
    public static final String AUTO_GENERATED_SEQUENCE_TRIGGER = "AUTO_GENERATED_SEQUENCE_TRIGGER";

    public Column() {
        this((String)null, (DataTypeUsage)null);
    }

    public Column(String name) {
        this(name, (DataTypeUsage)null);
    }

    public Column(String name, DataTypeUsage usage) {
        super(name, (DBObject)null);
        if (usage != null) {
            this.setDataTypeUsage(usage);
        }
        this.setNotNull(false);
    }

    public void setDefault(Object defaultValue) {
        this.setProperty("default", defaultValue);
    }

    public Object getDefault() {
        return this.getProperty("default");
    }

    public void setVirtualExpression(SQLFragment expression) {
        this.setProperty("virtualExpression", expression);
    }

    @Derived(value="virtualExpressionSource")
    @Internal
    public SQLFragment getVirtualExpression() {
        return (SQLFragment)this.getProperty("virtualExpression");
    }

    public void setVirtualExpressionSource(String expression) {
        this.setProperty("virtualExpressionSource", expression);
    }

    @TextProperty(multiLine=true)
    public String getVirtualExpressionSource() {
        SQLFragment frag;
        String retval = (String)this.getProperty("virtualExpressionSource");
        if (retval == null && (frag = (SQLFragment)this.getPropertySupport().get("virtualExpression")) != null) {
            retval = frag.getSQLText();
        }
        return retval;
    }

    public boolean isNotNull() {
        return (Boolean)this.getProperty("notNull", false);
    }

    public void setNotNull(boolean notNull) {
        this.setProperty("notNull", notNull);
    }

    public void setDataTypeUsage(DataTypeUsage dataTypeUsage) {
        this.setProperty("dataTypeUsage", dataTypeUsage);
    }

    public DataTypeUsage getDataTypeUsage() {
        return (DataTypeUsage)this.getProperty("dataTypeUsage");
    }

    public void setIdentityProperties(IdentityColumnProperties props) {
        this.setProperty("identityProperties", props);
    }

    public IdentityColumnProperties getIdentityProperties() {
        return (IdentityColumnProperties)this.getProperty("identityProperties");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Internal
    public Relation getRelation() {
        return (Relation)this.getParent();
    }

    public void setRelation(Relation relation) {
        this.setParent(relation);
    }

    @Transient
    @Deprecated
    public Long getPrecision() {
        DataTypeUsage dtu = this.getDataTypeUsage();
        if (dtu == null) {
            return null;
        }
        Long precision = DataTypeHelper.getLongAttributeValue(dtu, "precision");
        Long size = DataTypeHelper.getLongAttributeValue(dtu, "size");
        return precision == null ? size : precision;
    }

    @Transient
    @Deprecated
    public void setPrecision(Long precision) {
        DataTypeUsage dtu = this.getDataTypeUsage();
        if (dtu != null) {
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType(dtu);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dataType != null) {
                if (dataType.hasDataTypeAttribute("precision")) {
                    dtu.putAttributeValue("precision", precision);
                } else if (dataType.hasDataTypeAttribute("size")) {
                    dtu.putAttributeValue("size", precision);
                }
            }
        }
    }

    @Deprecated
    @Transient
    public Long getScale() {
        DataTypeUsage dtu = this.getDataTypeUsage();
        return dtu == null ? null : DataTypeHelper.getLongAttributeValue(dtu, "scale");
    }

    @Deprecated
    @Transient
    public void setScale(Long scale) {
        DataTypeUsage dtu = this.getDataTypeUsage();
        if (dtu != null) {
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType(dtu);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dataType != null && dataType.hasDataTypeAttribute("scale")) {
                dtu.putAttributeValue("scale", scale);
            }
        }
    }
}

