/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtilCore;
import oracle.javatools.db.property.PropertyDefinition;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.util.DBObjectIDMap;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.db.util.DBObjectSet;
import oracle.javatools.util.ModelUtil;

public abstract class CascadeManager {
    private static final Iterator<String> s_tsKeyGen = DBUtil.getTimestampKeyGenerator(CascadeManager.class.getName());
    private DBObjectProvider m_pro;

    protected CascadeManager(DBObjectProvider pro) {
        if (pro == null) {
            throw new NullPointerException("DBObjectProvider cannot be null");
        }
        this.m_pro = pro;
    }

    protected final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    public abstract Collection<DBObjectID> listReferers(DBObject var1) throws CancelledException;

    public final Collection<DBObjectID> listTopLevelReferers(SystemObject obj, boolean deep) throws CancelledException {
        LookupCriteria criteria = new LookupCriteria();
        criteria.setRecurse(deep);
        return this.listTopLevelReferers(obj, criteria);
    }

    public abstract Collection<DBObjectID> listTopLevelReferers(SystemObject var1, LookupCriteria var2) throws CancelledException;

    @Deprecated
    public SystemObject cascadeDelete(DBObject deleted, SystemObject referer) throws NoCascadeRequiredException {
        throw new NoCascadeRequiredException(deleted);
    }

    @Deprecated
    public SystemObject cascadeDelete(DBObject deleted, SystemObject referer, boolean copyIfCascadeRequired) throws NoCascadeRequiredException {
        throw new NoCascadeRequiredException(deleted);
    }

    @Deprecated
    public void doCascadeDelete(SystemObject deleted, SystemObject referer) throws DBException {
        throw new NoCascadeRequiredException(deleted);
    }

    public Collection<SystemObject> listReferencedObjects(SystemObject obj, boolean recurse) throws CancelledException {
        LookupCriteria criteria = new LookupCriteria();
        criteria.setRecurse(recurse);
        return this.listReferencedObjects(obj, criteria);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SystemObject> listReferencedObjects(SystemObject obj, LookupCriteria criteria) throws CancelledException {
        String timestampKey = s_tsKeyGen.next();
        DBUtil.suspendTimestampChecking(this.m_pro, timestampKey);
        try {
            if (criteria == null) {
                criteria = new LookupCriteria();
            }
            DBObjectSet<SystemObject> deps = new DBObjectSet<SystemObject>();
            deps.add(obj);
            this.addDependencies(deps, obj, criteria);
            deps.remove(obj);
            DBObjectSet<SystemObject> dBObjectSet = deps;
            return dBObjectSet;
        }
        finally {
            DBUtil.resumeTimestampChecking(this.m_pro, timestampKey);
        }
    }

    private void ensureDerivedPropertiesBuilt(DBObject obj) throws CancelledException {
        CancelledException.checkInterrupt();
        DBObjectID id = obj.getID();
        DBObjectProvider pro = null;
        if (id instanceof BaseObjectID) {
            pro = ((BaseObjectID)id).getProvider();
        }
        if (pro == null) {
            pro = this.getProvider();
        }
        try {
            DBUtil.ensureDerivedPropertiesBuilt(obj, pro);
        }
        catch (CancelledException ce) {
            throw ce;
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.INFO, "Could not build derived properties of {0} : {1}", new Object[]{DBUtil.getFullyQualifiedName(obj), dbe.getMessage()});
        }
    }

    private final void addDependencies(Set<SystemObject> deps, DBObject obj, LookupCriteria criteria) throws CancelledException {
        this.ensureDerivedPropertiesBuilt(obj);
        for (Map.Entry<String, Object> entry : obj.getProperties().entrySet()) {
            CancelledException.checkInterrupt();
            String propName = entry.getKey();
            if (criteria.isIgnoredProperty(propName)) continue;
            Object propValue = entry.getValue();
            if (propValue instanceof DBObjectID) {
                this.addDependency(obj, (DBObjectID)propValue, criteria, deps);
                continue;
            }
            if (propValue instanceof DBObject) {
                this.addDependencies(deps, (DBObject)propValue, criteria);
                continue;
            }
            if (!(propValue instanceof Object[])) continue;
            for (Object arrElem : (Object[])propValue) {
                if (arrElem instanceof DBObjectID) {
                    this.addDependency(obj, (DBObjectID)arrElem, criteria, deps);
                    continue;
                }
                if (!(arrElem instanceof DBObject)) continue;
                this.addDependencies(deps, (DBObject)arrElem, criteria);
            }
        }
    }

    private void addDependency(DBObject obj, DBObjectID ref, LookupCriteria criteria, Set<SystemObject> deps) throws CancelledException {
        try {
            String dbName;
            if (ref instanceof BaseObjectID && ModelUtil.hasLength((String)(dbName = ((BaseObjectID)ref).getDatabaseName()))) {
                Schema schema = DBUtil.getSchema(obj);
                SystemObject link = this.getProvider().getObject(DBObjectCriteria.createSingleObjectCriteria("DATABASE LINK", schema, dbName));
                if (link == null) {
                    CancelledException.checkInterrupt();
                    String publicSchemaName = this.getProvider().getDescriptor().getPublicSchemaName();
                    if (publicSchemaName != null) {
                        link = this.getProvider().getObject(DBObjectCriteria.createSingleObjectCriteria("DATABASE LINK", publicSchemaName, dbName));
                    }
                }
                if (link != null && !deps.contains(link)) {
                    criteria.addIfRequired(link, deps);
                }
            }
            if (!(obj instanceof PlSqlReference) || ref instanceof ReferenceID) {
                ArrayList<SystemObject> refs = new ArrayList<SystemObject>();
                if (ref instanceof ReferenceID) {
                    ReferenceID.ReferenceInfo info = ((ReferenceID)ref).getReferenceInfo();
                    refs.addAll(info.getSystemObjects());
                } else {
                    DBObject refobj = ref.resolveID();
                    if (refobj != null) {
                        SystemObject parent = DBUtil.getSystemObject(refobj);
                        if (parent != null) {
                            refs.add(parent);
                        }
                    } else {
                        this.getLogger().log(Level.FINEST, "Reference type {0} resolved to null on {1}", new Object[]{ref.getClass().getSimpleName(), DBUtil.getFullyQualifiedName(obj)});
                    }
                }
                for (SystemObject parent : refs) {
                    if (deps.contains(parent)) continue;
                    criteria.addIfRequired(parent, deps);
                    if (!criteria.isRecurse()) continue;
                    this.addDependencies(deps, parent, criteria);
                }
            }
        }
        catch (CancelledException ce) {
            throw ce;
        }
        catch (DBException e) {
            this.getLogger().log(Level.WARNING, "Failed to resolve reference on {0}: {1}", new Object[]{DBUtil.getFullyQualifiedName(obj), e.getMessage()});
        }
    }

    private boolean ignoreForUnresolvedReferences(PropertyInfo info) {
        return info.isDerived() || info.isInternalReference() || info.isStaticReference();
    }

    public boolean isUnresolvedReference(DBObjectID id) {
        return id instanceof ReferenceID && DBUtil.getUppermostParent(id) instanceof ReferenceID;
    }

    @Deprecated
    public Collection<Difference> resolveUnresolvedReferences(SystemObject obj) throws CancelledException {
        return Collections.emptyList();
    }

    protected Collection<SystemObject> listUnresolvedReferers(SystemObject obj) throws CancelledException {
        return Collections.emptyList();
    }

    public void resolveUnresolvedReferences(SystemObject incoming, DBObjectTransaction txn) throws DBException {
        for (SystemObject referer : this.listUnresolvedReferers(incoming)) {
            SystemObject copy;
            if (txn.findExistingUpdate(referer) != null || !this.resolveUnresolvedReferences(incoming, copy = txn.getCopyForUpdate(referer))) continue;
            txn.includeUpdate(referer, copy);
        }
    }

    private boolean resolveUnresolvedReferences(SystemObject incoming, DBObject referer) {
        boolean retval = false;
        for (Map.Entry<String, Object> entry : DBUtil.getFrozenProperties(referer).entrySet()) {
            String prop = entry.getKey();
            PropertyInfo info = this.getProvider().getPropertyManager().findPropertyInfo(referer.getClass(), prop);
            if (this.ignoreForUnresolvedReferences(info)) continue;
            Object val = entry.getValue();
            DBObjectID[] newVal = null;
            if (val instanceof DBObjectID) {
                if (this.isUnresolvedReference((DBObjectID)val)) {
                    newVal = this.resolveUnresolvedReference(incoming, (DBObjectID)val);
                }
            } else if (val instanceof DBObjectID[]) {
                Object[] oldVal = (DBObjectID[])val;
                for (int i = 0; i < oldVal.length; ++i) {
                    DBObjectID replacement;
                    if (!this.isUnresolvedReference((DBObjectID)oldVal[i]) || (replacement = this.resolveUnresolvedReference(incoming, (DBObjectID)oldVal[i])) == null) continue;
                    if (newVal == null) {
                        newVal = new DBObjectID[oldVal.length];
                        System.arraycopy(oldVal, 0, newVal, 0, oldVal.length);
                    }
                    ((DBObjectID[])newVal)[i] = replacement;
                }
            } else if (val instanceof DBObject) {
                if (this.resolveUnresolvedReferences(incoming, (DBObject)val)) {
                    retval = true;
                }
            } else if (val instanceof DBObject[]) {
                for (DBObject child : (DBObject[])val) {
                    if (!this.resolveUnresolvedReferences(incoming, child)) continue;
                    retval = true;
                }
            }
            if (newVal == null) continue;
            try {
                info.setPropertyValue(referer, newVal);
                retval = true;
            }
            catch (Exception e) {
                DBLog.logStackTrace(e);
            }
        }
        return retval;
    }

    private DBObjectID resolveUnresolvedReference(DBObject incoming, DBObjectID unresolved) {
        DBObjectID retval;
        block3: {
            DBObject kid;
            retval = null;
            DBObjectID incomingID = incoming.getID();
            if (this.resolvesUnresolvedReference(incoming, incomingID, unresolved)) {
                if (incomingID == null) {
                    incomingID = TemporaryObjectID.createID(incoming);
                    incoming.setID(incomingID);
                }
                retval = incomingID;
            }
            if (retval != null) break block3;
            Iterator<DBObject> iterator = DBUtil.getExistingOwnedObjects(incoming).iterator();
            while (iterator.hasNext() && (retval = this.resolveUnresolvedReference(kid = iterator.next(), unresolved)) == null) {
            }
        }
        return retval;
    }

    private boolean resolvesUnresolvedReference(DBObject incoming, DBObjectID incomingID, DBObjectID unresolved) {
        boolean retval = unresolved instanceof ReferenceID ? ((ReferenceID)unresolved).resolvesTo(incoming) : unresolved.equals(incomingID, false);
        return retval;
    }

    protected final Logger getLogger() {
        return DBLog.getLogger(this);
    }

    protected Set<DBObjectID> createIDSet() {
        return new DBObjectIDSet(true);
    }

    protected <T> Map<DBObjectID, T> createIDMap() {
        return new DBObjectIDMap(true);
    }

    public final Map<PropertyInfo, Object> findPropertyReferences(DBObject obj, DBObjectID reference) {
        return this.findReferencesImpl(obj, reference, false);
    }

    private Map<PropertyInfo, Object> findReferencesImpl(DBObject obj, DBObjectID reference, boolean oneIsEnough) {
        LinkedHashMap<PropertyInfo, Object> retval = null;
        Map<String, Object> propMap = obj.getProperties();
        for (Map.Entry<String, Object> entry : propMap.entrySet()) {
            Object value = entry.getValue();
            boolean found = false;
            if (value instanceof DBObjectID && this.matches((DBObjectID)value, reference)) {
                found = true;
            } else if (value instanceof Object[]) {
                for (Object id : (Object[])value) {
                    if (!(id instanceof DBObjectID)) break;
                    if (!this.matches((DBObjectID)id, reference)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            String propName = entry.getKey();
            PropertyInfo info = this.getProvider().getPropertyManager().findPropertyInfo(obj.getClass(), propName);
            if (info == null) {
                this.getLogger().fine("Found id to cacade to but it has no PropertyInfo");
                info = new PropertyDefinition(propName, DBObjectID.class, null, new Class[0]);
            }
            if (info.isStaticReference()) continue;
            if (retval == null) {
                retval = new LinkedHashMap<PropertyInfo, Object>();
            }
            retval.put(info, value);
            if (!oneIsEnough) continue;
            break;
        }
        return retval;
    }

    private boolean matches(DBObjectID id, DBObjectID reference) {
        boolean retval = DBUtil.isSameOrChildOf(id, reference, this.useStrictComparison(id, reference));
        if (!retval && id instanceof BaseObjectID && reference instanceof BaseObjectID) {
            String name;
            if ("SCHEMA".equals(reference.getType())) {
                String name2 = ((BaseObjectID)id).getSchemaName();
                if (name2 != null) {
                    retval = name2.equals(((BaseObjectID)reference).getName());
                }
            } else if ("DATABASE LINK".equals(reference.getType()) && (name = ((BaseObjectID)id).getDatabaseName()) != null) {
                retval = name.equals(((BaseObjectID)reference).getName());
            }
        }
        return retval;
    }

    private boolean useStrictComparison(Object value, DBObjectID to) {
        return !(value instanceof BaseObjectID);
    }

    public final Collection<DBObjectID> findReferers(DBObject obj, DBObjectID to, Collection<DBObjectID> refdBy, boolean topLevel) throws CancelledException {
        boolean found = false;
        this.ensureDerivedPropertiesBuilt(obj);
        CancelledException.checkInterrupt();
        Map<PropertyInfo, Object> refProps = this.findReferencesImpl(obj, to, true);
        boolean isPlSqlSourceObject = obj instanceof PlSqlSourceObject;
        if (!(!topLevel && isPlSqlSourceObject || refProps == null || refProps.isEmpty())) {
            DBObjectID refererID;
            if (refdBy == null) {
                refdBy = this.createIDSet();
            }
            if ((refererID = obj.getID()) == null) {
                this.getLogger().log(Level.WARNING, "Dependent object has no ID set: " + DBUtil.getFullyQualifiedName(obj));
            } else if (topLevel) {
                refdBy.add(DBUtil.getUppermostParent(refererID));
                found = true;
            } else {
                refdBy.add(refererID);
            }
        }
        if (!found) {
            DBObject[] kids;
            if (isPlSqlSourceObject) {
                List<DBObject> frags = PlSqlUtilCore.getPlSqlFragmentReferers((PlSqlSourceObject)obj, to, this.getProvider());
                kids = frags.toArray(new DBObject[frags.size()]);
            } else {
                kids = obj instanceof DBObjectPlSqlFragment && !(obj instanceof PlSqlReference) ? new DBObject[]{} : obj.getOwnedObjects();
            }
            for (DBObject kid : kids) {
                refdBy = this.findReferers(kid, to, refdBy, topLevel);
            }
        }
        return refdBy;
    }

    protected final Collection<DBObjectID> includeSchemaObjects(Schema schema, Collection<DBObjectID> refs) throws CancelledException {
        try {
            DBObjectProvider pro = this.getProvider();
            DBObjectCriteria<SystemObject> crit = DBObjectCriteria.createCriteria(DBUtil.filterSchemaObjectTypes(pro.listObjectTypes()), schema, null);
            crit.setUserOnly(true);
            Collection<SystemObject> objs = pro.listObjects(crit);
            for (SystemObject schemaObj : objs) {
                DBObjectID schemaObjID;
                if (refs == null) {
                    refs = this.createIDSet();
                }
                if ((schemaObjID = schemaObj.getID()) == null) continue;
                refs.add(schemaObjID);
            }
        }
        catch (CancelledException ce) {
            throw ce;
        }
        catch (DBException dbe) {
            this.getLogger().warning(dbe.getMessage());
        }
        return refs;
    }

    public static class LookupCriteria {
        private boolean m_recurse;
        private String[] m_types;
        private String[] m_ignoredProps;

        public void setRecurse(boolean recurse) {
            this.m_recurse = recurse;
        }

        public boolean isRecurse() {
            return this.m_recurse;
        }

        public void setTypes(String ... types) {
            this.m_types = this.convertAndSort(types);
        }

        private String[] convertAndSort(String[] arr) {
            Object[] retval;
            if (arr == null || arr.length == 0) {
                retval = null;
            } else {
                retval = new String[arr.length];
                System.arraycopy(arr, 0, retval, 0, arr.length);
                Arrays.sort(retval);
            }
            return retval;
        }

        public String[] getTypes() {
            return this.m_types;
        }

        public boolean isRequiredType(String type) {
            boolean retval = true;
            if (this.m_types != null) {
                retval = Arrays.binarySearch(this.m_types, type) >= 0;
            }
            return retval;
        }

        public <T extends DBObject> boolean addIfRequired(T obj, Collection<? super T> objs) {
            boolean retval = false;
            if (this.isRequiredType(obj.getType())) {
                retval = objs.add(obj);
            }
            return retval;
        }

        public <T extends DBObjectID> boolean addIfRequired(T id, Collection<? super T> ids) {
            boolean retval = false;
            if (this.isRequiredType(id.getType())) {
                retval = ids.add(id);
            }
            return retval;
        }

        public void setIgnoredProperties(String ... props) {
            this.m_ignoredProps = this.convertAndSort(props);
        }

        public String[] getIgnoredProperties() {
            return this.m_ignoredProps;
        }

        public boolean isIgnoredProperty(String prop) {
            boolean retval = false;
            if (this.m_ignoredProps != null) {
                retval = Arrays.binarySearch(this.m_ignoredProps, prop) >= 0;
            }
            return retval;
        }
    }

    @Deprecated
    public static class NoCascadeRequiredException
    extends DBException {
        public NoCascadeRequiredException(DBObject obj) {
            super(obj, "No cascade required.");
        }
    }
}

